/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.utils;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axis2.databinding.utils.Constants;
import org.apache.axis2.databinding.utils.States;

public class SimpleElementReaderStateMachine
implements States,
Constants {
    private QName elementNameToTest = null;
    private int currentState = -1;
    private boolean nillable = false;
    private String text = "";
    private String errorMessage = "";
    private boolean elementSkipped = false;

    public boolean isElementSkipped() {
        return this.elementSkipped;
    }

    public String getText() {
        return this.text;
    }

    public void setNillable() {
        this.nillable = true;
    }

    public void setElementNameToTest(QName elementNameToTest) {
        this.elementNameToTest = elementNameToTest;
    }

    public void reset() {
        this.elementNameToTest = null;
        this.currentState = -1;
        this.nillable = false;
        this.text = "";
        this.errorMessage = "";
    }

    public void read(XMLStreamReader reader) throws XMLStreamException {
        do {
            this.updateState(reader);
            if (this.currentState == 1 && this.nillable && "true".equals(reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "nil"))) {
                this.text = null;
                this.currentState = 7;
            }
            if (this.currentState == 2) {
                this.text = reader.getText();
            }
            if (this.currentState == 4 || this.currentState == 5) continue;
            reader.next();
        } while (this.currentState != 4 && this.currentState != 5);
        if (this.currentState == 5) {
            throw new RuntimeException("Illegal state!" + this.errorMessage);
        }
    }

    private void updateState(XMLStreamReader reader) throws XMLStreamException {
        int event = reader.getEventType();
        switch (this.currentState) {
            case -1: {
                if (event == 7) {
                    this.currentState = 0;
                    break;
                }
                if (event == 1) {
                    if (this.elementNameToTest.equals(reader.getName())) {
                        this.currentState = 1;
                        break;
                    }
                    this.currentState = 0;
                    break;
                }
                if (event != 2) break;
                this.currentState = 4;
                this.elementSkipped = true;
                break;
            }
            case 0: {
                if (event != 1 || !this.elementNameToTest.equals(reader.getName())) break;
                this.currentState = 1;
                break;
            }
            case 1: {
                if (event == 4) {
                    this.currentState = 2;
                    break;
                }
                if (event != 2) break;
                this.text = "";
                if (this.elementNameToTest.equals(reader.getName())) {
                    this.currentState = 3;
                    break;
                }
                this.currentState = 5;
                this.errorMessage = "Wrong element name " + reader.getName();
                break;
            }
            case 2: {
                if (event == 2) {
                    if (this.elementNameToTest.equals(reader.getName())) {
                        this.currentState = 3;
                        break;
                    }
                    this.currentState = 5;
                    this.errorMessage = "Wrong element name " + reader.getName();
                    break;
                }
                if (event != 4) break;
                this.text = String.valueOf(this.text) + reader.getText();
                break;
            }
            case 3: {
                this.currentState = 4;
                break;
            }
            case 7: {
                while (event != 2) {
                    event = reader.next();
                }
                this.currentState = 3;
                break;
            }
            default: {
                if (event == 4) {
                    if (reader.getText().trim().length() == 0) break;
                    this.currentState = 5;
                    this.errorMessage = "Mixed Content " + reader.getText();
                    break;
                }
                this.currentState = 5;
                this.errorMessage = "Current state is " + this.currentState;
            }
        }
    }
}

