/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.IncorrectnessListener;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlHtml;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.NamedAttrNodeMapImpl;
import com.gargoylesoftware.htmlunit.html.NonSerializable;
import com.gargoylesoftware.htmlunit.html.xpath.XPathUtils;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DomNode
implements Cloneable,
Serializable,
Node {
    protected static final String AS_TEXT_BLOCK_SEPARATOR = "\u00a7bs\u00a7";
    protected static final String AS_TEXT_NEW_LINE = "\u00a7nl\u00a7";
    protected static final String AS_TEXT_BLANK = "\u00a7blank\u00a7";
    protected static final String AS_TEXT_TAB = "\u00a7tab\u00a7";
    private static final long serialVersionUID = -2013573303678006763L;
    public static final String READY_STATE_UNINITIALIZED = "uninitialized";
    public static final String READY_STATE_LOADING = "loading";
    public static final String READY_STATE_LOADED = "loaded";
    public static final String READY_STATE_INTERACTIVE = "interactive";
    public static final String READY_STATE_COMPLETE = "complete";
    private SgmlPage page_;
    private DomNode parent_;
    private DomNode previousSibling_;
    private DomNode nextSibling_;
    private DomNode firstChild_;
    private transient ScriptableObject scriptObject_;
    private String readyState_ = "loading";
    public static final String PROPERTY_ELEMENT = "element";
    private int startLineNumber_ = -1;
    private int startColumnNumber_ = -1;
    private int endLineNumber_ = -1;
    private int endColumnNumber_ = -1;
    private List<DomChangeListener> domListeners_;
    private final transient Object domListeners_lock_ = new Object();

    @Deprecated
    protected DomNode() {
        this(null);
    }

    protected DomNode(SgmlPage page) {
        this.page_ = page;
    }

    void setStartLocation(int startLineNumber, int startColumnNumber) {
        this.startLineNumber_ = startLineNumber;
        this.startColumnNumber_ = startColumnNumber;
    }

    void setEndLocation(int endLineNumber, int endColumnNumber) {
        this.endLineNumber_ = endLineNumber;
        this.endColumnNumber_ = endColumnNumber;
    }

    public int getStartLineNumber() {
        return this.startLineNumber_;
    }

    public int getStartColumnNumber() {
        return this.startColumnNumber_;
    }

    public int getEndLineNumber() {
        return this.endLineNumber_;
    }

    public int getEndColumnNumber() {
        return this.endColumnNumber_;
    }

    public SgmlPage getPage() {
        return this.page_;
    }

    @Override
    public Document getOwnerDocument() {
        return (Document)((Object)this.getPage());
    }

    public void setScriptObject(ScriptableObject scriptObject) {
        this.scriptObject_ = scriptObject;
    }

    @Override
    public DomNode getLastChild() {
        if (this.firstChild_ != null) {
            return this.firstChild_.previousSibling_;
        }
        return null;
    }

    @Override
    public DomNode getParentNode() {
        return this.parent_;
    }

    protected void setParentNode(DomNode parent) {
        this.parent_ = parent;
    }

    @Override
    public DomNode getPreviousSibling() {
        if (this.parent_ == null || this == this.parent_.firstChild_) {
            return null;
        }
        return this.previousSibling_;
    }

    @Override
    public DomNode getNextSibling() {
        return this.nextSibling_;
    }

    @Override
    public DomNode getFirstChild() {
        return this.firstChild_;
    }

    public boolean isAncestorOf(DomNode node) {
        while (node != null) {
            if (node == this) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    protected void setPreviousSibling(DomNode previous) {
        this.previousSibling_ = previous;
    }

    protected void setNextSibling(DomNode next) {
        this.nextSibling_ = next;
    }

    @Override
    public abstract short getNodeType();

    @Override
    public abstract String getNodeName();

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String prefix) {
    }

    @Override
    public boolean hasChildNodes() {
        return this.firstChild_ != null;
    }

    @Override
    public NodeList getChildNodes() {
        return new DomNodeList();
    }

    @Override
    public boolean isSupported(String namespace, String featureName) {
        throw new UnsupportedOperationException("DomNode.isSupported is not yet implemented.");
    }

    @Override
    public void normalize() {
        throw new UnsupportedOperationException("DomNode.normalize is not yet implemented.");
    }

    @Override
    public String getBaseURI() {
        throw new UnsupportedOperationException("DomNode.getBaseURI is not yet implemented.");
    }

    @Override
    public short compareDocumentPosition(Node other) {
        Node node;
        int i;
        if (other == this) {
            return 0;
        }
        List<Node> myAncestors = this.getAncestors(true);
        List<Node> otherAncestors = ((DomNode)other).getAncestors(true);
        int max = Math.min(myAncestors.size(), otherAncestors.size());
        for (i = 1; i < max && myAncestors.get(i) == otherAncestors.get(i); ++i) {
        }
        if (i == max) {
            if (myAncestors.size() == max) {
                return 20;
            }
            return 10;
        }
        Node myAncestor = myAncestors.get(i);
        Node otherAncestor = otherAncestors.get(i);
        for (node = myAncestor; node != otherAncestor && node != null; node = node.getPreviousSibling()) {
        }
        if (node == null) {
            return 4;
        }
        return 2;
    }

    protected List<Node> getAncestors(boolean includeSelf) {
        ArrayList<Node> list = new ArrayList<Node>();
        if (includeSelf) {
            list.add(this);
        }
        for (Node node = this.getParentNode(); node != null; node = node.getParentNode()) {
            list.add(0, node);
        }
        return list;
    }

    @Override
    public String getTextContent() {
        switch (this.getNodeType()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                StringBuilder builder = new StringBuilder();
                for (DomNode child : this.getChildren()) {
                    short childType = child.getNodeType();
                    if (childType == 8 || childType == 7) continue;
                    builder.append(child.getTextContent());
                }
                return builder.toString();
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return this.getNodeValue();
            }
        }
        return null;
    }

    @Override
    public void setTextContent(String textContent) {
        this.removeAllChildren();
        this.appendChild(new DomText(this.getPage(), textContent));
    }

    @Override
    public boolean isSameNode(Node other) {
        return other == this;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        throw new UnsupportedOperationException("DomNode.lookupPrefix is not yet implemented.");
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException("DomNode.isDefaultNamespace is not yet implemented.");
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException("DomNode.lookupNamespaceURI is not yet implemented.");
    }

    @Override
    public boolean isEqualNode(Node arg) {
        throw new UnsupportedOperationException("DomNode.isEqualNode is not yet implemented.");
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException("DomNode.getFeature is not yet implemented.");
    }

    @Override
    public Object getUserData(String key) {
        throw new UnsupportedOperationException("DomNode.getUserData is not yet implemented.");
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new UnsupportedOperationException("DomNode.setUserData is not yet implemented.");
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    protected boolean isTrimmedText() {
        return true;
    }

    protected boolean isStyleVisible() {
        boolean isVisible = true;
        SgmlPage page = this.getPage();
        if (page instanceof HtmlPage) {
            boolean isNotIE = !((HtmlPage)page).getWebClient().getBrowserVersion().isIE();
            DomNode node = this;
            do {
                CSSStyleDeclaration style;
                String visibility;
                ScriptableObject scriptableObject;
                if (!((scriptableObject = node.getScriptObject()) instanceof HTMLElement) || (visibility = (style = ((HTMLElement)scriptableObject).jsxGet_style()).jsxGet_visibility()).length() <= 0) continue;
                if (visibility.equals("visible")) {
                    isVisible = true;
                    break;
                }
                if (!visibility.equals("hidden") && (!isNotIE || !visibility.equals("collapse"))) continue;
                isVisible = false;
                break;
            } while ((node = node.getParentNode()) != null);
        }
        return isVisible;
    }

    public String asText() {
        String text = this.asTextInternal();
        text = text.replaceAll("\u00a7nl\u00a7\u00a7bs\u00a7", AS_TEXT_BLOCK_SEPARATOR);
        text = this.reduceWhitespace(text);
        text = text.replaceAll(AS_TEXT_BLANK, " ");
        String ls = System.getProperty("line.separator");
        text = text.replaceAll(AS_TEXT_NEW_LINE, ls);
        text = text.replaceAll("(?:\u00a7bs\u00a7)+", ls);
        text = text.replaceAll(AS_TEXT_TAB, "\t");
        return text;
    }

    protected String asTextInternal() {
        return this.getChildrenAsText();
    }

    protected boolean isBlock() {
        return false;
    }

    protected final String getChildrenAsText() {
        StringBuilder buffer = new StringBuilder();
        for (DomNode node : this.getChildren()) {
            if (node instanceof DomText) {
                if (!node.isStyleVisible()) continue;
                buffer.append(node.asTextInternal());
                continue;
            }
            boolean block = node.isBlock();
            if (block) {
                buffer.append(AS_TEXT_BLOCK_SEPARATOR);
            }
            buffer.append(node.asTextInternal());
            if (!block) continue;
            buffer.append(AS_TEXT_BLOCK_SEPARATOR);
        }
        return buffer.toString();
    }

    protected String reduceWhitespace(String text) {
        text = text.trim();
        text = text.replaceAll("\\s*\u00a7bs\u00a7\\s*", AS_TEXT_BLOCK_SEPARATOR);
        while (text.startsWith(AS_TEXT_BLOCK_SEPARATOR)) {
            text = text.substring(AS_TEXT_BLOCK_SEPARATOR.length());
        }
        while (text.endsWith(AS_TEXT_BLOCK_SEPARATOR)) {
            text = text.substring(0, text.length() - AS_TEXT_BLOCK_SEPARATOR.length());
        }
        text = text.trim();
        StringBuilder buffer = new StringBuilder(text.length());
        boolean whitespace = false;
        for (char ch : text.toCharArray()) {
            if (ch == '\u00a0') {
                buffer.append(' ');
                whitespace = false;
                continue;
            }
            if (whitespace) {
                if (Character.isWhitespace(ch)) continue;
                buffer.append(ch);
                whitespace = false;
                continue;
            }
            if (Character.isWhitespace(ch)) {
                whitespace = true;
                buffer.append(' ');
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public String asXml() {
        String charsetName = null;
        if (this.getPage() instanceof HtmlPage) {
            charsetName = ((HtmlPage)this.getPage()).getPageEncoding();
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (charsetName != null && this instanceof HtmlHtml) {
            printWriter.println("<?xml version=\"1.0\" encoding=\"" + charsetName + "\"?>");
        }
        this.printXml("", printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    protected void printXml(String indent, PrintWriter printWriter) {
        printWriter.println(indent + this);
        this.printChildrenAsXml(indent, printWriter);
    }

    protected void printChildrenAsXml(String indent, PrintWriter printWriter) {
        for (DomNode child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            child.printXml(indent + "  ", printWriter);
        }
    }

    @Override
    public String getNodeValue() {
        return null;
    }

    @Override
    public void setNodeValue(String x) {
    }

    @Override
    public DomNode cloneNode(boolean deep) {
        DomNode newnode;
        try {
            newnode = (DomNode)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone not supported for node [" + this + "]");
        }
        newnode.parent_ = null;
        newnode.nextSibling_ = null;
        newnode.previousSibling_ = null;
        newnode.firstChild_ = null;
        newnode.scriptObject_ = null;
        if (deep) {
            DomNode child = this.firstChild_;
            while (child != null) {
                newnode.appendChild(child.cloneNode(true));
                child = child.nextSibling_;
            }
        }
        return newnode;
    }

    public ScriptableObject getScriptObject() {
        if (this.scriptObject_ == null) {
            if (this == this.getPage()) {
                throw new IllegalStateException("No script object associated with the Page");
            }
            this.scriptObject_ = ((SimpleScriptable)this.page_.getScriptObject()).makeScriptableFor(this);
        }
        return this.scriptObject_;
    }

    @Override
    public DomNode appendChild(Node node) {
        DomNode domNode = (DomNode)node;
        if (domNode instanceof DomDocumentFragment) {
            DomDocumentFragment fragment = (DomDocumentFragment)domNode;
            for (DomNode child : fragment.getChildren()) {
                this.appendChild(child);
            }
        } else {
            if (domNode != this && domNode.getParentNode() != null) {
                domNode.remove();
            }
            this.basicAppend(domNode);
            if (domNode.getStartLineNumber() == -1) {
                domNode.onAddedToPage();
                domNode.onAllChildrenAddedToPage(true);
            }
            if (!(this instanceof DomDocumentFragment) && this.getPage() instanceof HtmlPage) {
                ((HtmlPage)this.getPage()).notifyNodeAdded(domNode);
            }
            this.fireNodeAdded(this, domNode);
        }
        return domNode;
    }

    void quietlyRemoveAndMoveChildrenTo(DomNode destination) {
        if (destination.getPage() != this.getPage()) {
            throw new RuntimeException("Cannot perform quiet move on nodes from different pages.");
        }
        for (DomNode child : this.getChildren()) {
            child.basicRemove();
            destination.basicAppend(child);
        }
        this.basicRemove();
    }

    private void basicAppend(DomNode node) {
        node.setPage(this.getPage());
        if (this.firstChild_ == null) {
            this.firstChild_ = node;
            this.firstChild_.previousSibling_ = node;
        } else {
            DomNode last = this.getLastChild();
            last.nextSibling_ = node;
            node.previousSibling_ = last;
            node.nextSibling_ = null;
            this.firstChild_.previousSibling_ = node;
        }
        node.parent_ = this;
    }

    protected void checkChildHierarchy(Node newChild) throws DOMException {
        for (Node parentNode = this; parentNode != null; parentNode = parentNode.getParentNode()) {
            if (parentNode != newChild) continue;
            throw new DOMException(3, "Child node is already a parent.");
        }
        Document thisDocument = this.getOwnerDocument();
        Document childDocument = newChild.getOwnerDocument();
        if (childDocument != thisDocument && childDocument != null) {
            throw new DOMException(4, "Child node " + newChild.getNodeName() + " is not in the same Document as this " + this.getNodeName() + ".");
        }
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) {
        if (refChild == null) {
            this.appendChild(newChild);
        } else {
            if (refChild.getParentNode() != this) {
                throw new DOMException(8, "Reference node is not a child of this node.");
            }
            ((DomNode)refChild).insertBefore((DomNode)newChild);
        }
        return null;
    }

    public void insertBefore(DomNode newNode) throws IllegalStateException {
        if (this.previousSibling_ == null) {
            throw new IllegalStateException("Previous sibling for " + this + " is null.");
        }
        if (newNode == this) {
            return;
        }
        DomNode exParent = newNode.getParentNode();
        newNode.basicRemove();
        if (this.parent_.firstChild_ == this) {
            this.parent_.firstChild_ = newNode;
        } else {
            this.previousSibling_.nextSibling_ = newNode;
        }
        newNode.previousSibling_ = this.previousSibling_;
        newNode.nextSibling_ = this;
        this.previousSibling_ = newNode;
        newNode.parent_ = this.parent_;
        newNode.setPage(this.page_);
        if (newNode.getStartLineNumber() == -1) {
            newNode.onAddedToPage();
            newNode.onAllChildrenAddedToPage(true);
        }
        if (this.getPage() instanceof HtmlPage) {
            ((HtmlPage)this.getPage()).notifyNodeAdded(newNode);
        }
        this.fireNodeAdded(this, newNode);
        if (exParent != null) {
            this.fireNodeDeleted(exParent, newNode);
            exParent.fireNodeDeleted(exParent, this);
        }
    }

    private void setPage(SgmlPage newPage) {
        if (this.page_ == newPage) {
            return;
        }
        this.page_ = newPage;
        for (DomNode node : this.getChildren()) {
            node.setPage(newPage);
        }
    }

    @Override
    public NamedNodeMap getAttributes() {
        return NamedAttrNodeMapImpl.EMPTY_MAP;
    }

    @Override
    public Node removeChild(Node child) {
        if (child.getParentNode() != this) {
            throw new DOMException(8, "Node is not a child of this node.");
        }
        ((DomNode)child).remove();
        return child;
    }

    public void remove() {
        DomNode exParent = this.parent_;
        this.basicRemove();
        if (this.getPage() instanceof HtmlPage) {
            ((HtmlPage)this.getPage()).notifyNodeRemoved(this);
        }
        if (exParent != null) {
            this.fireNodeDeleted(exParent, this);
            exParent.fireNodeDeleted(exParent, this);
        }
    }

    private void basicRemove() {
        if (this.parent_ != null && this.parent_.firstChild_ == this) {
            this.parent_.firstChild_ = this.nextSibling_;
        } else if (this.previousSibling_ != null && this.previousSibling_.nextSibling_ == this) {
            this.previousSibling_.nextSibling_ = this.nextSibling_;
        }
        if (this.nextSibling_ != null && this.nextSibling_.previousSibling_ == this) {
            this.nextSibling_.previousSibling_ = this.previousSibling_;
        }
        if (this.parent_ != null && this == this.parent_.getLastChild()) {
            this.parent_.firstChild_.previousSibling_ = this.previousSibling_;
        }
        this.nextSibling_ = null;
        this.previousSibling_ = null;
        this.parent_ = null;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) {
        if (oldChild.getParentNode() != this) {
            throw new DOMException(8, "Node is not a child of this node.");
        }
        ((DomNode)oldChild).replace((DomNode)newChild);
        return oldChild;
    }

    public void replace(DomNode newNode) throws IllegalStateException {
        if (newNode != this) {
            newNode.remove();
            this.insertBefore(newNode);
            this.remove();
        }
    }

    protected void onAddedToPage() {
        if (this.firstChild_ != null) {
            for (DomNode child : this.getChildren()) {
                child.onAddedToPage();
            }
        }
    }

    protected void onAllChildrenAddedToPage(boolean postponed) {
    }

    public final Iterable<DomNode> getChildren() {
        return new Iterable<DomNode>(){

            @Override
            public Iterator<DomNode> iterator() {
                return new ChildIterator();
            }
        };
    }

    public final Iterable<HtmlElement> getAllHtmlChildElements() {
        return new Iterable<HtmlElement>(){

            @Override
            public Iterator<HtmlElement> iterator() {
                return new DescendantElementsIterator();
            }
        };
    }

    public String getReadyState() {
        return this.readyState_;
    }

    public void setReadyState(String state) {
        this.readyState_ = state;
    }

    public void removeAllChildren() {
        if (this.getFirstChild() == null) {
            return;
        }
        Iterator<DomNode> it = this.getChildren().iterator();
        while (it.hasNext()) {
            it.next().removeAllChildren();
            it.remove();
        }
    }

    public List<?> getByXPath(String xpathExpr) {
        return XPathUtils.getByXPath(this, xpathExpr);
    }

    public <X> X getFirstByXPath(String xpathExpr) {
        List<?> results = this.getByXPath(xpathExpr);
        if (results.isEmpty()) {
            return null;
        }
        return (X)results.get(0);
    }

    public String getCanonicalXPath() {
        DomNode parent = this.getParentNode();
        if (parent == null) {
            return "";
        }
        return parent.getCanonicalXPath() + '/' + this.getXPathToken();
    }

    private String getXPathToken() {
        DomNode parent = this.getParentNode();
        int total = 0;
        int nodeIndex = 0;
        for (DomNode child : parent.getChildren()) {
            if (child.getNodeName().equals(this.getNodeName())) {
                ++total;
            }
            if (child != this) continue;
            nodeIndex = total;
        }
        if (nodeIndex == 1 && total == 1) {
            return this.getNodeName();
        }
        return this.getNodeName() + '[' + nodeIndex + ']';
    }

    protected void notifyIncorrectness(String message) {
        WebClient client = this.getPage().getEnclosingWindow().getWebClient();
        IncorrectnessListener incorrectnessListener = client.getIncorrectnessListener();
        incorrectnessListener.notify(message, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDomChangeListener(DomChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Object object = this.domListeners_lock_;
        synchronized (object) {
            if (this.domListeners_ == null) {
                this.domListeners_ = new ArrayList<DomChangeListener>();
            }
            if (!this.domListeners_.contains(listener)) {
                this.domListeners_.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDomChangeListener(DomChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Object object = this.domListeners_lock_;
        synchronized (object) {
            if (this.domListeners_ != null) {
                this.domListeners_.remove(listener);
            }
        }
    }

    protected void fireNodeAdded(DomNode parentNode, DomNode addedNode) {
        List<DomChangeListener> listeners = this.safeGetDomListeners();
        if (listeners != null) {
            DomChangeEvent event = new DomChangeEvent(parentNode, addedNode);
            for (DomChangeListener listener : listeners) {
                listener.nodeAdded(event);
            }
        }
        if (this.parent_ != null) {
            this.parent_.fireNodeAdded(parentNode, addedNode);
        }
    }

    protected void fireNodeDeleted(DomNode parentNode, DomNode deletedNode) {
        List<DomChangeListener> listeners = this.safeGetDomListeners();
        if (listeners != null) {
            DomChangeEvent event = new DomChangeEvent(parentNode, deletedNode);
            for (DomChangeListener listener : listeners) {
                listener.nodeDeleted(event);
            }
        }
        if (this.parent_ != null) {
            this.parent_.fireNodeDeleted(parentNode, deletedNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DomChangeListener> safeGetDomListeners() {
        Object object = this.domListeners_lock_;
        synchronized (object) {
            if (this.domListeners_ != null) {
                return new ArrayList<DomChangeListener>(this.domListeners_);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        Object object = this.domListeners_lock_;
        synchronized (object) {
            ArrayList<DomChangeListener> temp;
            if (this.domListeners_ != null) {
                temp = new ArrayList<DomChangeListener>(this.domListeners_);
                Iterator<DomChangeListener> i = this.domListeners_.iterator();
                while (i.hasNext()) {
                    DomChangeListener listener = i.next();
                    if (!(listener instanceof NonSerializable)) continue;
                    i.remove();
                }
            } else {
                temp = null;
            }
            stream.defaultWriteObject();
            this.domListeners_ = temp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DescendantElementsIterator
    implements Iterator<HtmlElement> {
        private HtmlElement nextElement_;

        protected DescendantElementsIterator() {
            this.nextElement_ = this.getFirstChildElement(DomNode.this);
        }

        @Override
        public boolean hasNext() {
            return this.nextElement_ != null;
        }

        @Override
        public HtmlElement next() {
            return this.nextElement();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public HtmlElement nextElement() {
            HtmlElement result = this.nextElement_;
            this.setNextElement();
            return result;
        }

        private void setNextElement() {
            HtmlElement next = this.getFirstChildElement(this.nextElement_);
            if (next == null) {
                next = this.getNextDomSibling(this.nextElement_);
            }
            if (next == null) {
                next = this.getNextElementUpwards(this.nextElement_);
            }
            this.nextElement_ = next;
        }

        private HtmlElement getNextElementUpwards(DomNode startingNode) {
            DomNode next;
            if (startingNode == DomNode.this) {
                return null;
            }
            DomNode parent = startingNode.getParentNode();
            if (parent == DomNode.this) {
                return null;
            }
            for (next = parent.getNextSibling(); next != null && !(next instanceof HtmlElement); next = next.getNextSibling()) {
            }
            if (next == null) {
                return this.getNextElementUpwards(parent);
            }
            return (HtmlElement)next;
        }

        private HtmlElement getFirstChildElement(DomNode parent) {
            DomNode node;
            if (parent instanceof HtmlNoScript && DomNode.this.getPage().getEnclosingWindow().getWebClient().isJavaScriptEnabled()) {
                return null;
            }
            for (node = parent.getFirstChild(); node != null && !(node instanceof HtmlElement); node = node.getNextSibling()) {
            }
            return (HtmlElement)node;
        }

        private HtmlElement getNextDomSibling(HtmlElement element) {
            DomNode node;
            for (node = element.getNextSibling(); node != null && !(node instanceof HtmlElement); node = node.getNextSibling()) {
            }
            return (HtmlElement)node;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ChildIterator
    implements Iterator<DomNode> {
        private DomNode nextNode_;
        private DomNode currentNode_;

        protected ChildIterator() {
            this.nextNode_ = DomNode.this.firstChild_;
            this.currentNode_ = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextNode_ != null;
        }

        @Override
        public DomNode next() {
            if (this.nextNode_ != null) {
                this.currentNode_ = this.nextNode_;
                this.nextNode_ = this.nextNode_.nextSibling_;
                return this.currentNode_;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.currentNode_ == null) {
                throw new IllegalStateException();
            }
            this.currentNode_.remove();
        }
    }

    private class DomNodeList
    implements NodeList {
        private DomNodeList() {
        }

        public int getLength() {
            int length = 0;
            for (Node node = DomNode.this.firstChild_; node != null; node = node.getNextSibling()) {
                ++length;
            }
            return length;
        }

        public Node item(int index) {
            int i = 0;
            for (Node node = DomNode.this.firstChild_; node != null; node = node.getNextSibling()) {
                if (i == index) {
                    return node;
                }
                ++i;
            }
            return null;
        }
    }
}

