/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2006 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.ajax.requesthandler;

import java.util.Date;
import org.json.JSONValue;

/**
 * {@link AJAXRequestResult} - Simple container for a {@link JSONValue result} generated by a {@link AJAXRequestHandler request handler}.
 * 
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public final class AJAXRequestResult {

    private final JSONValue resultObject;

    private final Date timestamp;

    private final int hashCode;

    /**
     * Initializes a new {@link AJAXRequestResult} with time stamp left to <code>null</code>.
     * 
     * @param resultObject The result object
     */
    public AJAXRequestResult(final JSONValue resultObject) {
        this(resultObject, null);
    }

    /**
     * Initializes a new {@link AJAXRequestResult}.
     * 
     * @param resultObject The result object
     * @param timestamp The server's last-modified time stamp (corresponding to either a GET, ALL, or LIST request)
     */
    public AJAXRequestResult(final JSONValue resultObject, final Date timestamp) {
        super();
        this.resultObject = resultObject;
        this.timestamp = null == timestamp ? null : new Date(timestamp.getTime());
        this.hashCode = _hashCode();
    }

    private int _hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((resultObject == null) ? 0 : resultObject.hashCode());
        result = prime * result + ((timestamp == null) ? 0 : timestamp.hashCode());
        return result;
    }

    @Override
    public int hashCode() {
        return hashCode;
    }

    @Override
    public boolean equals(final Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final AJAXRequestResult other = (AJAXRequestResult) obj;
        if (resultObject == null) {
            if (other.resultObject != null) {
                return false;
            }
        } else if (!resultObject.equals(other.resultObject)) {
            return false;
        }
        if (timestamp == null) {
            if (other.timestamp != null) {
                return false;
            }
        } else if (!timestamp.equals(other.timestamp)) {
            return false;
        }
        return true;
    }

    /**
     * Gets the result object.
     * 
     * @return The result object
     */
    public JSONValue getResultObject() {
        return resultObject;
    }

    /**
     * Gets the time stamp.
     * 
     * @return The time stamp
     */
    public Date getTimestamp() {
        return null == timestamp ? null : new Date(timestamp.getTime());
    }

    @Override
    public String toString() {
        return new StringBuilder(34).append(super.toString()).append(" resultObject=").append(resultObject).append(", timestamp=").append(
            timestamp).toString();
    }
}
