/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2006 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.publish.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventConstants;
import org.osgi.service.event.EventHandler;
import com.openexchange.context.ContextService;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.publish.helpers.AbstractPublicationService;
import com.openexchange.publish.impl.EntityCleanUp;
import com.openexchange.publish.impl.FolderCleanUpEventHandler;
import com.openexchange.publish.impl.InfostoreCleanUpEventHandler;
import com.openexchange.server.osgiservice.Whiteboard;

/**
 * {@link CleanUpActivator}
 * 
 * @author <a href="mailto:francisco.laguna@open-xchange.com">Francisco Laguna</a>
 */
public class CleanUpActivator implements BundleActivator {

    private List<ServiceRegistration> registrations = new LinkedList<ServiceRegistration>();

    private Whiteboard whiteboard;

    public void start(BundleContext context) throws Exception {
        whiteboard = new Whiteboard(context);
        ContextService contexts = whiteboard.getService(ContextService.class);

        EntityCleanUp entityCleanUp = new EntityCleanUp(AbstractPublicationService.STORAGE);

        registerHandler(
            context,
            new FolderCleanUpEventHandler(entityCleanUp, "contacts", FolderObject.CONTACT, contexts),
            "com/openexchange/groupware/folder/delete");

        registerHandler(context, new InfostoreCleanUpEventHandler(entityCleanUp, contexts), "com/openexchange/groupware/infostore/delete");

    }

    public void registerHandler(BundleContext context, EventHandler handler, String topic) {
        final Dictionary<Object, Object> serviceProperties = new Hashtable<Object, Object>();
        serviceProperties.put(EventConstants.EVENT_TOPIC, new String[] { topic });
        registrations.add(context.registerService(EventHandler.class.getName(), handler, serviceProperties));
    }

    public void stop(BundleContext context) throws Exception {
        for (ServiceRegistration registration : registrations) {
            registration.unregister();
        }
        whiteboard.close();
    }

}
