var tab = new temporary.VTab(newnode("span", 0, 0, [
    addTranslated(_("Subscriptions")),
    newnode("span", { background: "orange", marginLeft: "5px", padding: "2px",
                      MozBorderRadius: "2px", WebkitBorderRadius: "2px",
                      color:"white" }, 0, [document.createTextNode(_("Beta"))])
]), 0.2);
temporary.folderTabs.addTab(tab);

var widgets = {
    input: function(def) { return new ox.UI.Input(def.displayName); },
    password: function(def) { return new ox.UI.Password(def.displayName); },
    checkbox: function(def) { return new ox.UI.CheckBox(def.displayName); },
    text: function(def) { return new ox.UI.Text(def.displayName); },
    link: function(def) {
        var link = new ox.UI.Widget();
        link.default_value = "";
        link.addContent = function() {
            this.anchor = newnode("a", 0,
                { href: this.default_value, target: "_blank" },
                [document.createTextNode(this.default_value)]);
            this.node = this.parent.addCells(noI18n(def.displayName),
                                             this.anchor);
            ox.UI.Widget.prototype.addContent.apply(this, arguments);
        };
        link.set = function(value) {
            this.anchor.href = value;
            this.anchor.firstChild.data = value;
        };
        link.get = function() { return this.anchor.firstChild.data; };
        return link;
    }
};

tab.init = function() {
    var sources, modules, onInit;
    
    ox.JSON.get(AjaxRoot + "/subscriptionSources/?action=all"
        + "&columns=id,displayName,icon,module,formDescription&session="
        + session, function(reply) {
            sources = {};
            modules = {};
            for (var i in reply.data) {
                var s = reply.data[i];
                var source = { id: s[0], displayName: s[1], icon: s[2],
                               module: s[3], formDescription: s[4] };
                sources[source.id] = source;
                var module = modules[source.module];
                if (!module) module = modules[source.module] = {};
                module[source.id] = source;
            }
            if (onInit) onInit();
        });

    // Left panel
    
    var selection = new Selection();
    var grid = new LiveGrid([{
        text: _("Name"),
        index: 1,
        clear: LiveGrid.makeClear(""),
        set: LiveGrid.defaultSet
    }], selection);
    grid.emptylivegridtext = _("No subscriptions configured");
    tab.list = grid;
    
    var storage = new Storage(0, []);

    tab.enableList = function() {
        ox.JSON.get(AjaxRoot +
            "/subscriptions?action=all&columns=id,displayName&folder=" +
            this.parent.folder.id + "&entityModule=" +
            this.parent.folder.module + "&session=" + session,
            function(reply) {
                storage.remove(0, storage.ids.length);
                storage.append(reply.data);
                grid.enable(storage);
            });
    };
    
    function load(id, cont) {
        ox.JSON.get(AjaxRoot + "/subscriptions?action=get&id=" + id +
            "&session=" + session, function(reply) { cont(reply.data); });
    }

    tab.load = function(cont) { load(selection.getSelected()[0], cont); };
    
    tab.save = function(data, cont) {
        if ("id" in data) {
            ox.JSON.put(AjaxRoot + "/subscriptions/?action=update&session=" +
                session, data, function(reply) {
                    load(data.id, function(data) {
                        storage.localUpdate([data.id], function(old) {
                            return [data.id, data.displayName];
                        });
                        cont(data);
                    });
                });
        } else {
            ox.JSON.put(AjaxRoot + "/subscriptions/?action=new&session=" +
                session, data, function(reply) {
                    load(reply.data, function(data) {
                        storage.append([[data.id, data.displayName]]);
                        cont(data);
                    });
                });
        }
    };
    
    menuarrows[tab.viewID] = {};

    var menu = MenuNodes.createSmallButtonContext("subscribe.subscriptions",
        _("Subscriptions"));
    MenuNodes.createSmallButton(menu, "subscribe.subscriptions.add", _("Add"),
        getFullImgSrc("img/menu/add_category.gif"),
        getFullImgSrc("img/menu/add_category_d.gif"),
        function() { tab.addNew({}); });
    MenuNodes.createSmallButton(menu, "subscribe.subscriptions.remove", _("Remove"),
        getFullImgSrc("img/menu/remove_category.gif"),
        getFullImgSrc("img/menu/remove_category_d.gif"), confirmDelete);
    addMenuNode(menu.node, MenuNodes.FIXED, 31);
    changeDisplay(tab.viewID, "subscribe.subscriptions");
    
    menuarrows[tab.viewID] = {};
    register("OX_SELECTED_ITEMS_CHANGED", function() {
        var deleteenabled = selection.count > 0;
        menuglobalzaehler = 0;
        menuarrows[tab.viewID]["subscribe.subscriptions"] = [];
        menu_display_contents(tab.viewID, "subscribe.subscriptions", true,
            "subscribe.subscriptions.add");
        menu_display_contents(tab.viewID, "subscribe.subscriptions", deleteenabled,
            "subscribe.subscriptions.remove");
    });

    function confirmDelete() {
        if (!selection.count) return;
        newConfirm(ngettext("Delete Subscription", "Delete Subscriptions",
                            selection.count)(),
            ngettext(
                "Are you sure you want to delete the selected subscription?",
                "Are you sure you want to delete the selected subscriptions?",
                selection.count)(),
            AlertPopup.YES | AlertPopup.NO, null, null, handleDelete);
    }
    function handleDelete() {
        var ids = selection.getSelected();
        ox.JSON.put(AjaxRoot + "/subscriptions?action=delete&session=" + session,
            ids, function(reply) { storage.removeIDs(ids); });
    }

    // Right panel
    
    var entry = new ox.UI.FieldSet();
    entry.getLegend = function() {
        var select = this.select = newnode("select", 0,
            { disabled: !this.isEnabled },
            [newnode("option", 0, { value: "" },
                     [addTranslated(_("Select a source"))])]);
        addDOMEvent(this.select, "change",  
            function() { entry.updateSelect(); });
        if (sources) initSelect(); else onInit = initSelect;

        var refresh = newnode("img",
            { cursor: "pointer", verticalAlign: "middle",
              display: this.id ? "" : "none" },
            { src: getFullImgSrc("img/toolbar/tb_loading.gif") });
        addDOMEvent(refresh, "click", function() {
            refresh.src = getFullImgSrc("img/toolbar/ox_animated.gif");
            ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id="
                + entry.id + "&folder=" + tab.parent.folder.id + "&session="
                + session, stopAnim, stopAnim);
            function stopAnim() {
                refresh.src = getFullImgSrc("img/toolbar/tb_loading.gif");
            }
        });
        entry.setID = function(id) {
            // TODO: automatic refresh the first time?
            this.id = id;
            refresh.style.display = id ? "" : "none";
        }
        return [this.select, document.createTextNode(" "), refresh];

        function initSelect() {
            var module = tab.parent.folder.module;
            for (var i in sources) {
                var m = sources[i].module;
                if (m == module) {
                    select.appendChild(newnode("option", 0, { value: i },
                        [document.createTextNode(sources[i].displayName)]));
                }
            }
            onInit = undefined;
        }
    };
    entry.applyEnabled = function() {
        if (this.select) this.select.disabled = !this.isEnabled;
        ox.UI.FieldSet.prototype.applyEnabled.call(this);
    };
    entry.updateSelect = function() {
        for (var i = this.children.length - 1; i >= 0; i--) {
            this.deleteWidget(entry.children[i]);
        }
        if (this.select.value && (this.select.value in sources)) {
            var defs = sources[this.select.value].formDescription;
            for (var i = 0; i < defs.length; i++) {
                var def = defs[i];
                var widget = widgets[def.widget](def);
                if ("defaultValue" in def)
                    widget.default_value = def.defaultValue;
                this.addWidget(widget, def.name);
            }
        }
    };
    var defaultSet = entry.set;
    entry.set = function(value) {
        this.setID(value.id);
        this.select.value = value.source;
        this.updateSelect();
        defaultSet.call(this, value[value.source]);
    };
    var defaultGet = entry.get;
    entry.get = function() {
        if (!this.select.value) return;
        var value = {
            source: this.select.value,
            folder: tab.parent.folder.id,

            entityModule: tab.parent.folder.module,
            entity: { folder: tab.parent.folder.id }

        };
        value[value.source] = defaultGet.call(this);
        if (this.id) value.id = this.id;
        return value;
    };
    tab.addWidget(entry, ox.Configuration.Group.NoField);

};