/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * 
 */

var selAttachment, priority, senderAddress, signature, tmp_attachmentDialog, defaultSignature = -1;
var action = "new", myListAddressBook = null, distruGrid = null, msgref = null, autosave = null, undoActive = false;
var internalCache, tmp_attachmentDialog, defaultSignature = -1;
var refToMain = corewindow;
var configContainsKey = corewindow.configContainsKey;
var configGetKey = corewindow.configGetKey;
var configSetKey = corewindow.configSetKey;
var options = configGetKey("gui.mail.newmail_options") || { "from": true, "cc": true, "bcc": false, "options": false };
var editorEnabled = (!configGetKey("gui.mail.formatmessage").match(/text\/plain/i));

/**
 * callback when tinyMCE get initialized
 */
function cb_initTiny(inst) {	
    /*
     * setting tabindex on the editor iframe content
     */
    if ($ALL(tinyMCE.activeEditor.id+"_ifr")) {
        $ALL(tinyMCE.activeEditor.id+"_ifr").setAttribute("tabIndex", "5");
    }
    /*
     * hide the editor toolbar if the editor has been disabled (e.g. plain/text messages)
     */
	if (!editorEnabled) {    		
		var tdContent = $ALL("editor_content_tbl").getElementsByTagName("td");
		tdContent[0].style.display="none";
		tdContent[1].className="tiny_mceFirst";
	}
}

/*
 * initialize tinyMCE editor 
 */
tinyMCE.init({
    // global settings
	mode : "textareas",		
	theme : "advanced",
	editor_selector : "mceEditorOX",
	language : (corewindow && configGetKey("language") ? configGetKey("language").substring(0,2) : "en"),		
	plugins : "inlinepopups",
	content_css : getURL() + "css/mail/newmail.css",
	
	theme_advanced_buttons1 : (editorEnabled ? "newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,|,fontselect,fontsizeselect,|,forecolor,backcolor" : "") ,
	theme_advanced_buttons2 : (editorEnabled ? "cut,copy,paste,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,image,link,unlink,|,hr,|,charmap,|,blockquote" : "") ,
    theme_advanced_buttons3 : "",
	theme_advanced_toolbar_location : "top",
	theme_advanced_toolbar_align : "left",
	theme_advanced_resize_horizontal : false,
	
	extended_valid_elements : "a[name|href|target|title|onclick],img[class|src|border=0|alt|title|hspace|vspace|width|height|align|onmouseover|onmouseout|name],hr[class|width|size|noshade],font[face|size|color|style],span[class|align|style],blockquote[type|style],style[type]",
	
	gecko_spellcheck : true,	
	button_tile_map : true,
	entity_encoding: "raw",
	relative_urls : false,
	convert_urls : false,
	
	force_br_newlines : true,
	forced_root_block : "", // Needed for 3.x
	force_p_newlines : false,
	remove_linebreaks : false,
	
	init_instance_callback : "cb_initTiny",
	onBeforeRenderUI: "cb_initTiny",
	file_browser_callback : "cb_mailFileBrowser",
	
	convert_fonts_to_spans : false,
	
    setup: function(ed) { ed.onKeyPress.add(tinyKeypress); }

});

function tinyKeypress(ed, e) {
    if ((e.keyCode || e.which) == 13) {
        var range = ed.selection.getRng();
        if (range.startContainer) {
            if (!range.collapsed) {
                ed.execCommand("Delete", false, null);
                range = ed.selection.getRng();
            }
            var body = ed.getBody();
            SearchBlockquotes: {
                var container = range.commonAncestorContainer;
                while (container != body) {
                    if (container.nodeName.toUpperCase() == "BLOCKQUOTE")
                        break SearchBlockquotes;
                    container = container.parentNode;
                }
                return;
            }
            var container = range.commonAncestorContainer;
            while (container != body) {
                range.setEndAfter(container);
                var contents = range.extractContents();
                if (container.nextSibling) {
                    container.parentNode.insertBefore(contents,
                        container.nextSibling);
                } else {
                    container.parentNode.appendChild(contents);
                }
                container = container.parentNode;
            }
            var doc = ed.getDoc();
            var br = doc.createElement("br");
            range.insertNode(doc.createElement("br"));
            range.insertNode(br);
            ed.selection.select(br);
            ed.execCommand("Delete", false, null);
            tinymce.dom.Event.cancel(e);
        } else {
            var body = ed.getBody();
            var before = body.createTextRange();
            before.setEndPoint("EndToStart", range);
            before = before.htmlText;
            var after = body.createTextRange();
            after.setEndPoint("StartToEnd", range);
            after = after.htmlText;
            var mark = "#cursor~mark^";
            while (before.indexOf(mark) >= 0 || after.indexOf(mark) >= 0)
                mark += String.fromCharCode(64 + Math.random() * 63);
            body.innerHTML = before + mark + after;
            range.findText(mark);
            range.select();
            ed.execCommand("Delete", false, null);
            tinymce.dom.Event.cancel(e);
        }
    }
    if (!undoActive) {
    	tinyMCE.activeEditor.execCommand("mceAddUndoLevel");
    	undoActive = !undoActive;
    }
}


var ums = false;
function setBeforeUnload(on) {
    ums = on;
}

window.onbeforeunload = function() {
    if (ums && !isIE()) {
       return _("Do you really want to discard your changes and close the window?");
    }
};

register("Loaded", newMailOnload);
register("OX_Object_Add_Attachment", function() { 
        setTimeout(function() { 
        	toggleSelectFields("hidden");
        }, 100); 
    });
    
register("OX_Attachment_Dialog_Cancel", function() { 
        setTimeout(function() { 
        	toggleSelectFields("visible"); 
        }, 100); 
    });
    
register("OX_Cancel_Object", function() {
	function cbyes() {
		oMailFunctionsNew.cleanUp();
		window.onbeforeunload=null;
		window.close();			
	}
	function cbclose() {
		toggleSelectFields("visible");
	}
	toggleSelectFields("hidden");
	if (ums) {
	newConfirm(_("Close Window"),
		_("Do you really want to discard your changes and close the window?"),
		AlertPopup.YESNO,null,null,cbyes,null,null,null,cbclose);	
	} else {
		cbyes();
	}
});

/**
 * handles resizing of the tinyMCE editor and will be called
 * each time the resized event got triggered
 */
function cb_resize_tinyMCE() {
	/*
	 * getting the iframe element of the editor
	 */
	var editor = $ALL(tinyMCE.activeEditor.id+"_ifr");
	if (!editor) {
		return; // ups, no editor!?
	}
	
	/*
	 * needed for IE6 only. fixes some strange layout problems when resizing
	 * the editor. if we don't do it the calculation of the real size in IE6 fails.
	 */
	if (IE6) {
        editor.style.height=($("body").offsetHeight) + "px";
    }
	
	/*
	 * calculates the plain editor height without toolbar
	 * and setting the new height (if it really changed)
	 */
	var editorHeight = $('mailsplitbottom').clientHeight - $ALL("editor_content_tbl").getElementsByTagName("td")[0].offsetHeight;	
	if (editorHeight > 0 && editorHeight != editor.offsetHeight) {
		editor.style.height = editorHeight-1 + "px";
	}
	
    /*
     * works also but ineffective
    tinyMCE.settings.height = $('mailsplitbottom').clientHeight + "px";
    tinyMCE.execCommand('mceRemoveControl', true, 'editor_content');
    tinyMCE.execCommand('mceAddControl', true, 'editor_content');
    */
}

/** 
 * will be executed if the body onload event gots triggered
 */
function newMailWindowOnload() {
	activemodule='mail_new';
	initContents('mail_new');
	initAll();	
	
	window.setTimeout(function() {
		var themeStyle = corewindow.oxThemeStyle || { name: "Default", path: "default" };
		loadCSSFileForNewWindow("themes/"+themeStyle.path+"/css/global.css");
		loadCSSFileForNewWindow("themes/"+themeStyle.path+"/css/popup.css");
		loadCSSFileForNewWindow("themes/"+themeStyle.path+"/css/bgimages.css");		
	}, 0);
}

/**
 * handles the initialization of all necessary events, parameter and load
 * contents for the new mail window 
 */
function newMailOnload() {
	loadingComplete();
	
	/*
	// ugly hack to fix bug #12826	 
    var themeStyle = corewindow.oxThemeStyle || { name: "Default", path: "default" };   
    var img = document.getElementsByTagName("img");
    for (var i=0; i < img.length; i++) {
        img[i].src = img[i].src.replace(/\/default\//g, "/"+themeStyle.path+"/")
    }
    */
	triggerEvent("OX_Switch_View","mail_new");	
	triggerEvent("OX_menu_Change_Height",true);

	internalCache = corewindow.internalCache;
	action = url["action"];
	
	/*
	 * attach autocomplete to recipient dialogs if enabled in the user options
	 */
	if (configGetKey("gui.mail.autocomplete")) {
		new AutoComplete($('to'), $('AutoCompleteContent'), 25, configGetKey("minimumSearchCharacters"));	
		new AutoComplete($('cc'), $('AutoCompleteContent'), 25, configGetKey("minimumSearchCharacters"));	
		new AutoComplete($('bcc'), $('AutoCompleteContent'), 25, configGetKey("minimumSearchCharacters"));
	}
	
	// enable/disable the header fields
	for (var i in options) {
	   triggerEvent("OX_New_Mail_Show_Additional_Header", i, options[i]);
	}	
	
	/*
	 * register to reszing event for setting the new height of the tinyMCE editor
	 * when the user resizes the window 
	 */
	resizeEvents.register("Resized", cb_resize_tinyMCE); 
	
	initMessageHeader();
	initMessageContent(action);	

	if (url["to"])
		setRecipients([[ null, url["to"]]], "to");
	else if (url["cc"])
		setRecipients([[ null, url["cc"]]], "cc");
	else if (url["bcc"])
		setRecipients([[ null, url["cc"]]], "bcc");
	else if (url["subject"])
		setSubject(url["subject"]);
	
	var myFields = new Array("to", "cc", "bcc");
	
	/* 
	 * init Addressbook
	 */
	if(!myListAddressBook) {
		myListAddressBook = new SearchListAddressBook(null, "addressbookNewEmail", "newmailSearchResult", null, "newmail_add_list", "newmail_search", myFields);
        myListAddressBook.setAllFolders($("newmail-search-all-folders"),
                                        $("but_folder"));
	}
	myListAddressBook.buildFloatingDiv("none");		
	
	// disable attachments first
	triggerEvent("SubSelected", 0);
	
	// init cb for attachment dialog
	tmp_attachmentDialog = new attachmentDialog(0, cb_attachmentDialog);
	addDOMEvent($('addAddressTo'), "mousedown", function(){seachEmailAddress('to')});
	addDOMEvent($('addAddressCc'), "mousedown", function(){seachEmailAddress('cc')});
	addDOMEvent($('addAddressBcc'), "mousedown", function(){seachEmailAddress('bcc')});
	
	/*
	 * if enabled in the user options initialize auto save and register timer which
	 * saves the message each n minutes to the drafts folder 
	 */
	if (!isNaN(configGetKey("gui.mail.auto_save_drafts")) && configGetKey("gui.mail.auto_save_drafts") != 0) {
		window.setInterval("oMailFunctionsNew.autosaveMessage()", ( configGetKey("gui.mail.auto_save_drafts") * 60000 ));	
	}
	
}

registerView("mail_new", null, 
			function() {
				try{
					if (url["action"] && (url["action"] == "reply" || url["action"] == "replyall")){
						tinyMCE.execCommand('mceAddControl', true, 'editor_content');
						tinyMCE.execCommand('mceFocus', true, 'editor_content');						
					} else {
						setTimeout(function() { if ($("to") && $("to").focus()) $("to").focus(); }, 0);					
					}
				} catch(e) { }
			}, null,
			function() {
				unregister("cb_mailComboChanged", cb_mailComboChanged);
			},
			function() {
				try{
					if (url["action"] && (url["action"] == "reply" || url["action"] == "replyall")){
						tinyMCE.execCommand('mceAddControl', true, 'editor_content');
						tinyMCE.execCommand('mceFocus', true, 'editor_content');
					} else {
						setTimeout(function() { if ($("to") && $("to").focus()) $("to").focus(); }, 0);					
					}
				} catch(e) { }
			}
			

		);

/**
 * The attachment dialog callback. We take the given objects
 * and convert them into unique attachment objects.
 * @param {attachments} the attachment object
 */
function cb_attachmentDialog(attachments) {	
	toggleSelectFields("visible");
	// nothing to do
	if (!attachments && !attachments.length) return;
		
	// fetch objects and add to global attach obj
	for (var i=0; i<attachments.length; i++) {
		if (!oMailFunctionsNew.attachmentExists(attachments[i].id)) {
			oMailFunctionsNew.addAttachment(
				{id: attachments[i].id, filename: attachments[i].filename, size: null, 
				content_type: attachments[i].content_type || null, 
				msgref: attachments[i].msgref || null, selected: false});
		}
	}
}

/*
 * The attachment remove callback
 */
register('OX_Object_Attachment_Delete', cb_deleteAttachments);
function cb_deleteAttachments() {	
	for (var i=0; i<oMailFunctionsNew.attachObj.length; i++) {
		if (oMailFunctionsNew.attachObj[i].selected) {
			oMailFunctionsNew.removeAttachment(oMailFunctionsNew.attachObj[i].id);
			triggerEvent("SubSelected", 0);
		}
	}
}

register("setSignature", cb_setSignatureText);
function cb_setSignatureText(obj) {
	if(obj) {		
		obj.signature_text = obj.signature_text.replace(/\n/g,"<br/>");
		var text = tinyMCE.activeEditor.getContent();
		if(obj.position == "above") {			
			var newText = "<span>" + replaceLeadingSpaces(obj.signature_text) + "</span><br/><br/>" + text;
		} else if(obj.position == "below") {			
			var newText = text + "<br/><br/><span>" + replaceLeadingSpaces(obj.signature_text) + "</span>";
		} else {
			var newText = text + "<br/><br/><span" + replaceLeadingSpaces(obj.signature_text) + "</span>";
		}
		tinyMCE.activeEditor.setContent(newText);
//		window.setTimeout(
//			function() {
//				tinyMCE.activeEditor.setContent(newText); 
//			}, 0);
	}
}

function initMessageHeader() {
	var aliases = {};
	for (var i=0; configContainsKey("mail.addresses") && i<configGetKey("mail.addresses").length; i++) {
		aliases[configGetKey("mail.addresses")[i]] = configGetKey("mail.addresses")[i];
	}	
	
	// adding e-mail addresses from external accounts to sender addresses list
	if (corewindow.mail_accounts && corewindow.mail_accounts.ids.length) {
		corewindow.mail_accounts.newIterate(corewindow.mail_accounts.ids, emptyFunction,
	            function(i, data) {
					aliases[data.primary_address] = data.primary_address + " (" + data.name + ")";
	            });
	}
	var scrollBar = aliases.length > 3 ? 4 : null;
	senderAddress = new ComboBox3(window, "mail.fromCombo", "25em", 0, true, "cb_mailComboChanged", scrollBar);	
	for (var i in aliases) {
		senderAddress.addElement(aliases[i], i);
	}
	senderAddress.getDomNode();
	senderAddress.setKey(configGetKey("mail.sendaddress"));
	
	priority = new ComboBox3(window, "mail.priorityCombo", "13em", 1, true, "cb_mailComboChanged", 3);
	priority.addElement("Low","4");
	priority.addElement("Normal","3");
	priority.addElement("High","2");
	priority.getDomNode();
	register("cb_mailComboChanged", cb_mailComboChanged);
	
    priority.onShow = function() { toggleSelectFields("hidden"); }
    priority.onHide = function() { toggleSelectFields("visible"); }
	
	signature = new ComboBox3(window, "mail.signatureCombo", "15em", 0, true, "setSignature", 2);
	if(configContainsKey("gui.mail.signatures")) {
		signature.addElement("None","");
		for (var a=0; a < configGetKey("gui.mail.signatures").length; a++) {
			var signatures = configGetKey("gui.mail.signatures")[a];
			function make_callback(value) {
				return function() { return value; };
			}
			var sig_name = signatures.signature_name.length == 0 ? _("Unnamed signature") /*i18n*/ : signatures.signature_name;
			signature.addElement(sig_name, signatures, make_callback(sig_name));
			if(configGetKey("gui.mail.signatures")[a].signature_default) {
				defaultSignature = a;
				signature.selected = a+1;				
			}
		}
	} else {
		signature.addElement("No signature","");
	}
	signature.getDomNode();
	
	if(!configGetKey("gui.mail.signatures") || ((configGetKey("gui.mail.signatures") && configGetKey("gui.mail.signatures").length == 0))) {
		setTimeout(function() { signature.disable(); }, 0);
	}
	
	if (configGetKey("mail.vcard")) document.getElementsByName("mail.attachVCard")[0].checked=true;	
}

function cb_mailComboChanged() {	
	setBeforeUnload(true);
}

function initMessageContent(m_action) {
	var addParam = "";
	if (m_action && m_action == "draft") {
		m_action = "get", addParam = "&edit=1";
	}
	
	if (m_action && m_action != "") {
        var sObj = "multiForward" in window ? multiForward : [{ "folder": url["folder"], "id": url["id"] }];        
		
		(new JSON()).put(AjaxRoot + "/mail?action=" + m_action + "&session=" + 
			corewindow.session + addParam, sObj, null, 
				function(cb) {
					if (cb && cb.data) {
						setRecipients(cb.data["to"], "to");
						setRecipients(cb.data["cc"], "cc");
						setRecipients(cb.data["bcc"], "bcc");
						setSubject(cb.data["subject"]);
						msgref = cb.data["msgref"];
						if (cb.data["nested_msgs"] && cb.data["nested_msgs"].length > 0) {
							for (var i = 0; i < cb.data["nested_msgs"].length; i++) {
								var nobj = cb.data["nested_msgs"][i];
								var textAttachment = nobj.subject || _("attachment");
								oMailFunctionsNew.addAttachment(
									{ id: nobj.id || "message/rfc822", 
									filename: textAttachment, size: null, 
									content_type: "message/rfc822", 
									msgref: nobj.msgref || null, selected: false,
									disk: nobj.disk || null});
							}
						}
						setMessageText(cb.data["attachments"]);	
						
						if(cb.data["priority"] && priority) {
							priority.setKey(cb.data["priority"]);
						}
	                    if (action == "draft" && cb.data["disp_notification_to"] && $("acknowledge")) {
	                        $("acknowledge").checked = true;
	                    }
					}
					setTimeout(function() {
						// disable loading screen
	                    $("loading_data_bg").style.display="none";
					}, 0);
				},
				function(cb) {
					// disable loading screen
                    $("loading_data_bg").style.display="none";
                    // mail no longer exists so shwo alert and then close window
					if (cb && cb.code == "MSG-0032") {
						newAlert(_("Error"), formatError(cb), 
								function() { 
									oMailFunctionsNew.cleanUp();
									corewindow.triggerEvent("OX_Mail_Delete");
									window.onbeforeunload=null;
									window.close();
								}
						);
						return true;
					} else {
						return false;
					}
				});
		
	} else {
		if (typeof aInfoMailAttachmentFile != "undefined") {
			setMessageText(aInfoMailAttachmentFile);
		} else if (typeof aInfoMailAttachmentLink != "undefined") {
			setMessageText(aInfoMailAttachmentLink);
		} else {
			setMessageText({}); // new message, call with blank text
		}
		setTimeout(function() {
			// disable loading screen
	        $("loading_data_bg").style.display="none";
		}, 0);
	}
}

function setRecipients(to, field) {
	if (to && to.length && $(field)) {
		$(field).value = corewindow.getAdressString(to, false);
		if (field != "to" && trimStr($(field).value).length != 0) {
		   // don't use trigger event because we won't store the settings! 
		   oMailFunctionsNew.showAdditionalHeaderField(field, true);		  
		}		
	}
	// trying to find any of the sender addresses in the reply-addresses
	// if so, re-set this address as sender address
	for (var i in to) {
		for (var ib in senderAddress.elements) {
			if (to[i][1] && String(to[i][1]).indexOf(senderAddress.elements[ib].key) != -1) {
				senderAddress.setKey(senderAddress.elements[ib].key);
			}			
		}
	}
}

function setSubject(subject) {
	if (subject) $("subject").value = subject;	
}

function setMessageText(attachments) {

	var mda = $("newMailAttachmentDivExist"), cnn = "";
	for (idfield in attachments) {
		var conArr = attachments[idfield];
		var ct = conArr["content_type"].toLowerCase();
		var con = conArr["content"];		
		if (ct.search(/text\//) != -1 && con && con != undefined) {
			if (ct.search(/text\/plain/) != -1) {
				cnn += replaceLeadingSpaces(con);
			} else { 
				cnn += con;
			}
		} else {	
		 	if(conArr["filename"] && !oMailFunctionsNew.attachmentExists(conArr.id)) {
				oMailFunctionsNew.addAttachment(
					{id: conArr.id || null, filename: conArr.filename || null, 
					size: conArr.size || null, content_type: conArr.content_type || null, 
					disp: conArr.disp || null, content: conArr.content || null, 
					disk: conArr.disk || null, selected: false,
					infostore: conArr.infostore || null});
			}
		}
	}

//	if (action != "draft")	{
//		setTimeout(function() { 
//			cb_setSignatureText(configGetKey("gui.mail.signatures")[defaultSignature]) 
//		}, 0);
//	}
	
	setTimeout(function() { 
		tinyMCE.activeEditor.setContent(cnn);

		if (action != "draft")	{
			cb_setSignatureText(configGetKey("gui.mail.signatures")[defaultSignature]);
		}

		if (editorEnabled) { 
			var default_font_tynmce = configGetKey("gui.mail.defaul_mail_font");
			if (default_font_tynmce && default_font_tynmce != 'default'){ tinyMCE.execCommand('fontname',false,default_font_tynmce);  }

			var default_font_size_tynmce = configGetKey("gui.mail.defaul_mail_font_size");
			if (default_font_size_tynmce && default_font_size_tynmce != 'default'){ tinyMCE.execCommand('fontsize',false,default_font_size_tynmce);  }
		
			try{
				//if (url["action"] && (url["action"] == "reply" || url["action"] == "replyall")){
					tinyMCE.execCommand('mceAddControl', true, 'editor_content');
					tinyMCE.execCommand('mceFocus', true, 'editor_content');
				//} else {
				//	setTimeout(function() { if ($("to") && $("to").focus()) $("to").focus(); }, 0);					
				//}
			} catch(e) { }
		}
		
		// Other options which can be used here.
		//tinyMCE.execCommand('Bold');
		//tinyMCE.execCommand('mceInsertContent',false,'<b>Hello world!!</b>');
		 	
	}, 0);

	
}

function MailFunctions() {
	this.oo = new Object();
	this.ooA = new Object();
	this.attachContainer = new Array();	
	this.attachObj = new Array();
    this.savePending = false;
}

MailFunctions.prototype = {

	sendMessage : function(param) {	
		var Self = this;	
        if (this.savePending) return;
		if (!param) { 
            Self.getMailValues(); 
        }
		function cb_ok() {
			Self.savePending = true;
	        if (action == "forward")
                Self.oo["sendtype"] = 2;
	        else if (action == "reply" || action == "replyall")
	            Self.oo["sendtype"] = 1;
	        Self.sAction  = AjaxRoot + "/mail?action=new&session=" + corewindow.session;
	        var sTargetParam = 'mailSendCB';        
	        tmp_attachmentDialog.do_post(Self.oo,callback_new,Self.sAction,sTargetParam);
		}
        if (trimStr(Self.oo["subject"]).length == 0) {
	          newInput(_("Send"),_("You did not entered a subject. Would you like to enter a subject now?"), 
	                   null, "", AlertPopup.OKCANCEL, function() {
                   	   	   $("subject").value = $("create_window_text_field").value;
                           Self.oo["subject"] = $("create_window_text_field").value;
                           cb_ok();
	                   }, null, null, null, "input", null);
        } else {
        	cb_ok();
        }
	},
	
	saveMessageAsDraft : function() {
		this.getMailValues();
		this.oo["flags"] = 4;
		this.sendMessage("fromDraft");
	},
	
	autosaveMessage: function() {		
		if (!ums) return; // nothing changed, so no need to save anything
		
		this.getMailValues();
		delete(this.oo["attachments"]);
		delete(this.oo["infostore_ids"]);
		if (autosave) {
			this.oo["msgref"] = autosave;
		} else {
			delete(this.oo["msgref"]);
		}
		this.oo["flags"] = 4;
		// refill message text
		this.oo["attachments"] = [ { content_type: configGetKey("gui.mail.formatmessage"),
                                   content: tinyMCE.activeEditor.getContent() } ];	
		
		new JSON().put(AjaxRoot + "/mail?action=autosave&session=" + corewindow.session, this.oo, null, 
		function(reply) {
			if (!reply.error && reply.data) {
                corewindow.updateDraftsFolderCache(autosave, reply.data);
                autosave = reply.data;
			}
		});
	},
	
	cleanUp: function() {						
		// delete autosave message if necessary
		if (autosave) {
			corewindow.deleteAutosaveMessage(
			     configGetKey("mail.folder.drafts"), 
			     String(autosave.match(/[0-9]+$/g)), true);
		}
	},
	
	getMailValues : function() {		
		this.clearObjectContent();

		var mail_pn = corewindow.getPersonalFullName() ? "\"" + corewindow.getPersonalFullName() + "\"" : "";
		var mail_sa = senderAddress.getKey() ? senderAddress.getKey() : "undefined";
		this.oo["from"] = mail_pn + "<" + mail_sa + ">";
		this.oo["to"] = $("to").value;
		this.oo["cc"] = $("cc").value;
		this.oo["bcc"] = $("bcc").value;
		this.oo["subject"] = $("subject").value;
		this.oo["priority"] = priority.getKey();
		if (msgref != null)
			this.oo["msgref"] = msgref;
				
		if(typeof aInfoMailAttachmentFile != "undefined" && aInfoMailAttachmentFile.length > 0) {
			this.oo["infostore_ids"] = new Array();
			for (var id in aInfoMailAttachmentFile) {
				this.oo["infostore_ids"].push(aInfoMailAttachmentFile[id].id);
			}
		}
		
		if(document.getElementsByName("acknowledge")[0].checked)
			this.oo["disp_notification_to"] = document.getElementsByName("acknowledge")[0].checked;
		 		
		if(document.getElementsByName("mail.attachVCard")[0].checked)
			this.oo["vcard"] = 1;
	
		this.ooA["content_type"] = configGetKey("gui.mail.formatmessage");
		this.ooA["content"] = tinyMCE.activeEditor.getContent();
			
		// build the final attachment object
		var tmp_attachObj = new Array();
		tmp_attachObj.push(this.ooA); // always message text first
		for (var i=0; i<this.attachObj.length; i++) {
			if (this.attachObj[i].content_type != null && !this.attachObj[i].infostore) {
				tmp_attachObj.push(this.attachObj[i]);
			}
		}
		this.oo["attachments"] = tmp_attachObj;		
	},
	
	clearObjectContent: function() {
		this.oo = {};
		this.ooA = {};
	},
	
	addAttachment: function(attachObj) {
		if (!attachObj || !attachObj.id)
			return;			
		this.attachObj.push(attachObj);
		this.drawAttachmentPanel();
	},
	
	getAttachment: function(id) {
		for (var i=0; i<this.attachObj.length; i++) {
			if (this.attachObj[i].id == id)
				return this.attachObj[i];
		}
		return null;
	},
	
	removeAttachment: function(id) {
		for (var i=0; i<this.attachObj.length; i++) {
			if (this.attachObj[i].id == id) {
				this.attachObj.splice(i,1);
				tmp_attachmentDialog.removeFiles([id]);
			}
		}
		this.drawAttachmentPanel();
	},
	
	attachmentExists: function(id) {
		return (this.getAttachment(id) != null ? true: false);
	},
	
	drawAttachmentPanel: function() {
		var mda = $("newMailAttachmentDiv");
		removeChildNodes(mda);
		
		for (var i=0; i<this.attachObj.length; i++) {
			var oDOMDiv = newnode("div", 0, { id: this.attachObj[i].id, className: "mailDetailAttachmentsCont" + (this.attachObj[i].selected ? "Sel background-color-PMG-selection-elements" : "") },
				[ newnode("img",0,
					{ src: getFullImgSrc("img/mail/" + (this.attachObj[i].content_type && this.attachObj[i].content_type.match(/^message\/rfc822/gi) ? "unread.gif" : "attachment.gif")), align: "absmiddle", padding: "3px"}),
				  	newnode("span",0,{className: "_nothing"},
				  		[ document.createTextNode(
				  			format(_(" %1$s%2$s; "), this.attachObj[i].filename, 
				  			(this.attachObj[i].size ? " (" + bytesToString(this.attachObj[i].size) + ")" : "")) ) ]
					  	)
					]
				);	
			
			addDOMEvent(oDOMDiv, "mousedown", (function(id, oMailFunctionsNew) {
				return function(e) {	
					cancelDefault(e);	
					oMailFunctionsNew.selectAttachment(id);
				};
			})(this.attachObj[i].id, oMailFunctionsNew));
						
			mda.appendChild(oDOMDiv);
		}
		
		var os = "0em";
		if (this.attachObj.length > 0)	
			os = "3.2em";
		setTimeout(function() { resizeSplit(mda.id, os) },0);

		toggleSelectFields("visible");
	},
	
	/*
	 * @private
	 * 
	 */
	selectAttachment: function(id) {
		for (var i=0; i<this.attachObj.length; i++) {
			this.attachObj[i].selected=false;
			if (this.attachObj[i].id == id) {
				this.attachObj[i].selected=true;
				triggerEvent("SubSelected", 1);
			}
			document.getElementById(this.attachObj[i].id).className=
				"mailDetailAttachmentsCont" + (this.attachObj[i].selected ? "Sel background-color-PMG-selection-elements" : "");
		}		
	},
	
	showAdditionalHeaderField: function(field, selected) {
		if (!$ALL(field + "_row") || $ALL(field + "_row").style.display == (selected ? "" : "none")) {
				return;
		}
	   $ALL(field + "_row").style.display = selected ? "" : "none";
	   $ALL("menu_new_mail_view_" + field + "field_checkbox").checked = selected;
	   this.drawAttachmentPanel();
	}
}

var oMailFunctionsNew = new MailFunctions();

function callback_new(cb) {
    oMailFunctionsNew.savePending = false;
	if (cb) {
		if (cb.data && !cb.error) {
			switch(action) {
				case "reply":
				case "replyall":
				    corewindow.updateMailFlagsInternal(url["folder"], url["id"], { flag:1, bool:true });
				    break;
				case "forward":
				    corewindow.updateMailFlagsInternal(url["folder"], url["id"], { flag:256, bool:true });
				    break;
				case "draft":
				    corewindow.updateDraftsFolderCache(url["id"], cb.data);
				    break;				
			}
			oMailFunctionsNew.cleanUp();
			window.onbeforeunload=null;
			window.setTimeout(
				function() {
					window.close();
				}, 250);
		} else {
			newServerError(cb);
		}
	} else {
		triggerEvent("OX_New_Error", 4, _("The server didn't respond!"));
	}
}

register("OX_SAVE_OBJECT", function() {
			oMailFunctionsNew.sendMessage()
		});

register("OX_Save_Template_Object", function() {
			action = "draft";
			oMailFunctionsNew.saveMessageAsDraft()
		});

register("OX_New_Mail_Show_Additional_Header", function(field, selected) {   
   options[field] = selected;
   configSetKey("gui.mail.newmail_options", options);
	oMailFunctionsNew.showAdditionalHeaderField(field, selected);
});	

var ums = false;
function setBeforeUnload(on) {
    ums = on;
}

/* search EmailAddresses */
function seachEmailAddress(recipientField) {
	setTimeout(function() { toggleSelectFields("hidden") }, 100);
	centerPopupWindow($('addressbookNewEmail'));
	$('addressbookNewEmail').style.display = 'block';
	addOnClose($("addressbookNewEmail"),closeAddressbookNewEmail);
	myListAddressBook.resetView();
	myListAddressBook.recipientType = recipientField;
	addressbookFolderPath();
	myListAddressBook.getResult();
}

function newmailContact() {		
	var searchString = $('newmail_search').value;
	myListAddressBook.searchstring = searchString;
	myListAddressBook.method = "mail";
				
	myListAddressBook.getResult();
	distruGrid.events.register("Activated", function(ids) {		
		});
	
	distruGrid.events.register("Selected", function(ids) {
			myListAddressBook.numberOfSelection = ids;	
		});		
}

function closeAddressbookNewEmail() {
	toggleSelectFields("visible");
	var _ftj = myListAddressBook.tmpIdsForSave && 
		myListAddressBook.tmpIdsForSave.length != 0 ? "subject" : myListAddressBook.recipientType;
	setTimeout(function() {
			if(document.getElementById(_ftj) && document.getElementById(_ftj).focus()) 
				document.getElementById(_ftj).focus(); 
		},0);
}

function toggleSelectFields(switchView) {
	if(!IE6 || !editorEnabled) return;

	var d1 = document.getElementById('mce_editor_0_fontNameSelect')
	if(d1 && d1.style.visibility != switchView) d1.style.visibility = switchView;
	
	var d2 = document.getElementById('mce_editor_0_fontSizeSelect');
	if(d2 && d2.style.visibility != switchView)	d2.style.visibility = switchView;
}

function toogleAdditionalMailHeader(cStatus) {
	var newStatus = cStatus || !$('menu_new_mail_view_optionsfield_checkbox').checked;	
	$('menu_new_mail_view_optionsfield_checkbox').checked = newStatus; 
	triggerEvent('OX_New_Mail_Show_Additional_Header', 'options', newStatus);
}

function addnewmailToList(field) {
	if(myListAddressBook)
		myListAddressBook.addToList('bySelection', field);	
}

function addAllnewmailToList() {
	if (myListAddressBook)
		myListAddressBook.addToList('all');
}

function replaceLeadingSpaces(text) {
	return text.replace(/(^|<br>)([ \t]+)|([ \t]{2,}|\t)/g,
		function(_, prefix, m1, m2) {
			var match = (m1 || m2).replace(/\t/g, "        "); // TODO: real tabs
			var retval = new Array((match.length + 3) >> 1);
			retval[0] = prefix || "";
			var max = match.length >> 1;
			for (var i = 1; i <= max; i++) retval[i] = "&nbsp; ";
			if (match.length & 1) retval[retval.length - 1] = "&nbsp;";
			return retval.join("");
		});
}

function getURL() {
	var URL = window.location.pathname;
   URL = URL.substring(0, URL.lastIndexOf("/")+1);
   return URL;
}

function isIE() {
	var test = navigator.appVersion.match(/MSIE (\d+\.\d+)/, '');
    return (test != null && Number(test[1]) >= 5.5);
}

/**
 * File browser for adding images as Inline Content. 
 * Will be added to the Image selection dialog.
 * @param field_name
 * @param url 
 * @param type
 * @param win
 */
function cb_mailFileBrowser(field_name, url, type, win) {
    if (!win || !win.document) {
        return false;
    }

    var URL = getURL();    

    var doc = win.document;
    if (doc.getElementById("oxmainBG")) {
        doc.getElementById("oxmainBG").parentNode.removeChild(doc.getElementById("oxmainBG"));
    }
    if (doc.getElementById("oxmain")) {
        doc.getElementById("oxmain").parentNode.removeChild(doc.getElementById("oxmain"));
    }
    
    if (IE6 && doc.getElementById('align')) {
        doc.getElementById("align").style.visibility = "hidden";
    }

    // build div for file browser
    var nd1 = newnode("div", { zIndex: 2, width: "100%", height: "100%", top: 0, left: 0, position: "fixed", background: "#FFFFFF none repeat scroll 0 0", opacity: 0.6 }, { id: "oxmainBG" }, null, doc);

    var pURL = AjaxRoot + "/file?action=new&module=mail&type=image&session=" + corewindow.session;
    var nd2 = newnode("div", { position: "absolute", zIndex: 3, top: 0, left: 0, width: "100%", height: "100%" },{ id: "oxmain"}, null, doc);
    var nd_form;
    if (isIE()) {
        nd_form = doc.createElement('<form action="' + pURL + '" method="POST" enctype="multipart/form-data" target="hiddenNMFrame" name="mailUploadImage" id="mailUploadImage">');
    } else {
    	nd_form = newnode("form", null, { enctype: "multipart/form-data", method: "post", action: pURL, acceptCharset: "UTF-8", target: "hiddenNMFrame", id: "mailUploadImage", name: "mailUploadImage" }, null, doc);
    }
   
    var nd3 = newnode("div", { width: "90%", position: "absolute", zIndex: "99", top: "85px", left: "12px", padding: "5px", textAlign: "right", border: "1px solid gray", backgroundColor: "white", id: "oxmainContent" }, null, null, doc);  

    nd3.appendChild( newnode("div", { width: "90%", textAlign: "left" }, null, [ doc.createTextNode(_("Select a File:")) ], doc ));
    nd3.appendChild( newnode("input", { border: "solid 1px gray", width: "100%" }, { type: "file", size: "30", name: "file", id: "file" }, null, doc) ); 
   
    var nd4 = newnode("input", { marginTop: "5px" }, { type: "button", name: _("OK"), value: _("OK") }, null, doc);
    addDOMEvent(nd4, "click", function() { win.sendOXFile() }, win);
    nd3.appendChild(nd4);
    
    var nd5 = newnode("input", { margin: "5px 0px 0px 5px" }, { type: "button", name: _("Cancel"), value: _("Cancel") }, null, doc);
    addDOMEvent(nd5, "click", function() { win.disableOXBG() }, win );
    nd3.appendChild(nd5);
    
    nd_form.appendChild(nd3);
    nd2.appendChild(nd_form);   
    doc.body.appendChild(nd1);
    doc.body.appendChild(nd2);   

    doc.body.appendChild( newnode("script", null, { language: "javascript", type: "text/javascript", src: URL + "js/mail/mailFileBrowser.js" }, null, doc ) );
    doc.body.appendChild( newnode("iframe", { display: "none" }, { scrolling: "no", frameBorder: "0", src: URL + "newInfoItemHidden.html", name: "hiddenNMFrame", id: "hiddenNMFrame"}, null, doc) );

    /* *** Ugly workaround for IE Only *** */
    if (win.frames["hiddenNMFrame"].name != "hiddenNMFrame") { 
        win.frames["hiddenNMFrame"].name = "hiddenNMFrame";
    }

    var ielem = win.document.getElementById("insert");
    if (ielem) {
        ielem.onmousedown = function() {    if (win.oxFile) addImg2Poll(win.oxFile); }
    }
   
    return false;
}

function addImg2Poll(id) {
	var timeout = configGetKey("maxUploadIdleTimeout") ? configGetKey("maxUploadIdleTimeout") : 200000;
	timeout = Math.round(timeout * .9);
	window.setInterval(function() {
		(new JSON()).get(AjaxRoot + "/file?action=keepalive&session=" + corewindow.session + "&id=" + id,
			null, function(cb) { }, function(cb) { return true });
	}, timeout);
}