/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * 
 */

var fdInfoDetailTabsList = new Array('tab_infodetail1','tab_infodetail2','tab_infodetail3');
var fdInfoDetailPanelsList = new Array('panel_infodetail1','panel_infodetail2','panel_infodetail3');

var bDetailVersionLoaded = false;
var bVersionCreated		= false;

var nCurrentDetailItemTimestamp = -1;
var versJSON = new JSON();
var infostoreRequest;
var infostoreLinkingObject;
register("OX_Switch_InfoStore_Detail",function(param) { menuswitchInfoStoreDetail(param) });
function loadInfoDetail() {
	register('OX_InfoStore_Delete', deleteDetailItems);
	register('OX_InfoStore_Edit', editDetailItems);
	var aEvents = new Array();
	var aEvent = new Array('OX_Switch_InfoStore_Detail','overview');
	aEvents[0] = aEvent;
	var aEvent = new Array('OX_Switch_InfoStore_Detail','version');
	aEvents[1] = aEvent;							
	var aEvent = new Array('OX_Switch_InfoStore_Detail','links');
	aEvents[2] = aEvent;
			
	setTabLists(fdInfoDetailTabsList, fdInfoDetailPanelsList,aEvents);		
	refreshDetailDetailView(1); 
	/* init Linking */
	if(!oLastSelectedInfoObject) return;
	var oObjectIdObj = oLastSelectedInfoObject[0];
	if(!infostoreLinkingObject) {
		infostoreLinkingObject = new LinkingObject('infodet_Linking', oObjectIdObj.id, 137, 'infodet_count_linking');
		infostoreLinkingObject.makeLiveGrid();
	} else {
    	infostoreLinkingObject.id = oObjectIdObj.id;
		infostoreLinkingObject.getStorage();
    }
	infostoreLinkingObject.disableLinkingLivegrid();
}

unregister('OX_InfoStore_Delete', deleteDetailItems);
unregister('OX_InfoStore_Edit', editDetailItems);

function deleteDetailVersion()
{
	function cbyes() {
		var oObjectIdObj = oLastSelectedInfoObject[0];	
		var aVersions = gridVersionsInfoSplit.getSelectedIDs();
		var nTimeStamp = versionsStorage.timestamp;
		
		function cb_detach_version(arg) { getVersions(); }
		doAjaxDetachVersion(oObjectIdObj,aVersions,nTimeStamp,cb_detach_version);
	}
	newConfirm(_("Delete Version"),_('Are you sure you want to delete the selected version?'),AlertPopup.YESNO,null,null,cbyes);
}

function doAjaxDetachVersion(oObjectIdObj,aVersions,nTimeStamp,callback) {
	var sAjaxRequest = AjaxRoot + "/infostore?action=detach&id=" + oObjectIdObj.id +"&session=" + session + 
									"&folder=" +oObjectIdObj.folder + "&timestamp=" + nTimeStamp;
	versJSON.put(sAjaxRequest, aVersions,null,callback);
}

function setCurrentVersion() {	
	var oObjectIdObj = oLastSelectedInfoObject[0];	
	var aVersions = gridVersionsInfoSplit.getSelectedIDs();
	var nVersion = aVersions[0]; //one Selected...
	var nTimeStamp = versionsStorage.timestamp;
	function cb_set_current(arg)  { getVersions(findVersion); }
    function findVersion() {
        versionsStorage.newIterate([nVersion], emptyFunction, updateCache);
    }
    function updateCache(n, data) {
        var newData = {
            filename: data[3],
            file_mimetype: data[4],
            file_size: data[5],
            version: data[0],
            version_comment: data[8],
            current_version: true
        };
        OXInfoStoreMapping.editObjects([oObjectIdObj], newData);
    }
	var newInfoItem = new Object();
	newInfoItem['version'] = parseInt(nVersion);
	doAjaxRequestUpdateItem(oObjectIdObj,newInfoItem,nTimeStamp,cb_set_current);
}

function doAjaxRequestUpdateItem(oId,newInfoItem,nTimeStamp,callback) {
	var nId = parseInt(oId.id);
	var sAjaxRequest = AjaxRoot + "/infostore?action=update&id="+nId+"&timestamp="+nTimeStamp+"&session=" + session;
	newInfoJson.put(sAjaxRequest, newInfoItem, null,callback);		
}

function deleteDetailItems() {
	function cbyes() {
		var sInfoStoreDefaultView = configGetKey("gui.infostore.view").split("/")[1];
		setActiveFolder(oLastSelectedInfoObject[0].folder_id, function () { menuswitchInfoStoreView(sInfoStoreDefaultView); });
		OXInfoStoreMapping.deleteObjects([oLastSelectedInfoObject[0]]);
	}
	newConfirm(_("Delete Object"),_('Are you sure you want to delete selected item?'),AlertPopup.YESNO,null,null,cbyes);
}

function editDetailItems()
{
	editInfoItemId = oLastSelectedInfoObject[0];		
	openNewInfoPopup("infostore",editInfoItemId.folder);
}

var gridVersionsInfoSplit;
function loadDetailDocumentVersions(arg, cb_functionDetail) {	
	if(arg=='version') {
		var oObjectIdObj = oLastSelectedInfoObject[0];
		function setDocSize(div, text) {
			if(text < 0 ) { var sDisplayString = ''; }
			else { var sDisplayString = bytesToString(text); }
			
			if (div.firstChild) { div.firstChild.data = sDisplayString; }
			else { div.appendChild(document.createTextNode(text)); }
		}	
		if(!bVersionCreated) {
			bVersionCreated = true;	
			var clear = LiveGrid.makeClear("...");
			var DomListDiv = $("lg_versions_info_split");
			var DomListDivHeader = $("lg_versions_info_splitHeader");
			gridVersionsInfoSplit = new LiveGrid([
				{
					index: 1,
					text: "Version", /*i18n*/
					i18n: true,						
					width: "6em",								
					sortable: true,
					set: LiveGrid.defaultSet,					
					clear: LiveGrid.makeClear("...")
				}, {
					index: 2,
					text: "Created", /*i18n*/
					i18n: true,						
					width: "8em",								
					sortable: true,
					set: LiveGrid.dateSet,				
					clear: LiveGrid.makeClear("...")
				}, {
					index: 3,					
					text: "File", /*i18n*/
					i18n: true,						
					sortable: true,
					set: LiveGrid.defaultSet,					
					clear: LiveGrid.makeClear("...")
				}, {
					index: 4,		
					text: "Mime Type", /*i18n*/
					i18n: true,						
					sortable: true,
					width: "15em",			
					set: LiveGrid.defaultSet,					
					clear: LiveGrid.makeClear("...")
				}, {
					index: 5,					
					text: "Size", /*i18n*/
					i18n: true,						
					width: "8em",														
					sortable: true,	
					set: setDocSize,
					clear: LiveGrid.makeClear("...")
				}, {
					index: 6,					
					text: "Current", /*i18n*/
					i18n: true,						
					width: "6em",														
					sortable: true,	
					set: function (div, text) {
						if(text)
							var sDisplayString = _('Yes');
						else
						{
							var sDisplayString = _('No');
						}
						if (div.firstChild)
							div.firstChild.data = sDisplayString;
						else
							div.appendChild(document.createTextNode(sDisplayString));
					},				
					clear: LiveGrid.makeClear("...")
				}
            ], new Selection());
			DomListDivHeader.appendChild(gridVersionsInfoSplit.getHeader());
			gridVersionsInfoSplit.getTable(DomListDiv);
			gridVersionsInfoSplit.events.register("Selected", function(ids) {
				refreshDetailVersions(ids);					
				triggerEvent("SubSelected",ids);
			});
    		getVersions();
    		var menu = gridVersionsInfoSplit.contextmenu = new ContextMenu();
            var current = new MenuItem("Current"/*i18n*/,
                function() { triggerEvent('OX_InfoStore_Version_Current'); });
            current.setIcon("img/menu/infostorecurrentversion.gif",
                            "img/menu/infostorecurrentversion_d.gif");
            menu.addItem(current);
            var del = new MenuItem("Delete"/*i18n*/,
                function() { triggerEvent('OX_InfoStore_Version_Delete'); });
            del.setIcon("img/menu/delete.gif", "img/menu/delete_d.gif");
            menu.addItem(del);
            menu.onShow = function() {
                var collection = {
                    columns: ["created_by", "modified_by", "locked_until",
                              "file_size", "filename"],
                    objects: infostoreSelection.getSelected()
                };
                OXCache.newRequest(null, "infostore", collection,
                                   callback, callback);
                function callback(objects) {
                    var count = menu.getContext().count;
                    var hasRights;
                    if (count)
                        hasRights = menuhasRight(objects.objects, "WRITE")
                                 && checkRights(objects.objects);
                    current.setEnabled(count == 1 && hasRights);
                    del.setEnabled(count > 0 && hasRights);
                }
                function checkRights(objects) {
                    var me = configGetKey("identifier");
                    for(var i in objects) {
                        var obj = objects[i];
                        if(obj.locked_until && obj.modified_by != me) return false;
                    }
                    return true;
                }
            };
    	} else {
            getVersions(cb_functionDetail);
        }
	}
}

var aCoumnsToFetch = new Array(705,705,4,702,703,704,710,2,709);
var versionsStorage;
function getVersions(cb_functionVersion)
{
	versionsStorage = new Storage(0, []);
	function cb_versions(arg)
	{
		versionsStorage.append(arg.data);
		versionsStorage.timestamp = arg.timestamp;
		nCurrentDetailItemTimestamp = versionsStorage.timestamp;
		gridVersionsInfoSplit.enable(versionsStorage);
		bDetailVersionLoaded = true; 
		if(cb_functionVersion) cb_functionVersion();
	}
	doAjaxFetchAllVersions(cb_versions);
}


function doAjaxFetchAllVersions(callback)
{
	var sColumns = aCoumnsToFetch.join(",");
	var oObjectIdObj = oLastSelectedInfoObject[0];
	var sAjaxRequest = AjaxRoot + "/infostore?action=versions&id=" + oObjectIdObj.id + "&columns="+sColumns+"&session=" + session;
	versJSON.get(sAjaxRequest, null,callback);
}


function refreshDetailVersions(ids)
{
	clearInfoTable('version_det_table');
	if(ids>0) {
		var aSelIds = gridVersionsInfoSplit.getSelectedIDs();
		var aData = versionsStorage.data.data;
		var oObj = oLastSelectedInfoObject[0];
		var nVersionId =  aSelIds[0];
		var aDataSelected  =aData[nVersionId];

		for(nInd=0;nInd<aDataSelected.length;nInd++)
		{
			var nColumn = aCoumnsToFetch[nInd];			
			var PREFIX = "vers_detail_";
			var sDOMID = PREFIX + nColumn;		
			var sValue = aDataSelected[nInd];	
			if(nColumn == 2)
			{
				var newValue = sValue;
				var stopId = sDOMID;
				var arr = new Array();
				arr[0] = sValue;
				function fnSetUserColumn(arg)
				{					
					if(document.getElementById(stopId))
					{
						if ($(stopId).firstChild)
							removeChildNodes($(stopId));
						$(stopId).appendChild(document.createTextNode(arg[newValue].display_name || ""))
					}
				}
				sValue = internalCache.getUsers(arr,fnSetUserColumn);
				continue;
			}
			if(nColumn == 702)
			{
				var oNodAnc = newnode("span",0,{className:"linkstyle"});
				function openFIleInfoStore(evt)
				{				
					var sContentType = 'application/octet-stream';
					var sURL = AjaxRoot + '/infostore/' + encodeURIComponent(sValue)
							+ '?action=document&session=' + session
							+ '&content_type=' + encodeURIComponent(sContentType)
							+ '&id=' + encodeURIComponent(oObj.id)
							+ '&version=' + encodeURIComponent(nVersionId);
					$('dlIframe').src = sURL;	
					stopEvent(evt);
				}
				var oTextNode = document.createTextNode(sValue);				
				addDOMEvent(oNodAnc,"click",openFIleInfoStore);				
				document.getElementById(sDOMID).appendChild(oNodAnc);						
				oNodAnc.appendChild(oTextNode);		
				/////////////////////////////////////////////////////////////////	
				continue;
			}
			if($(sDOMID))
			{	
				if ($(sDOMID).firstChild)
					removeChildNodes($(sDOMID));		
				 //version comment
				if(nColumn == 709 && typeof(sValue) == "string") {
					//sValue = sValue.replace(/\n/g,'<BR>');
					var text = sValue.split("\n");
					for (var i = 0; i < text.length; i++) {
						$(sDOMID).appendChild(document.createTextNode(text[i]));
						$(sDOMID).appendChild(newnode("br"));
					}					
				}
				else
				{
					$(sDOMID).appendChild(document.createTextNode(sValue));				
				}
			}
		}
	}
}

function unLoadInfoDetail()
{	
	if(infostoreRequest) {
        OXCache.unregister(infostoreRequest.uniqueName);
        infostoreRequest=null;
    }
	unregister('OX_InfoStore_Delete', deleteDetailItems);
	unregister('OX_InfoStore_Edit', editDetailItems);
}
function unLoadInfoDetailVersion()
{
	if(bDetailVersionLoaded)
	{	
		gridVersionsInfoSplit.disable();
		bDetailVersionLoaded = false;
	}
}
var nCurrentDetailItemData;
function refreshDetailDetailView(ids)
{
	function handleDataInfostore (daten) {
		nCurrentDetailItemTimestamp = daten.objects[0].timestamp;
        nCurrentDetailItemData = daten.objects[0];
        if(currentpath2[2] == "overview") {
            viewThisDetailsDetailView(nCurrentDetailItemData,'infodet_');                                       
        } else {
            removeChildNodes($('doc_name_info_detail'));
            $('doc_name_info_detail').appendChild(document.createTextNode(daten.objects[0].title || ""));
        }
        writeBottomString(nCurrentDetailItemData,"info_detail_bot");    
        checkLockUnLock(oLastSelectedInfoObject);
        lockedDetailInformation =nCurrentDetailItemData.locked_until;
        $("infostore.detail.versions.title").firstChild.data =
            //#. Tab caption for the infostore detail view
            //#. %s is the number of versions.
            format(_("Versions (%s)"), nCurrentDetailItemData.version);
    }
	clearInfoTable('detail_table');
	if(ids>0) {
        if(!oLastSelectedInfoObject) { return; }
		var collection= { objects : [oLastSelectedInfoObject[0]], columns : null };
		if(infostoreRequest) {
          OXCache.unregister(infostoreRequest.uniqueName);
          infostoreRequest=null;
        }
		infostoreRequest=OXCache.newRequest(null,"infostore",collection,function(daten) {
            handleDataInfostore(daten);
        },
		function(daten) {
			handleDataInfostore(daten);  
		});
 	}
}
var stopId1 = function (sIddd){ return function (){var stopId2=sIddd;return stopId2;}};


function viewThisDetailsDetailView(oObj,sPrefix)
{
	var nObjectId = oObj.id;
	var bFileAttached = false;

	aPrintDetailInfoStore = new Array();
	aPrintDetailInfoStore.push(Print.createTitle(oObj.title || ""));
	aPrintDetailInfoStore.push(Print.createLine("5px"));
	aPrintDetailInfoStore.push(Print.createEmpty(true));

	if(oObj.title)
		aPrintDetailInfoStore.push(Print.createContent(pgettext("description", "Title:"),oObj.title));
	if(oObj.filename && oObj.filename.length>0)
		aPrintDetailInfoStore.push(Print.createContent(_("Document:"),oObj.filename));
	
	if(oObj.created_by)
	{
		
		var aTMPusrArray2 = new Array();
		aTMPusrArray2[0] =  oObj.created_by;
		internalCache.getUsers(aTMPusrArray2,function (oparam)
		{
			aPrintDetailInfoStore.push(Print.createContent(_("Created By"),
														oparam[aTMPusrArray2[0]].display_name));		
		});
	}
	if(oObj.creation_date)
	{
		var oDate = new Date(oObj.creation_date);				
		var nMonth = oDate.getMonth()+1;
		if(nMonth<10)
			nMonth = '0'+nMonth;
		var nDate = oDate.getDate();				
		var nYear = oDate.getFullYear();								
		aPrintDetailInfoStore.push(Print.createContent(_("Created on"),
													' ' + nMonth + '/' + nDate + '/' + nYear + ' '));
	}
	if(oObj.modified_by)
	{

		var aTMPusrArray = new Array();
		aTMPusrArray[0] =  oObj.modified_by;
		internalCache.getUsers(aTMPusrArray,		function (oparam)
		{
			aPrintDetailInfoStore.push(Print.createContent(_("Modified By"),
														oparam[aTMPusrArray[0]].display_name));		
		});
	}
	if(oObj.last_modified)
	{
		var oDate = new Date(oObj.last_modified);				
		var nMonth = oDate.getMonth()+1;
		if(nMonth<10)
			nMonth = '0'+nMonth;
		var nDate = oDate.getDate();				
		var nYear = oDate.getFullYear();								
		aPrintDetailInfoStore.push(Print.createContent(_("Last modified"),
													' ' + nMonth + '/' + nDate + '/' + nYear + ' '));
	}		
	var sHeaderObjName="";
	aPrintDetailInfoStore.push(Print.createEmpty(true));		
	if(oObj.description)
		aPrintDetailInfoStore.push(Print.createContent(_("Comment:"),oObj.description));		

	for(attr in oObj)
	{
		var sId = sPrefix + attr;
		var sValue = oObj[attr] || "";
		if($(sId))
		{
			if(attr == 'filename')
			{
				if(sValue.length > 0)
					bFileAttached = true;				
				var oNodAnc = newnode("span",0,{className:"linkstyle"});
				function openFileclose(sValueCl,nObjectIdCl) {
					return function openFIleInfoStore(evt)
					{				
						var sContentType = 'application/octet-stream';
						var sURL = AjaxRoot + '/infostore/' 
									+ encodeURIComponent(sValueCl)
									+ '?action=document&session=' + session
									+ '&content_type=' + encodeURIComponent(sContentType)
									+ '&id=' + encodeURIComponent(nObjectIdCl);
						if(IE6)		
						{
							newWindow(sURL);	
						}
						else
						{
							$('dlIframe').src = sURL;
						}
						stopEvent(evt);
					}
				}
				removeChildNodes($(sId));
				var oTextNode = document.createTextNode(sValue);				
				addDOMEvent(oNodAnc,"click",openFileclose(sValue,nObjectId));				
				$(sId).appendChild(oNodAnc);						
				oNodAnc.appendChild(oTextNode);		
			}
			else if(attr == 'url')
			{
				removeChildNodes($(sId));
				$(sId).appendChild(newnode('a', null, { href: sValue, target: "_blank"}, [ document.createTextNode(sValue)]));
			}								
			else if(attr == 'color_label')
			{
				if(!isNaN(sValue) && parseInt(sValue)>0)
				{
					var oDOMimg = newnode('img');				
					oDOMimg.src = getFullImgSrc("img/menu/tag_"+sValue+".gif");
					removeChildNodes($(sId));
					$(sId).appendChild(oDOMimg);
				}
			}
			else if(attr == 'folder_id')
			{
				var stoppId = sId;				
				function fn(sPath)
				{
					removeChildNodes($(sId));
					$(stoppId).appendChild(document.createTextNode(sPath));
				}				
				oMainFolderTree.get_folder_path(sValue,fn);
			}	
			else if(attr == 'description')
			{			
				removeChildNodes($(sId));
				var text = sValue.split("\n");
				for (var i = 0; i < text.length; i++) {
					
					$(sId).appendChild(document.createTextNode(text[i]));
					$(sId).appendChild(newnode("br"));
				}
				
			}	
			else if(attr == 'file_size')
			{
				removeChildNodes($(sId));
				if(sValue != 0)
				{
					$(sId).appendChild(document.createTextNode(bytesToString(sValue)));
				}
			}	
			else if(attr == 'file_mimetype')
			{			
				removeChildNodes($(sId));
				removeChildNodes($(sId+'_img'));
				var oNodeTest = $(sId);
				var oNodeIMG = $(sId+'_img');
				var sImagePath = getMimeImage(sValue);
				var oTextNode = document.createTextNode(sValue);
				oNodeTest.appendChild(oTextNode);
				oNodeIMG.appendChild(newnode('img',0,{src:sImagePath}));				
			}
			else if(typeof(sValue) == "string")	
			{
				var oTextNode = document.createTextNode(sValue);
				removeChildNodes($(sId));
				var oNodeTest = $(sId);
				oNodeTest.appendChild(oTextNode);
			}
			else  if(typeof(sValue) == "object")
			{
				var sStringFromArray = "";
				for(var nCatNum in sValue)
				{
					sStringFromArray += sValue[nCatNum];
					sStringFromArray += ', ';
				}
				if(sStringFromArray.length > 2)
				{
					sStringFromArray = sStringFromArray.substr(0,(sStringFromArray.length-2));
				}
				var oTextNode = document.createTextNode(sStringFromArray);
				var oNodeTest = $(sId);
				removeChildNodes($(sId));
				oNodeTest.appendChild(oTextNode);
			}		
			if(sPrefix == "infodet_")
			{	
				if ($("doc_name_info_detail").firstChild)
				removeChildNodes($("doc_name_info_detail"));
				$("doc_name_info_detail").appendChild(document.createTextNode(sHeaderObjName));
			}			
			//save HEader
			if(attr == 'title')
			{
				var sHeaderObjName = sValue;
			}
		}		
	}
	var oDL = $(sPrefix + 'dl');		
	var oTextNode = document.createTextNode(getDirectLinkLocal(oObj));
	removeChildNodes(oDL);
	oDL.appendChild(oTextNode); 
}
fileloaded();