/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Suphi Basdemir <suphi.basdemir@open-xchange.com>
 * 
 */

var weekStorage;
var allcalendarWeekObjects=new Object();

function openNewAppointmentInWeek(date) {
	calendar_activedate=date;
	calendar_wholeday=false;
	triggerEvent("OX_Before_Create_Calendar");
}

function WeekCalendarTool() {
	this.firstinit=false;
	this.oCalendarTool = new calendarTool(activeMonth,activeYear);
	this.switchedToNext = 0;
	this.oCalendarTool1970 = new calendarTool(1,1970);
	this.calendarwfields = new Array(200, 201, 202, 203, 207, 221, 401, 402, 102, 400, 101, 206, 2, 220);
	//title, startdate, enddate, note, seq(0-4), participants, fulltime(true|false), shownas, tag
	this.calendarWeekTimer = null;
	this.timer = 700;
	this.showallappointments = true;
	this.aAppointmentAssoc = new Object();
	this.divIdCurrentDay = "";
	this.aDateForNewWindow = new Object();
	this.aMonthForNewWindow = new Object();
	this.registeredEvents = new Array();
	this.registeredEventsAdd = new Array();
	this.displayedWeekLinks = new Array();
	this.appendetFirstChilds = new Array();	
}

WeekCalendarTool.prototype = {
	
	init: function(paramYear, paramMonth, paramDay) {
		//fixed text selection bug in IE
		if(!this.firstinit) {
			addDOMEvent($("weekcontainer"), "selectstart", function() { return false; });			
			addDOMEvent($("weekcontainer"), "drag" , function() { return false; });
			addDOMEvent($("weekcontainer"), "click", function (e) {
				if (calendarSelection.count != 0) {
					triggerEvent("Selected", []);
					calendarSelection.reset();
					selectedAppointment = null;
					selectAppointmentWeekView();					
				}
			});
			this.firstinit=true;
			var hover=new Hover($("weekcontainer"),OXAppointmentHover.getContent().node);
			calendarhovers["week"]=hover;
			
			hover.setSize(OXAppointmentHover.contentobject.node);
			hover.getTarget = function (node) {
				function getNode(actualnode) {
					if(actualnode.oxcalobj) {
						return actualnode;
					}
					return;
				}
				while (node) {
					var element=getNode(node);
					if(element) {
						return element;
					}
					try {
					   node = node.parentNode;
					} catch (e) { 
						node = null;
					} 
				}
				return;
			}
			hover.onShow = function (node) {
				OXAppointmentHover.actualHover=this;
				var splitid=node.oxcalobj.split("-");
				OXAppointmentHover.refillContent(splitid[1],splitid[0],splitid[2]);	
			}
		}
		
		if (configGetKey("gui.effects.hover.calendar") && calendarhovers["week"]) {
			calendarhovers["week"].enable();
		}
		
		for (var t = 1; t< 8; t++) {
			$("imageList"+t).style.display = "none";
		}
		
		if (paramYear && (paramMonth != undefined) && paramDay) {			
			activeYear = paramYear;
			activeMonth = paramMonth;
			activeDay = paramDay;
			this.oDateLoc = new Date(Date.UTC(paramYear, paramMonth, paramDay, 0, 0, 0));
		} else {
			this.oDateLoc = new Date(Date.UTC(activeYear, activeMonth, activeDay, 0, 0, 0));
		}
		
		this.setKW();
		this.setDays();
		
		if(calendar_getAllFoldersAttribute()) {
			this.showallappointments=true;
			$("allAppointmentWeekView").checked = true;
		} else { 
			this.showallappointments=false;
			$("allAppointmentWeekView").checked = false;
		}
			
		this.getStorageCache();
		this.getData = 0;		
	},
	setKW: function() {
		this.currentKW = this.oCalendarTool.getKW(this.oDateLoc.getUTCFullYear(),
															this.oDateLoc.getUTCMonth(),
																	this.oDateLoc.getUTCDate());
		
		
		this.testToday();
	},
	testToday: function() {
		if(this.divIdCurrentDay != "") {
			/* reset background-color */
			$(this.divIdCurrentDay).className = "weekViewDivContent font-color-default workTimeBackground border-color-design";
		}
		this.oDateAct = new Date();
		this.nKW = this.oCalendarTool.getKW(this.oDateAct.getUTCFullYear(),this.oDateAct.getUTCMonth(),this.oDateAct.getDate());
		if(this.currentKW == this.nKW && activeYear == this.oDateAct.getUTCFullYear()) {
			this.divIdCurrentDay = 'weekDayContent'+this.oDateAct.getDay();
			$(this.divIdCurrentDay).className = "weekViewDivContent background-color-content todaySelectionBorder";
		}
		
	},
	openNewCalendar: function(evt,clicked) {
		var DOMTarget = (evt.target) ? evt.target : evt.srcElement;
		var oDate = new Date();
		activeDay = oDate.getUTCDate();
		activeMonth = oDate.getUTCMonth();
		activeYear = oDate.getUTCFullYear();
		if (clicked == "dblclick") {
			triggerEvent('OX_Before_Create_Calendar');
		} else if (clicked == "click") {
			window.setTimeout(function() {
				menuswitchCalendarTimerange("day")
			}, 20);
		}
	},
	setDays: function() {
		this.oMonday = new Date(getDayInSameWeek(new Date(Date.UTC(activeYear,activeMonth,activeDay,0,0,0)), weekStart) * 864e5);
		var Self = this;
		
		function drawpreviewDragandDrop(evt,type,object) {
			var subObject = object;
			if(object && object.currentObjects && object.currentObjects.length>0) {
					subObject = object.currentObjects[0]; 
			}			
			var DOMTarget = (evt.target)?evt.target:evt.srcElement;	
			DOMTarget.style.cursor = "move";
			if(!$2("dnd_div_")) {				
				var iconNode = Self.getAppointmentDiv(subObject);					
				iconNode.id = "dnd_div_";
				iconNode.style.left = (evt.clientX + iconOffset) + "px";
				iconNode.style.top = (evt.clientY + iconOffset)+ "px";	
				body.appendChild(iconNode);
				addTMPId(iconNode);
				iconNode.style.width = "320px";
				iconNode.style.position = "absolute";				
			} else {
				var iconNode = $2("dnd_div_");
				iconNode.style.left = (evt.clientX + iconOffset) + "px";
				iconNode.style.top = (evt.clientY + iconOffset)+ "px";	
			}
			var sId = DOMTarget.id;
			if(sId.slice(0,14) != "weekDayContent")
				return;
			DOMTarget.className = removeClass(DOMTarget.className,"dndSelectionCalendarBG");			
			DOMTarget.className += " dndSelectionCalendarBG";
		}
		
		function removeDDPreviewDivs(evt,type,object) {
			var DOMTarget = (evt.currentTarget)?evt.currentTarget:evt.srcElement;
			var DOMTarget2 = (evt.target)?evt.target:evt.srcElement;
			DOMTarget2.style.cursor = "default";
			DOMTarget.className = removeClass(DOMTarget.className,"dndSelectionCalendarBG");
			if($2("dnd_div_")) {
				body.removeChild($2("dnd_div_"));
				removeTMPId($2("dnd_div_"));
			}
		}					

		function dropCallBack(evt,dragType,object,mousepos,targetNode,dropNode){
			var subObject = object;
			if (object && object.currentObjects && object.currentObjects.length > 0) {
				subObject = object.currentObjects[0]; 
			}						
			var DOMTarget = targetNode;//(evt.target)?evt.target:evt.srcElement;
			var sId = DOMTarget.id;	

			var nNum = (parseInt(sId.slice(sId.length-1, sId.length)) == 0)
			     ? 7 : parseInt(sId.slice(sId.length-1, sId.length));

			var sKey = "weekviewDay" + nNum;
			if (Self.aDateForNewWindow[sKey] == undefined
			    || Self.aMonthForNewWindow[sKey] == undefined) return;

			DOMTarget.className = removeClass(DOMTarget.className,"dndSelectionCalendarBG");			

			var oDate = new Date();
			oDate.setUTCHours(0);		
			oDate.setUTCMinutes(0);					
			oDate.setUTCSeconds(0);								
			oDate.setUTCDate(1);		
			oDate.setUTCFullYear(activeYear);				
			oDate.setUTCMonth((Self.aMonthForNewWindow[sKey]-1));				
			oDate.setUTCDate(Self.aDateForNewWindow[sKey]);			
			var start_date = new Date(subObject.start_date);
			var end_date = new Date(subObject.end_date);			
			oDate.setUTCHours(start_date.getUTCHours());
			oDate.setUTCMinutes(start_date.getUTCMinutes());
			var changes=oDate.getTime()-start_date.getTime();
			var oDateEnd=new Date(end_date.getTime()+changes);
			
			// drop only allowed if destination date != current date	
			if (formatDate(start_date, "date") != formatDate(oDate, "date"))
			     moveAppToNewStart(subObject,oDate,oDateEnd);
			     
			if($2("dnd_div_")) {
				body.removeChild($2("dnd_div_"));
				removeTMPId($2("dnd_div_"));
			}
			var DOMTarget2 = (evt.target)?evt.target:evt.srcElement;
			DOMTarget2.style.cursor = "default";						
		}
		
		for (var inWeekDay=0; inWeekDay<7; inWeekDay++) {
			(function (inWeekDayIndex) {
				
				if (inWeekDayIndex == 6) {
					var dayContentId = 'weekDayContent0';
				} else {
					var dayContentId = 'weekDayContent'+(inWeekDayIndex +1);
				}
				
				var sId = 'weekviewDay'+(inWeekDayIndex+1);			
				var nCurrHeader  = $(sId);
				var nCurrContent  = $(dayContentId);				
				
				if (Self.registeredEvents["dbl_1_" + inWeekDayIndex]) {
					removeDOMEvent(nCurrContent,'dblclick', Self.registeredEvents["dbl_1_" + inWeekDayIndex]);
				}
				if (Self.registeredEvents["dbl_2_" + inWeekDayIndex]) {
					removeDOMEvent(nCurrHeader,'dblclick', Self.registeredEvents["dbl_2_" + inWeekDayIndex]);
				}				
				
				var nDisplayMonth = Self.oMonday.getUTCMonth()+1;
				Self.aMonthForNewWindow[sId] = nDisplayMonth;
				
				if (nDisplayMonth < 10)	nDisplayMonth = '0' + nDisplayMonth;
				var nDisplayDate = Self.oMonday.getUTCDate();
				Self.aDateForNewWindow[sId] = nDisplayDate;
				
				if(nDisplayDate < 10) nDisplayDate = '0' + nDisplayDate;		

				var date=new Date();
				date.setUTCDate(1);
				date.setUTCFullYear(Self.oMonday.getUTCFullYear());
				date.setUTCMonth(Self.oMonday.getUTCMonth());
				date.setUTCDate(Self.oMonday.getUTCDate());
				date.setUTCHours(configGetKey("gui.calendar.starttime") || 8);
				
				function openNewAppointmentInWeek(e) {
					calendar_activedate=date;
					calendar_activedate.setUTCMinutes(0);					
					calendar_wholeday=false;
					triggerEvent("OX_Before_Create_Calendar");					
				}
				
				function openNewWholeAppointmentInWeek(e) {
					var date2=date;
					date2.setUTCHours(0);
					date2.setUTCMinutes(0);
					calendar_activedate=date2;
					calendar_wholeday=true;
					triggerEvent("OX_Before_Create_Calendar");
				}
				Self.registeredEvents["dbl_1_" + inWeekDayIndex] = openNewAppointmentInWeek;
				Self.registeredEvents["dbl_2_" + inWeekDayIndex] = openNewWholeAppointmentInWeek;
				
				addDOMEvent(nCurrContent, 'dblclick', openNewAppointmentInWeek);	
				addDOMEvent(nCurrHeader, 'dblclick', openNewWholeAppointmentInWeek);
				
				Self.yearUTC=Self.oMonday.getUTCFullYear();	
				nCurrHeader.className = isToday(Self.oMonday) 
				        ? "background-color-PMG-selection-elements" : "";

				nCurrHeader.firstChild.nodeValue = formatDate(Self.oMonday,"dateday");
				Self.oMonday.setUTCDate(Self.oMonday.getUTCDate()+1);
				
				registerTarget(nCurrContent,{calendar:dropCallBack},null,null,
						drawpreviewDragandDrop,	//drawpreviewDragandDrop
						drawpreviewDragandDrop,	//drawreviewDragandDrop
						removeDDPreviewDivs );//removeDDPreviewDivs				
			})(inWeekDay)
		}
		$('weekviewheader').firstChild.nodeValue = _("CW") /*i18n*/ 
										+ " " + this.currentKW + " " + this.yearUTC;
		
	},
	goToNextWeek: function(nDirection) {		
		this.clearContentFields();
		this.getData = 1;
		this.nDirection = nDirection;
		this.oDateLoc.setUTCDate(this.oDateLoc.getUTCDate()+(nDirection*7));	
		activeMonth = this.oDateLoc.getUTCMonth();
		activeYear = this.oDateLoc.getUTCFullYear();		
		activeDay = this.oDateLoc.getUTCDate();	
		this.setKW();
		this.setDays();
		var Self = this;
		
		Self.calendarWeekTimer  = window.setTimeout(
									function() 	{
											Self.goToNextWeek(Self.nDirection); 
											Self.switchedToNext++;
									}, Self.timer);
		if (this.switchedToNext>4) {
			Self.timer = 400;
		} else {
			Self.timer = 700;
		}
		
		if (oMiniCalendar) oMiniCalendar.setSelectedByDate(activeYear, activeMonth, activeDay);
	},
	clearTimer: function() {
		this.switchedToNext = 0;
		window.clearTimeout(this.calendarWeekTimer);
		if(this.getData >0) {
			this.getData = 0;
			this.getStorageCache();
		}		
	}, 
	clearContentFields: function() {
		for (var t = 1; t< 8; t++)
		 		$("imageList"+t).style.display = "none";
		allcalendarWeekObjects = {};
		this.weekAppointments = new Array()
		for(var i=0; i<7;i++) {
			removeChildNodes($('weekDayContent'+i));
			var fullTimeDIV = newnode('div');
			fullTimeDIV.className = 'containerFullTimeWeek';
			$('weekDayContent'+i).appendChild(fullTimeDIV);
		}		
	},
	updateView: function() {
		this.clearContentFields();
		this.iterateStorage();
		lastUpdateOfCalendarTimestamp = storageCache.current.timestamp;
	},
	showAllAppointments: function(mybool) {
		this.showallappointments=mybool;
		configSetKey("gui.calendar.allfolders",mybool)
		this.getStorageCache();
	},
	getStorageCache: function() {
		if (weekStorage) {
            weekStorage.events.unregister("Changed", function() {
                Self.updateView();
            });
        }
		this.clearContentFields();
		var start = new Date(getDayInSameWeek(this.oDateLoc, weekStart) * 864e5);		
		var end = new Date(start.getTime());
		end.setUTCDate(start.getUTCDate()+7);
		this.starttime=start.getTime();
		var endtime=end.getTime();
		var Self = this;
		Self.params=new Object();
		Self.params.action="all";
		Self.params.start=Self.starttime;
		Self.params.end=endtime;		
		Self.params.columns="1,20,207";
		if(!Self.showallappointments) {
			Self.params.folder= activefolder;
		}
		storageCache.get(AjaxRoot + "/calendar",
		 Self.params ,
		 function(storage) {
		 	Self.weekAppointments = new Array()
		 	for (var t = 0; t< Self.displayedWeekLinks.length; t++)
		 		Self.displayedWeekLinks[t].style.display = "none";
		 		
		 		
		 	storageCache.current = storage;		 	
			calendarSelection.setStorage(storage);
		 	storageCache.update();
		 	Self.iterateStorage(storage);
			lastUpdateOfCalendarTimestamp = storage.timestamp;
		 },
		 Self.calendarwfields.toString(),
		 true,
		 function(x) { return x.folder + "." + x.id + "." + x.recurrence_position; } ,
		 function(x) { return { id: x[0], folder: x[1], recurrence_position : x[2] } }
		);
	},
	iterateStorage: function(storage) {		
		var Self = this;
		Self.displayedWeekLinks = [];
		this.appendetFirstChilds = [];
		if (storage) {
			weekStorage = storage;
			storage.events.register("Changed", function() {
				Self.updateView();
			});
		}
		weekStorage.newIterate(weekStorage.ids, emptyFunction, function(x,y) {
			Self.buildAppointments(x,y);
		},function(){
			Self.sortAppointments();
		});
	}, 
	buildAppointments: function(index, object) {
		this.weekAppointments[index] = object;
		object["indxxx"]  = index;
	},
	sortAppointments: function() {
		this.weekAppointments.sort(function(a,b){
			return (a[4] == b[4]) ? (a[3] < b[3]) ? -1 : 1 : (a[4] < b[4]) ? -1 : 1;
		});
		for(var i=0; i<this.weekAppointments.length;i++) {
			this.generateCalendarObjects(this.weekAppointments[i]["indxxx"],this.weekAppointments[i]);
		}
	},
	getAppointmentDiv:function (object) {
		var appointmentDate = new Date(object.start_date);
		var appointmentDateEnd = new Date(object.end_date);
		var formatForStart = (appointmentDate.getUTCMinutes()<10)? "0":"";
		var formatForEnd = (appointmentDateEnd.getUTCMinutes()<10)? "0":"";
		if(!object.title) {
			object.title="";
		}
		var textToView = appointmentDate.getUTCHours() + ":" + formatForStart + appointmentDate.getUTCMinutes() + " - ";
		textToView += appointmentDateEnd.getUTCHours() + ":" + formatForEnd + appointmentDateEnd.getUTCMinutes() + " ";
		textToView += object.title;		
		var shownDiv = getShownDiv(object.shown_as);
		
		var divIconParticipant = newnode("div", {},{ className: "showAppointmentSeqWeek"});
		if(object.participants && object.participants.length > 1) {
			var imageGroupFlag=document.createElement("img");
			imageGroupFlag.setAttribute("src",getFullImgSrc("img/calendar/group.gif"));
			divIconParticipant.appendChild(imageGroupFlag);
		}
		
		var divIconPrivate = newnode("div", {},{ className: "showAppointmentSeqWeek"});
		if(object.private_flag) {
			var imagePrivatFlag=document.createElement("img");
			imagePrivatFlag.setAttribute("src",getFullImgSrc("img/private_flag.gif"));
			divIconPrivate.appendChild(imagePrivatFlag);
		}
		
		var divIconTag = newnode("div", {}, { className: "showAppointmentSeqWeek"});
		if(object.color_label && object.color_label > 0) {
			var imageColorLabel=document.createElement("img");
			imageColorLabel.setAttribute("src",getFullImgSrc("img/menu/tag_" + object.color_label + ".gif"));
			divIconTag.appendChild(imageColorLabel);
		}		
		
		var textDiv;
		if(!object.full_time) {	
			shownDiv.appendChild(document.createTextNode(" "));
			var datDIV = newnode('div');
			datDIV.className = 'appInWeekView borderDefault background-color-content border-color-design';
			textDiv = newnode('div');
			textDiv.className = "showAppointmentTextWeek mozSelected";
			
			textDiv.appendChild(document.createTextNode(textToView));
			datDIV.appendChild(shownDiv);	
			datDIV.appendChild(textDiv);
			
			if (divIconParticipant.firstChild) datDIV.appendChild(divIconParticipant);
			if (divIconPrivate.firstChild) datDIV.appendChild(divIconPrivate);
			if (divIconTag.firstChild) datDIV.appendChild(divIconTag);
			
			if(object.recurrence_type > 0) {
				var image=document.createElement("img");
				image.setAttribute("src",getFullImgSrc("img/calendar/calendar_series.gif"));
				var seqDiv = newnode('div', {}, { className: "showAppointmentSeqWeek"});
				seqDiv.className = "showAppointmentSeqWeek";	
				seqDiv.appendChild(image);
				datDIV.appendChild(seqDiv);	
			}
		} else {	
			shownDiv.appendChild(document.createTextNode(" "));
			var datDIV = newnode('div');
			datDIV.className = 'textFullTimeWeek wholeDayBackground border-color-design borderDefault';
			textDiv = newnode("div", {flt:"left", width: "80%"}, null, [document.createTextNode(textToView)])
			textDiv.className="mozSelected"
			datDIV.appendChild(shownDiv);	
			datDIV.appendChild(textDiv);

            if (divIconParticipant.firstChild) datDIV.appendChild(divIconParticipant);
            if (divIconPrivate.firstChild) datDIV.appendChild(divIconPrivate);
            if (divIconTag.firstChild) datDIV.appendChild(divIconTag);

			if(object.recurrence_type > 0) {
				var image=document.createElement("img");
				image.setAttribute("src",getFullImgSrc("img/calendar/calendar_series.gif"));
				var seqDiv = newnode('div');
				seqDiv.className = "showAppointmentSeqWeek";	
				seqDiv.appendChild(image);
				datDIV.appendChild(seqDiv);	
			}
			datDIV.style.height = 1.9 + "em";
		}
		
		return datDIV;						
	},
	generateCalendarObjects: function(index, object) {
		this.index = index;
		this.object = object;
		var id = this.object[0];
		var folder_id = this.object[1];
		var nRecPosition = this.object[2];
		var nRecId = this.object[14];
		var created_by = this.object[15];
		this.object.index = index;
		allcalendarWeekObjects[""+folder_id+"-"+id + "-"+nRecPosition]=this.object;
		
		var selectedAppointmentWeek = { 
			id:id, folder:folder_id, recurrence_position:nRecPosition, 
			recurrence_id:nRecId, created_by:created_by };
		var divAppId = 'appInWeekView' + folder_id + "_" + id+"_"+nRecPosition;
		
		var title = this.object[3];
		var start_date = this.object[4];
		var end_date = this.object[5];
		var note = this.object[6];
		var recurrence_type = this.object[7];
		
		// consolidate users and participants (field 220 and 221)
		for (var i in object[16]) {
			var a1 = object[16][i];
			for (var ia in object[8]) {
				if (object[8][ia].id == a1.id) {
					a1.confirmation = object[8][ia].confirmation;
					if (object[8][ia].confirmmessage) a1.confirmmessage = object[8][ia].confirmmessage;
					break;
				}
			}
		}
		
		var participants = this.object[8];
		var full_time = this.object[9];
		var shown_as = this.object[10];
		var color_label = this.object[11];
		var private_flag = this.object[13];
		var appointmentDate = new Date(start_date);
		var appointmentDateEnd = new Date(end_date);
		var formatForStart = (appointmentDate.getUTCMinutes()<10)? "0":"";
		var formatForEnd = (appointmentDateEnd.getUTCMinutes()<10)? "0":"";
		var timeWeekpart1 = appointmentDate.getUTCHours() + ":" + formatForStart + appointmentDate.getUTCMinutes();
		var timeWeekpart2 = appointmentDateEnd.getUTCHours() + ":" + formatForEnd + appointmentDateEnd.getUTCMinutes();
		
		var textToView = timeWeekpart1 + " - " + timeWeekpart2 + " ";
		if(!title) title="";
		textToView += title;
		
		var divId = "weekDayContent" + appointmentDate.getUTCDay();
		
		this.aAppointmentAssoc[divAppId] = this.object;
		var divIconFlags = newnode("div", {flt:"right", marginLeft : "5px"});
       		
		var divIconParticipant = newnode("div", {},{ className: "showAppointmentSeqWeek"});
		if(participants && participants.length > 1) {
			var imageGroupFlag=document.createElement("img");
			imageGroupFlag.setAttribute("src",getFullImgSrc("img/calendar/group.gif"));
			divIconParticipant.appendChild(imageGroupFlag);
		}
		
		var divIconPrivate = newnode("div", {},{ className: "showAppointmentSeqWeek"});
		if(private_flag) {
			var imagePrivatFlag=document.createElement("img");
			imagePrivatFlag.setAttribute("src",getFullImgSrc("img/private_flag.gif"));
			divIconPrivate.appendChild(imagePrivatFlag);
		}
		
		var divIconTag = newnode("div", {}, { className: "showAppointmentSeqWeek"});
		if(color_label && color_label > 0) {
			var imageColorLabel=document.createElement("img");
			imageColorLabel.setAttribute("src",getFullImgSrc("img/menu/tag_" + color_label + ".gif"));
			divIconTag.appendChild(imageColorLabel);
		}
		
		var oneday=1000*60*60*24;
		var showappointment=true;		
		var fulltimeStartBefore = false;
		var fulltimeStartBeforeDiff = 0;
		
		// Setze Startzeit des Termins um , falls er vor der Anzeige beginnt
		if (start_date < this.starttime) {
			fulltimeStartBeforeDiff = (this.starttime - start_date)  / 1000 / 60 / 60 / 24;
			start_date=this.starttime;
			fulltimeStartBefore = true;
		}
		
		if (fulltimeStartBefore && !full_time) {
			end_date = end_date + oneday;
		}
		
		// Setze Endzeit des Termins um , falls er nach der Anzeige endet
		if (end_date > this.starttime + (7 * oneday)) {
			end_date = this.starttime + (7 * oneday)
		}
		
		/*
		 * ms / d
		 * calculating appointment duration in days
		 */
		var d_end = Math.ceil(end_date / 864e5);
        var d_start = Math.floor(start_date / 864e5);
		days = d_end-d_start;
		
		var titlesMultidays = [];
		if (days > 1) {
			textToView = titlesMultidays[0] = timeWeekpart1 + " - 24:00 " + title;
			titlesMultidays[1] = "0:00 - 24:00 " + title;
			titlesMultidays[2] = "0:00 - " + timeWeekpart2 + " " + title;
		}

		var Self = this;
		
		var shownDiv = newnode('div');
		switch (shown_as) {
			case 1:
				shownDiv.className = "appointmentRESERVED";
				break;
			case 2:
				shownDiv.className = "appointmentTEMPORARY";
				break;
			case 3:
				shownDiv.className = "appointmentABSENT";
				break;
			case 4:
				shownDiv.className = "appointmentFREE";
				break;
			default:
				shownDiv.className = "appointmentNONE";
				break;
		}
		shownDiv.className += ' showAppointmentShownWeek';
		
		var	paramObj = { id: Self.object[0], folder: Self.object[1], 
		                 folder_id: Self.object[1], recurrence_position: (Self.object[7]) ? Self.object[7] : 0
		               };

		function disabled(e) {
			var iconNode=$2("cww_node_dd");
			if (iconNode == undefined) {
				iconNode = newnode("img", 
				        { position:"absolute", left:(e.clientX + iconOffset) + "px", 
				          top:(e.clientY + iconOffset) + "px" },
			            { src: getFullImgSrc("img/dnd_disabled.gif"), alt: "" });
				iconNode.id="cww_node_dd";
				body.appendChild(iconNode);
				addTMPId(iconNode);
			}
			iconNode.style.left = (e.clientX + iconOffset) + "px";
			iconNode.style.top = (e.clientY + iconOffset)+ "px";
			stopEvent(e);
			return false;
		}
		
		function disabledremove(e,targetNode) {
			if ($2("cww_node_dd")) {
				$2("cww_node_dd").parentNode.removeChild($2("cww_node_dd"));
			}
		}
		
	    if (!full_time) {
			shownDiv.appendChild(document.createTextNode(" "));
			var datDIV = newnode('div',0,{className:"appInWeekView background-color-content border-color-design borderDefault"});
			if (selectedAppointmentWeekView == divAppId) {
				datDIV.className = removeClass(datDIV.className,"borderDefault");
				datDIV.className += ' selectedAppMonth border-color-selection-elements';
			}
			datDIV.id = divAppId;
			datDIV.oxcalobj=""+folder_id + "-" + id + "-" + nRecPosition;
			var textDiv = newnode('div');
			textDiv.className = "showAppointmentTextWeek";
			
			// setting confirmation styles
			if (participants.length) {
				for (var i in participants) {
					if (participants[i].id == config.identifier) {
						switch(participants[i].confirmation) {
							case 0:
								datDIV.style.opacity = ".6";
								textDiv.style.fontStyle = "italic";
								textToView += " (" + _("waiting") + ")";
								break;
							case 2:
								textDiv.style.textDecoration = "line-through";
								break;
							case 3:											
								textDiv.style.fontStyle = "italic";
								textToView += " (" + _("tentative") + ")";
								break;
						}
					}
				}
			}
			
			textDiv.appendChild(document.createTextNode(textToView));
			datDIV.appendChild(shownDiv);	
			datDIV.appendChild(textDiv);
			
			if (divIconParticipant.firstChild) {
				datDIV.appendChild(divIconParticipant);
			}
            if (divIconPrivate.firstChild) {
            	datDIV.appendChild(divIconPrivate);
            }
            if (divIconTag.firstChild) {
            	datDIV.appendChild(divIconTag);
            }
			
			if (recurrence_type > 0) {
				var image=document.createElement("img");
				image.setAttribute("src",getFullImgSrc("img/calendar/calendar_series.gif"));
				var seqDiv = newnode('div');
				seqDiv.className = "showAppointmentSeqWeek";	
				seqDiv.appendChild(image);
				datDIV.appendChild(seqDiv);	
			}			
						
			registerSource(datDIV, "calendar",
			     function () {
			     	objMoveCopy.begin("calendar",
			     	[ new CalendarWorkWeekObject(
			     	       object[0], object[1], object[2], object[14], object[15], object[3], object[4], 
			     	       object[5], null, object[7], null, object[9], object[10],
			     	       null,null,null)
			     	]);
				    return objMoveCopy;
				     
				 }, null,null, calendardefaultdisabled, defaultdisabledremove);
			
		 	var oInplEdit  = new inplaceEdit(textDiv, title, 
		 	                    function (sStr,oObj) {
		 	                    	editAppointment(paramObj,{title:sStr});
								});

			//fixed bug with auto selection													
			if (calendarSelection) {
				calendarSelection.reset();
			}
				
			addDOMEvent(datDIV, "click", function(e) {
				var SelObj = calendarSelection.getID();
				if (SelObj && SelObj.id == paramObj.id &&
							SelObj.folder == paramObj.folder_id &&
									SelObj.recurrence_position == paramObj.recurrence_position) {
					if (window.event) {
						e = window.event;
					}
					oInplEdit.on();
				} else {					
						setSelectionWeekView(selectedAppointmentWeek);
						selectAppointmentWeekView(divAppId,1);
				}
				stopEvent(e);
	
			});	
            addDOMEvent(datDIV, "contextmenu", function(e) {            	
                stopEvent(e);
                globalContextMenus.calendar.display(e.clientX, e.clientY,
                                                    calendarSelection);
            });

			addDOMEvent(datDIV, "mousedown", function(e) {
														setSelectionWeekView(selectedAppointmentWeek);
														selectAppointmentWeekView(divAppId,1);
													});									
			addDOMEvent(datDIV, "dblclick", function(e) {
														setActivatedWeekView(selectedAppointmentWeek, e);
														selectAppointmentWeekView(divAppId,1);
														});
			/*
			 * draw the first appointment
			 */																		
			if (!fulltimeStartBefore) {
				$(divId).appendChild(datDIV);
				addTMPId(datDIV);
			}
			
			/*
			 * if appointment lasts longer then 1 day draw the rest
			 */
			for (i=1;i<days;i++) {
				var ccweek_template_app_time = datDIV.cloneNode(true);
				if (i+1 == days) {
					ccweek_template_app_time.childNodes[1].firstChild.nodeValue = titlesMultidays[2];
				} else {
					ccweek_template_app_time.childNodes[1].firstChild.nodeValue = titlesMultidays[1];
				}

				var	paramObj = {id:Self.object[0],folder:Self.object[1], folder_id:Self.object[1],
												recurrence_position:(Self.object[7])?Self.object[7]:0};
				if(!fulltimeStartBefore) {
					start_date += oneday;
				}
				var newId = new Date(start_date).getUTCDay();
				divId = "weekDayContent" + newId;
				ccweek_template_app_time.id = datDIV.id + "-"+i;
				ccweek_template_app_time.oxcalobj=""+folder_id + "-" + id + "-" + nRecPosition;
				
				addDOMEvent(ccweek_template_app_time, "click", function(e) {					
					var SelObj = calendarSelection.getID();
					if (SelObj && SelObj.id == paramObj.id &&
					    SelObj.folder == paramObj.folder_id &&
						SelObj.recurrence_position == paramObj.recurrence_position) {
						if(window.event) {
							e = window.event;
						}
						oInplEdit.on();
					} else {
						setSelectionWeekView(selectedAppointmentWeek);
						selectAppointmentWeekView(divAppId,1);
					}
					stopEvent(e);
		
				});	
                addDOMEvent(ccweek_template_app_time, "contextmenu", function(e) {
                    if (!calendarSelection.get(index))
                        calendarSelection.click(index, e);
                    stopEvent(e);
                    globalContextMenus.calendar.display(e.clientX, e.clientY,
                                                        calendarSelection);
                });

				addDOMEvent(ccweek_template_app_time, "mousedown", function(e) {
													setSelectionWeekView(selectedAppointmentWeek);
													selectAppointmentWeekView(divAppId,1);
											});
				addDOMEvent(ccweek_template_app_time, "dblclick", function(e) {
															setActivatedWeekView(selectedAppointmentWeek);
															selectAppointmentWeekView(divAppId,1);
															});

				$(divId).appendChild(ccweek_template_app_time);	
				addTMPId(ccweek_template_app_time);
				if(fulltimeStartBefore) {
					start_date += oneday;
				}
			}
			
		} else {
			var ftDiv = newnode('div',0,{className:"textFullTimeWeek wholeDayBackground border-color-design borderDefault"});
			ftDiv.className = removeClass(ftDiv.className,"border-color-selection-elements");
			
			if(selectedAppointmentWeekView == divAppId) {
				ftDiv.className = removeClass(ftDiv.className,"borderDefault");
				ftDiv.className +=  ' selectedAppMonth border-color-selection-elements';
			}
			ftDiv.id = divAppId;
			ftDiv.oxcalobj=""+folder_id + "-" + id + "-" + nRecPosition;
			ftDiv.appendChild(shownDiv);
			addTMPId(ftDiv);
			if(!title) { title=""; }
			var fullTextDiv = newnode("div", {flt:"left", width: "80%"}, null);
			
			// setting confirmation styles
			if (participants.length) {
				for (var i in participants) {
					if (participants[i].id == config.identifier) {
						switch(participants[i].confirmation) {
							case 0:
								fullTextDiv.style.opacity = ".6";
								fullTextDiv.style.fontStyle = "italic";
								title += " (" + _("waiting") + ")";
								break;
							case 2:
								fullTextDiv.style.textDecoration = "line-through";
								break;
							case 3:											
								fullTextDiv.style.fontStyle = "italic";
								title += " (" + _("tentative") + ")";
								break;
						}
					}
				}
			}
			
			fullTextDiv.appendChild(document.createTextNode(title));
			ftDiv.appendChild(fullTextDiv);

            if (divIconParticipant.firstChild) ftDiv.appendChild(divIconParticipant);
            if (divIconPrivate.firstChild) ftDiv.appendChild(divIconPrivate);
            if (divIconTag.firstChild) ftDiv.appendChild(divIconTag);
			
			if(recurrence_type > 0) {
				var image=document.createElement("img");
				image.setAttribute("src",getFullImgSrc("img/calendar/calendar_series.gif"));
				var seqDiv = newnode('div');
				seqDiv.className = "showAppointmentSeqWeek";	
				seqDiv.appendChild(image);
				ftDiv.appendChild(seqDiv);
			}
			
            addDOMEvent(ftDiv, "contextmenu", function(e) {
                if (!calendarSelection.get(index))
                    calendarSelection.click(index, e);
                stopEvent(e);
                globalContextMenus.calendar.display(e.clientX, e.clientY,
                                                    calendarSelection);
            });

			addDOMEvent(ftDiv, "mousedown", function(e) {
														setSelectionWeekView(selectedAppointmentWeek);
														selectAppointmentWeekView(divAppId,2);
													});
			addDOMEvent(ftDiv, "dblclick", function(e) {
														setActivatedWeekView(selectedAppointmentWeek);
														selectAppointmentWeekView(divAppId,2);
														});
			
		
			
			for(i=0;i<days;i++) {
					var ccweek_template_full_time =ftDiv.cloneNode(true);

					var newId = new Date(start_date).getUTCDay();
					divId = "weekDayContent" + newId;
					
					ccweek_template_full_time.id = ftDiv.id + "-"+i;
					ccweek_template_full_time.oxcalobj=""+folder_id + "-" + id + "-" + nRecPosition;
					
					/////////////////// 					
			
			var divs = ccweek_template_full_time.getElementsByTagName("div");
			var oInplEdit  = new inplaceEdit(divs[1], title, function (sStr,oObj){
														editAppointment(paramObj,{title:sStr});
													});
			addDOMEvent(ccweek_template_full_time, "click", function(e) {
				var SelObj = calendarSelection.getID();
				if(SelObj && SelObj.id == paramObj.id &&
							SelObj.folder == paramObj.folder &&
									SelObj.recurrence_position == paramObj.recurrence_position)
				{
					if(window.event)
					{
						e = window.event;
					}
					oInplEdit.on();		
				}
				else
				{
						setSelectionWeekView(selectedAppointmentWeek);
						selectAppointmentWeekView(divAppId,2);
				}
				stopEvent(e);
	
			});	
			///////////////////
		
			registerSource(ccweek_template_full_time,"calendar",function () {
		 							objMoveCopy.begin("calendar",[new CalendarWorkWeekObject(object[0],object[1],
								object[2],object[14],object[15],object[3],
								object[4],object[5],null,object[7],null,object[9],object[10],null,null,null)]);
									return objMoveCopy; },
															 null,null,calendardefaultdisabled,defaultdisabledremove);
		
                    addDOMEvent(ccweek_template_full_time, "contextmenu", function(e) {
                        stopEvent(e);
                        globalContextMenus.calendar.display(e.clientX, e.clientY,
                                                            calendarSelection);
                    });
					addDOMEvent(ccweek_template_full_time, "mousedown", function(e) {
														setSelectionWeekView(selectedAppointmentWeek);
														selectAppointmentWeekView(divAppId,2);
													});
					addDOMEvent(ccweek_template_full_time, "dblclick", function(e) {
																setActivatedWeekView(selectedAppointmentWeek, e);
																selectAppointmentWeekView(divAppId,2);
																});		
					
					var idSuffix = divId.substr(divId.length - 1,1);
					if(idSuffix == 0) idSuffix = 7;
					
					var appendet = false;
					
					for (var v = 0; v< Self.appendetFirstChilds.length; v++) {
						if(divId == Self.appendetFirstChilds[v])
							appendet = true;
					}
					
					if(appendet) {
						$("imageList" + idSuffix).style.display = "inline";
						this.displayedWeekLinks.push($("imageList" + idSuffix));
					} else {
						this.appendetFirstChilds.push(divId);
						$(divId).firstChild.appendChild(ccweek_template_full_time);
						addTMPId(ccweek_template_full_time);	
					}

					start_date += oneday;
				}

		}
	}
}

function setSelectionWeekView(selectedAppointmentWeek) {
	selectedAppointment = selectedAppointmentWeek;
	var arrId = new Array();
	arrId.push(selectedAppointment);
	var arrayIndex = selectedAppointmentWeek.folder+"-"+selectedAppointmentWeek.id+"-"+selectedAppointmentWeek.recurrence_position;
	calendarSelection.click(allcalendarWeekObjects[arrayIndex].index);
	triggerEvent("Selected", arrId);
}

function setActivatedWeekView(selectedAppointmentWeek, evt) {
	selectedAppointment = selectedAppointmentWeek;
	openAppointmentPopup(evt);
}
var selectedAppointmentWeekView = '';
var selectedAppointmentWeekViewModus = 0;
function selectAppointmentWeekView(divAppId, app) {
	if($2(divAppId)) {
		$2(divAppId).className = removeClass($2(divAppId).className,"border-color-selection-elements");
		$2(divAppId).className = removeClass($2(divAppId).className,"borderDefault");
		$2(divAppId).className += ' selectedAppMonth border-color-selection-elements';
	}
	
	for(var i = 0; i<=7;i++) {
		if($2(divAppId + "-" + i)) {
			$2(divAppId + "-" + i).className = removeClass($2(divAppId + "-" + i).className,"border-color-selection-elements");
			$2(divAppId + "-" + i).className = removeClass($2(divAppId + "-" + i).className,"borderDefault");			
			$2(divAppId + "-" + i).className += ' selectedAppMonth border-color-selection-elements';
		}
	}
	
				
	if(selectedAppointmentWeekView != '' && $2(selectedAppointmentWeekView) && selectedAppointmentWeekView != divAppId) {
		$2(selectedAppointmentWeekView).className = (selectedAppointmentWeekViewModus == 1) ? 'appInWeekView background-color-content border-color-design borderDefault' : 'textFullTimeWeek wholeDayBackground border-color-design borderDefault';
	}
	if(selectedAppointmentWeekView != '' && selectedAppointmentWeekView != divAppId) {
		for(var i = 0; i<=7;i++) {
			if($2(selectedAppointmentWeekView + "-" + i)) {
				$2(selectedAppointmentWeekView + "-" + i).className = (selectedAppointmentWeekViewModus == 1) ? 'appInWeekView background-color-content border-color-design borderDefault' : 'textFullTimeWeek wholeDayBackground border-color-design borderDefault';
			}
		}
	}
	
	if (divAppId) {
		selectedAppointmentWeekView = divAppId;
		selectedAppointmentWeekViewModus = app;
	}
	
}

var objWeekCalendarTool = new WeekCalendarTool();
fileloaded();