<?xml version="1.0" encoding="UTF-8"?>

<!-- 

	All content on this website (including text, images, source
	code and any other original works), unless otherwise noted,
	is licensed under a Creative Commons License.
	
	http://creativecommons.org/licenses/by-nc-sa/2.5/
	
	Copyright (C) 2004-2007 Open-Xchange, Inc.
	Mail: info@open-xchange.com 
	
	@author Viktor Pracht <viktor.pracht@open-xchange.com>

 -->

<!--

	Borders

	Dec: 16  1 32    Hex: 10 01 20
	      2     4         02    04
	     64  8 128        40 08 80

	header: 55, body: 6, bottom: 206

-->

<stylesheet version="2.0"
            xmlns="http://www.w3.org/1999/XSL/Transform"
            xmlns:h="http://www.w3.org/1999/xhtml"
            xmlns:ox="http://localhost/html/dtd/ox.dtd"
            xmlns:f="http://localhost/html/dtd/f.dtd"
            xmlns:saxon="http://saxon.sf.net/"
           exclude-result-prefixes="#all">

	<output method="html"
	        doctype-system="http://www.w3.org/TR/html4/strict.dtd"
	        doctype-public="-//W3C//DTD HTML 4.01//EN"/>
	
	<namespace-alias stylesheet-prefix="h" result-prefix="#default"/>

	<param name="jstarget" />
	<param name="version" />
	<param name="pversion" />
	<param name="varname" select="init"/>
	<param name="preid"/>
	<strip-space elements="*" />

	<template match="/" mode="#default">
		<variable name="include">
			<apply-templates mode="include" />
		</variable>
		<variable name="misc">
			<apply-templates select="$include" mode="misc" />
		</variable>
		<variable name="border">
			<apply-templates select="$misc" mode="border" />
		</variable>
		<variable name="layout">
			<apply-templates select="$border" mode="layout" />
		</variable>
		<variable name="img">
			<apply-templates select="img"/>
		</variable>
		<comment>/Creative Commons License</comment>
		<comment>
			&lt;rdf:RDF xmlns="http://web.resource.org/cc/" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#">
				&lt;Work rdf:about="">
					&lt;license rdf:resource="http://creativecommons.org/licenses/by-nc-sa/2.5/" />
				&lt;/Work>
				&lt;License rdf:about="http://creativecommons.org/licenses/by-nc-sa/2.5/">
					&lt;permits rdf:resource="http://web.resource.org/cc/Reproduction"/>
					&lt;permits rdf:resource="http://web.resource.org/cc/Distribution"/>
					&lt;requires rdf:resource="http://web.resource.org/cc/Notice"/>
					&lt;requires rdf:resource="http://web.resource.org/cc/Attribution"/>
					&lt;prohibits rdf:resource="http://web.resource.org/cc/CommercialUse"/>
					&lt;permits rdf:resource="http://web.resource.org/cc/DerivativeWorks"/>
					&lt;requires rdf:resource="http://web.resource.org/cc/ShareAlike"/>
				&lt;/License>
			&lt;/rdf:RDF>
		</comment>
		<text>&#10;</text>
		<apply-templates select="$layout" mode="i18n"/>
		<result-document href="{$jstarget}" method="text">
			<text>var </text>
			<value-of select="$varname"/>
			<text>={IE6workaround:{</text>
			<value-of select="f:ie6workaround($include//ox:border[@ox:align])"/>
			<text>},movable:[</text>
			<value-of select="f:movable($include//ox:popupwindow)"/>
			<text>],help:{</text>
			<value-of select="f:help($include//@ox:help)"/>
			<text>},min:{</text>
			<value-of select="f:attrset($include//@ox:min)"/>
			<text>},max:{</text>
			<value-of select="f:attrset($include//@ox:max)"/>
			<text>},hide:{</text>
			<value-of select="f:set($include//ox:iframe)"/>
			<text>},size:[</text>
			<apply-templates select="$border" mode="layout-js"/>
			<text>],split:{</text>
			<value-of select="f:attrset($border//@ox:split)"/>
			<text>},i18n:{</text>
			<value-of select="f:attrset($layout//@ox:i18n)"/>
			 <text>},images:{</text>
				<value-of select="f:attrset($include//img/@src)"/> 
			<text>}};</text>
		</result-document>
	</template>
	
	<template match="@*|*|text()" mode="include misc border layout i18n" priority="-1">
		<copy><apply-templates select="@*|node()" mode="#current"/></copy>
	</template>
	
	<template match="comment()" mode="include misc border layout i18n">
		<if test="starts-with(., '[if')"><copy/></if>
	</template>
	
	<template match="@*|text()" mode="#all" priority="-2"/>
	
	<function name="f:set">
		<param name="nodes"/>
		<for-each select="$nodes">
			<text>"</text>
			<value-of select="@ox:id"/>
			<text>":true</text>
			<if test="position() lt last()">,&#10;</if>
		</for-each>
	</function>

	<function name="f:attrset">
		<param name="attrs"/>
		<for-each select="$attrs">
			<text>"</text>
			<value-of select="../@ox:id"/>
			<text>":"</text>
			<value-of select="."/>
			<text>"</text>
			<if test="position() lt last()">,&#10;</if>
		</for-each>
	</function>

	<!-- dbg -->

	<function name="f:dbg">
		<param name="nodes"/>
		<variable name="text">
			<apply-templates select="$nodes" mode="dbg"/>
		</variable>
		<value-of select="string($text)"/>
	</function>
	
	<template match="element()" mode="dbg">
		<value-of select="concat('&lt;', name(.), f:dbg(@*), '&gt;', f:dbg(*), '&lt;/', name(.), '&gt;')"/>
	</template>
	
	<template match="text()" mode="dbg">
		<value-of select="."/>
	</template>
	
	<template match="attribute()" mode="dbg">
		<value-of select="concat(' ', name(.), '=&quot;', ., '&quot;')"/>
	</template>

	<!-- include -->

	<template match="ox:include" mode="include" priority="1">
		<apply-templates select="document(@src)/*" mode="#current"/>
	</template>
	
	<template match="*[@id]" mode="include">
		<copy>
			<attribute name="ox:id" select="@id"/>
			<apply-templates select="@*|node()" mode="#current"/>
		</copy>
	</template>
	
	<template match="*[not(@id)]" mode="include">
		<copy>
			<attribute name="ox:id" select="concat($preid,generate-id())"/>
			<apply-templates select="@*|node()" mode="#current"/>
		</copy>
	</template>
	
	<!-- IE6 workaround -->

	<function name="f:ie6workaround">
		<param name="nodes"/>
		<for-each select="$nodes">
			<text>"</text>
			<value-of select="@ox:id"/>
			<text>":{dir:</text>
			<value-of select="@dir"/>
			<text>,padding:"</text>
			<variable name="type" select="@type"/>
			<value-of select="replace($borderpadding/ox:padding[@name = $type],
			                          '[^ ]+ ([^ ]+) [^ ]+ ([^ ]+)',
			                          '0 $1 0 $2')"/>
			<text>"}</text>
			<if test="position() lt last()">,&#10;</if>
		</for-each>
	</function>

	<!-- movable -->

	<template match="ox:popupwindow" mode="misc">				
		<h:div class="popup-window popupBackground {@class}">	
			<apply-templates select="@*[name(.) != 'caption' and name(.) != 'class']" mode="#current"/>


<h:table border="0" cellspacing="0" cellpadding="0" width="100%" style="overflow:hidden;">
<h:tbody>
<h:tr>

<h:td class="popup_border_lo"> 

<h:table border="0" marginwidth="0" marginheight="0" cellspacing="0" cellpadding="0" width="100%" height="100%" style="overflow:hidden;">
<h:tbody>
<h:tr>
<h:td class="popupHeaderTableLeft1 popup_master_background" style=""></h:td>
</h:tr>
<h:tr>
<h:td class="popupHeaderTableLeft2" style=""></h:td>
</h:tr>
<h:tr>
<h:td class="popupHeaderTableLeft3 popup_master_background" style=""><h:img src="themes/default/img/dummy.gif" height="1px" width="1px" /></h:td>
</h:tr>
</h:tbody>
</h:table>					


</h:td>

<h:td class="popup_border_oo">

			<h:div class="popup-header popupHeaderBackground" id="{@ox:id}-h">
				<h:img ox:id="{@ox:id}-h-i" ox:i18n="alt,title" style="margin-top:2px; float: right; cursor: pointer;" src="themes/default/img/x.png" alt="Close" title="Close"/>
				<h:span ox:id="{@ox:id}-h-c" ox:i18n=""><value-of select="@caption"/></h:span>
			</h:div>

</h:td>
<h:td class="popup_border_ro">

<h:table border="0" marginwidth="0" marginheight="0" cellspacing="0" cellpadding="0" width="100%" height="100%" style="overflow:hidden;">
<h:tbody>
<h:tr>
<h:td class="popupHeaderTableRight1 popup_master_background" style=""></h:td>
</h:tr>
<h:tr>
<h:td class="popupHeaderTableRight2" style=""></h:td>
</h:tr>
<h:tr>
<h:td class="popupHeaderTableRight3 popup_master_background" style=""><h:img src="themes/default/img/dummy.gif" height="1px" width="1px" /></h:td>
</h:tr>
</h:tbody>
</h:table>	

</h:td>
</h:tr>
<h:tr>
<h:td class="popup_border_ll">&#x00A0;</h:td>
<h:td class="popup_center_area">		
	
		 <apply-templates select="node()" mode="#current"/>				
</h:td>
<h:td class="popup_border_rr">&#x00A0;</h:td>
</h:tr>

<h:tr>
<h:td class="popup_master_background  popup_border_lu"></h:td>
<h:td class="popup_border_uu"></h:td>
<h:td class="popup_master_background  popup_border_ru"></h:td>
</h:tr>
</h:tbody>
</h:table>					
		</h:div>			
	</template>
	
	<function name="f:movable">
		<param name="nodes"/>
		<for-each select="$nodes">
			<text>"</text>
			<value-of select="concat(@ox:id, '-h')"/>
			<text>"</text>
			<if test="position() lt last()">,&#10;</if>
		</for-each>
	</function>
	
	<!-- button -->

	<template match="ox:button" mode="misc">
		<h:div class="fakeButton background-color-default {@class}" tabindex="0">
			<apply-templates select="@style|@id|@onclick|@onkeydown" mode="#current"/>
			<h:div class="fakeButtonBottom">
				<h:div class="fakeButtonLeft">
					<h:div class="fakeButtonRight">
						<h:div class="fakeButtonTopLeft">
							<h:div class="fakeButtonTopRight">
								<h:div class="fakeButtonBottomLeft">
									<h:div class="fakeButtonBottomRight" ox:id="{@ox:id}-button">
										<apply-templates select="@*[not(contains(' style class ox:id id onclick onkeydown ', concat(' ', name(), ' ')))]|node()" mode="#current"/>
									</h:div>
								</h:div>
							</h:div>
						</h:div>
					</h:div>
				</h:div>
			</h:div>
		</h:div>
	</template>

	<!-- notag -->
	<template match="ox:notag" mode="misc">
		<apply-templates select="*" mode="#current"/>
	</template>
	

	<!-- help -->

	<template match="@ox:help" mode="misc">
		<attribute name="id" select="../@ox:id"/>
	</template>

	<function name="f:help">
		<param name="nodes"/>
		<for-each select="$nodes">
			<text>"</text>
			<value-of select="../@ox:id"/>
			<text>":"</text>
			<value-of select="."/>
			<text>"</text>
			<if test="position() lt last()">,&#10;</if>
		</for-each>
	</function>

	<!-- options -->

	<template match="ox:options" mode="misc">
		<h:div class="options-arrow {@class}">
			<apply-templates select="@*[name() != 'class']" mode="#current"/>
			<h:img src="themes/default/img/arrows/arrow-down.gif" alt="Options" title="Options"
			       ox:id="{@ox:id}-opt" ox:i18n="alt,title"/>
		</h:div>
	</template>

	<!-- min/max -->

	<template match="@ox:min|@ox:max" mode="misc">
		<attribute name="id" select="../@ox:id"/>
	</template>

	<!-- iframe -->

	<template match="ox:iframe" mode="misc">
		<h:iframe ox:align="stretch">
			<apply-templates select="@*" mode="#current"/>
		</h:iframe>
		<h:div ox:id="{@ox:id}-hide" id="{@ox:id}-hide" style="overflow:hidden;display:none;position:absolute;left:0;top:0;width:100%;height:100%">
			<h:img src="themes/default/img/dummy.gif" style="width: 100%; height: 100%"/>
		</h:div>
	</template>
	
	<!-- version -->

	<template match="ox:version" mode="misc">
		<value-of select="$version"/>
	</template>
	
	<template match="ox:pversion" mode="misc">
		<value-of select="$pversion"/>
	</template>

	<!-- img -->
	
	<template match="img/@src" mode="misc">
		<attribute name="id" select="../@ox:id"/>
		<attribute name="src" select="'themes/default/img/dummy.gif'"/>
	</template>

	<!-- timestamp -->

	<template match="ox:timestamp" mode="misc">
		<value-of select="format-dateTime(current-dateTime(), '[Y0001]-[M01]-[D01] [H01]:[m01]:[s01]')"/>
	</template>

	<!-- border -->

	<variable name="borderpadding">
		<ox:padding name="topheader">8px 4px 0px 4px</ox:padding>
		<ox:padding name="topheaderactive">8px 0px 0px 0px</ox:padding>
		<ox:padding name="cpheader">0px 4px 0px 4px</ox:padding>
		<ox:padding name="cpbody">0px 4px 0px 4px</ox:padding>
		<ox:padding name="cpbottom">0px 4px 8px 4px</ox:padding>
		<ox:padding name="calbody">0px 4px 0px 0px</ox:padding>
	</variable>
	
	<function name="f:borderstyle">
		<param name="type"/>
		<value-of select="concat('padding:', $borderpadding/ox:padding[@name = $type], ';')"/>
	</function>

	<function name="f:notlayout">
		<param name="node"/>
		<value-of select="not(contains(' ox:align ox:split ox:size ox:resize ox:padding ox:border ox:margin ', concat(' ', name($node), ' ')))"/>
	</function>
	
	<function name="f:notborder">
		<param name="attr"/>
		<value-of select="not(contains('type dir', local-name($attr))) = true()"/>
	</function>

	<template name="border2" match="ox:border[@ox:align]" mode="border" priority="1">
		<param name="bits" select="@dir"/>
		<param name="color" select="concat(' ', @type, '-color')"/>
		<param name="suffixes" select="'-t -l -r -b -tl -tr -bl -br '"/>
		<if test="$bits mod 2 = 0">
			<call-template name="border2">
				<with-param name="bits" select="$bits div 2"/>
				<with-param name="color" select="$color"/>
				<with-param name="suffixes" select="substring-after($suffixes, ' ')"/>
			</call-template>
		</if>
		<if test="$bits mod 2">
			<variable name="newbits" select="floor($bits div 2)"/>
			<variable name="type" select="@type"/>
			<variable name="first" select="boolean($color)"/>
			<variable name="last" select="not($newbits)"/>
			<variable name="style" select="concat(
				if (not($first)) then
					'position:absolute;left:0;top:0;width:100%;height:100%;'
				else
					'',
				if ($last) then @style else '')"/>
			<h:div class="{@type}{substring-before($suffixes, ' ')}{$color} {@class}">
				<if test="$style"><attribute name="style" select="$style"/></if>
				<if test="$first">
					<attribute name="ox:padding" select="$borderpadding/ox:padding[@name=$type]"/>
					<copy-of select="@*[f:notborder(.) = true() and name() != 'class']"/>
				</if>
				<choose>
					<when test="not($last)">
						<call-template name="border2">
							<with-param name="bits" select="$newbits"/>
							<with-param name="color" select="''"/>
							<with-param name="suffixes" select="substring-after($suffixes, ' ')"/>
						</call-template>
					</when>
					<when test="$first or */@ox:align">
						<apply-templates select="node()" mode="border"/>
					</when>
					<otherwise>
						<h:div style="margin:{$borderpadding/ox:padding[@name=$type]}">
							<apply-templates select="node()" mode="border"/>
						</h:div>
					</otherwise>
				</choose>
			</h:div>
		</if>
	</template>
	
	<template name="border3" match="ox:border" mode="border">
		<param name="bits" select="@dir"/>
		<param name="color" select="concat(' ', @type, '-color')"/>
		<param name="suffixes" select="'-t -l -r -b -tl -tr -bl -br '"/>
		<if test="$bits mod 2 = 0">
			<call-template name="border3">
				<with-param name="bits" select="$bits div 2"/>
				<with-param name="color" select="$color"/>
				<with-param name="suffixes" select="substring-after($suffixes, ' ')"/>
			</call-template>
		</if>
		<if test="$bits mod 2">
			<variable name="newbits" select="floor($bits div 2)"/>
			<h:div class="{@type}{substring-before($suffixes, ' ')}{$color} {@class}">
				<if test="$color"><copy-of select="@*[f:notborder(.) = true() and name() != 'class']"/></if>
				<if test="$newbits">
					<call-template name="border3">
						<with-param name="bits" select="$newbits"/>
						<with-param name="color" select="''"/>
						<with-param name="suffixes" select="substring-after($suffixes, ' ')"/>
					</call-template>
				</if>
				<if test="not($newbits)">
					<attribute name="style" select="concat(f:borderstyle(@type), @style)"/>
					<apply-templates select="node()" mode="border"/>
				</if>
			</h:div>
		</if>
	</template>
	
	<!-- layout -->

	<template match="@ox:align|@ox:split" mode="layout">
		<attribute name="id" select="../@ox:id"/>
	</template>
	
	<template match="@ox:size|@ox:resize|@ox:padding|@ox:border|@ox:margin" mode="layout"/>

	<template match="*[@ox:padding]|*[@ox:border]|*[@ox:margin]" mode="layout">
		<variable name="padding" select="if (@ox:padding) then concat('padding: ', @ox:padding, ';') else ''"/>
		<variable name="border" select="if (@ox:border) then concat('border-width: ', @ox:border, ';') else ''"/>
		<variable name="margin" select="if (@ox:margin) then concat('margin: ', @ox:margin, ';') else ''"/>
		<copy>
			<attribute name="style" select="concat($padding, $border, $margin, @style)"/>
			<apply-templates select="@*[name() != 'style']|node()" mode="#current"/>
		</copy>
	</template>
	
	<template match="*[@ox:align]" mode="layout-js">
		{id:"<value-of select="@ox:id"/>",
		 align:"<value-of select="@ox:align"/>",
		 <if test="@ox:size">size:"<value-of select="@ox:size"/>",</if>
		 <if test="@ox:padding">padding:"<value-of select="@ox:padding"/>",</if>
		 <if test="@ox:border">border:"<value-of select="@ox:border"/>",</if>
		 <if test="@ox:margin">margin:"<value-of select="@ox:margin"/>",</if>
		 <if test="@ox:resize">resize:"<value-of select="@ox:resize"/>",</if>
		 children:[<apply-templates mode="#current"/>]},
	</template>
	
	<!-- i18n -->

	<template match="@ox:i18n" mode="i18n">
		<attribute name="id" select="../@ox:id"/>
	</template>

	<template match="@ox:id" mode="i18n"/>

</stylesheet>