
var angle = 0;
var dir = 0.01;
var left, right;
var cubetimeout;
function startrotate(node1,node2,direction) {
	if(cubetimeout) {
		clearTimeout(cubetimeout);
	}	
	if(configGetKey("gui.effects.global")) {
		var a = Math.PI / 4, b = Math.PI / 2;
		cubetimeout=setTimeout(function() {
			if(node1 && node2 && node1.id==node2.id) return;
			if(direction >= 0) {left = node1; right = node2; }
			else { right = node1; left = node2; }
			dir = (direction >= 0) ? 0.005 : -0.005;
			angle = (direction >=0) ? 0 : b;
			rotate(direction);
		},1200);
	} else {
		if(node1) {	
			node1.style.left = Math.round(24 - 24 * Math.cos(Math.PI / 4))+  "px";	
			node1.style.width = "0px";
		}
		if(node2) {
			node2.style.left = Math.round(24 - 24 * Math.cos(Math.PI / 4) )+ "px";
			node2.style.width = "34px";
		}	
	}
}


function rotate(direction) {
	var a = Math.PI / 4, b = Math.PI / 2; 	
	var start = (new Date()).getTime();
	setTimeout(function() {
		var now = (new Date()).getTime();
		angle += dir * (now - start);
		if (dir > 0 && angle >= b) {
			angle = b;
		} else if (dir < 0 && angle < 0) {
			angle = 0;
		} else
			rotate(direction);
		if(left) {	
			left.style.left = Math.round(24 - 24 * Math.cos(angle - a) )+  "px";	
			left.style.width = Math.round(34 * Math.cos(angle)) + "px";
		}
		if(right) {
			right.style.left = Math.round(24 + 24 * Math.cos(angle + a) )+ "px";
			right.style.width = Math.round(34 * Math.sin(angle)) + "px";
		}
	}, 0);
}

/******************************************************/
/*** Find as you type                              ****/
/******************************************************/
register("Loaded",function () {
	if($("menu_search_global_searchfield")) {
		var d=new PreSearch($("menu_search_global_searchfield"));
		d.addEvents();
	} 
	if($("menu_search_mail_searchfield")) {
		var d2=new PreSearch($("menu_search_mail_searchfield"));
		d2.addEvents();
	}
});
PreSearch = function (searchfield) {
	var Self=this;
	this.keytimeout;
	this.actualposition=-1;
	this.searchfield=searchfield;
	this.mycontent=newnode("div",null,{ className : "presearchcontent" },[]);
	this.mycontent.style.display="none";
	this.mycontent.onselectstart = function () { var tmp=menuselectstart ; menuselectstart = false; return tmp; }  
	this.mycontent.onmousedown = function () { var tmp=menumousedown ; menumousedown = false; return tmp; }
	$("body").appendChild(this.mycontent);
}
PreSearch.prototype.close = function () {
	var Self=this;
	popupHide();
}
PreSearch.prototype.open = function () {
	var Self=this;
	popup(Self.mycontent,null,null,null,"findasyoutype",true);
}
PreSearch.prototype.addEvents = function () {
	var Self=this;
	addDOMEvent(this.searchfield,"keydown",Self.addKeyDown()); 	
}
PreSearch.prototype.nextContent = function(direction) {
	if(direction) {
		this.actualposition++;
		this.actualposition=this.setSelected(this.actualposition);
	} else {
		this.actualposition--;
		this.actualposition=this.setSelected(this.actualposition);
	}
}
PreSearch.prototype.addKeyDown = function () {
	var Self=this;
	return function(evt) {
		if(Self.keytimeout) {
			clearTimeout(Self.keytimeout);
		}
		
		if (!evt) evt = window.event;
		var a = evt.keyCode;
		switch (a) {
			case 27: //ESC
				Self.actualposition=-1;
				Self.close();
				stopEvent(evt); 
				return false;
				break;
			case 13: case 9: // ENTER
				if(Self.actualposition!=-1) {
					if(Self.mycontent.childNodes[Self.actualposition]) {
						var myelem=Self.mycontent.childNodes[Self.actualposition];					
 						Self.searchfield.value=myelem.oxvalue;
					} 
				}
				popupHide();
				break;
			case 38:	// UP
				Self.nextContent(false);
				break;
			case 40:	// DOWN
				Self.nextContent(true);
				break;
		
			default:
				Self.actualposition=-1;
				Self.keytimeout=setTimeout(function() {
					var newpresearch=Self.searchfield.value;
					Self.presearch(newpresearch);
				},500);
				break;
		}
	}
}
PreSearch.prototype.presearch = function (searchstring) {
	var Self=this;
	removeChildNodes(this.mycontent);
	if(searchstring.length > 2)  {
		this.mycontent.appendChild(
			newnode("div", { textAlign: "center", width: "100%", padding: "1px" }, null, [ 
				newnode("img",null,{src: getFullImgSrc("img/ox_animated_withoutbg.gif")},[])
			])
		);
		this.mycontent.style.left=getAbsolutePositionLeft(this.searchfield.parentNode.parentNode.parentNode.parentNode.parentNode)+"px";
		this.mycontent.style.top=(getAbsolutePositionTop(this.searchfield.parentNode.parentNode.parentNode.parentNode.parentNode)+this.searchfield.parentNode.parentNode.parentNode.parentNode.offsetHeight)+"px";
		switch(currentpath2[0]) {
			case "calendar":
				Self.open();
				var reqobj = new Object();
				reqobj.pattern = searchstring;
				if(!calendar_getAllFoldersAttribute()) {
					reqobj.folder = activefolder;
				}
				new JSON().put(AjaxRoot + "/calendar?session=" + session + "&action=search&columns=200",
				reqobj, null, 
				function(cb) {
					Self.refill(cb.data);
				});
				break;
			case "contacts":
				Self.open();
                var reqobj = {
                    display_name: searchstring, first_name: searchstring,
                    last_name: searchstring, email1: searchstring,
                    email2: searchstring, email3: searchstring,
                    orSearch: true, folder: activefolder
                };
				new JSON().put(AjaxRoot + "/contacts?session=" + session + "&action=search&columns=500",
				reqobj, null, 
				function(cb) {
					Self.refill(cb.data);
				});
				break;
			case "infostore":
				Self.open();		
				var reqobj = new Object();
				reqobj.pattern = searchstring;
				reqobj.folder = activefolder;
				(new JSON()).put(AjaxRoot + "/infostore?session=" + session + "&action=search&columns=700",
				reqobj, null, 
				function(cb) {
					Self.refill(cb.data);
				});
				break;
			case "tasks":				
				Self.open();
				var reqobj = new Object();
				reqobj.pattern = "*"+searchstring+"*";
				reqobj.folder = activefolder;
				(new JSON()).put(AjaxRoot + "/tasks?session=" + session + "&action=search&columns=200",
				reqobj, null, 
				function(cb) {
					Self.refill(cb.data);
				});
				break;
			case "mail":
				var column="";
				var searchcolumn=menumailsearchcontents[mailsearchcontent];
				if(OXMailObject.stringmapping[searchcolumn]) { 
					searchcolumn = OXMailObject.stringmapping[searchcolumn];
					column=""+searchcolumn;
				} else { 
					break;
				}
				Self.open();
				var req=""+AjaxRoot + '/mail?action=search&session='+session+'&columns='
					+ column + '&folder=' + encodeURIComponent(activefolder);
				
				var reqobj = new Array();
				var oObj = new Object();
				oObj.pattern = searchstring;
				oObj.col=searchcolumn;
				reqobj.push(oObj);
				if(reqobj.length<=0) { return; }
				new JSON().put(req,reqobj, null, 
				function(cb) {
					var newarray = new Array();
					function createEntry(entry) {
						if(entry) {
							for(var i2=0;i2<entry.length;i2++) {
								var mystring=entry[i2].join("");
								if(mystring.toLowerCase().indexOf(searchstring.toLowerCase())!=-1) { 
									if(entry[i2][0] && entry[i2][0]!="") {
										var tmp3=entry[i2][0];
										if(tmp3.charAt(0)=="\"" && tmp3.charAt(tmp3.length-1) == "\"") {
											tmp3=tmp3.substring(1,tmp3.length-1);
										}
										newarray.push([tmp3]);
									} else {
										newarray.push([entry[i2][1]]);
									}
								}
							}
						}
					} 
					if(activemodule=="mail" && (menumailsearchcontents[mailsearchcontent] == "from" || menumailsearchcontents[mailsearchcontent] == "to" || menumailsearchcontents[mailsearchcontent] == "cc")) {
						for(var i=0;i<cb.data.length;i++) {
							createEntry(cb.data[i][0])
						}
						Self.refill(newarray);	
					} else {
						Self.refill(cb.data);
					}
					
				});
				break;
			default:
				popupHide();
		}	
	} else {
		popupHide();
	}	
}
PreSearch.prototype.refill = function (dataarray) {
	var Self=this;
	var tmpobject=new Object();
	var counter=0;
	if(dataarray.length==0) {
		removeChildNodes(this.mycontent);
		popupHide();
	} else {
		removeChildNodes(this.mycontent);
		for (var  i = 0; i < dataarray.length; i++ ) {
			if(!tmpobject[dataarray[i][0]]) {
				tmpobject[dataarray[i][0]]=true;
				counter++;
				if(counter>5) break;
				var nDiv = newnode("div",{ overflow: "hidden", whiteSpace: "nowrap", padding: "1px" }, []);
				nDiv.appendChild(document.createTextNode(dataarray[i][0]));
				addDOMEvent(nDiv,"mouseover",function(e) { this.className = "background-color-PMG-selection-elements";});
				addDOMEvent(nDiv,"mouseout",function(e) { if(Self.actualposition!= this.position) {this.className = "background-color-content";}});
				nDiv.oxvalue= dataarray[i][0];
				nDiv.position=i;
				Self.actualposition=-1;
				addDOMEvent(nDiv,"mousedown",function(e) {
					var myelem=e.currentTarget || e.srcElement;					
 					Self.searchfield.value=myelem.oxvalue; 
					popupHide(); 
					if(activemodule=="mail") {
						triggerEvent("OX_New_Search",activemodule,Self.searchfield.value,menumailsearchcontents[mailsearchcontent]);
					} else {
						triggerEvent("OX_New_Search",activemodule,Self.searchfield.value);
					}  
				});
			}
			if(counter>5) break;
			this.mycontent.appendChild(nDiv);	
		}
	} 
}
PreSearch.prototype.setSelected = function (int1) {
	var Self=this;
	var childs=this.mycontent.childNodes;
	if(int1<0) { int1=0; }
	if(int1>=childs.length) { int1=childs.length-1; }
	for(var i=0;i<childs.length;i++) {
		if(i==int1) {
			childs[i].className = "background-color-PMG-selection-elements";
		} else {
			childs[i].className = "background-color-content";
		}
	}
	return int1;
}

function Accordion(maxheight,width,hover) {
	this.hover=hover;
	this.speed=12;
	this.intervalcounts=0;
	this.interval=10;
	this.actualcontent=0;
	this.components=new Object();
	this.maxheight=maxheight;
	this.width="100%";
	if(width) { this.width = width +"px" }
	this.container=newnode("div",{ width: this.width },{},[]);

}
Accordion.prototype.addComponent = function(title,node,maximumheight) {
	if(this.components[title]) {
		this.container.removeChild(this.components[title].content);
	}
	this.components[title]= {"title" : title , "content" : node, maximumheight : maximumheight };
	node.style.height="0px";
	var height=Accordion.getHeight(node,this,maximumheight);
	this.components[title].maxheight=height;
	this.container.appendChild(node);
	this.checkHeight();	
}
Accordion.prototype.checkComponentHeight = function(title) {
	if(this.components[title]) {
		this.components[title].maxheight=Accordion.getHeight(this.components[title].content,this,this.components[title].maximumheight);
		this.checkHeight();
	}
}
Accordion.prototype.removeComponent=function(title) {
	if(this.components[title]) {
		try {
			this.container.removeChild(this.components[title].content)
		} catch(e) {}
		delete this.components[title];
	}
}
Accordion.prototype.clear=function() {
	this.components=new Object();
	this.getDomNode();
}
Accordion.prototype.inTree = function() {
	var node=this.container;
	while(node) {
		if(node==$("body")) { return true; }
		node=node.parentNode;
	}
}
Accordion.prototype.setHover = function(hover) {
	this.hover=hover;
}
Accordion.prototype.checkHeight = function() {

	if(this.intervalcounts==0) {
	
		if(this.maxheight && this.maxheight<this.container.offsetHeight) {
			this.container.style.height=this.maxheight+"px";
			this.container.style.overflowX="hidden";
			this.container.style.overflowY="auto";
		} else {
			this.container.style.height="";
		}
		
		if(!this.hover) {
			if(OXAppointmentHover.actualHover) {
				OXAppointmentHover.actualHover.sizeChanged();
			}
		} else {
			this.hover.sizeChanged();
		}
	}
}
Accordion.prototype.getDomNode = function () {
	removeChildNodes(this.container);
	
	var tmpintree=this.inTree();
	if(!tmpintree) { $("body").appendChild(this.container); }
	for(var i in this.components) {
		var tmp=this.components[i];
		this.container.appendChild(tmp.content);
		this.components[i].maxheight=Accordion.getHeight(tmp.content,this);
		this.components[i].content.style.height="0px";
	}
	if(!tmpintree) { $("body").removeChild(this.container); }
	return this.container;
}

Accordion.prototype.showExtraContent = function(number) {
	var tmpcontents=(""+this.actualcontent).split(",");
	tmpcontents.push(number);
	this.showContent(tmpcontents.join(","));
}
Accordion.prototype.hideExtraContent = function(number) {
	var tmpcontents=(""+this.actualcontent).split(",");
	for(var i=0;i<tmpcontents.length;i++) {
		if(tmpcontents[i] == number) {
			tmpcontents.splice(i,1);
			break;
		}
	}
	this.showContent(tmpcontents.join(","));
	
}

Accordion.prototype.showContent = function(number) {
	var Self=this;
	
	var newnumbers=(""+number).split(",");
	var oldnumbers=(""+Self.actualcontent).split(",");
	var oldobject=new Object();
	var newobject=new Object();
	for(var i=0;i<oldnumbers.length;i++) {
		oldobject[oldnumbers[i]]=true;
	}
	for(var i=0;i<newnumbers.length;i++) {
		newobject[newnumbers[i]]=true;
	}
	this.container.style.height="";
	this.container.style.overflow="";
	
	for(var i2 in Self.components) {	
		if(!oldobject[i2]) {
			if(!newobject[i2]) {
				Self.components[i2].content.style.height="0px";
			} else {
				Self.setDisplay(Self.components[i2],true);
			}
		} else {
			if(!newobject[i2]) {
				Self.setDisplay(Self.components[i2],false);			
			} else {
				if(Self.components[i2].content.style.height=="0px") {
					Self.setDisplay(Self.components[i2],true);
				}
				
			} 
		}
	} 
	Self.checkHeight();
	var newnumbers=new Array();
	for(var i in newobject) {
		newnumbers.push(i);
	}
	Self.actualcontent=newnumbers;
}

Accordion.prototype.setDisplay = function(containerobject,direction) {

	var Self=this;
	var fade=configGetKey("gui.effects.fading");
	if(direction) {

		containerobject.content.style.height="0px";
		containerobject.content.style.display="block";
		if(!containerobject.maxheight) { containerobject.tmpheight=0; }
		else { containerobject.tmpheight=containerobject.maxheight; }
		
		if(containerobject.interval) { containerobject.interval(); }
		Self.intervalcounts++;
		function final_cb1() {
			if(fade) {
				containerobject.content.style.opacity = "";
				containerobject.content.style.filter = "";	// IE
			}
			if(containerobject.maximumheight && containerobject.content.offsetHeight>=containerobject.maximumheight) {
				containerobject.content.style.height=containerobject.maximumheight+"px";	
			} else {
				containerobject.content.style.height="";
			}
			containerobject.interval=null;
			Self.intervalcounts--;
			if(fade) {
				Self.checkHeight();
			}
		}
		
		if(configGetKey("gui.effects.global")) {
			containerobject.interval=animate(500, 100,
			function(curr) {
				var tmpheight=containerobject.maxheight || 0 ;
				var nextheight=Math.round(tmpheight* (curr/100));
				if(containerobject.maximumheight && nextheight>containerobject.maximumheight) {
					nextheight=containerobject.maximumheight;
				}
				if(fade) {
					containerobject.content.style.opacity = (curr/100);
					containerobject.content.style.filter = "alpha(style=0,opacity:" +(curr)+ ")";	// IE 
				}
				containerobject.content.style.height = nextheight+"px";
			},final_cb1);
		
		} else {	
			if (containerobject.maximumheight && containerobject.maxheight > containerobject.maximumheight){
				containerobject.content.style.height = containerobject.maximumheight+"px";
			}
			final_cb1();
		}					
	} else {
		if(containerobject.interval) { containerobject.interval(); }

		Self.intervalcounts++;
		function final_cb2() {
			if(fade) {
				containerobject.content.style.opacity = 0;
				containerobject.content.style.filter = "alpha(style=0,opacity:" +(0)+ ")";	// IE
			}
			containerobject.content.style.height="0px";
			containerobject.interval=null;
			Self.intervalcounts--;
			if(fade) {
				Self.checkHeight();
			}
		}
		if(configGetKey("gui.effects.global")) {

			containerobject.interval=animate(500, 100,
			function(curr) {
				var tmpheight=containerobject.maxheight || 0;
				var nextheight=Math.round(tmpheight* ((100-curr)/100));
				if(containerobject.maximumheight && containerobject.maximumheight<=nextheight) { nextheight=containerobject.maximumheight; }
				if(fade) {
					containerobject.content.style.opacity = (curr/100);
					containerobject.content.style.filter = "alpha(style=0,opacity:" +(curr)+ ")";	// IE
				} 
				containerobject.content.style.height = nextheight+"px";
			},final_cb2);	
		} else {
			if (containerobject.maximumheight && containerobject.maxheight > containerobject.maximumheight){
				containerobject.content.style.height = containerobject.maximumheight+"px";
			}		
			final_cb2();
		}
	}
}

Accordion.getHeight = function(node,accordion,maximumheight) {
	
	var tmpheight=node.style.height;
	var tmpnode=node.cloneNode(true);
	tmpnode.style.height="";
	tmpnode.style.zIndex=-1;
	body.appendChild(tmpnode);
	var value=tmpnode.offsetHeight;
	if(maximumheight && value > maximumheight) {
		node.style.overflow="auto";
	} else {
		node.style.overflow="hidden";
	}
	body.removeChild(tmpnode);
	return value;
}
function Slider(count) {
    this.titlecontent=newnode("div",{ fontWeight: "bold"},{ className : "contenttext notclickable" },[
        document.createTextNode("")
    ]);
    this.content;
    this.mousedownactive=false;
    this.pos=0;
    this.selected=0;
    this.sliderwidth=200;
    this.slidersteps=50;
    this.count=count;
    this.slidercontents=new Array();
    for(var i=0;i<count;i++) {
        this.slidercontents[i]=new Object();
        this.slidercontents[i]["active"]=false;
    }
}
Slider.prototype.getSliderPos = function(e,leftimg,rightimg,middleimg,sliderimg) {
	var posx=getAbsolutePositionLeft(this.content);
	var fieldposx=e.clientX-posx;
	var momentvalue=leftimg.w+(sliderimg.w/2);
	var sliderstep=(this.sliderwidth-sliderimg.w-leftimg.w-rightimg.w)/(this.slidersteps - 1);
	for(var i=0;i<this.slidersteps;i++) {
		var curdiff=Math.abs(fieldposx-momentvalue);
		var nextdiff=Math.abs(fieldposx-(momentvalue+sliderstep));
		if(curdiff<nextdiff) { return i; }
		momentvalue=momentvalue+sliderstep;
	}
	return this.slidersteps-1;
}
Slider.prototype.getSelected = function(pos) {
    var value =Math.round((pos/(this.slidersteps/(this.count-1))));
    return value;
    
}
Slider.prototype.click= function(e,leftimg,rightimg,middleimg,sliderimg) {
    var pos=this.getSliderPos(e,leftimg,rightimg,middleimg,sliderimg);
    var selected=this.getSelected(pos);
    var sliderstep=(this.sliderwidth-sliderimg.w-leftimg.w-rightimg.w)/(this.slidersteps - 1);
    this.nodeClicked(pos,null,selected,sliderstep);
}
Slider.prototype.mouseup= function(e,leftimg,rightimg,middleimg,sliderimg) {
	var pos=this.getSliderPos(e,leftimg,rightimg,middleimg,sliderimg);
    var selected=this.getSelected(pos);
    var sliderstep=(this.sliderwidth-sliderimg.w-leftimg.w-rightimg.w)/(this.slidersteps - 1);
    this.nodeClicked(pos,null,selected,sliderstep);
}

Slider.prototype.bodymouseup= function(e,leftimg,rightimg,middleimg,sliderimg) {
    this.mousedownactive=false;
    this.pos=0;
    this.selected=0;
}

Slider.prototype.mousemove = function(e,leftimg,rightimg,middleimg,sliderimg) {
	if(!this.mousedownactive) return;
	var pos=this.getSliderPos(e,leftimg,rightimg,middleimg,sliderimg);
    var selected=this.getSelected(pos);
    var sliderstep=(this.sliderwidth-sliderimg.w-leftimg.w-rightimg.w)/(this.slidersteps - 1);
    this.mouseMoveButton(pos,selected,sliderstep);
}
Slider.prototype.mouseout = function(e,leftimg,rightimg,middleimg,sliderimg) {
	if(!realMouseOutIn(e,true)) return;
    if(!this.mousedownactive) return;
    var sliderstep=(this.sliderwidth-sliderimg.w-leftimg.w-rightimg.w)/(this.slidersteps - 1);
    var pos=this.pos;
    var selected=this.selected;
    removeChildNodes(this.titlecontent);
    var title = this.slidercontents[selected].title || "";
    title = typeof title == "string" ? document.createTextNode(title) : title;
	this.titlecontent.appendChild(title);	
	this.content.getElementsByTagName("div")[3].style.left =(pos*sliderstep) +"px";
    this.content.getElementsByTagName("div")[3].style.height="19px";
    this.content.getElementsByTagName("div")[3].style.display="block";
}
Slider.prototype.mousedown =function(e,leftimg,rightimg,middleimg,sliderimg) {
    var pos=this.getSliderPos(e,leftimg,rightimg,middleimg,sliderimg);
    var selected=this.getSelected(pos);
    this.mousedownactive=true;
    this.pos=pos;
    this.selected=selected;
}
Slider.prototype.enableButton = function(pos,selected,sliderstep) {
    if(!sliderstep) { sliderstep=0; }
	this.slidercontents[selected]["active"]=true;
	for(var i=0;i<this.slidercontents.length;i++) {
	   if(i!=selected) {
	       this.slidercontents[selected]["active"]=false;
	   }
	}
	/* Ugly IE Bug with display none */
	this.content.getElementsByTagName("div")[3].style.left =(pos*sliderstep) +"px";
    this.content.getElementsByTagName("div")[3].style.height="19px";
    this.content.getElementsByTagName("div")[3].style.display="block";
    if(this.slidercontents[selected].enable) {
		this.slidercontents[selected].enable();
	}
}
Slider.prototype.mouseMoveButton = function(pos,selected,sliderstep) {
    if(!sliderstep) { sliderstep=0; }
	removeChildNodes(this.titlecontent);
    var title = this.slidercontents[selected].title || "";
    title = typeof title == "string" ? document.createTextNode(title) : title;	
	this.titlecontent.appendChild(title);
	this.content.getElementsByTagName("div")[3].style.left =(pos*sliderstep) +"px"
	this.content.getElementsByTagName("div")[3].style.height="19px";
	this.content.getElementsByTagName("div")[3].style.display="block";
	if(this.slidercontents[selected].mouseover) {
		this.slidercontents[selected].mouseover();
	}		
}
Slider.prototype.nodeClicked = function(pos,force,selected,sliderstep) {
	if(!selected) { selected=this.getSelected(pos); }
	if(this.slidercontents[selected]["active"]) {
		if(force) { this.enableButton(pos,selected,sliderstep);	}
	} else {
		this.enableButton(pos,selected,sliderstep);
	}
	removeChildNodes(this.titlecontent);
	var title = this.slidercontents[selected].title || "";
	title = typeof title == "string" ? document.createTextNode(title) : title;
	this.titlecontent.appendChild(title);	
	
}
Slider.prototype.setNodeFunctions =function(i,enable,disable,title) {
	if(i>=0 && this.slidercontents.length > i) {
		this.slidercontents[i].enable=enable;
		this.slidercontents[i].disable=disable;
		this.slidercontents[i].title=title;
	}
}
Slider.prototype.getDomNode = function(type) {
	switch(type){
		default:
			return this.getDomNodeType1();
	}
}

	
Slider.prototype.getDomNodeType1 = function() {
	var Self=this;
	if(this.content) {
		return this.content;
	}
	var leftimg = { h : 19 , w : 2 };
	var rightimg = { h : 19 , w : 2 };
	var middleimg = { h : 19 };
	var sliderimg = { h : 19 , w : 15}
	this.content = newnode("div",{ height: middleimg.h+"px", width: this.sliderwidth + "px" , position: "relative" },{ className : "clickable"},[
		newnode("div", { position:"absolute" , left: "0px", top : "0px", height : leftimg.h +"px" , width : leftimg.w +"px" },{ className : "slider_left"},[
		]),
		newnode("div", { position:"absolute" , left: (this.sliderwidth-rightimg.w) +"px", top : "0px", height : rightimg.h +"px" , width : rightimg.w +"px"},{ className : "slider_right" },[
		]),
		newnode("div", { position:"absolute" , left: (leftimg.w) +"px", top : "0px", height : middleimg.h +"px" , width : (this.sliderwidth-rightimg.w-leftimg.w) +"px"  },{ className : "slider_middle" },[
		])
	]);
	var nodeact=
        newnode("div", { position:"absolute" , display : "none" , left: (0) +"px", top : "0px", height : sliderimg.h +"px" , width : (sliderimg.w) +"px" },{ className : "slider_enabled"},[
    ]);
    this.content.appendChild(nodeact);
	addDOMEvent(this.content,"click",function (e) { Self.click(e,leftimg,rightimg,middleimg,sliderimg) });
	addDOMEvent(this.content,"mousemove",function (e) { Self.mousemove(e,leftimg,rightimg,middleimg,sliderimg) });
	addDOMEvent(this.content,"mouseup",function (e) { Self.mouseup(e,leftimg,rightimg,middleimg,sliderimg) });
	addDOMEvent(this.content,"mouseout",function (e) { Self.mouseout(e,leftimg,rightimg,middleimg,sliderimg) });
	addDOMEvent(this.content,"mousedown",function (e) { Self.mousedown(e,leftimg,rightimg,middleimg,sliderimg) });
	addDOMEvent(body,"mouseup",function (e) { Self.bodymouseup(e,leftimg,rightimg,middleimg,sliderimg) });
	return this.content;
}

function createHoverContent(innerwidth,headerheight,borderheight,imgsizes, tabnummer) {
	var mywidth=412;
	var innerwidthtop;
	if(!innerwidthtop) { innerwidthtop= 392;}
	var innerwidthbottom;
	if(!innerwidthbottom) { innerwidthbottom= 392;}
	
	if(!innerwidth) { innerwidth= 400;}
	if(!imgsizes) { imgsizes= { t: 9 , tl:10 , tr:10 , r : 6,l : 6 , b :15, bl : 10, br:10} }
	if(!headerheight) { headerheight = 9 }
	if(!borderheight) { borderheight = 15 }
	var mywidthtop=innerwidth+imgsizes.tr+imgsizes.tl;
	var returnobj=new Object();
	var coreelement=newnode("div",{ position: "absolute", width: "414px", zIndex: 100000, left : "300px", top : "100px" , display:"none" },{},[
		
		
		newnode("div",{ position:"relative" , width: "0px", height : ("0px"), whiteSpace: "nowrap"},{},[		   	
			newnode("div",{ position: "absolute", top: "0px", left: "0px", width: "0px" , height: "0px" },{ className : "hover-header-t" },[
				newnode("img",{},{src: getFullImgSrc("img/dummy.gif") },[])
			]),
			newnode("div",{ position:"absolute",top : "0px",left: "0px",width: "0px",height : "0px" },{ className : "hover-header-tr" },[
				newnode("img",{},{src: getFullImgSrc("img/dummy.gif") },[])
			]),
			newnode("div",{ position: "absolute",top : "0px",left: "0px",width: "0px", height: "0px" },{ className : "hover-header-tl" },[
				newnode("img",{},{src: getFullImgSrc("img/dummy.gif") },[])
			]),
			newnode("div",{ position: "absolute", left : "0px" , top: "0px", width: "0px", height: "0px" },{ className : "hover-header-r" },[
				newnode("img",{},{src: getFullImgSrc("img/dummy.gif") },[])
			]),
			newnode("div",{ position: "absolute", left : "0px", top: "0px", width: "0px", height: "0px" },{ className : "hover-header-l" },[
				newnode("img",{},{src: getFullImgSrc("img/dummy.gif") },[])
			]),
			newnode("div",{ position: "absolute", left: "0px", top: "0px" , width:"0px" , height: "0px" },{ className : "hover-header-color" },[
				newnode("img",{},{src: getFullImgSrc("img/dummy.gif") },[])
			])
			
		]),
			
		newnode("div",{ position:"relative",overflow: "hidden", width: "414px" },{},[
			
			
			newnode("div", { marginLeft: (imgsizes.l +2) + "px"  , width: (innerwidth)+"px" ,overflow:"hidden", zIndex:"1" },{ className : "hover_background" },[
				newnode("div", { height: "100%", width: "100%" ,overflow:"hidden" },null)		
			]),
		    	
			newnode("div",{ position:"absolute",left : "408px", top:"23px",height: "1000px",width: "7px" },{ className : "hover-body-r" },[
				newnode("img",{},{src: getFullImgSrc("img/dummy.gif") })
			]),
			newnode("div",{ position:"absolute",left : "0px", top:"23px",height: "1000px",width: (imgsizes.l+2)+"px" },{className : "hover-body-l" },[
				newnode("img",{},{src: getFullImgSrc("img/dummy.gif") })
			]),
			newnode("div",{ position: "absolute",top : "0px",left: "0px",width: (imgsizes.tl+"px"), height: ("23px") },{ className : "hover-header-tab-tl_ac" , id : tabnummer+"hover-tabbin-corner-l" },[
				newnode("img",{},{src: getFullImgSrc("img/dummy.gif") })
			]),
			newnode("div",{ position:"absolute",top : "0px",left: "406px",width: "10px",height : "23px"},{ className : "hover-header-tab-tr", id : tabnummer+"hover-tabbin-corner-r" },[
				newnode("img",{},{src: getFullImgSrc("img/dummy.gif") })
			])	

		]),
		newnode("div",{ position: "relative",width: mywidth+"px",height : (borderheight+"px")},{},[
			newnode("div",{ position: "absolute",left : "406px", top:borderheight-imgsizes.b+"px" , width: (imgsizes.br+"px"), height: (imgsizes.b +"px") },{ className : "hover-bottom-br" },[
				newnode("img",{},{src: getFullImgSrc("img/dummy.gif") },[])
			]),
			newnode("div",{ position: "absolute",left : "0px", top: borderheight-imgsizes.b+"px" , width: (imgsizes.bl+"px"), height: (imgsizes.b +"px") },{ className : "hover-bottom-bl" },[
				newnode("img",{},{src: getFullImgSrc("img/dummy.gif") },[])
			]),
			newnode("div",{ position: "absolute",left : "0px", top:"0px" , width: (imgsizes.bl+"px"), height: ((borderheight-imgsizes.b)+"px") },{ className : "hover-bottom-l" },[
				newnode("img",{},{src: getFullImgSrc("img/dummy.gif") },[])
			]),
			newnode("div",{ position: "absolute",left : (innerwidthbottom+imgsizes.bl)+"px", top:"0px" , width: (imgsizes.br+"px"), height: ((borderheight-imgsizes.b)+"px") },{ className : "hover-bottom-r" },[
				newnode("img",{},{src: getFullImgSrc("img/dummy.gif") },[])
			]),
			newnode("div",{ position: "absolute", left: imgsizes.bl+ "px", top: (borderheight-imgsizes.b)+"px", width: "396px" , height: (imgsizes.b)+"px"},{ className : "hover-bottom-b" },[
				newnode("img",{},{src: getFullImgSrc("img/dummy.gif") },[])
			]),
			newnode("div",{ position: "absolute", left: imgsizes.bl+ "px", top: "0px" , width:(innerwidthbottom)+"px" , height: (borderheight-imgsizes.b)+"px"},{ className : "hover-bottom-color" },[
				newnode("img",{},{src: getFullImgSrc("img/dummy.gif") },[])
			])
		])
	]);
	var test = navigator.appVersion.match(/MSIE (\d+\.\d+)/, '');
   	var IE = (test != null && Number(test[1]) >= 5.5);
	if(IE) {
		body.appendChild(coreelement);
		var elementsdiv=coreelement.getElementsByTagName("div");
   		for (i=0; i<elementsdiv.length; i++){
      		var bg = elementsdiv[i].currentStyle.backgroundImage;
      		if (bg) {	
         		if (bg.match(/\.png/i) != null) {
            		var mypng = bg.substring(5,bg.length-2);
            		elementsdiv[i].style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+mypng+"', sizingMethod='scale')";
            		//elementsdiv[i].style.backgroundImage = "url('"+getFullImgSrc("img/dummy.gif")+"')";
					elementsdiv[i].className = "hover_nobackground";
         		}
      		}
   		}
		body.removeChild(coreelement);
	} 
	returnobj.node=coreelement;
	returnobj.header=coreelement.getElementsByTagName("div")[6];
	returnobj.body=coreelement.getElementsByTagName("div")[9];
	returnobj.bottom=coreelement.getElementsByTagName("div")[18];
	return returnobj;
}

/* ################################################################################################# */

function Tabbing(count, tabnummer) {

    this.content;
    this.mousedownactive=false;
    this.selected=0;
    this.tabbingwidth=410;
	this.tabsize = { h : 19, w : 105 };
    this.count=count;
    this.tabnummer = tabnummer;
    
    this.tabbingcontents=new Array();
    for(var i=0;i<count;i++) {
        this.tabbingcontents[i]=new Object();
        this.tabbingcontents[i]["active"]=false;
    }
}

Tabbing.prototype.getDomNode = function(type) {
	switch(type){
		default:
			return this.getDomNodeType1();
	}
}

Tabbing.prototype.setNodeFunctions =function(i,enable,disable,title) {
	if(i>=0 && this.tabbingcontents.length > i) {

		if (this.content.getElementsByTagName("td")[i].firstChild){
			var todelete = this.content.getElementsByTagName("td")[i].firstChild;
			this.content.getElementsByTagName("td")[i].removeChild(todelete);
		}
	
		this.tabbingcontents[i].enable=enable;
		this.tabbingcontents[i].disable=disable;
		this.tabbingcontents[i].title=title;
		title = typeof title == "string" ? document.createTextNode(title) : title;
				
		this.content.getElementsByTagName("td")[i].appendChild(title);
		
		if (i > 0){
			var prevElement = this.content.getElementsByTagName("td")[(i-1)];
			this.content.getElementsByTagName("td")[i]
		}

	}
}

Tabbing.prototype.getDomNodeType1 = function() {
	var Self=this;
	if(this.content) {
		return this.content;
	}

	var tabcounts = [];
	var leftStartPosition;

	for (var i = 0; i < this.tabbingcontents.length; i++){
		tabcounts[i] = newnode("td", { }, { className : "clickable tabbing_tab_inactive" }, []);
	}
	
	tabcounts[tabcounts.length] = newnode("td", { width : "100%" }, { className : "tabbing_border_style" }, [document.createTextNode("\u00a0")]);
	this.content = newnode("tr",{},{},tabcounts);
	addDOMEvent(this.content,"click",function (e) { Self.click(e) });
	
	return this.content;
}

Tabbing.prototype.nodeClicked = function(pos,force,selected,sliderstep) {
	if(!selected) { 
		selected=pos
		this.selected=pos;
	}
	if (this.tabbingcontents[selected]){
		this.selected = selected;
		if(this.tabbingcontents[selected]["active"]) {
			if(force) { this.enableButton();	}
		} else {
			this.enableButton();
		}
	} else {
		this.selected=0;
		this.enableButton();
	}
	
}

Tabbing.prototype.enableButton = function() {
    
	this.tabbingcontents[this.selected]["active"]=true;
	this.content.getElementsByTagName("td")[this.selected].className="tabbing_tab_active";

	
	for(var i=0;i<this.tabbingcontents.length;i++) {
	   if(i!=this.selected) {
	       this.tabbingcontents[i]["active"]=false;
	       this.tabbingcontents[i]["title"].parentNode.className="tabbing_tab_inactive";
	   }
	}

	if (this.selected > 0){
	    this.tabbingcontents[this.selected-1]["title"].parentNode.className="tabbing_tab_inactive_left";
	}


	var test = navigator.appVersion.match(/MSIE (\d+\.\d+)/, '');
   	var IE = (test != null && Number(test[1]) >= 5.5);
	if(IE) {
		
		
		if (this.selected == 0){
			var elementsdiv = document.getElementById(this.tabnummer+"hover-tabbin-corner-l");
			elementsdiv.className="hover-header-tab-tl_ac";
			var bg = elementsdiv.currentStyle.backgroundImage;
			if (bg){
     			if (bg.match(/\.png/i) != null) {
           			var mypng = bg.substring(5,bg.length-2);
           			elementsdiv.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+mypng+"', sizingMethod='scale')";
					elementsdiv.className = "hover_nobackground";
       			}
       		}	
   		} else {
			var elementsdiv = document.getElementById(this.tabnummer+"hover-tabbin-corner-l");
			elementsdiv.className="hover-header-tab-tl";
			var bg = elementsdiv.currentStyle.backgroundImage;
			if (bg){
     			if (bg.match(/\.png/i) != null) {
           			var mypng = bg.substring(5,bg.length-2);
           			elementsdiv.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+mypng+"', sizingMethod='scale')";
					elementsdiv.className = "hover_nobackground";
       			}
       		}  
   		}

	} else {
		if (this.selected == 0){
	    	document.getElementById(this.tabnummer+"hover-tabbin-corner-l").className="hover-header-tab-tl_ac";
		} else {
	    	document.getElementById(this.tabnummer+"hover-tabbin-corner-l").className="hover-header-tab-tl";
		}
	}

    if(this.tabbingcontents[this.selected].enable) {
		this.tabbingcontents[this.selected].enable();
	}
}


Tabbing.prototype.getSelected = function() {
    return this.selected;
}

Tabbing.prototype.click= function(e) {

    var posx=getAbsolutePositionLeft(this.content);
    var fieldposx=e.clientX-posx;
    var opentab;
    
	for(var i=0;i<this.tabbingcontents.length;i++) {
		if (fieldposx > this.tabbingcontents[i]["title"].parentNode.offsetLeft && fieldposx < ( this.tabbingcontents[i]["title"].parentNode.offsetLeft + this.tabbingcontents[i]["title"].parentNode.offsetWidth ) ){
		    opentab = i;
		}
	}

    this.selected = opentab;
    this.nodeClicked(opentab,null);
}
