/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

register("OX_Refresh", initacceptdeny);

function AcceptDenyObject(module,object) {
	this.title=object.title;
	this.location=object.location;
	this.startdate;
	this.enddate;
	this.folder_id=object.folder_id;
	this.created_by=object.created_by;
	this.objectid=object.id;
	this.module=module;
	this.confirmation=-1;
	this.com="";

	if(object.start_date) {
		this.startdate=new Date(object.start_date);
	}
	if(object.end_date) {
		this.enddate=new Date(object.end_date);
	}
	for(var i=0;i<object.users.length;i++) {
		if(object.users[i].id == configGetKey("identifier")) {
			this.confirmation=object.users[i].confirmation;
			this.com=object.users[i].confirmmessage;
		}
	}
}
function AcceptDeny(showdetail) {
	this.showdetail=showdetail;
	this.activeobject;
	var Self=this;
	this.acceptdeny_accept = function () {
		Self.removeDomEvents();
		if(Self.showdetail) { acceptdeny_updateConfirm(Self.activeobject,1,$("acceptdeny_comment").value); }
		else { acceptdeny_updateConfirm(Self.activeobject,1,$("acceptdeny_comment2").value); }
	};
	this.acceptdeny_decline = function () {
		Self.removeDomEvents();
		if(Self.showdetail) { acceptdeny_updateConfirm(Self.activeobject,2,$("acceptdeny_comment").value); }
		else { acceptdeny_updateConfirm(Self.activeobject,2,$("acceptdeny_comment2").value); }

	};
	this.acceptdeny_tentiative = function () {
		Self.removeDomEvents();
		if(Self.showdetail) { acceptdeny_updateConfirm(Self.activeobject,3,$("acceptdeny_comment").value); }
		else { acceptdeny_updateConfirm(Self.activeobject,3,$("acceptdeny_comment2").value); }

	};
	this.acceptdeny_later = function () {
		Self.acceptdeny_close();
		
		triggerEvent("OX_Next_Confirm");		
	};
	this.acceptdeny_close = function () {
		Self.removeDomEvents();
		hideNode("acceptdeny_object");
		$("acceptdeny_object").style.display="none";
		hideNode("disable_background_window");
		$("disable_background_window").style.display="none";
		
	};
	this.addDomEvents = function () {
		addOnClose($("acceptdeny_object"),Self.acceptdeny_close);
		addDOMEvent($("acceptdeny_accept"), "click", Self.acceptdeny_accept);
		addDOMEvent($("acceptdeny_decline"), "click", Self.acceptdeny_decline);
		addDOMEvent($("acceptdeny_tentiative"), "click", Self.acceptdeny_tentiative);
		addDOMEvent($("acceptdeny_later"), "click", Self.acceptdeny_later);
	};
	this.removeDomEvents = function () {	
		removeOnClose($("acceptdeny_object"),Self.removeDomEvents);
		removeDOMEvent($("acceptdeny_accept"), "click", Self.acceptdeny_accept);
		removeDOMEvent($("acceptdeny_decline"), "click", Self.acceptdeny_decline);
		removeDOMEvent($("acceptdeny_tentiative"), "click", Self.acceptdeny_tentiative);
		removeDOMEvent($("acceptdeny_later"), "click", Self.acceptdeny_later);	
	};
}
AcceptDeny.prototype = {
	changeConfirm : function(acceptdenyobjectarray) {
		this.activeobject=acceptdenyobjectarray;
		$("acceptdeny_detail").style.display="none";
		$("acceptdeny_nodetail").style.display="";
		var alltds=$("acceptdeny_status").getElementsByTagName("td");
		$("acceptdeny_notnew").style.display="none";
		$("acceptdeny_comment").value="";
		$("acceptdeny_comment2").value="";
		if(acceptdenyobjectarray && acceptdenyobjectarray.length == 1 && acceptdenyobjectarray[0].com) {
			$("acceptdeny_comment2").value=acceptdenyobjectarray[0].com;
		}
		showNode("disable_background_window");
		$("disable_background_window").style.display="block";
		showNode("acceptdeny_object");
		centerPopupWindow($("acceptdeny_object"));
		$("acceptdeny_object").style.display="block";
		this.addDomEvents();
		
	},
	showConfirmation : function (acceptdenyobject) {
		this.activeobject=acceptdenyobject;
		if(!this.showdetail) {
			$("acceptdeny_detail").style.display="none";
			$("acceptdeny_nodetail").style.display="";
		}
		else {
			$("acceptdeny_detail").style.display="";
			$("acceptdeny_nodetail").style.display="none";
			var alltrs=$("acceptdeny_detail").getElementsByTagName("tr");
			if(acceptdenyobject.module=="tasks") {
				alltrs[0].getElementsByTagName("td")[0].style.display="none";
				alltrs[0].getElementsByTagName("td")[1].style.display="";
				alltrs[2].style.display="none";
				
			}
			else if(acceptdenyobject.module=="calendar") {
				alltrs[0].getElementsByTagName("td")[0].style.display="";
				alltrs[0].getElementsByTagName("td")[1].style.display="none";
				alltrs[2].style.display="";
			}
			else {
				alltrs[0].getElementsByTagName("td")[0].style.display="none";
				alltrs[0].getElementsByTagName("td")[1].style.display="none";
			}
			if(acceptdenyobject.title) {
				alltrs[1].getElementsByTagName("td")[1].firstChild.nodeValue=acceptdenyobject.title;
			}
			else {
				alltrs[1].getElementsByTagName("td")[1].firstChild.nodeValue="";
			}
			if(acceptdenyobject.location) {
				alltrs[2].getElementsByTagName("td")[1].firstChild.nodeValue=acceptdenyobject.location;
			}
			else {
				alltrs[2].getElementsByTagName("td")[1].firstChild.nodeValue="";
			}
            if (this.startDateNode) {
                this.startDateNode.value = acceptdenyobject.startdate
                    ? new Date(acceptdenyobject.startdate) : null;
                this.startDateNode.update();
            } else {
                this.startDateNode = new I18nNode(function() {
                    return this.value ? formatDate(this.value, "datetime") : "";
                }, { value: acceptdenyobject.startdate ? new Date(acceptdenyobject.startdate) : null });
                var parent = alltrs[3].getElementsByTagName("td")[1];
                parent.replaceChild(this.startDateNode.node, parent.firstChild);
            }
            if (this.endDateNode) {
                this.endDateNode.value = acceptdenyobject.enddate
                    ? new Date(acceptdenyobject.enddate) : null;
                this.endDateNode.update();
            } else {
                this.endDateNode = new I18nNode(function() {
                    return this.value ? formatDate(this.value, "datetime") : "";
                }, { value: acceptdenyobject.enddate ? new Date(acceptdenyobject.enddate) : null });
                var parent = alltrs[4].getElementsByTagName("td")[1];
                parent.replaceChild(this.endDateNode.node, parent.firstChild);
            }
			if(acceptdenyobject.folder_id) {
				alltrs[5].getElementsByTagName("td")[1].firstChild.nodeValue="Loading...";
				function doresponse1(path) {
					$("acceptdeny_detail").getElementsByTagName("tr")[5].getElementsByTagName("td")[1].firstChild.nodeValue=path;
				}
				oMainFolderTree.get_folder_path(acceptdenyobject.folder_id,doresponse1);
			} else {
				alltrs[5].getElementsByTagName("td")[1].firstChild.nodeValue="";
			}
			if(acceptdenyobject.created_by) {
				alltrs[6].getElementsByTagName("td")[1].firstChild.nodeValue="Loading...";
				function doresponse2(response) {
					if(response && response[acceptdenyobject.created_by]) {
						$("acceptdeny_detail").getElementsByTagName("tr")[6].getElementsByTagName("td")[1].firstChild.nodeValue=response[acceptdenyobject.created_by].display_name;
					} else {
						$("acceptdeny_detail").getElementsByTagName("tr")[6].getElementsByTagName("td")[1].firstChild.nodeValue="";
					}
				}
				internalCache.getUsers([acceptdenyobject.created_by],doresponse2);			
			}
		}
		var alltds=$("acceptdeny_status").getElementsByTagName("td");
		for(var i=1;i<alltds.length;i++) {
			if(i==(acceptdenyobject.confirmation+1)) {
				alltds[i].style.display="";
			}
			else {
				alltds[i].style.display="none";
			}
		}
		if(acceptdenyobject.confirmation!=0) {
			$("acceptdeny_notnew").style.display="none";
		} else {
			$("acceptdeny_notnew").style.display="";
		}
		if(acceptdenyobject.com) {
			$("acceptdeny_comment").value=acceptdenyobject.com;
		}
		else {
			$("acceptdeny_comment").value="";
		}
		showNode("disable_background_window");
		$("disable_background_window").style.display="block";
		showNode("acceptdeny_object");
		centerPopupWindow($("acceptdeny_object"));
		$("acceptdeny_object").style.display="block";
		this.addDomEvents();
	}
}

function acceptdeny_updateConfirm(acceptdenyobject,confirmstatus,confirmmessage) {	
	if (acceptdenyobject.constructor == Array) {
		var myJoin = new Join(function() { });
		var requests=new Array();
		
		for (var i=0;i<acceptdenyobject.length;i++) {
			var realobject=acceptdenyobject[i];			
			// need to get folder owner if it's a shared folder
	    	oMainFolderTree.cache.get_folder(acceptdenyobject[i].folder_id, 
    			(myJoin.add(function(folder) {
    				var owner = folder.oxfolder.data.type == 3 ? folder.oxfolder.data.created_by : configGetKey("identifier");					
					var requestObject=new Object();
					requestObject["module"] = realobject.module;
					requestObject["action"] = "confirm";
					requestObject["folder"] = acceptdenyobject[i].folder_id;
					requestObject["id"] = acceptdenyobject[i].objectid;
					requestObject["data"]= new Object();
					requestObject["data"]["confirmmessage"] = confirmmessage;
					requestObject["data"]["confirmation"] = confirmstatus;
					if (owner != configGetKey("identifier")) {
						requestObject["data"]["id"] = owner;
					}
					requests.push(requestObject);
		    	}))
			);
		}
		
		myJoin.add((function(requests) {
			json.put(AjaxRoot + "/multiple?session=" + session,requests,null,		
				function(resp) {
					//TODO CHECK ERRORS
					hideNode("acceptdeny_object");
					$("acceptdeny_object").style.display="none";
					hideNode("disable_background_window");
					$("disable_background_window").style.display="none";
					acceptdeny_update_objects_in_cache(requests, acceptdeny_get_timestamp(resp));			
					triggerEvent("OX_AcceptDeny_Changed");
				}
			)		
		})(requests));
		
	} else {
		
        // need to get folder owner if it's a shared folder
    	oMainFolderTree.cache.get_folder(acceptdenyobject.folder_id, function(folder) {
    		var requests=new Array();
            var requestObject=new Object();
    		
    		var owner = folder.oxfolder.data.type == 3 ? folder.oxfolder.data.created_by : configGetKey("identifier");
	        requestObject["module"] = acceptdenyobject.module;
	        requestObject["action"] = 'confirm';
	        requestObject["folder"] = acceptdenyobject.folder_id;
	        requestObject["id"] = acceptdenyobject.objectid;
	        requestObject["data"]= new Object();        
	        requestObject["data"]["confirmmessage"] = confirmmessage;
	        requestObject["data"]["confirmation"] = confirmstatus;
	        requests.push(requestObject);
	        
	        json.put(AjaxRoot + "/multiple?session=" + session, requests, null, function(reply) { 
	            if (!reply.error) { 
	                hideNode("acceptdeny_object");
	                $("acceptdeny_object").style.display="none";
	                hideNode("disable_background_window");
	                $("disable_background_window").style.display="none";
	                triggerEvent("OX_AcceptDeny_Changed");
	                acceptdeny_update_objects_in_cache(requests, acceptdeny_get_timestamp(reply));
	            }
	            triggerEvent("OX_Next_Confirm");
	        }, function(reply) {
	            if (reply.error) { 
	                hideNode("acceptdeny_object");
	                $("acceptdeny_object").style.display="none";
	                hideNode("disable_background_window");
	                $("disable_background_window").style.display="none";
	                triggerEvent("OX_AcceptDeny_Changed");
	                acceptdeny_update_objects_in_cache(requests, acceptdeny_get_timestamp(reply));
	            }
	            triggerEvent("OX_Next_Confirm");
	        });
    	});
	}
}

function acceptdeny_update_objects_in_cache(objects, timestamp) {
    for (var i in objects) {
        var object = objects[i];
        if (object.module == "calendar") {
        	if (storageCache && storageCache.current != null) storageCache.update();
        	else lastUpdateOfCalendarTimestamp = timestamp;
        	continue; // not implemented right now
        }
    	// need to get folder owner if it's a shared folder
    	oMainFolderTree.cache.get_folder(object.data.folder_id, function(folder) {
    		var owner = folder.oxfolder.data.type == 3 ? folder.oxfolder.data.created_by : configGetKey("identifier");
    		OXCache.moduleMappings[object.module].editObjects(
                  [ { "module": object.module, "folder_id": object.data.folder_id, "id": object.data.id } ],
                  { "users": 
                    [{ "confirmation": object.data.confirmation,
                       "confirmmessage": object.data.confirmmessage,
                       "id": owner 
                    }],
                    "timestamp": timestamp
                  }
            );
    	});
    }
}

register("OX_Configuration_Loaded_Complete",initacceptdeny);
function initacceptdeny() {
	acceptdeny_start();
}

function acceptdeny_start() {	
	function acceptdeny_fillCalendar(response) 
	{
		var conarray=new Array();
		var constrings=new Object();
		contimestamp=response.timestamp;
		if(!response.data) {
			return;
		}
		response=response.data;
		for(var i=0;i<response.length;i++) {
			var newobject=new Object();
			newobject.id=response[i][0];
			newobject.folder_id=response[i][1];	
			newobject.start_date=response[i][2];
			newobject.end_date=response[i][3];
			newobject.users=response[i][5];
			newobject.title=response[i][6];
			newobject.created_by=response[i][7];	
			newobject.location=response[i][8];


			for(var i2=0;i2<newobject.users.length;i2++) {
				if(newobject.users[i2].id == configGetKey("identifier")) {
					this.confirmation=newobject.users[i2].confirmation;
					if(confirmation==0) {
						if(!constrings[newobject.folder_id+":"+newobject.id]) {
							constrings[newobject.folder_id+":"+newobject.id]=true;
							conarray.push(newobject);		
						}
					}
					break;
				}
			}
		}	
		showAllConfirmation(conarray);
	}
	function acceptdeny_fillTasks(response) {
	}
	var checkconfirmation=true;
	var calendarstring;
	var columns="1,20,201,202,209,221,200,2"
	var taskstring;
	var confirmtimestamp=0;
	if(configContainsKey("gui.global.confirmpopup")) {
		checkconfirmation=configGetKey("gui.global.confirmpopup")
	}
	if(configContainsKey("gui.global.confirmtimestamp")) {
		confirmtimestamp=configGetKey("gui.global.confirmtimestamp")
	}
	if(checkconfirmation) {
		calendarstring=AjaxRoot + "/calendar?action=updates&session="+session+"&start="+(new Date().getTime())+"&end="+(new Date().getTime()+360000*24*365*5)+"&timestamp="+confirmtimestamp+"&ignore=deleted&columns="+columns+",400";
		taskstring=AjaxRoot + "/tasks?action=updates&session="+session+"&start="+(new Date().getTime())+"&end="+(new Date().getTime()+360000*24*365*5)+"&timestamp="+confirmtimestamp+"&ignore=deleted&columns="+columns;
		var json=new JSON();
		if(configGetKey("modules.calendar.module"))
			json.get(calendarstring,null,acceptdeny_fillCalendar);
	}
}
var globalconfirm= new AcceptDeny(true);
var confirm_array=new Array();
var confirm_zaehler= -1;
var contimestamp;
register("OX_Next_Confirm",function() { nextConfirmation(); });

function nextConfirmation () {
	confirm_zaehler++;
	if(this.confirm_zaehler<this.confirm_array.length) {
		globalconfirm.showConfirmation(new AcceptDenyObject("calendar",confirm_array[confirm_zaehler]));
	}
	else {
		confirm_array=new Array();
		confirm_zaehler=-1;
		if(contimestamp && contimestamp > 0) { configSetKey("gui.global.confirmtimestamp",contimestamp); }
		//triggerEvent("OX_Save_Configuration",true,true);
	}
}
function showAllConfirmation(acceptdenyarray) {
	confirm_array = acceptdenyarray;
	confirm_zaehler=-1;
	triggerEvent("OX_Next_Confirm");
}
fileloaded();