/*
 * $Id: CategoriesTest.java,v 1.2 2007/04/14 06:24:53 fortuna Exp $
 *
 * Created on 17/03/2007
 *
 * Copyright (c) 2007, Ben Fortuna
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  o Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 *  o Neither the name of Ben Fortuna nor the names of any other contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.fortuna.ical4j.model.property;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

import junit.framework.TestCase;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.util.Calendars;

/**
 * Unit testing for {@link Categories}.
 * @author Ben Fortuna
 *
 */
public class CategoriesTest extends TestCase {

    /**
     * Test construction of category list.
     */
    public void testCategoryList() {
        String list = "one,two,three";
        Categories categories = new Categories(list);
        assertEquals(list, categories.getCategories().toString());
    }
    
    /**
     * Test escaping of categories string representation.
     */
    public void testStringEscaping() throws ParserException, IOException,
        ValidationException {
        
        Calendar calendar = Calendars.load("etc/samples/valid/categories.ics");
        
        Categories orig = (Categories) calendar.getComponent(
                Component.VEVENT).getProperty(Property.CATEGORIES);
        
        StringWriter tempOut = new StringWriter();
        CalendarOutputter cout = new CalendarOutputter();
        cout.output(calendar, tempOut);
        
        CalendarBuilder builder = new CalendarBuilder();
        calendar = builder.build(new StringReader(tempOut.getBuffer().toString()));
        
        Categories copy = (Categories) calendar.getComponent(
                Component.VEVENT).getProperty(Property.CATEGORIES);
        
        assertEquals(orig, copy);
    }
}
