/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONString;
import org.json.JSONTokener;
import org.json.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONObject
implements JSONValue {
    private static final String STR_TRUE = "true";
    private static final String STR_FALSE = "false";
    private static final String STR_NULL = "null";
    private final Map<String, Object> myHashMap;
    public static final Object NULL = new Null();
    private static final String STR_ERR01 = "JSONObject[";

    public JSONObject() {
        this.myHashMap = new HashMap<String, Object>();
    }

    public JSONObject(JSONObject jo, String[] sa) throws JSONException {
        this();
        for (int i = 0; i < sa.length; ++i) {
            this.putOpt(sa[i], jo.opt(sa[i]));
        }
    }

    public JSONObject(JSONTokener x) throws JSONException {
        this();
        this.parseJSONTokener(x);
    }

    private final void parseJSONTokener(JSONTokener tokener) throws JSONException {
        if (tokener.nextClean() != '{') {
            throw tokener.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = tokener.nextClean();
            switch (c) {
                case '\u0000': {
                    throw tokener.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            tokener.back();
            String key = tokener.nextValue().toString();
            c = tokener.nextClean();
            if (c == '=') {
                if (tokener.next() != '>') {
                    tokener.back();
                }
            } else if (c != ':') {
                throw tokener.syntaxError("Expected a ':' after a key");
            }
            this.put(key, tokener.nextValue());
            switch (tokener.nextClean()) {
                case ',': 
                case ';': {
                    if (tokener.nextClean() == '}') {
                        return;
                    }
                    tokener.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw tokener.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Map<String, ? extends Object> map) {
        this.myHashMap = map == null ? new HashMap<String, Object>() : new HashMap<String, Object>(map);
    }

    public JSONObject(Object object, String[] names) {
        this();
        Class<?> c = object.getClass();
        for (int i = 0; i < names.length; ++i) {
            try {
                String name = names[i];
                Field field = c.getField(name);
                Object value = field.get(object);
                this.put(name, value);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public JSONObject(String string) throws JSONException {
        this(new JSONTokener(string));
    }

    public JSONObject parseJSONString(String string) throws JSONException {
        this.parseJSONTokener(new JSONTokener(string));
        return this;
    }

    public JSONObject accumulate(String key, Object value) throws JSONException {
        JSONObject.testValidity(value);
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, value instanceof JSONArray ? new JSONArray().put(value) : value);
        } else if (o instanceof JSONArray) {
            ((JSONArray)o).put(value);
        } else {
            this.put(key, new JSONArray().put(o).put(value));
        }
        return this;
    }

    public JSONObject append(String key, Object value) throws JSONException {
        JSONObject.testValidity(value);
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, new JSONArray().put(value));
        } else if (o instanceof JSONArray) {
            this.put(key, ((JSONArray)o).put(value));
        } else {
            throw new JSONException(STR_ERR01 + key + "] is not a JSONArray.");
        }
        return this;
    }

    @Override
    public void reset() {
        this.myHashMap.clear();
    }

    public static final String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return STR_NULL;
        }
        String s = Double.toString(d);
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public Object get(String key) throws JSONException {
        Object o = this.opt(key);
        if (o == null) {
            throw new JSONException(STR_ERR01 + JSONObject.quote(key) + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(String key) throws JSONException {
        Object o = this.get(key);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase(STR_FALSE)) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase(STR_TRUE)) {
            return true;
        }
        throw new JSONException(STR_ERR01 + JSONObject.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) throws JSONException {
        Object o = this.get(key);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.parseDouble((String)o);
        }
        catch (Exception e) {
            throw new JSONException(STR_ERR01 + JSONObject.quote(key) + "] is not a number.");
        }
    }

    public int getInt(String key) throws JSONException {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(key);
    }

    public JSONArray getJSONArray(String key) throws JSONException {
        Object o = this.get(key);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new JSONException(STR_ERR01 + JSONObject.quote(key) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key) throws JSONException {
        Object o = this.get(key);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new JSONException(STR_ERR01 + JSONObject.quote(key) + "] is not a JSONObject.");
    }

    public long getLong(String key) throws JSONException {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(key);
    }

    public String getString(String key) throws JSONException {
        return this.get(key).toString();
    }

    public boolean has(String key) {
        return this.myHashMap.containsKey(key);
    }

    public boolean hasAndNotNull(String key) {
        return this.has(key) && !this.isNull(key);
    }

    public boolean isNull(String key) {
        return NULL.equals(this.opt(key));
    }

    public Iterator<String> keys() {
        return this.myHashMap.keySet().iterator();
    }

    public Set<String> keySet() {
        return this.myHashMap.keySet();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.myHashMap.entrySet();
    }

    @Override
    public int length() {
        return this.myHashMap.size();
    }

    public JSONArray names() {
        JSONArray ja = new JSONArray();
        Set<String> keys = this.keySet();
        for (String name : keys) {
            ja.put(name);
        }
        return ja.length() == 0 ? null : ja;
    }

    public static final String numberToString(Number n) throws JSONException {
        if (n == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(n);
        String s = n.toString();
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public Object opt(String key) {
        return key == null ? null : this.myHashMap.get(key);
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONObject put(String key, Collection<? extends Object> value) throws JSONException {
        this.put(key, new JSONArray(value));
        return this;
    }

    public double optDouble(String key) {
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        try {
            Object o = this.opt(key);
            return o instanceof Number ? ((Number)o).doubleValue() : new Double((String)o).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(String key) {
        Object o = this.opt(key);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(String key) {
        Object o = this.opt(key);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(String key) {
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        try {
            return this.getLong(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(String key) {
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        Object o = this.opt(key);
        return o != null ? o.toString() : defaultValue;
    }

    public JSONObject put(String key, boolean value) throws JSONException {
        this.put(key, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONObject put(String key, double value) throws JSONException {
        this.put(key, (Object)value);
        return this;
    }

    public JSONObject put(String key, int value) throws JSONException {
        this.put(key, (Object)value);
        return this;
    }

    public JSONObject put(String key, long value) throws JSONException {
        this.put(key, (Object)value);
        return this;
    }

    public JSONObject put(String key, Map<String, ? extends Object> value) throws JSONException {
        this.put(key, new JSONObject(value));
        return this;
    }

    public JSONObject put(String key, Object value) throws JSONException {
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (value != null) {
            JSONObject.testValidity(value);
            this.myHashMap.put(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    public JSONObject putOpt(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    public static final String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public Object remove(String key) {
        return this.myHashMap.remove(key);
    }

    static final void testValidity(Object o) throws JSONException {
        Float f;
        Double d;
        if (o != null && (o instanceof Double ? (d = (Double)o).isInfinite() || d.isNaN() : o instanceof Float && ((f = (Float)o).isInfinite() || f.isNaN()))) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    public JSONArray toJSONArray(JSONArray names) throws JSONException {
        if (names == null || names.length() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (int i = 0; i < names.length(); ++i) {
            ja.put(this.opt(names.getString(i)));
        }
        return ja;
    }

    public String toString() {
        try {
            int n = this.length();
            if (n <= 0) {
                return "{}";
            }
            StringBuilder sb = new StringBuilder(n * 16).append('{');
            Iterator<Map.Entry<String, Object>> iter = this.myHashMap.entrySet().iterator();
            Map.Entry<String, Object> first = iter.next();
            sb.append(JSONObject.quote(first.getKey()));
            sb.append(':');
            sb.append(JSONObject.valueToString(first.getValue()));
            for (int i = 1; i < n; ++i) {
                Map.Entry<String, Object> next = iter.next();
                sb.append(',');
                sb.append(JSONObject.quote(next.getKey()));
                sb.append(':');
                sb.append(JSONObject.valueToString(next.getValue()));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) throws JSONException {
        return this.toString(indentFactor, 0);
    }

    @Override
    public String toString(int indentFactor, int indent) throws JSONException {
        int n = this.length();
        if (n == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder().append('{');
        int newindent = indent + indentFactor;
        if (n == 1) {
            Iterator<String> keys = this.keys();
            String o = keys.next();
            sb.append(JSONObject.quote(o));
            sb.append(": ");
            sb.append(JSONObject.valueToString(this.myHashMap.get(o), indentFactor, indent));
        } else {
            Set<String> keys = this.keySet();
            for (String o : keys) {
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (int i = 0; i < newindent; ++i) {
                    sb.append(' ');
                }
                sb.append(JSONObject.quote(o));
                sb.append(": ");
                sb.append(JSONObject.valueToString(this.myHashMap.get(o), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (int i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
        }
        sb.append('}');
        return sb.toString();
    }

    static final String valueToString(Object value) throws JSONException {
        if (value == null || NULL.equals(value)) {
            return STR_NULL;
        }
        if (value instanceof JSONString) {
            String o;
            try {
                o = ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            if (o instanceof String) {
                return o;
            }
            throw new JSONException("Bad value from toJSONString: " + o);
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONValue) {
            return value.toString();
        }
        return JSONObject.quote(value.toString());
    }

    static final String valueToString(Object value, int indentFactor, int indent) throws JSONException {
        if (value == null || NULL.equals(value)) {
            return STR_NULL;
        }
        try {
            String o;
            if (value instanceof JSONString && (o = ((JSONString)value).toJSONString()) instanceof String) {
                return o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONValue) {
            return ((JSONValue)value).toString(indentFactor, indent);
        }
        return JSONObject.quote(value.toString());
    }

    @Override
    public Writer write(Writer writer) throws JSONException {
        try {
            writer.write(123);
            int len = this.myHashMap.size();
            if (len > 0) {
                Iterator<Map.Entry<String, Object>> iter = this.myHashMap.entrySet().iterator();
                JSONObject.writeValue(writer, iter.next());
                for (int i = 1; i < len; ++i) {
                    writer.write(44);
                    JSONObject.writeValue(writer, iter.next());
                }
            }
            writer.write(125);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    private static void writeValue(Writer writer, Map.Entry<String, Object> entry) throws IOException, JSONException {
        writer.write(JSONObject.quote(entry.getKey()));
        writer.write(58);
        Object v = entry.getValue();
        if (v instanceof JSONValue) {
            ((JSONValue)v).write(writer);
        } else {
            writer.write(JSONObject.valueToString(v));
        }
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    private static final class Null
    implements Cloneable {
        protected Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return JSONObject.STR_NULL;
        }
    }
}

