/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.corba.idl.parser;

import antlr.ASTVisitor;
import antlr.collections.AST;
import java.util.Map;
import org.apache.axis2.corba.idl.types.AbstractCollectionType;
import org.apache.axis2.corba.idl.types.ArrayType;
import org.apache.axis2.corba.idl.types.DataType;
import org.apache.axis2.corba.idl.types.EnumType;
import org.apache.axis2.corba.idl.types.ExceptionType;
import org.apache.axis2.corba.idl.types.IDL;
import org.apache.axis2.corba.idl.types.Interface;
import org.apache.axis2.corba.idl.types.Member;
import org.apache.axis2.corba.idl.types.Operation;
import org.apache.axis2.corba.idl.types.PrimitiveDataType;
import org.apache.axis2.corba.idl.types.SequenceType;
import org.apache.axis2.corba.idl.types.Struct;
import org.apache.axis2.corba.idl.types.Typedef;
import org.apache.axis2.corba.idl.types.UnionMember;
import org.apache.axis2.corba.idl.types.UnionType;
import org.apache.axis2.corba.idl.types.ValueType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IDLVisitor
implements ASTVisitor {
    private static final Log log = LogFactory.getLog((Class)IDLVisitor.class);
    private IDL idl = null;
    private String module = "";
    private String moduleForInnerTypes = null;
    private static final String INNERTYPE_SUFFIX = "Package";

    public IDL getIDL() {
        return this.idl;
    }

    public void visit(AST node) {
        this.idl = new IDL();
        while (node != null) {
            switch (node.getType()) {
                case 7: {
                    this.idl.addInterface(this.visitInterface(node));
                    break;
                }
                case 11: {
                    AST moduleName = node.getFirstChild();
                    IDLVisitor moduleVisitor = new IDLVisitor();
                    moduleVisitor.setModule(this.module + moduleName);
                    moduleVisitor.visit(moduleName.getNextSibling());
                    this.idl.addIDL(moduleVisitor.getIDL());
                    break;
                }
                case 55: {
                    this.idl.addType(this.visitStruct(node));
                    break;
                }
                case 9: {
                    this.idl.addType(this.visitValueType(node));
                    break;
                }
                case 68: {
                    this.idl.addType(this.visitException(node));
                    break;
                }
                case 60: {
                    this.idl.addType(this.visitEnum(node));
                    break;
                }
                case 56: {
                    this.idl.addType(this.visitUnion(node));
                    break;
                }
                case 42: {
                    this.visitAndAddTypedefs(node, this.module);
                    break;
                }
                default: {
                    log.error((Object)("Unsupported IDL token " + node));
                }
            }
            node = node.getNextSibling();
        }
    }

    private Struct visitStruct(AST node) {
        AST structNode = node.getFirstChild();
        String structName = structNode.toString();
        Struct struct = new Struct();
        struct.setModule(this.module);
        struct.setName(structName);
        AST memberTypeNode = structNode.getNextSibling();
        while (memberTypeNode != null) {
            Member member = new Member();
            DataType dataType = this.findDataType(memberTypeNode);
            AST memberNode = memberTypeNode.getNextSibling();
            String memberName = memberNode.getText();
            int dimensions = memberNode.getNumberOfChildren();
            if (dimensions > 0) {
                AbstractCollectionType arrayType = null;
                ArrayType rootArrayType = null;
                int i = 1;
                for (AST dimensionNode = memberNode.getFirstChild(); dimensionNode != null; dimensionNode = dimensionNode.getNextSibling()) {
                    ArrayType temp = new ArrayType();
                    temp.setElementModule(this.module);
                    temp.setElementName(memberName);
                    temp.setDepth(i);
                    ++i;
                    if (arrayType != null) {
                        arrayType.setDataType(temp);
                    } else {
                        rootArrayType = temp;
                    }
                    arrayType = temp;
                    arrayType.setElementCount(Integer.parseInt(dimensionNode.getText()));
                }
                if (arrayType != null) {
                    arrayType.setDataType(dataType);
                }
                dataType = rootArrayType;
            }
            member.setDataType(dataType);
            member.setName(memberName);
            struct.addMember(member);
            memberTypeNode = memberNode.getNextSibling();
        }
        return struct;
    }

    private ValueType visitValueType(AST node) {
        AST valueNode = node.getFirstChild();
        ValueType value = new ValueType();
        value.setModule(this.module);
        value.setName(valueNode.toString());
        AST memberModifierNode = valueNode.getNextSibling();
        while (memberModifierNode != null) {
            String memberModifierName = memberModifierNode.toString();
            if (!memberModifierName.equals("private") && !memberModifierName.equals("public")) {
                if (14 == memberModifierNode.getType()) {
                    String[] pragma;
                    if (memberModifierName.startsWith("pragma ID ") && (pragma = (memberModifierName = memberModifierName.substring(10)).split(" ")).length == 2 && pragma[0] != null && pragma[1] != null && pragma[0].equals(value.getName())) {
                        pragma[1] = pragma[1].replace('\"', ' ');
                        value.setId(pragma[1].trim());
                    }
                } else {
                    value.addOperation(this.visitOperation(memberModifierNode));
                }
                memberModifierNode = memberModifierNode.getNextSibling();
                continue;
            }
            Member memberType = new Member();
            memberType.setModifier(memberModifierName);
            AST memberTypeNode = memberModifierNode.getNextSibling();
            memberType.setDataType(this.findDataType(memberTypeNode));
            AST memberNode = memberTypeNode.getNextSibling();
            memberType.setName(memberNode.toString());
            value.addMember(memberType);
            memberModifierNode = memberNode.getNextSibling();
        }
        return value;
    }

    private Interface visitInterface(AST node) {
        Interface intf = new Interface();
        intf.setModule(this.module);
        AST interfaceNode = node.getFirstChild();
        String interfaceName = interfaceNode.toString();
        intf.setName(interfaceName);
        this.moduleForInnerTypes = this.module + interfaceName + INNERTYPE_SUFFIX + "::";
        block10: for (AST node2 = interfaceNode.getNextSibling(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getType()) {
                case 55: {
                    Struct innerStruct = this.visitStruct(node2);
                    innerStruct.setModule(this.moduleForInnerTypes);
                    this.idl.addType(innerStruct);
                    continue block10;
                }
                case 9: {
                    log.error((Object)("Unsupported IDL token " + node2));
                    continue block10;
                }
                case 68: {
                    ExceptionType innerEx = this.visitException(node2);
                    innerEx.setModule(this.moduleForInnerTypes);
                    this.idl.addType(innerEx);
                    continue block10;
                }
                case 60: {
                    EnumType innerEnum = this.visitEnum(node2);
                    innerEnum.setModule(this.moduleForInnerTypes);
                    this.idl.addType(innerEnum);
                    continue block10;
                }
                case 56: {
                    UnionType innerUnion = this.visitUnion(node2);
                    innerUnion.setModule(this.moduleForInnerTypes);
                    this.idl.addType(innerUnion);
                    continue block10;
                }
                case 42: {
                    this.visitAndAddTypedefs(node2, this.moduleForInnerTypes);
                    continue block10;
                }
                case 27: {
                    log.error((Object)("Unsupported IDL token " + node2));
                    continue block10;
                }
                case 81: {
                    intf.addOperation(this.visitGetAttribute(node2));
                    intf.addOperation(this.visitSetAttribute(node2));
                    continue block10;
                }
                default: {
                    if (node2.toString().startsWith("pragma ID ")) {
                        String pragmaId = node2.toString().substring(10);
                        String[] pragma = pragmaId.split(" ");
                        if (pragma.length != 2 || pragma[0] == null || pragma[1] == null || !pragma[0].equals(intf.getName())) continue block10;
                        pragma[1] = pragma[1].replace('\"', ' ');
                        intf.setId(pragma[1].trim());
                        continue block10;
                    }
                    intf.addOperation(this.visitOperation(node2));
                }
            }
        }
        this.moduleForInnerTypes = null;
        return intf;
    }

    private Operation visitGetAttribute(AST node) {
        Operation operation = new Operation();
        AST type = node.getFirstChild();
        operation.setReturnType(this.findDataType(type));
        AST name = type.getNextSibling();
        operation.setName("_get_" + name.toString());
        return operation;
    }

    private Operation visitSetAttribute(AST node) {
        Operation operation = new Operation();
        AST type = node.getFirstChild();
        operation.setReturnType(PrimitiveDataType.getPrimitiveDataType("void"));
        AST name = type.getNextSibling();
        String attrName = name.toString();
        operation.setName("_set_" + attrName);
        Member param = new Member();
        param.setName(attrName);
        param.setDataType(this.findDataType(type));
        operation.addParam(param);
        return operation;
    }

    private Operation visitOperation(AST node) {
        Operation operation = new Operation();
        operation.setName(node.toString());
        AST type = node.getFirstChild();
        operation.setReturnType(this.findDataType(type));
        for (AST mode = type.getNextSibling(); mode != null; mode = mode.getNextSibling()) {
            if (73 == mode.getType()) {
                for (AST idlType = mode.getFirstChild(); idlType != null; idlType = idlType.getNextSibling()) {
                    operation.addRaises((ExceptionType)this.findDataType(idlType));
                }
                continue;
            }
            Member param = new Member();
            param.setMode(mode.toString());
            AST idlType = mode.getFirstChild();
            param.setDataType(this.findDataType(idlType));
            AST paramName = idlType.getNextSibling();
            param.setName(paramName.toString());
            operation.addParam(param);
        }
        return operation;
    }

    private ExceptionType visitException(AST node) {
        ExceptionType raisesType = new ExceptionType();
        AST exNode = node.getFirstChild();
        String exName = exNode.toString();
        raisesType.setModule(this.module);
        raisesType.setName(exName);
        AST memberTypeNode = exNode.getNextSibling();
        while (memberTypeNode != null) {
            Member member = new Member();
            member.setDataType(this.findDataType(memberTypeNode));
            AST memberNode = memberTypeNode.getNextSibling();
            member.setName(memberNode.toString());
            raisesType.addMember(member);
            memberTypeNode = memberNode.getNextSibling();
        }
        return raisesType;
    }

    private DataType findDataType(AST typeNode) {
        return this.findDataType(typeNode, true);
    }

    private DataType findDataType(AST typeNode, boolean root) {
        if (typeNode.getType() == 61) {
            return this.visitAnonymousSequence(typeNode, root);
        }
        DataType dataType = null;
        Map compositeDataTypes = this.idl.getCompositeDataTypes();
        String typeName = this.getTypeName(typeNode);
        if (compositeDataTypes != null) {
            if (!this.module.equals("") && !typeName.startsWith(this.module)) {
                dataType = (DataType)this.idl.getCompositeDataTypes().get(this.module + typeName);
            }
            if (dataType == null && this.moduleForInnerTypes != null && !typeName.startsWith(this.module)) {
                dataType = (DataType)this.idl.getCompositeDataTypes().get(this.moduleForInnerTypes + typeName);
            }
            if (dataType == null) {
                dataType = (DataType)this.idl.getCompositeDataTypes().get(typeName);
            }
        }
        if (dataType == null) {
            dataType = PrimitiveDataType.getPrimitiveDataType(typeName);
        }
        return dataType;
    }

    public String getTypeName(AST node) {
        String typeName = node.getText();
        for (AST memberTypeNodeChild = node.getFirstChild(); memberTypeNodeChild != null; memberTypeNodeChild = memberTypeNodeChild.getNextSibling()) {
            typeName = typeName + "::" + memberTypeNodeChild.toString();
        }
        return typeName;
    }

    public void setModule(String module) {
        if (module == null || module.length() < 1) {
            module = "";
        } else if (!module.endsWith("::")) {
            module = module + "::";
        }
        this.module = module;
    }

    private EnumType visitEnum(AST node) {
        AST enumNode = node.getFirstChild();
        String enumName = enumNode.toString();
        EnumType enumType = new EnumType();
        enumType.setModule(this.module);
        enumType.setName(enumName);
        for (AST memberTypeNode = enumNode.getNextSibling(); memberTypeNode != null; memberTypeNode = memberTypeNode.getNextSibling()) {
            enumType.addEnumMember(memberTypeNode.toString());
        }
        return enumType;
    }

    private UnionType visitUnion(AST node) {
        UnionType unionType = new UnionType();
        AST exNode = node.getFirstChild();
        String exName = exNode.toString();
        unionType.setModule(this.module);
        unionType.setName(exName);
        AST switchTypeNode = exNode.getNextSibling();
        unionType.setDiscriminatorType(this.findDataType(switchTypeNode));
        for (AST caseOrDefaultNode = switchTypeNode.getNextSibling(); caseOrDefaultNode != null; caseOrDefaultNode = caseOrDefaultNode.getNextSibling()) {
            AST typeNode;
            UnionMember unionMember = new UnionMember();
            if (59 == caseOrDefaultNode.getType()) {
                unionMember.setDefault(true);
                typeNode = caseOrDefaultNode.getFirstChild();
            } else {
                unionMember.setDefault(false);
                AST caseValueNode = caseOrDefaultNode.getFirstChild();
                unionMember.setDiscriminatorValue(caseValueNode.getText());
                typeNode = caseValueNode.getNextSibling();
            }
            unionMember.setDataType(this.findDataType(typeNode));
            AST memberNode = typeNode.getNextSibling();
            unionMember.setName(memberNode.toString());
            unionType.addMember(unionMember);
        }
        return unionType;
    }

    private void visitAndAddTypedefs(AST node, String moduleName) {
        AST typedefNameNode;
        AST typedefNode = node.getFirstChild();
        DataType dataType = this.findDataType(typedefNode);
        String typedefName = typedefNameNode.toString();
        for (typedefNameNode = typedefNode.getNextSibling(); typedefNameNode != null; typedefNameNode = typedefNameNode.getNextSibling()) {
            int dimensions = typedefNameNode.getNumberOfChildren();
            if (dimensions > 0) {
                AbstractCollectionType arrayType = null;
                ArrayType rootArrayType = null;
                int i = 1;
                for (AST dimensionNode = typedefNameNode.getFirstChild(); dimensionNode != null; dimensionNode = dimensionNode.getNextSibling()) {
                    ArrayType temp = new ArrayType();
                    temp.setElementModule(moduleName);
                    temp.setElementName(typedefName);
                    temp.setDepth(i);
                    ++i;
                    if (arrayType != null) {
                        arrayType.setDataType(temp);
                    } else {
                        rootArrayType = temp;
                    }
                    arrayType = temp;
                    arrayType.setElementCount(Integer.parseInt(dimensionNode.getText()));
                }
                if (arrayType != null) {
                    arrayType.setDataType(dataType);
                }
                dataType = rootArrayType;
            }
            Typedef typedef = new Typedef();
            typedef.setDataType(dataType);
            typedef.setModule(moduleName);
            typedef.setName(typedefName);
            this.idl.addType(typedef);
        }
    }

    private SequenceType visitAnonymousSequence(AST node, boolean root) {
        AST countNode;
        AST typeNode = node.getFirstChild();
        SequenceType sequenceType = new SequenceType();
        DataType dataType = this.findDataType(typeNode, false);
        sequenceType.setDataType(dataType);
        sequenceType.setElementModule(this.module);
        AST elementNode = node.getNextSibling();
        if (elementNode != null && root) {
            String elementName = elementNode.getText();
            SequenceType tempSeqType = sequenceType;
            int i = 1;
            while (true) {
                tempSeqType.setElementName(elementName);
                tempSeqType.setDepth(i);
                ++i;
                DataType tempDataType = tempSeqType.getDataType();
                if (!(tempDataType instanceof SequenceType)) break;
                tempSeqType = (SequenceType)tempDataType;
            }
        }
        if ((countNode = typeNode.getNextSibling()) != null) {
            sequenceType.setElementCount(Integer.parseInt(countNode.getText()));
        } else {
            sequenceType.setElementCount(0);
        }
        return sequenceType;
    }
}

