/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import java.io.IOException;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlOption
extends ClickableElement
implements DisabledElement {
    private static final long serialVersionUID = 8995198439134305753L;
    public static final String TAG_NAME = "option";
    private final boolean initialSelectedState_ = this.hasAttribute("selected");

    HtmlOption(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public boolean isSelected() {
        return this.hasAttribute("selected");
    }

    public Page setSelected(boolean selected) {
        if (selected == this.isSelected()) {
            return this.getPage();
        }
        HtmlSelect select = this.getEnclosingSelect();
        if (select != null) {
            if (!select.isMultipleSelectEnabled() && select.getOptionSize() == 1) {
                selected = true;
            }
            return select.setSelectedAttribute(this, selected);
        }
        this.setSelectedInternal(selected);
        return this.getPage();
    }

    @Override
    public void insertBefore(DomNode newNode) throws IllegalStateException {
        HtmlOption option;
        super.insertBefore(newNode);
        if (newNode instanceof HtmlOption && (option = (HtmlOption)newNode).isSelected()) {
            this.getEnclosingSelect().setSelectedAttribute(option, true);
        }
    }

    public HtmlSelect getEnclosingSelect() {
        return (HtmlSelect)this.getEnclosingElement("select");
    }

    public void reset() {
        this.setSelectedInternal(this.initialSelectedState_);
    }

    public final String getSelectedAttribute() {
        return this.getAttribute("selected");
    }

    public final boolean isDefaultSelected() {
        return this.initialSelectedState_;
    }

    @Override
    public final boolean isDisabled() {
        if (this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLOPTION_PREVENT_DISABLED)) {
            return false;
        }
        return this.hasAttribute("disabled");
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttribute("disabled");
    }

    public final String getLabelAttribute() {
        return this.getAttribute("label");
    }

    public final void setLabelAttribute(String newLabel) {
        this.setAttribute("label", newLabel);
    }

    public final String getValueAttribute() {
        return this.getAttribute("value");
    }

    public final void setValueAttribute(String newValue) {
        this.setAttribute("value", newValue);
    }

    @Override
    protected Page doClickAction(Page defaultPage) throws IOException {
        if (!this.isSelected()) {
            return this.setSelected(true);
        }
        return defaultPage;
    }

    @Override
    public DomNode appendChild(Node node) {
        DomNode addedNode = super.appendChild(node);
        if (this.getAttribute("value") == ATTRIBUTE_NOT_DEFINED) {
            this.setAttribute("value", this.asText());
        }
        return addedNode;
    }

    void setSelectedInternal(boolean selected) {
        if (selected) {
            this.setAttribute("selected", "selected");
        } else {
            this.removeAttribute("selected");
        }
    }

    @Override
    public String asText() {
        return super.asText();
    }

    @Override
    protected String asTextInternal() {
        if (this.getLabelAttribute() != ATTRIBUTE_NOT_DEFINED) {
            return this.getLabelAttribute();
        }
        return super.asTextInternal();
    }

    public void setText(String text) {
        if (this.getPage().getWebClient().getBrowserVersion().isIE() && (text == null || text.length() == 0)) {
            this.removeAllChildren();
        } else {
            DomNode child = this.getFirstChild();
            if (child == null) {
                this.appendChild(new DomText(this.getPage(), text));
            } else {
                child.setNodeValue(text);
            }
        }
    }

    public String getText() {
        DomNode child = this.getFirstChild();
        if (child == null) {
            return "";
        }
        return child.getNodeValue();
    }
}

