/* Generated By:JavaCC: Do not edit this line. SACParserCSS2.java */
package com.steadystate.css.parser;

import java.io.*;
import java.net.*;
import java.text.MessageFormat;
import java.util.*;
import org.w3c.css.sac.*;
import com.steadystate.css.parser.selectors.*;
import com.steadystate.css.sac.TestCSSParseException;

/**
 * @author <a href="mailto:davidsch@users.sourceforge.net">David Schweinsberg</a>
 * @version $Id: SACParserCSS2.jj,v 1.2 2008/03/25 16:43:09 sdanig Exp $
 */
public class SACParserCSS2 extends AbstractSACParser implements Parser, SACParserCSS2Constants {

    private boolean _quiet = true;

    public SACParserCSS2() {
        this((CharStream) null);
    }

    public String getParserVersion() {
        return "http://www.w3.org/TR/REC-CSS2/";
    }

    protected String getGrammarUri()
    {
        return "http://www.w3.org/TR/REC-CSS2/grammar.html";
    }

    protected Token getToken()
    {
        return this.token;
    }

//
// stylesheet
//  : [ CHARSET_SYM S* STRING S* ';' ]?
//      [S|CDO|CDC]* [ import [S|CDO|CDC]* ]*
//      [ [ ruleset | media | page | font_face ] [S|CDO|CDC]* ]*
//  ;
//
  final public void styleSheet() throws ParseException {
    try {
          this.handleStartDocument();
      styleSheetRuleList();
      jj_consume_token(0);
    } finally {
        this.handleEndDocument();
    }
  }

  final public void styleSheetRuleList() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHARSET_SYM:
      charsetRule();
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
      case CDO:
      case CDC:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        jj_consume_token(S);
        break;
      case CDO:
        jj_consume_token(CDO);
        break;
      case CDC:
        jj_consume_token(CDC);
        break;
      default:
        jj_la1[2] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IMPORT_SYM:
        ;
        break;
      default:
        jj_la1[3] = jj_gen;
        break label_2;
      }
      importRule();
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
        case CDO:
        case CDC:
          ;
          break;
        default:
          jj_la1[4] = jj_gen;
          break label_3;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          jj_consume_token(S);
          break;
        case CDO:
          jj_consume_token(CDO);
          break;
        case CDC:
          jj_consume_token(CDC);
          break;
        default:
          jj_la1[5] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case PAGE_SYM:
      case MEDIA_SYM:
      case FONT_FACE_SYM:
      case ATKEYWORD:
      case IDENT:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case IDENT:
        styleRule();
        break;
      case MEDIA_SYM:
        mediaRule();
        break;
      case PAGE_SYM:
        pageRule();
        break;
      case FONT_FACE_SYM:
        fontFaceRule();
        break;
      case ATKEYWORD:
        unknownRule();
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
        case CDO:
        case CDC:
          ;
          break;
        default:
          jj_la1[8] = jj_gen;
          break label_5;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          jj_consume_token(S);
          break;
        case CDO:
          jj_consume_token(CDO);
          break;
        case CDC:
          jj_consume_token(CDC);
          break;
        default:
          jj_la1[9] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case IMPORT_SYM:
      case PAGE_SYM:
      case MEDIA_SYM:
      case FONT_FACE_SYM:
      case ATKEYWORD:
      case IDENT:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_6;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case IDENT:
        styleRule();
        break;
      case MEDIA_SYM:
        mediaRule();
        break;
      case PAGE_SYM:
        pageRule();
        break;
      case FONT_FACE_SYM:
        fontFaceRule();
        break;
      case IMPORT_SYM:
        importRuleIgnored();
        break;
      case ATKEYWORD:
        unknownRule();
        break;
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
        case CDO:
        case CDC:
          ;
          break;
        default:
          jj_la1[12] = jj_gen;
          break label_7;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          jj_consume_token(S);
          break;
        case CDO:
          jj_consume_token(CDO);
          break;
        case CDC:
          jj_consume_token(CDC);
          break;
        default:
          jj_la1[13] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

//
// This is used by ASTStyleSheet.insertRule to parse a single rule
//
  final public void styleSheetRuleSingle() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHARSET_SYM:
      charsetRule();
      break;
    case IMPORT_SYM:
      importRule();
      break;
    case DOT:
    case COLON:
    case ASTERISK:
    case LSQUARE:
    case HASH:
    case IDENT:
      styleRule();
      break;
    case MEDIA_SYM:
      mediaRule();
      break;
    case PAGE_SYM:
      pageRule();
      break;
    case FONT_FACE_SYM:
      fontFaceRule();
      break;
    case ATKEYWORD:
      unknownRule();
      break;
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void charsetRule() throws ParseException {
  Token t;
    try {
      jj_consume_token(CHARSET_SYM);
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[15] = jj_gen;
          break label_8;
        }
        jj_consume_token(S);
      }
      t = jj_consume_token(STRING);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[16] = jj_gen;
          break label_9;
        }
        jj_consume_token(S);
      }
      jj_consume_token(SEMICOLON);
            this.handleCharset(t.toString());
    } catch (ParseException e) {
        this.getErrorHandler().error(
            this.toCSSParseException("invalidCharsetRule", e));
    }
  }

  final public void unknownRule() throws ParseException {
    Token t;
    String s;
    try {
      t = jj_consume_token(ATKEYWORD);
            s = skip();
            this.handleIgnorableAtRule(s);
    } catch (ParseException e) {
        this.getErrorHandler().error(
            this.toCSSParseException("invalidUnknownRule", e));
    }
  }

//
// import
//   : IMPORT_SYM S*
//     [STRING|URI] S* [ medium [ ',' S* medium]* ]? ';' S*
//   ;
//
  final public void importRule() throws ParseException {
    Token t;
//    String s;
    SACMediaListImpl ml = new SACMediaListImpl();
    try {
      jj_consume_token(IMPORT_SYM);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[17] = jj_gen;
          break label_10;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
        t = jj_consume_token(STRING);
        break;
      case URI:
        t = jj_consume_token(URI);
        break;
      default:
        jj_la1[18] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[19] = jj_gen;
          break label_11;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        mediaList(ml);
        break;
      default:
        jj_la1[20] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
            this.handleImportStyle(unescape(t.image), ml, null);
    } catch (CSSParseException e) {
        this.getErrorHandler().error(e);
        this.error_skipAtRule();
    } catch (ParseException e) {
        this.getErrorHandler().error(
            this.toCSSParseException("invalidImportRule", e));
        this.error_skipAtRule();
    }
  }

  final public void importRuleIgnored() throws ParseException {
    Token t;
    SACMediaListImpl ml = new SACMediaListImpl();
      ParseException e = generateParseException();
    try {
      jj_consume_token(IMPORT_SYM);
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[21] = jj_gen;
          break label_12;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
        t = jj_consume_token(STRING);
        break;
      case URI:
        t = jj_consume_token(URI);
        break;
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[23] = jj_gen;
          break label_13;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        mediaList(ml);
        break;
      default:
        jj_la1[24] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    } finally {
        this.getErrorHandler().error(this.toCSSParseException("invalidImportRuleIgnored", e));
    }
  }

//
// media
//   : MEDIA_SYM S* medium [ ',' S* medium ]* '{' S* ruleset* '}' S*
//   ;
//
  final public void mediaRule() throws ParseException {
    boolean start = false;
    SACMediaListImpl ml = new SACMediaListImpl();
    try {
      jj_consume_token(MEDIA_SYM);
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[25] = jj_gen;
          break label_14;
        }
        jj_consume_token(S);
      }
      mediaList(ml);
            start = true;
            this.handleStartMedia(ml);
      jj_consume_token(LBRACE);
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[26] = jj_gen;
          break label_15;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case PAGE_SYM:
      case ATKEYWORD:
      case IDENT:
        mediaRuleList();
        break;
      default:
        jj_la1[27] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
    } catch (CSSParseException e) {
        this.getErrorHandler().error(e);
        this.error_skipblock();
    } catch (ParseException e) {
        CSSParseException cpe = this.toCSSParseException("invalidMediaRule", e);
        this.getErrorHandler().error(cpe);
        this.getErrorHandler().warning(this.createSkipWarning("ignoringRule", cpe));
        this.error_skipblock();
    } finally {
        if (start) {
            this.handleEndMedia(ml);
        }
    }
  }

  final public void mediaList(SACMediaListImpl ml) throws ParseException {
    String s;
    try {
      s = medium();
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[28] = jj_gen;
          break label_16;
        }
        jj_consume_token(COMMA);
        label_17:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[29] = jj_gen;
            break label_17;
          }
          jj_consume_token(S);
        }
                             ml.add(s);
        s = medium();
      }
          ml.add(s);
    } catch (ParseException e) {
        {if (true) throw this.toCSSParseException("invalidMediaList", e);}
    }
  }

  final public void mediaRuleList() throws ParseException {
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case IDENT:
        styleRule();
        break;
      case PAGE_SYM:
        pageRule();
        break;
      case ATKEYWORD:
        unknownRule();
        break;
      default:
        jj_la1[30] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[31] = jj_gen;
          break label_19;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case PAGE_SYM:
      case ATKEYWORD:
      case IDENT:
        ;
        break;
      default:
        jj_la1[32] = jj_gen;
        break label_18;
      }
    }
  }

  final public void mediaRuleSingle() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOT:
    case COLON:
    case ASTERISK:
    case LSQUARE:
    case HASH:
    case IDENT:
      styleRule();
      break;
    case PAGE_SYM:
      pageRule();
      break;
    case ATKEYWORD:
      unknownRule();
      break;
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

//
// medium
//   : IDENT S*
//   ;
//
  final public String medium() throws ParseException {
  Token t;
    t = jj_consume_token(IDENT);
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[34] = jj_gen;
        break label_20;
      }
      jj_consume_token(S);
    }
        this.handleMedium(t.image);
        {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

//
// page
//   : PAGE_SYM S* IDENT? pseudo_page? S*
//     '{' S* declaration [ ';' S* declaration ]* '}' S*
//   ;
//
  final public void pageRule() throws ParseException {
    Token t = null;
    String s = null;
    boolean start = false;
    try {
      jj_consume_token(PAGE_SYM);
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[35] = jj_gen;
          break label_21;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
      case IDENT:
        if (jj_2_1(2)) {
          t = jj_consume_token(IDENT);
          s = pseudoPage();
          label_22:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case S:
              ;
              break;
            default:
              jj_la1[36] = jj_gen;
              break label_22;
            }
            jj_consume_token(S);
          }
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case IDENT:
            t = jj_consume_token(IDENT);
            label_23:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case S:
                ;
                break;
              default:
                jj_la1[37] = jj_gen;
                break label_23;
              }
              jj_consume_token(S);
            }
            break;
          case COLON:
            s = pseudoPage();
            label_24:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case S:
                ;
                break;
              default:
                jj_la1[38] = jj_gen;
                break label_24;
              }
              jj_consume_token(S);
            }
            break;
          default:
            jj_la1[39] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
      default:
        jj_la1[40] = jj_gen;
        ;
      }
      jj_consume_token(LBRACE);
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[41] = jj_gen;
          break label_25;
        }
        jj_consume_token(S);
      }
            start = true;
            this.handleStartPage((t != null) ? unescape(t.image) : null, s);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        declaration();
        break;
      default:
        jj_la1[42] = jj_gen;
        ;
      }
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          ;
          break;
        default:
          jj_la1[43] = jj_gen;
          break label_26;
        }
        jj_consume_token(SEMICOLON);
        label_27:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[44] = jj_gen;
            break label_27;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENT:
          declaration();
          break;
        default:
          jj_la1[45] = jj_gen;
          ;
        }
      }
      jj_consume_token(RBRACE);
    } catch (ParseException e) {
        {if (true) throw this.toCSSParseException("invalidPageRule", e);}
    } finally {
        if (start) {
            this.handleEndPage((t != null) ? unescape(t.image) : null, s);
        }
    }
  }

//
// pseudoPage
//   : ':' IDENT
//   ;
//
  final public String pseudoPage() throws ParseException {
  Token t;
    jj_consume_token(COLON);
    t = jj_consume_token(IDENT);
                        {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

//
// font_face
//   : FONT_FACE_SYM S*
//     '{' S* declaration [ ';' S* declaration ]* '}' S*
//   ;
//
  final public void fontFaceRule() throws ParseException {
    boolean start = false;
    try {
      jj_consume_token(FONT_FACE_SYM);
      label_28:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[46] = jj_gen;
          break label_28;
        }
        jj_consume_token(S);
      }
      jj_consume_token(LBRACE);
      label_29:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[47] = jj_gen;
          break label_29;
        }
        jj_consume_token(S);
      }
                            start = true; this.handleStartFontFace();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        declaration();
        break;
      default:
        jj_la1[48] = jj_gen;
        ;
      }
      label_30:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          ;
          break;
        default:
          jj_la1[49] = jj_gen;
          break label_30;
        }
        jj_consume_token(SEMICOLON);
        label_31:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[50] = jj_gen;
            break label_31;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENT:
          declaration();
          break;
        default:
          jj_la1[51] = jj_gen;
          ;
        }
      }
      jj_consume_token(RBRACE);
    } catch (ParseException e) {
        {if (true) throw this.toCSSParseException("invalidFontFaceRule", e);}
    } finally {
        if (start) {
            this.handleEndFontFace();
        }
    }
  }

//
// operator
//   : '/' S* | ',' S* |
//   ;
//
  final public LexicalUnit operator(LexicalUnit prev) throws ParseException {
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SLASH:
      t = jj_consume_token(SLASH);
      label_32:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[52] = jj_gen;
          break label_32;
        }
        jj_consume_token(S);
      }
                           {if (true) return new LexicalUnitImpl(prev, LexicalUnit.SAC_OPERATOR_SLASH);}
      break;
    case COMMA:
      t = jj_consume_token(COMMA);
      label_33:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[53] = jj_gen;
          break label_33;
        }
        jj_consume_token(S);
      }
                           {if (true) return new LexicalUnitImpl(prev, LexicalUnit.SAC_OPERATOR_COMMA);}
      break;
    default:
      jj_la1[54] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

//
// combinator
//   : '+' S* | '>' S* |
//   ;
//
  final public char combinator() throws ParseException {
  char c = ' ';
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      jj_consume_token(PLUS);
             c='+';
      label_34:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[55] = jj_gen;
          break label_34;
        }
        jj_consume_token(S);
      }
      break;
    case GT:
      jj_consume_token(GT);
           c='>';
      label_35:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[56] = jj_gen;
          break label_35;
        }
        jj_consume_token(S);
      }
      break;
    case S:
      jj_consume_token(S);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case GT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
          jj_consume_token(PLUS);
                     c='+';
          break;
        case GT:
          jj_consume_token(GT);
                                       c='>';
          break;
        default:
          jj_la1[57] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_36:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[58] = jj_gen;
            break label_36;
          }
          jj_consume_token(S);
        }
        break;
      default:
        jj_la1[59] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[60] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return c;}
    throw new Error("Missing return statement in function");
  }

//
// unary_operator
//   : '-' | '+'
//   ;
//
  final public char unaryOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
      jj_consume_token(MINUS);
              {if (true) return '-';}
      break;
    case PLUS:
      jj_consume_token(PLUS);
                                       {if (true) return '+';}
      break;
    default:
      jj_la1[61] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

//
// property
//   : IDENT S*
//   ;
//
  final public String property() throws ParseException {
    Token t;
    t = jj_consume_token(IDENT);
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[62] = jj_gen;
        break label_37;
      }
      jj_consume_token(S);
    }
      {if (true) return unescape(t.image);}
    throw new Error("Missing return statement in function");
  }

//
// ruleset
//   : selector [ ',' S* selector ]*
//     '{' S* declaration [ ';' S* declaration ]* '}' S*
//   ;
//
  final public void styleRule() throws ParseException {
    SelectorList selList = null;
    boolean start = false;
    try {
      selList = selectorList();
      jj_consume_token(LBRACE);
      label_38:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[63] = jj_gen;
          break label_38;
        }
        jj_consume_token(S);
      }
            start = true;
            this.handleStartSelector(selList);
      styleDeclaration();
      jj_consume_token(RBRACE);
    } catch (CSSParseException e) {
        this.getErrorHandler().error(e);
        this.getErrorHandler().warning(this.createSkipWarning("ignoringRule", e));
        this.error_skipblock();
    } catch (ParseException e) {
        CSSParseException cpe = this.toCSSParseException("invalidStyleRule", e);
        this.getErrorHandler().error(cpe);
        this.getErrorHandler().warning(this.createSkipWarning("ignoringFollowingDeclarations", cpe));
        this.error_skipblock();
    } finally {
        if (start) {
            this.handleEndSelector(selList);
        }
    }
  }

  final public SelectorList selectorList() throws ParseException {
    SelectorListImpl selList = new SelectorListImpl();
    Selector sel;
    sel = selector();
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[64] = jj_gen;
        break label_39;
      }
      jj_consume_token(COMMA);
      label_40:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[65] = jj_gen;
          break label_40;
        }
        jj_consume_token(S);
      }
                         selList.add(sel);
      sel = selector();
    }
        selList.add(sel);
        {if (true) return selList;}
    throw new Error("Missing return statement in function");
  }

//
// selector
//   : simple_selector [ combinator simple_selector ]*
//   ;
//
  final public Selector selector() throws ParseException {
    Selector sel;
    char comb;
    try {
      sel = simpleSelector(null, ' ');
      label_41:
      while (true) {
        if (jj_2_2(2)) {
          ;
        } else {
          break label_41;
        }
        comb = combinator();
        sel = simpleSelector(sel, comb);
      }
      label_42:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[66] = jj_gen;
          break label_42;
        }
        jj_consume_token(S);
      }
            this.handleSelector(sel);
            {if (true) return sel;}
    } catch (ParseException e) {
        {if (true) throw this.toCSSParseException("invalidSelector", e);}
        //skipSelector();

    }
    throw new Error("Missing return statement in function");
  }

//
// simple_selector
//   : element_name? [ HASH | class | attrib | pseudo ]* S*
//   ;
//
  final public Selector simpleSelector(Selector sel, char comb) throws ParseException {
    SimpleSelector simpleSel = null;
    Condition c = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASTERISK:
      case IDENT:
        simpleSel = elementName();
        label_43:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case DOT:
          case COLON:
          case LSQUARE:
          case HASH:
            ;
            break;
          default:
            jj_la1[67] = jj_gen;
            break label_43;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case HASH:
            c = hash(c);
            break;
          case DOT:
            c = _class(c);
            break;
          case LSQUARE:
            c = attrib(c);
            break;
          case COLON:
            c = pseudo(c);
            break;
          default:
            jj_la1[68] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
      case DOT:
      case COLON:
      case LSQUARE:
      case HASH:
                simpleSel = this.getSelectorFactory().createElementSelector(null, null);
        label_44:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case HASH:
            c = hash(c);
            break;
          case DOT:
            c = _class(c);
            break;
          case LSQUARE:
            c = attrib(c);
            break;
          case COLON:
            c = pseudo(c);
            break;
          default:
            jj_la1[69] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case DOT:
          case COLON:
          case LSQUARE:
          case HASH:
            ;
            break;
          default:
            jj_la1[70] = jj_gen;
            break label_44;
          }
        }
        break;
      default:
        jj_la1[71] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            if (c != null) {
                simpleSel = this.getSelectorFactory().createConditionalSelector(simpleSel, c);
            }

            if (sel != null) {
                switch (comb) {
                case ' ':
                    sel = this.getSelectorFactory().createDescendantSelector(sel, simpleSel);
                    break;
                case '+':
                    sel = this.getSelectorFactory().createDirectAdjacentSelector(sel.getSelectorType(), sel, simpleSel);
                    break;
                case '>':
                    sel = this.getSelectorFactory().createChildSelector(sel, simpleSel);
                    break;
                }
            } else {
                sel = simpleSel;
            }

            {if (true) return sel;}
    } catch (ParseException e) {
        {if (true) throw this.toCSSParseException("invalidSimpleSelector", e);}
    }
    throw new Error("Missing return statement in function");
  }

//
// class
//   : '.' IDENT
//   ;
//
  final public Condition _class(Condition pred) throws ParseException {
    Token t;
    try {
      jj_consume_token(DOT);
      t = jj_consume_token(IDENT);
            Condition c = this.getConditionFactory().createClassCondition(null, t.image);
            {if (true) return (pred == null) ? c : this.getConditionFactory().createAndCondition(pred, c);}
    } catch (ParseException e) {
        {if (true) throw this.toCSSParseException("invalidClassSelector", e);}
    }
    throw new Error("Missing return statement in function");
  }

//
// element_name
//   : IDENT | '*'
//   ;
//
  final public SimpleSelector elementName() throws ParseException {
    Token t;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        t = jj_consume_token(IDENT);
          {if (true) return this.getSelectorFactory().createElementSelector(null, unescape(t.image));}
        break;
      case ASTERISK:
        jj_consume_token(ASTERISK);
          {if (true) return this.getSelectorFactory().createElementSelector(null, null);}
        break;
      default:
        jj_la1[72] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (ParseException e) {
        {if (true) throw this.toCSSParseException("invalidElementName", e);}
    }
    throw new Error("Missing return statement in function");
  }

//
// attrib
//   : '[' S* IDENT S* [ [ '=' | INCLUDES | DASHMATCH ] S*
//     [ IDENT | STRING ] S* ]? ']'
//   ;
//
  final public Condition attrib(Condition pred) throws ParseException {
    Token t;
    String name = null;
    String value = null;
    int type = 0;
    try {
      jj_consume_token(LSQUARE);
      label_45:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[73] = jj_gen;
          break label_45;
        }
        jj_consume_token(S);
      }
      t = jj_consume_token(IDENT);
                      name = unescape(t.image);
      label_46:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[74] = jj_gen;
          break label_46;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUALS:
      case INCLUDES:
      case DASHMATCH:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQUALS:
          jj_consume_token(EQUALS);
                           type = 1;
          break;
        case INCLUDES:
          jj_consume_token(INCLUDES);
                             type = 2;
          break;
        case DASHMATCH:
          jj_consume_token(DASHMATCH);
                              type = 3;
          break;
        default:
          jj_la1[75] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_47:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[76] = jj_gen;
            break label_47;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENT:
          t = jj_consume_token(IDENT);
                              value = t.image;
          break;
        case STRING:
          t = jj_consume_token(STRING);
                               value = unescape(t.image);
          break;
        default:
          jj_la1[77] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_48:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[78] = jj_gen;
            break label_48;
          }
          jj_consume_token(S);
        }
        break;
      default:
        jj_la1[79] = jj_gen;
        ;
      }
      jj_consume_token(RSQUARE);
            Condition c = null;
            switch (type) {
            case 0:
                c = this.getConditionFactory().createAttributeCondition(name, null, false, null);
                break;
            case 1:
                c = this.getConditionFactory().createAttributeCondition(name, null, false, value);
                break;
            case 2:
                c = this.getConditionFactory().createOneOfAttributeCondition(name, null, false, value);
                break;
            case 3:
                c = this.getConditionFactory().createBeginHyphenAttributeCondition(name, null, false, value);
                break;
            }
            {if (true) return (pred == null) ? c : this.getConditionFactory().createAndCondition(pred, c);}
    } catch (ParseException e) {
        {if (true) throw this.toCSSParseException("invalidAttrib", e);}
    }
    throw new Error("Missing return statement in function");
  }

//
// pseudo
//   : ':' [ IDENT | FUNCTION S* IDENT S* ')' ]
//   ;
//
  final public Condition pseudo(Condition pred) throws ParseException {
    Condition c;
    Token t;
    String function;
    String arg;
    try {
      jj_consume_token(COLON);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        t = jj_consume_token(IDENT);
                // There appears to be an issue here regarding "first-letter" & "first-line"
                //String s = unescape(t.image);
                String s = t.image;
                    c = this.getConditionFactory().createPseudoClassCondition(null, s);
                {if (true) return (pred == null)
                    ? c
                    : this.getConditionFactory().createAndCondition(pred, c);}
        break;
      case FUNCTION:
        t = jj_consume_token(FUNCTION);
                                 function = unescape(t.image);
        label_49:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[80] = jj_gen;
            break label_49;
          }
          jj_consume_token(S);
        }
        t = jj_consume_token(IDENT);
                              arg = unescape(t.image);
        label_50:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[81] = jj_gen;
            break label_50;
          }
          jj_consume_token(S);
        }
        jj_consume_token(RROUND);
                    if (function.equalsIgnoreCase("lang(")) {
                        c = this.getConditionFactory().createLangCondition(unescape(arg));
                        {if (true) return (pred == null)
                            ? c
                            : this.getConditionFactory().createAndCondition(pred, c);}
                    } else {
                        c = this.getConditionFactory().createPseudoClassCondition(null, function + arg + ")");
                                                {if (true) return (pred == null)
                            ? c
                            : this.getConditionFactory().createAndCondition(pred, c);}
                    }
                    /*
                    else {
                        throw new TestCSSParseException(
                            "Invalid pseudo function name " + function,
                            getLocator(), this.getGrammarUri());
                    }
                    */

        break;
      default:
        jj_la1[82] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (ParseException e) {
        {if (true) throw this.toCSSParseException("invalidPseudo", e);}
    }
    throw new Error("Missing return statement in function");
  }

  final public Condition hash(Condition pred) throws ParseException {
    Token t;
    try {
      t = jj_consume_token(HASH);
            Condition c = this.getConditionFactory().createIdCondition(t.image.substring(1));
            {if (true) return (pred == null) ? c : this.getConditionFactory().createAndCondition(pred, c);}
    } catch (ParseException e) {
        {if (true) throw this.toCSSParseException("invalidHash", e);}
    }
    throw new Error("Missing return statement in function");
  }

  final public void styleDeclaration() throws ParseException {
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        declaration();
        break;
      default:
        jj_la1[83] = jj_gen;
        ;
      }
      label_51:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          ;
          break;
        default:
          jj_la1[84] = jj_gen;
          break label_51;
        }
        jj_consume_token(SEMICOLON);
        label_52:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[85] = jj_gen;
            break label_52;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENT:
          declaration();
          break;
        default:
          jj_la1[86] = jj_gen;
          ;
        }
      }
    } catch (ParseException ex) {
        this.getErrorHandler().error(this.toCSSParseException("invalidDeclaration", ex));
        error_skipdecl();
    }
  }

//
// declaration
//   : property ':' S* expr prio?
//   |
//   ;
//
  final public void declaration() throws ParseException {
  String p;
  LexicalUnit e;
  boolean priority = false;
    try {
      p = property();
      jj_consume_token(COLON);
      label_53:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[87] = jj_gen;
          break label_53;
        }
        jj_consume_token(S);
      }
      e = expr();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IMPORTANT_SYM:
        priority = prio();
        break;
      default:
        jj_la1[88] = jj_gen;
        ;
      }
            this.handleProperty(p, e, priority);
    } catch (CSSParseException ex) {
        this.getErrorHandler().error(ex);
        error_skipdecl();
    } catch (ParseException ex) {
        this.getErrorHandler().error(this.toCSSParseException("invalidDeclaration", ex));
        error_skipdecl();
    }
  }

//
// prio
//   : IMPORTANT_SYM S*
//   ;
//
  final public boolean prio() throws ParseException {
    jj_consume_token(IMPORTANT_SYM);
    label_54:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[89] = jj_gen;
        break label_54;
      }
      jj_consume_token(S);
    }
    {if (true) return true;}
    throw new Error("Missing return statement in function");
  }

//
// expr
//   : term [ operator term ]*
//   ;
//
// TODO: Deal with the operator
//
  final public LexicalUnit expr() throws ParseException {
    LexicalUnit head;
    LexicalUnit body;
    try {
      head = term(null);
                            body = head;
      label_55:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
        case SLASH:
        case PLUS:
        case MINUS:
        case HASH:
        case STRING:
        case URI:
        case INHERIT:
        case EMS:
        case EXS:
        case LENGTH_PX:
        case LENGTH_CM:
        case LENGTH_MM:
        case LENGTH_IN:
        case LENGTH_PT:
        case LENGTH_PC:
        case ANGLE_DEG:
        case ANGLE_RAD:
        case ANGLE_GRAD:
        case TIME_MS:
        case TIME_S:
        case FREQ_HZ:
        case FREQ_KHZ:
        case DIMEN:
        case PERCENTAGE:
        case NUMBER:
        case RGB:
        case FUNCTION:
        case IDENT:
        case UNICODERANGE:
          ;
          break;
        default:
          jj_la1[90] = jj_gen;
          break label_55;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
        case SLASH:
          body = operator(body);
          break;
        default:
          jj_la1[91] = jj_gen;
          ;
        }
        body = term(body);
      }
          {if (true) return head;}
    } catch (ParseException ex) {
        {if (true) throw this.toCSSParseException("invalidExpr", ex);}
    }
    throw new Error("Missing return statement in function");
  }

//
// term
//   : unary_operator?
//     [ NUMBER S* | PERCENTAGE S* | LENGTH S* | EMS S* | EXS S* | ANGLE S* |
//       TIME S* | FREQ S* | function ]
//   | STRING S* | IDENT S* | URI S* | RGB S* | UNICODERANGE S* | hexcolor
//   ;
//
  final public LexicalUnit term(LexicalUnit prev) throws ParseException {
  Token t;
  char op = ' ';
  String s;
  LexicalUnit value = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      op = unaryOperator();
      break;
    default:
      jj_la1[92] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EMS:
    case EXS:
    case LENGTH_PX:
    case LENGTH_CM:
    case LENGTH_MM:
    case LENGTH_IN:
    case LENGTH_PT:
    case LENGTH_PC:
    case ANGLE_DEG:
    case ANGLE_RAD:
    case ANGLE_GRAD:
    case TIME_MS:
    case TIME_S:
    case FREQ_HZ:
    case FREQ_KHZ:
    case PERCENTAGE:
    case NUMBER:
    case FUNCTION:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMBER:
        t = jj_consume_token(NUMBER);
            try
            {
                value = LexicalUnitImpl.createNumber(prev, intValue(op, t.image));
            }
            catch (NumberFormatException e)
            {
                value = LexicalUnitImpl.createNumber(prev, floatValue(op, t.image));
            }
        break;
      case PERCENTAGE:
        t = jj_consume_token(PERCENTAGE);
                              value = LexicalUnitImpl.createPercentage(prev, floatValue(op, t.image));
        break;
      case LENGTH_PX:
        t = jj_consume_token(LENGTH_PX);
                              value = LexicalUnitImpl.createPixel(prev, floatValue(op, t.image));
        break;
      case LENGTH_CM:
        t = jj_consume_token(LENGTH_CM);
                              value = LexicalUnitImpl.createCentimeter(prev, floatValue(op, t.image));
        break;
      case LENGTH_MM:
        t = jj_consume_token(LENGTH_MM);
                              value = LexicalUnitImpl.createMillimeter(prev, floatValue(op, t.image));
        break;
      case LENGTH_IN:
        t = jj_consume_token(LENGTH_IN);
                              value = LexicalUnitImpl.createInch(prev, floatValue(op, t.image));
        break;
      case LENGTH_PT:
        t = jj_consume_token(LENGTH_PT);
                              value = LexicalUnitImpl.createPoint(prev, floatValue(op, t.image));
        break;
      case LENGTH_PC:
        t = jj_consume_token(LENGTH_PC);
                              value = LexicalUnitImpl.createPica(prev, floatValue(op, t.image));
        break;
      case EMS:
        t = jj_consume_token(EMS);
                              value = LexicalUnitImpl.createEm(prev, floatValue(op, t.image));
        break;
      case EXS:
        t = jj_consume_token(EXS);
                              value = LexicalUnitImpl.createEx(prev, floatValue(op, t.image));
        break;
      case ANGLE_DEG:
        t = jj_consume_token(ANGLE_DEG);
                              value = LexicalUnitImpl.createDegree(prev, floatValue(op, t.image));
        break;
      case ANGLE_RAD:
        t = jj_consume_token(ANGLE_RAD);
                              value = LexicalUnitImpl.createRadian(prev, floatValue(op, t.image));
        break;
      case ANGLE_GRAD:
        t = jj_consume_token(ANGLE_GRAD);
                              value = LexicalUnitImpl.createGradian(prev, floatValue(op, t.image));
        break;
      case TIME_MS:
        t = jj_consume_token(TIME_MS);
                              value = LexicalUnitImpl.createMillisecond(prev, floatValue(op, t.image));
        break;
      case TIME_S:
        t = jj_consume_token(TIME_S);
                              value = LexicalUnitImpl.createSecond(prev, floatValue(op, t.image));
        break;
      case FREQ_HZ:
        t = jj_consume_token(FREQ_HZ);
                              value = LexicalUnitImpl.createHertz(prev, floatValue(op, t.image));
        break;
      case FREQ_KHZ:
        t = jj_consume_token(FREQ_KHZ);
                              value = LexicalUnitImpl.createKiloHertz(prev, floatValue(op, t.image));
        break;
      case FUNCTION:
        value = function(prev);
        break;
      default:
        jj_la1[93] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case STRING:
      t = jj_consume_token(STRING);
                              value = new LexicalUnitImpl(prev, LexicalUnit.SAC_STRING_VALUE, unescape(t.image));
      break;
    case IDENT:
      t = jj_consume_token(IDENT);
                              value = new LexicalUnitImpl(prev, LexicalUnit.SAC_IDENT, t.image);
      break;
    case URI:
      t = jj_consume_token(URI);
                              value = new LexicalUnitImpl(prev, LexicalUnit.SAC_URI, t.image);
      break;
    case UNICODERANGE:
      t = jj_consume_token(UNICODERANGE);
                              value = new LexicalUnitImpl(prev, LexicalUnit.SAC_UNICODERANGE, t.image);
      break;
    case RGB:
      value = rgb(prev);
      break;
    case HASH:
      value = hexcolor(prev);
      break;
    case DIMEN:
      t = jj_consume_token(DIMEN);
        int n = getLastNumPos(t.image);
        value = LexicalUnitImpl.createDimension(
            prev,
            floatValue(op, t.image.substring(0, n+1)),
            t.image.substring(n+1));
      break;
    case INHERIT:
      t = jj_consume_token(INHERIT);
                              value = new LexicalUnitImpl(prev, LexicalUnit.SAC_INHERIT, t.image);
      break;
    default:
      jj_la1[94] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_56:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[95] = jj_gen;
        break label_56;
      }
      jj_consume_token(S);
    }
        if (value instanceof LexicalUnitImpl)
        {
            ((LexicalUnitImpl) value).setLocator(this.getLocator());
        }
        {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

//
// function
//   : FUNCTION S* expr ')' S*
//   ;
//
  final public LexicalUnit function(LexicalUnit prev) throws ParseException {
    Token t;
    LexicalUnit params;
    t = jj_consume_token(FUNCTION);
    label_57:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[96] = jj_gen;
        break label_57;
      }
      jj_consume_token(S);
    }
    params = expr();
    jj_consume_token(RROUND);
        {if (true) return this.functionInternal(prev, t, params);}
    throw new Error("Missing return statement in function");
  }

//
// rgb
//   : RGB S* expr ')' S*
//   ;
//
  final public LexicalUnit rgb(LexicalUnit prev) throws ParseException {
    Token t;
    LexicalUnit params;
    t = jj_consume_token(RGB);
    label_58:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[97] = jj_gen;
        break label_58;
      }
      jj_consume_token(S);
    }
    params = expr();
    jj_consume_token(RROUND);
        {if (true) return LexicalUnitImpl.createRgbColor(prev, params);}
    throw new Error("Missing return statement in function");
  }

//
// hexcolor
//   : HASH S*
//   ;
//
  final public LexicalUnit hexcolor(LexicalUnit prev) throws ParseException {
    Token t;
    t = jj_consume_token(HASH);
        {if (true) return this.hexcolorInternal(prev, t);}
    throw new Error("Missing return statement in function");
  }

  void skipSelector() throws ParseException {
    Token t = getToken(1);
    while (t.kind != COMMA && t.kind != SEMICOLON && t.kind != LBRACE && t.kind != EOF ) {
        getNextToken();
        t = getToken(1);
    }
  }

  String skip() throws ParseException {
  StringBuffer sb = new StringBuffer();
  int nesting = 0;
  Token t = getToken(0);
  if (t.image != null) {
    sb.append(t.image);
  }
  do {
    t = getNextToken();
    if (t.kind == EOF)
      break;
    sb.append(t.image);
    if (t.kind == LBRACE)
      nesting++;
    else if (t.kind == RBRACE)
      nesting--;
    else if (t.kind == SEMICOLON && nesting <= 0)
      break;
  }
  while ((t.kind != RBRACE) || (nesting > 0));

  return sb.toString();
  }

  void error_skipblock() throws ParseException {
    Token t;
    int nesting = 0;
    do
    {
        t = getNextToken();
        if (t.kind == LBRACE)
        {
            nesting++;
        }
        else if (t.kind == RBRACE)
        {
            nesting--;
        }
        else if (t.kind == EOF)
        {
            break;
        }
    }
    while ((t.kind != RBRACE) || (nesting > 0));
  }

  void error_skipdecl() throws ParseException {
    int nesting = 0;
    Token t = getToken(1);
    if (t.kind == LBRACE)
    {
        error_skipblock();
    }
    else
    {
        Token oldToken = t;
        while (t.kind != SEMICOLON && t.kind != RBRACE && t.kind != EOF )
        {
            oldToken = t;
            t = getNextToken();
        }
        if (t.kind == RBRACE)
        {
            token = oldToken;
        }
    }
  }

  void error_skipAtRule() throws ParseException {
    Token t = null;
    do
    {
        t = getNextToken();
    }
    while (t.kind != SEMICOLON);
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_3_2() {
    if (jj_3R_60()) return true;
    if (jj_3R_61()) return true;
    return false;
  }

  final private boolean jj_3R_81() {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  final private boolean jj_3R_77() {
    if (jj_3R_81()) return true;
    return false;
  }

  final private boolean jj_3R_76() {
    if (jj_3R_80()) return true;
    return false;
  }

  final private boolean jj_3R_75() {
    if (jj_3R_79()) return true;
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_3R_78()) return true;
    return false;
  }

  final private boolean jj_3R_69() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  final private boolean jj_3R_67() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) return true;
    }
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(IDENT)) return true;
    if (jj_3R_59()) return true;
    return false;
  }

  final private boolean jj_3R_66() {
    Token xsp;
    if (jj_3R_69()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_69()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_80() {
    if (jj_scan_token(LSQUARE)) return true;
    return false;
  }

  final private boolean jj_3R_64() {
    if (jj_scan_token(S)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_67()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_63() {
    if (jj_scan_token(GT)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_79() {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_scan_token(PLUS)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_60() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_65() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  final private boolean jj_3R_61() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) return true;
    }
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_scan_token(ASTERISK)) return true;
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  final private boolean jj_3R_71() {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  final private boolean jj_3R_68() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) return true;
    }
    return false;
  }

  final private boolean jj_3R_78() {
    if (jj_scan_token(HASH)) return true;
    return false;
  }

  public SACParserCSS2TokenManager token_source;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[98];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x0,0x3000002,0x3000002,0x10000000,0x3000002,0x3000002,0xe00a0d00,0xe00a0d00,0x3000002,0x3000002,0xf00a0d00,0xf00a0d00,0x3000002,0x3000002,0xf00a0d00,0x2,0x2,0x2,0x900000,0x2,0x0,0x2,0x900000,0x2,0x0,0x2,0x2,0x200a0d00,0x80,0x2,0x200a0d00,0x2,0x200a0d00,0x200a0d00,0x2,0x2,0x2,0x2,0x2,0x400,0x400,0x2,0x0,0x200,0x2,0x0,0x2,0x2,0x0,0x200,0x2,0x0,0x2,0x2,0x1080,0x2,0x2,0x12000,0x2,0x12000,0x12002,0x6000,0x2,0x2,0x80,0x2,0x2,0xa0500,0xa0500,0xa0500,0xa0500,0xa0d00,0x800,0x2,0x2,0xc008000,0x2,0x100000,0x2,0xc008000,0x2,0x2,0x0,0x0,0x200,0x2,0x0,0x2,0x0,0x2,0x987080,0x1080,0x6000,0x0,0x980000,0x2,0x2,0x2,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x1,0x0,0x0,0x0,0x0,0x0,0x1000002,0x1000002,0x0,0x0,0x1000002,0x1000002,0x0,0x0,0x1000003,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x1000000,0x0,0x0,0x1000002,0x0,0x0,0x1000002,0x0,0x1000002,0x1000002,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x0,0x1000000,0x0,0x0,0x1000000,0x0,0x0,0x1000000,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x1800000,0x1000000,0x0,0x0,0x1000000,0x0,0x4,0x0,0x9fffff8,0x0,0x0,0xb7fff0,0x9fffff8,0x0,0x0,0x0,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[2];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public SACParserCSS2(CharStream stream) {
    token_source = new SACParserCSS2TokenManager(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 98; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 98; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public SACParserCSS2(SACParserCSS2TokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 98; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(SACParserCSS2TokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 98; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[78];
    for (int i = 0; i < 78; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 98; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 78; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 2; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
