/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2006 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.pop3.storage.mailaccount.util;

import java.sql.Connection;
import com.openexchange.mail.MailException;
import com.openexchange.mailaccount.MailAccountDeleteListener;
import com.openexchange.mailaccount.MailAccountException;
import com.openexchange.pop3.storage.mailaccount.RdbPOP3StorageProperties;
import com.openexchange.pop3.storage.mailaccount.RdbPOP3StorageTrashContainer;
import com.openexchange.pop3.storage.mailaccount.RdbPOP3StorageUIDLMap;

/**
 * {@link StorageDeleteListener} - Delete listener for mail account POP3 storage.
 * 
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public final class StorageDeleteListener implements MailAccountDeleteListener {

    /**
     * Initializes a new {@link StorageDeleteListener}.
     */
    public StorageDeleteListener() {
        super();
    }

    public void onAfterMailAccountDeletion(final int id, final int user, final int cid, final Connection con) throws MailAccountException {
        // Nothing to do
    }

    public void onBeforeMailAccountDeletion(final int id, final int user, final int cid, final Connection con) throws MailAccountException {
        try {
            RdbPOP3StorageProperties.dropProperties(id, user, cid, con);
            RdbPOP3StorageTrashContainer.dropTrash(id, user, cid, con);
            RdbPOP3StorageUIDLMap.dropIDs(id, user, cid, con);
        } catch (final MailException e) {
            throw new MailAccountException(e);
        }
    }

}
