var tab = new temporary.VTab(newnode("span", 0, 0, [
    addTranslated(_("Publications")),
    newnode("span", { background: "orange", marginLeft: "5px", padding: "2px",
                      MozBorderRadius: "2px", WebkitBorderRadius: "2px",
                      color:"white" }, 0, [document.createTextNode(_("Beta"))])
]), 0.2);
temporary.folderTabs.addTab(tab);

var old_enter = temporary.folderTabs.enter;
temporary.folderTabs.enter = function() {
    tab.setVisible(Boolean(this.folder.own_rights & (1 << 28)));
    old_enter.call(this);
};

var widgets = {
    input: function(def) { return new ox.UI.Input(def.displayName); },
    password: function(def) { return new ox.UI.Password(def.displayName); },
    checkbox: function(def) { return new ox.UI.CheckBox(def.displayName); },
    text: function(def) { return new ox.UI.Text(def.displayName); },
    link: function(def) {
        var link = new ox.UI.Widget();
        link.default_value = "";
        link.addContent = function() {
            this.anchor = newnode("a", 0,
                { href: this.default_value, target: "_blank" },
                [document.createTextNode(this.default_value)]);
            this.node = this.parent.addCells(noI18n(def.displayName),
                                             this.anchor);
            ox.UI.Widget.prototype.addContent.apply(this, arguments);
        };
        link.set = function(value) {
            this.anchor.href = value;
            this.anchor.firstChild.data = value;
        };
        link.get = function() { return this.anchor.firstChild.data; };
        return link;
    }
};

tab.init = function() {
    var targets, modules, onInit;
    
    ox.JSON.get(AjaxRoot + "/publicationTargets/?action=all"
        + "&columns=id,displayName,icon,module,formDescription&session="
        + session, function(reply) {
            targets = {};
            modules = {};
            for (var i in reply.data) {
                var t = reply.data[i];
                var target = { id: t[0], displayName: t[1], icon: t[2],
                               module: t[3], formDescription: t[4] };
                targets[target.id] = target;
                var module = modules[target.module];
                if (!module) module = modules[target.module] = {};
                module[target.id] = target;
            }
            if (onInit) onInit();
        });

    // Left panel
    
    var selection = new Selection();
    var grid = new LiveGrid([{
        text: _("Name"),
        index: 1,
        clear: LiveGrid.makeClear(""),
        set: LiveGrid.defaultSet
    }], selection);
    grid.emptylivegridtext = _("No publications configured");
    tab.list = grid;
    
    var storage = new Storage(0, []);

    tab.enableList = function() {
        ox.JSON.get(AjaxRoot +
            "/publications?action=all&columns=id,displayName&folder=" +
            this.parent.folder.id + "&entityModule=" +
            this.parent.folder.module + "&session=" + session,
            function(reply) {
                storage.remove(0, storage.ids.length);
                storage.append(reply.data);
                grid.enable(storage);
            });
    };
    
    function load(id, cont) {
        ox.JSON.get(AjaxRoot + "/publications?action=get&id=" + id +
            "&session=" + session, function(reply) { cont(reply.data); });
    }

    tab.load = function(cont) { load(selection.getSelected()[0], cont); };
    
    tab.save = function(data, cont) {
        if ("id" in data) {
            ox.JSON.put(AjaxRoot + "/publications/?action=update&session=" +
                session, data, function(reply) {
                    load(data.id, function(data) {
                        storage.localUpdate([data.id], function(old) {
                            return [data.id, data.displayName];
                        });
                        cont(data);
                    });
                });
        } else {
            ox.JSON.put(AjaxRoot + "/publications/?action=new&session=" +
                session, data, function(reply) {
                    load(reply.data, function(data) {
                        storage.append([[data.id, data.displayName]]);
                        cont(data);
                    });
                });
        }
    };
    
    menuarrows[tab.viewID] = {};
    var menu = MenuNodes.createSmallButtonContext("publish.publications",
        _("Publications"));
    MenuNodes.createSmallButton(menu, "publish.publications.add", _("Add"),
        getFullImgSrc("img/menu/add_category.gif"),
        getFullImgSrc("img/menu/add_category_d.gif"),
        function() { tab.addNew({}); });
    MenuNodes.createSmallButton(menu, "publish.publications.remove", _("Remove"),
        getFullImgSrc("img/menu/remove_category.gif"),
        getFullImgSrc("img/menu/remove_category_d.gif"), confirmDelete);
    addMenuNode(menu.node, MenuNodes.FIXED, 31);
    changeDisplay(tab.viewID, "publish.publications");
    
    menuarrows[tab.viewID] = {};
    register("OX_SELECTED_ITEMS_CHANGED", function() {
        var deleteenabled = selection.count > 0;
        menuglobalzaehler = 0;
        menuarrows[tab.viewID]["publish.publications"] = [];
        menu_display_contents(tab.viewID, "publish.publications", true,
            "publish.publications.add");
        menu_display_contents(tab.viewID, "publish.publications", deleteenabled,
            "publish.publications.remove");
    });

    function confirmDelete() {
        if (!selection.count) return;
        newConfirm(ngettext("Delete Publication", "Delete Publications",
                            selection.count)(),
            ngettext(
                "Are you sure you want to delete the selected publication?",
                "Are you sure you want to delete the selected publications?",
                selection.count)(),
            AlertPopup.YES | AlertPopup.NO, null, null, handleDelete);
    }
    function handleDelete() {
        var ids = selection.getSelected();
        ox.JSON.put(AjaxRoot + "/publications?action=delete&session=" + session,
            ids, function(reply) { storage.removeIDs(ids); });
    }

    // Right panel
    
    var entry = new ox.UI.FieldSet();
    entry.getLegend = function() {
        var select = this.select = newnode("select", 0,
            { disabled: !this.isEnabled },
            [newnode("option", 0, { value: "" },
                     [addTranslated(_("Select a target"))])]);
        addDOMEvent(this.select, "change",  
            function() { entry.updateSelect(); });
        if (targets) initSelect(); else onInit = initSelect;
        return [this.select];
        function initSelect() {
            var module = tab.parent.folder.module;
            for (var i in targets) {
                var m = targets[i].module;
                if (m == module) {
                    select.appendChild(newnode("option", 0, { value: i },
                        [document.createTextNode(targets[i].displayName)]));
                }
            }
            onInit = undefined;
        }
    };
    entry.applyEnabled = function() {
        if (this.select) this.select.disabled = !this.isEnabled;
        ox.UI.FieldSet.prototype.applyEnabled.call(this);
    };
    entry.updateSelect = function() {
        for (var i = this.children.length - 1; i >= 0; i--) {
            this.deleteWidget(entry.children[i]);
        }
        if (this.select.value && (this.select.value in targets)) {
            var defs = targets[this.select.value].formDescription;
            for (var i = 0; i < defs.length; i++) {
                var def = defs[i];
                var widget = widgets[def.widget](def);
                if ("defaultValue" in def)
                    widget.default_value = def.defaultValue;
                this.addWidget(widget, def.name);
            }
        }
    };
    var defaultSet = entry.set;
    entry.set = function(value) {
        this.id = value.id;
        this.select.value = value.target;
        this.updateSelect();
        defaultSet.call(this, value[value.target]);
    };
    var defaultGet = entry.get;
    entry.get = function() {
        if (!this.select.value) return;
        var value = {
            target: this.select.value,
            entityModule: tab.parent.folder.module,
            entity: { folder: tab.parent.folder.id }
        };
        value[value.target] = defaultGet.call(this);
        if (this.id) value.id = this.id;
        return value;
    };
    tab.addWidget(entry, ox.Configuration.Group.NoField);

};