new ox.Configuration.InnerNode("configuration/admin", _("Administration"));
var node = new ox.Configuration.LeafNode("configuration/admin/groups",
                                         _("Groups"));
var page = new ox.Configuration.VSplit(node, _("Group Administration"), 0.5);
page.init = function() {
    var selection = new Selection();
    var grid = new LiveGrid([
        {
            text: _("Group name"),
            index: "name",
            width: "50%",
            clear: LiveGrid.makeClear(""),
            set: LiveGrid.defaultSet
        }, {
            text: _("Display name"),
            index: "display_name",
            clear: LiveGrid.makeClear(""),
            set: LiveGrid.defaultSet
        }
    ], selection);
    grid.emptylivegridtext = _("No groups available");
    page.list = grid;
    var mapping = {};
    function updateMapping() {
        OXCache.newRequest(null, "contacts", {
            criteria: { folder_id: 6 },
            columns: ["internal_userid", "display_name"]
        }, null, handleUsers);
        function handleUsers(data) {
            mapping = {};
            for (var i = 0; i < data.objects.length; i++) {
                var obj = data.objects[i];
                mapping[obj.internal_userid] = obj.display_name;
            }
        }
    }
    page.enableList = function() {
        updateMapping();
        ox.JSON.put(AjaxRoot + "/group?action=search&session=" + session,
            { pattern: "*" }, handleSearch);
        function handleSearch(reply) {
            for (var i = 0; i < reply.data.length; i++)
                reply.data[i].timestamp = reply.timestamp;
            storage.remove(0, storage.ids.length);
            storage.append(reply.data);
            grid.enable(storage);
        }
    };
    page.load = function(cont) {
        storage.newIterate(selection.getSelected(), emptyFunction,
            function(i, data) { cont(data); });
    };
    page.save = function(data, cont) {
        if ("id" in data) {
            var d = clone(data);
            delete d.id;
            delete d.timestamp;
            ox.JSON.put(AjaxRoot + "/group/?action=update&id=" + data.id +
                        "&timestamp=" + data.timestamp +
                        "&session=" + session, d,
                        function(reply) {
                            data.timestamp = reply.timestamp;
                            storage.localUpdate([data.id],
                                function(old) { return data; });
                            cont(data);
                        });
        } else {
            ox.JSON.put(AjaxRoot + "/group/?action=new&session=" + session,
                        data, function(reply) {
                            data.id = reply.data.id;
                            data.timestamp = reply.timestamp;
                            storage.append([data]);
                            cont(data);
                        });
        }
    };
    
    var storage = new Storage(0, [], 0, 0, 0, 0,
        function(group) { return group.id; });
    var popup = new ParticipantsSmall(null, addMembers, true, false,
        false, false, _("Select Members")(), null, null, true);

    var menu = MenuNodes.createSmallButtonContext("admin.groups", _("Groups"));
    MenuNodes.createSmallButton(menu, "admin.groups.new", _("New"),
        getFullImgSrc("img/dummy.gif"), getFullImgSrc("img/dummy.gif"),
        function() {
            page.addNew({
                name: _("Group")(),
                display_name: _("New group")(),
                members: []
            });
        });
    MenuNodes.createSmallButton(menu, "admin.groups.delete", _("Delete"),
        getFullImgSrc("img/dummy.gif"), getFullImgSrc("img/dummy.gif"),
        confirmDelete);
    function confirmDelete() {
        if (!selection.count) return;
        newConfirm(ngettext("Delete Group", "Delete Groups", selection.count)(),
            ngettext("Are you sure you want to delete the selected group?",
                     "Are you sure you want to delete the selected groups?",
                     selection.count)(),
            AlertPopup.YES | AlertPopup.NO, null, null, handleDelete);
    }
    function handleDelete() {
        storage.newIterate(selection.getSelected(), emptyFunction,
            function(i, data) {
                ox.JSON.put(AjaxRoot + "/group?action=delete&timestamp=" +
                    data.timestamp + "&session=" + session, { id: data.id },
                    (function(id) {
                        return function(reply) { grid.deleteIDs([id]); };
                    })(data.id));
            });
    }
    addMenuNode(menu.node, MenuNodes.FIXED, 31);
    changeDisplay(node.id, "admin.groups");

    menuarrows[node.id] = {};
    register("OX_SELECTED_ITEMS_CHANGED", function() {
        var deleteenabled = selection.count > 0;
        menuglobalzaehler = 0;
        menuarrows[node.id]["admin.groups"] = [];
        menu_display_contents(node.id, "admin.groups",
            true, "admin.groups.new");
        menu_display_contents(node.id, "admin.groups", deleteenabled,
            "admin.groups.delete");
    });

    page.addWidget(new ox.UI.Input(_("Group name")), "name");
    page.addWidget(new ox.UI.Input(_("Displayed name")), "display_name");
    var list = new ox.Configuration.EditableList(_("Members"), "16em",
                                                 _("Members"));
    list.emptyText = _("This group has no members");
    list.getText = function(elem) { return mapping[elem]; };
    var addContinuation = emptyFunction;
    list.add = function(cont) {
        addContinuation = cont;
        popup.openAddParticipantsWindow();
    };
    page.addWidget(list, "members");
    function addMembers(members) {
        var data = new Array(members.length);
        for (var i = 0; i < members.length; i++) data[i] = members[i].id;
        addContinuation(data);
    }
    var timestamp = new ox.UI.Widget();
    timestamp.set = function(value) { this.value = value; };
    timestamp.get = function() { return this.value; };
    timestamp.setVisible = emptyFunction;
    timestamp.remove = emptyFunction;
    page.addWidget(timestamp, "timestamp");
};