<?

/**
 *
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com
 *
 * @author Manuel Kraft <manuel.kraft@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 *
 */
    session_start();
    $oxdata = $_SESSION['ox_data'];

    //$folder_id = $_GET['folder_id']; supplied in session
    $contact_id = $_GET['obj_id'];

    if (!$contact_id) {
        // show errror html
        echo "<h2>No contact id!";        
        return; // let script return
    } else {
        $folder_id = $oxdata['ox_default_folder_contacts'];
        // fetch contact data
        try{
            $data = oxGetContact($oxdata,$contact_id,$folder_id);
        }catch(oXSessionTimeoutException $e){
            //echo "Session expired , loggin in again!";
            $session_is_expired = true;
            $oxdata = oXDoLogin($oxdata['ox_host'],$oxdata['ox_user'], $oxdata['ox_passwd'], false);
        }

        if($session_is_expired){
            // data is not defined, seems that session is expired
            $data = oxGetContact($oxdata,$contact_id,$folder_id);
        }
    }
    
    // prepare data for display on detail rows below
    // FIXME: Make this a funtion to call always on every page
    //$displayname = oXGetDisplayNameFromContact($data);
    $displayname = "";
    if (!empty($data->first_name)) {
        $displayname = $data->first_name . " ";
    }
    $displayname .= $data->last_name;
?>

<div id="tasksDetail" title="<? echo _("Details");?>" class="panel">
    <h2><? echo $displayname;  ?></h2>
    <h2><? echo $data->company;  ?></h2>
    
    <fieldset>
        <?
            if (!empty($data->telephone_business1)) {
        ?>
                <div class="row">
                    <label class="labelH"><? echo _("Work") ?></label>
                    <div class="text">
                        <span onClick="location.href='tel:<? echo $data->telephone_business1; ?>'"> <? echo $data->telephone_business1; ?> </span>
                    </div>
                </div>
        <?
            }
            if (!empty($data->telephone_home1)) {
        ?>
                <div class="row">
                    <label class="labelH"><? echo _("Private") ?></label>
                    <div class="text">
                        <span onClick="location.href='tel:<? echo $data->telephone_home1; ?>'"> <? echo $data->telephone_home1; ?> </span>
                    </div>
                </div>
        <?
            }
            if (!empty($data->fax_business)) {
        ?>
                <div class="row">
                    <label class="labelH"><? echo _("Fax") ?></label>
                    <div class="text">
                        <span onClick="location.href='tel:<? echo $data->fax_business; ?>'"> <? echo $data->fax_business; ?> </span>
                    </div>
                </div>
        <?
            }
            if (!empty($data->fax_home)) {
        ?>
                <div class="row">
                    <label class="labelH"><? echo _("Fax (P)") ?></label>
                    <div class="text">
                        <span onClick="location.href='tel:<? echo $data->fax_home; ?>'"> <? echo $data->fax_home; ?> </span>
                    </div>
                </div>
        <?
            }
            if (!empty($data->cellular_telephone1)) {
        ?>
                <div class="row">
                    <label class="labelH"><? echo _("Mobile") ?></label>
                    <div class="text">
                        <span onClick="location.href='tel:<? echo $data->cellular_telephone1; ?>'"> <? echo $data->cellular_telephone1; ?> </span>
                    </div>
                </div>
        <?
            }
            if (!empty($data->cellular_telephone2)) {
        ?>
                <div class="row">
                    <label class="labelH"><? echo _("Mobile (P)") ?></label>
                    <div class="text">
                        <span onClick="location.href='tel:<? echo $data->cellular_telephone2; ?>'"> <? echo $data->cellular_telephone2; ?> </span>
                    </div>
                </div>
        <?
            }
        ?>
    </fieldset>
    
    <?
        if (!empty($data->email1) || !empty($data->email2)) {
    ?>    
    <fieldset>
        <?
            if (!empty($data->email1)) {
        ?>
                <div class="row">                
                    <label class="labelH"><? echo _("Work") ?></label>
                    <div class="text">
                        <span onClick="location.href='mailto:<? echo $data->email1; ?>'"> <? echo $data->email1; ?> </span>
                    </div>
                </div>
        <?
            }
            if (!empty($data->email2)) {
        ?>
                <div class="row">                
                    <label class="labelH"><? echo _("Private") ?></label>
                    <div class="text">
                        <span onClick="location.href='mailto:<? echo $data->email2; ?>'"> <? echo $data->email2; ?> </span>
                    </div>
                </div>
        <?
            }
        }
        ?>
    </fieldset>
    
    <?
        $noPrivateAddress = true;
        if (!empty($data->street_home) && !empty($data->postal_code_home) && !empty($data->city_home) && !empty($data->country_home)) {
            $noPrivateAddress = false;
        }
        $noBusinessAddress = true;
        if (!empty($data->street_business) && !empty($data->postal_code_business) && !empty($data->city_business) && !empty($data->country_business)) {
            $noBusinessAddress = false;
        }
        if (!$noPrivateAddress || !$noBusinessAddress) {
    ?>
    <fieldset>
        <?
            if (!$noBusinessAddress) {
        ?>
                <div class="row">                
                    <label class="labelH"><? echo _("Work") ?></label>
                    <div style="padding-left: 113px"onClick="location.href='http://maps.google.com?q=<? echo $data->street_business; ?> <? echo $data->postal_code_business; ?> <? echo $data->city_business; ?>'">
                        <? if (!empty($data->street_business)) { echo $data->street_business . "<br/>"; } ?>
                        <? if (!empty($data->postal_code_business)) { echo $data->postal_code_business; } ?> 
                        <? if (!empty($data->city_business)) { echo $data->city_business . "<br/>"; } ?>
                        <? if (!empty($data->country_business)) { echo $data->country_business; } ?>
                    </div>
                </div>
        <?
            }
            if (!$noPrivateAddress) {
        ?>
                <div class="row">                
                    <label class="labelH"><? echo _("Private") ?></label>
                    <div style="padding-left: 113px" onClick="location.href='http://maps.google.com?q=<? echo $data->street_home; ?> <? echo $data->postal_code_home; ?> <? echo $data->city_home; ?>'">
                        <? if (!empty($data->street_home)) { echo $data->street_home . "<br/>"; } ?>
                        <? if (!empty($data->postal_code_home)) { echo $data->postal_code_home; } ?> 
                        <? if (!empty($data->city_home)) { echo $data->city_home . "<br/>"; } ?>
                        <? if (!empty($data->country_home)) { echo $data->country_home; } ?>
                    </div>
                </div>
        <?
            }
        }
        ?>
    </fieldset>
</div>