/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

registerView("configuration/calendar/preferences",
	function () { 
		showNode("config_calendar"); 
		$("config_calendar").style.display="block";
    },
	function () { 
		register("OX_SAVE_OBJECT",cc_saveConfiguration);
		register("OX_Cancel_Object",cc_cancelConfiguration);
		cc_enter(); 
		},
	function () { 
		//configuration_askforSave();
		unregister("OX_SAVE_OBJECT",cc_saveConfiguration);
		unregister("OX_Cancel_Object",cc_cancelConfiguration);
		cc_leave(); 
		},
	function () { 
		hideNode("config_calendar"); 
		$("config_calendar").style.display="none";
    },
	function () { cc_enter(); }
);

function cc_saveConfiguration() {
	if(configuration_changed_fields["gui"]) {
		configSetKey("gui.calendar.interval",cc_interval.getKey());
		
		configSetKey("gui.calendar.default_reminder",cc_default_reminder.getKey());
		
		configSetKey("gui.calendar.starttime",cc_work_start.getKey());
		configSetKey("gui.calendar.endtime",cc_work_end.getKey());
		configSetKey("gui.calendar.view",cc_default_level1.getKey());
		configSetKey("gui.global.confirmpopup",getBoolofInt(getValueofRadioBox("cs_confirmpopup")));
		
		configSetKey("gui.calendar.day.numberofappointments",cc_countappointmentday.getKey());
		configSetKey("gui.calendar.workweek.numberofappointments",cc_countappointmentww.getKey());
		configSetKey("gui.calendar.workweek.startday",cc_startdayofworkweek.getKey());
		configSetKey("gui.calendar.workweek.countdays",cc_daysinworkweek.getKey());
		configSetKey("gui.calendar.custom.countdays",cc_daysincustom.getKey());
		configSetKey("gui.calendar.custom.numberofappointments",cc_countappointmentcustom.getKey());
		configSetKey("gui.effects.hover.calendar",getBoolofInt(getValueofRadioBox("cc_enablehovercalendar")));	
		menulastviews["calendar"]=cc_default_level1.getKey();
	}
	/*
     * store notification settings to config, if changed 
     */
    if (configuration_changed_fields["calendarnotification"]) {
        configSetKey("modules.calendar.notifyNewModifiedDeleted",getBoolofInt(getValueofRadioBox("cs_calendarnotification_0")));   
        configSetKey("modules.calendar.notifyAcceptedDeclinedAsCreator",getBoolofInt(getValueofRadioBox("cs_calendarnotification_1")));
        configSetKey("modules.calendar.notifyAcceptedDeclinedAsParticipant",getBoolofInt(getValueofRadioBox("cs_calendarnotification_2")));
    }
	
	triggerEvent("OX_Save_Configuration",false,false);
}
function cc_cancelConfiguration() {
	configuration_changed_fields["gui"]=false;
	cc_enter();
}
var cc_init_bool=false;
var cc_interval;
var cc_default_reminder;
var cc_work_start;
var cc_work_end;
var cc_default_level1;
var cc_countappointmentww,cc_countappointmentday,cc_countappointmentcustom,cc_daysinworkweek,cc_daysincustom,cc_startdayofworkweek;

function cc_enter() {
	if(!cc_init_bool) {
		cc_init();
		cc_init_bool=true;
	}
	if(configContainsKey("gui.calendar.interval")) {
		cc_interval.setKey(configGetKey("gui.calendar.interval"));
		configuration_changed_fields["gui"]=false;
	}
	
	if(configContainsKey("gui.calendar.default_reminder")) {
		cc_default_reminder.setKey(configGetKey("gui.calendar.default_reminder"));
		configuration_changed_fields["gui"]=false;
	}
	
	if(configContainsKey("gui.calendar.starttime")) {
		cc_work_start.setKey(configGetKey("gui.calendar.starttime"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.calendar.endtime")) {
		cc_work_end.setKey(configGetKey("gui.calendar.endtime"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.calendar.view")) {
		cc_default_level1.setKey(configGetKey("gui.calendar.view"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.global.confirmpopup")) {
		setValueofRadioBox("cs_confirmpopup",configGetKey("gui.global.confirmpopup"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.calendar.interval")) {
		cc_interval.setKey(configGetKey("gui.calendar.interval"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.calendar.day.numberofappointments")) {
		cc_countappointmentday.setKey(configGetKey("gui.calendar.day.numberofappointments"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.calendar.workweek.numberofappointments")) {
		cc_countappointmentww.setKey(configGetKey("gui.calendar.workweek.numberofappointments"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.calendar.workweek.startday")) {
		cc_startdayofworkweek.setKey(configGetKey("gui.calendar.workweek.startday"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.calendar.workweek.countdays")) {
		cc_daysinworkweek.setKey(configGetKey("gui.calendar.workweek.countdays"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.calendar.custom.countdays")) {
		cc_daysincustom.setKey(configGetKey("gui.calendar.custom.countdays"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.calendar.custom.numberofappointments")) {
		cc_countappointmentcustom.setKey(configGetKey("gui.calendar.custom.numberofappointments"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.effects.hover.calendar")) {
		setIntofRadioBox("cc_enablehovercalendar",configGetKey("gui.effects.hover.calendar"));
		configuration_changed_fields["gui"]=false;
	}
	if (configContainsKey("modules.calendar.notifyNewModifiedDeleted")) {
        setValueofRadioBox("cs_calendarnotification_0",configGetKey("modules.calendar.notifyNewModifiedDeleted"));
        configuration_changed_fields["calendarnotification"]=false;
    }
    if (configContainsKey("modules.calendar.notifyAcceptedDeclinedAsCreator")) {
        setValueofRadioBox("cs_calendarnotification_1",configGetKey("modules.calendar.notifyAcceptedDeclinedAsCreator"));
        configuration_changed_fields["calendarnotification"]=false;
    }
    if (configContainsKey("modules.calendar.notifyAcceptedDeclinedAsParticipant")) {
        setValueofRadioBox("cs_calendarnotification_2",configGetKey("modules.calendar.notifyAcceptedDeclinedAsParticipant"));
        configuration_changed_fields["calendarnotification"]=false;
    }
	$("cc_header").firstChild.nodeValue=getconfigPathSelected().substring(1);	
}

register("OX_Configuration_Loaded",cc_onconfigload);
function cc_onconfigload() {
	addDefaultView("calendar/calendar/day","Calendar day view");/*i18n*/
	addDefaultView("calendar/calendar/workweek","Calendar workweek view");/*i18n*/
	addDefaultView("calendar/calendar/month","Calendar month view");/*i18n*/
	addDefaultView("calendar/calendar/week","Calendar week view");/*i18n*/
	addDefaultView("calendar/calendar/custom","Calendar custom view");/*i18n*/
	if(configGetKey("modules.calendar.calendar_freebusy") && configGetKey("modules.calendar.calendar_teamview")) {
		addDefaultView("calendar/team/day","Team day view");/*i18n*/
		addDefaultView("calendar/team/workweek","Team workweek view");/*i18n*/
	}
	addDefaultView("calendar/list/day","List day view");/*i18n*/
	addDefaultView("calendar/list/workweek","List workweek view");/*i18n*/
	addDefaultView("calendar/list/month","List month view");/*i18n*/
	addDefaultView("calendar/list/week","List week view");/*i18n*/
}

 
function cc_init() {
	function config_translateTime(value) {
		return function() { return formatDate(value,"time"); };
	}
	cc_interval= new ComboBox3(window, "cc_interval", "11em", 1, true,"OX_Configuration_GUI_Changed", null);
	cc_interval.addElement("5",5);
	cc_interval.addElement("10",10);
	cc_interval.addElement("15",15);
	cc_interval.addElement("20",20);
	cc_interval.addElement("30",30);
	cc_interval.addElement("60",60);
	cc_interval.getDomNode();	
	
	var timearray=["00:00","01:00","02:00","03:00","04:00","05:00","06:00","07:00","08:00","09:00","10:00","11:00","12:00","13:00","14:00","15:00","16:00","17:00","18:00","19:00","20:00","21:00","22:00","23:00"];
	
	function makeInterval(t) { return function() { return getInterval(t); }; }
	var h = 60, d = 1440, w = 10080; // minutes per hour, day and week
    var cc_reminder_intervals = [0, 15, 30, 45, 1*h, 2*h, 4*h, 6*h, 8*h, 12*h,1*d, 2*d, 3*d, 4*d, 5*d, 6*d, 1*w, 2*w, 3*w, 4*w];
	cc_default_reminder = new ComboBox3(window, "cc_reminder_status", "11em", 2, true, "OX_Configuration_GUI_Changed", 5);
	cc_default_reminder.addElement("no reminder"/*i18n*/,"-1");
    for (var i = 0; i < cc_reminder_intervals.length; i++) {
        cc_default_reminder.addElement("", cc_reminder_intervals[i], makeInterval(cc_reminder_intervals[i] * 6e4)); // ms / min
    }
    cc_default_reminder.getDomNode();
	
	
	cc_work_start= new ComboBox3(window, "cc_work_start", "11em", 1, true,"OX_Configuration_GUI_Changed", 5);
	for(var i=0;i<timearray.length;i++) {
		cc_work_start.addElement(timearray[i],i,config_translateTime(new Date(Date.UTC(2000,1,1,i,0,0))));
	}
	cc_work_start.getDomNode();	
	cc_work_end= new ComboBox3(window, "cc_work_end", "11em", 1, true,"OX_Configuration_GUI_Changed", 5);
	for(var i=0;i<timearray.length;i++) {
		cc_work_end.addElement(timearray[i],i,config_translateTime(new Date(Date.UTC(2000,1,1,i,0,0))));
	}
	cc_work_end.getDomNode();	
	
	cc_default_level1= new ComboBox3(window, "cc_default_level1", "22em", 1, true,"OX_Configuration_GUI_Changed", 5);
	var calviews=getDefaultSubviews("calendar");
	for (var i in calviews) {
		cc_default_level1.addElement(calviews[i],i);
	}
	cc_default_level1.getDomNode();
	cc_countappointmentww= new ComboBox3(window, "cc_countappointmentww", "11em", 1, true,"OX_Configuration_GUI_Changed", 5);
	cc_countappointmentday= new ComboBox3(window, "cc_countappointmentday", "11em",1, true,"OX_Configuration_GUI_Changed", 5);
	cc_countappointmentcustom= new ComboBox3(window, "cc_countappointmentcustom", "11em",1, true,"OX_Configuration_GUI_Changed", 5);
	cc_daysinworkweek= new ComboBox3(window, "cc_daysinworkweek", "11em",1, true,"OX_Configuration_GUI_Changed", 5);
	cc_daysincustom= new ComboBox3(window, "cc_daysincustom", "11em",1, true,"OX_Configuration_GUI_Changed", 5);
	cc_startdayofworkweek= new ComboBox3(window, "cc_startdayofworkweek", "11em",1, true,"OX_Configuration_GUI_Changed", 5);
	for (var i2=1;i2<=8;i2++) {
		cc_countappointmentcustom.addElement(i2,i2);
		cc_countappointmentww.addElement(i2,i2);
		cc_countappointmentday.addElement(i2,i2);
	}
	for (var i2=1;i2<=7;i2++) {
		cc_daysinworkweek.addElement(i2,i2);
		cc_daysincustom.addElement(i2,i2);
		
	}
	for (var i2=0;i2<weekdays.length;i2++) {
		cc_startdayofworkweek.addElement(weekdays[i2],i2);
	}
	cc_countappointmentday.getDomNode();
	cc_daysinworkweek.getDomNode();
	cc_startdayofworkweek.getDomNode();
	cc_countappointmentww.getDomNode();
	cc_daysincustom.getDomNode();
	cc_countappointmentcustom.getDomNode();
}
function cc_leave() {
	
}

fileloaded();