function ObjectCache (size,updatemilliseconds) {
	this.waitingrequests=new Array();
	this.requestzaehler=0;
	this.activerequests=false;
	this.myfunctions=new Object();
	this.moduleobjects=new Object();
	this.size=size;
	this.updatemilliseconds = 0;
	if(updatemilliseconds) {
		this.updatemilliseconds=updatemilliseconds;
	}
	this.mrulist = new MRUList(size);
}
ObjectCache.prototype = {
	setRule: function(module,type,getfunction) {
		if(!this.myfunctions[module]) {
			this.myfunctions[module]=new Object();
		} 
		this.myfunctions[module][type]=getfunction;
	},
	setModuleObject: function (object,module) {
		this.moduleobjects[module]=object;
	},
	get: function (oxobjects,fields,cb,modcb) {
		var Self=this;
		var mymodules=new Object();
		for (var i=0;i<oxobjects.length;i++) { 
			if(!mymodules[oxobjects[i].module]) {
				mymodules[oxobjects[i].module]=new Array();
			}
			mymodules[oxobjects[i].module].push(oxobjects[i]);
		}
		
		for(var mod in mymodules) {
			if(this.myfunctions[mod] && this.myfunctions[mod]["get"]) {
				this.waitingrequests.push(function() { Self.myfunctions[mod]["get"](Self,mymodules[mod],fields,cb,modcb); });
			} else {
				//NOT A VALID MODULE OR FUNCTION TODO
			}
		}
		if(!this.activerequests) {
			this.checkMoreRequests();
		}
	},
	getModuleObject : function(module) {
		return this.moduleobjects[module];
	},
	checkMoreRequests : function() {
		if(this.requestzaehler<this.waitingrequests.length) {
			this.requestzaehler++;
			this.activerequests=true;
			this.waitingrequests[this.requestzaehler-1]();
		} else {
			this.activerequests=false;
			this.waitingrequests = new Array();
			this.requestzaehler=0;
		}
	}		
}
var objectcache=new ObjectCache(1000,5000);
function OXObject() {	
	var Self=this;
	this.type="OXObject";
	this.timestamp=0;
	this.lastupdate=0;
}
OXObject.idmapping = new Object();
OXObject.stringmapping = new Object();
OXObject.unique=new Array();
OXObject.prototype = {
	constructor : OXObject,
	setValue : function (key,value) {
		if(this.constructor.stringmapping[key]) {
			this[key]=value;
		} 
	},
	hasValue : function (stringname) {
		if(this.constructor.stringmapping[stringname]) {
			if(!(this[stringname] === undefined)) {
				return true;
			}
		}
		return false;
	},
	hasValues : function (stringobjects) {
		for(var i in stringobjects) {
			if(!this.hasValue(i)) {
				return false;
			}
		}
		return true;
	},
	getFilledFields : function() {
		var filledfields=new Array();
		for(var i in this.constructor.stringmapping) {
			if(this.hasValue(i)) {
				filledfields.push(i);
			} 
		}
		return filledfields;
	},
	getValue : function (stringname) {
		if(this.hasValue(stringname)) {
			return this[stringname];
		}
		return undefined;
	},
	getTimestamp : function () {
		return this.timestamp;
	},
	getLastUpdate : function () {
		return this.lastupdate;
	}
}
function OXGroupwareObject() {
	this.type="OXGroupwareObject";
}
OXGroupwareObject.idmapping = clone(OXObject.idmapping);
OXGroupwareObject.stringmapping = clone(OXObject.stringmapping);
OXGroupwareObject.unique = clone(OXObject.unique);
OXGroupwareObject.unique.push("id","folder_id");

OXGroupwareObject.setFields = function (id,stringname) {
	if(id) OXGroupwareObject.idmapping[id]=stringname;
	if(stringname) OXGroupwareObject.stringmapping[stringname]=id;
}
OXGroupwareObject.setFields(1,"id");	
OXGroupwareObject.setFields(2,"created_by");	
OXGroupwareObject.setFields(3,"modified_by");	
OXGroupwareObject.setFields(4,"creation_date");	
OXGroupwareObject.setFields(5,"last_modified");	
OXGroupwareObject.setFields(20,"folder_id");	
OXGroupwareObject.setFields(100,"categories");	
OXGroupwareObject.setFields(101,"private_flag");	


OXGroupwareObject.prototype = new OXObject;
OXGroupwareObject.prototype.constructor = OXGroupwareObject;
function OXFolderObject() {
	this.type="OXFolderObject";
	this.module="folder";
}
OXFolderObject.prototype = new OXGroupwareObject;
OXFolderObject.prototype.constructor = OXFolderObject;
OXFolderObject.idmapping = clone(OXGroupwareObject.idmapping);
OXFolderObject.stringmapping = clone(OXGroupwareObject.stringmapping);
OXFolderObject.unique = clone(OXGroupwareObject.unique);
OXFolderObject.setFields = function (id,stringname) {
	if(id) OXFolderObject.idmapping[id]=stringname;
	if(stringname) OXFolderObject.stringmapping[stringname]=id;
}
OXFolderObject.setFields(300,"title");
OXFolderObject.setFields(301,"module"); //module string
OXFolderObject.setFields(302,"type"); //1,2,3,5 number
OXFolderObject.setFields(304,"subfolders");
OXFolderObject.setFields(305,"own_rights");
OXFolderObject.setFields(null,"permissions");
OXFolderObject.setFields(307,"summary");
OXFolderObject.setFields(308,"standard_folder");
OXFolderObject.setFields(309,"total");
OXFolderObject.setFields(310,"new");
OXFolderObject.setFields(312,"unread");

function OXOperationObject() {
	this.type="OXOperationObject";
}
OXOperationObject.prototype = new OXGroupwareObject;
OXOperationObject.prototype.constructor = OXOperationObject;
OXOperationObject.idmapping = clone(OXGroupwareObject.idmapping);
OXOperationObject.stringmapping = clone(OXGroupwareObject.stringmapping);
OXOperationObject.unique = clone(OXGroupwareObject.unique);
OXOperationObject.setFields = function (id,stringname) {
	if(id) OXOperationObject.idmapping[id]=stringname;
	if(stringname) OXOperationObject.stringmapping[stringname]=id;
}
OXOperationObject.setFields(200,"title");
OXOperationObject.setFields(201,"start_date");
OXOperationObject.setFields(202,"end_date");
OXOperationObject.setFields(203,"note");
OXOperationObject.setFields(204,"alarm");
OXOperationObject.setFields(206,"recurrence_id");
OXOperationObject.setFields(207,"recurrence_position");
OXOperationObject.setFields(208,"recurrence_date_position");
OXOperationObject.setFields(209,"recurrence_type");
OXOperationObject.setFields(212,"days");
OXOperationObject.setFields(213,"days_in_month");
OXOperationObject.setFields(214,"month");
OXOperationObject.setFields(215,"internal");
OXOperationObject.setFields(216,"until");
OXOperationObject.setFields(217,"notification");
OXOperationObject.setFields(220,"participants");
OXOperationObject.setFields(221,"users");


function OXTaskObject() {
	this.type="OXTaskObject";
	this.module="tasks";
}
OXTaskObject.prototype= new OXOperationObject;
OXTaskObject.prototype.constructor = OXTaskObject;
OXTaskObject.idmapping = clone(OXOperationObject.idmapping);
OXTaskObject.stringmapping = clone(OXOperationObject.stringmapping);
OXTaskObject.unique = clone(OXOperationObject.unique);
OXTaskObject.setFields = function (id,stringname) {
	if(id) OXTaskObject.idmapping[id]=stringname;
	if(stringname) OXTaskObject.stringmapping[stringname]=id;
}
OXTaskObject.setFields(300,"status");
OXTaskObject.setFields(301,"percent_completed");
OXTaskObject.setFields(302,"actual_costs");
OXTaskObject.setFields(303,"actual_duration");
OXTaskObject.setFields(304,"after_complete");
OXTaskObject.setFields(305,"billing_information");
OXTaskObject.setFields(306,"project_id");
OXTaskObject.setFields(307,"target_costs");
OXTaskObject.setFields(308,"target_duration");
OXTaskObject.setFields(309,"priority");
OXTaskObject.setFields(310,"duration_type");
OXTaskObject.setFields(311,"type_of_costs");
OXTaskObject.setFields(312,"currency");
OXTaskObject.setFields(313,"trip_meter");
OXTaskObject.setFields(314,"companies");
OXTaskObject.setFields(315,"date_completed");
OXTaskObject.setFields(102,"color_label")

function OXCalendarObject() {
	this.type="OXCalendarObject";
	this.module="calendar";
}
OXCalendarObject.prototype= new OXOperationObject;
OXCalendarObject.prototype.constructor = OXCalendarObject;
OXCalendarObject.idmapping = clone(OXOperationObject.idmapping);
OXCalendarObject.stringmapping = clone(OXOperationObject.stringmapping);
OXCalendarObject.unique = clone(OXOperationObject.unique);
OXCalendarObject.unique.push("recurrence_position");
OXCalendarObject.setFields = function (id,stringname) {
	if(id) OXCalendarObject.idmapping[id]=stringname;
	if(stringname) OXCalendarObject.stringmapping[stringname]=id;
}
OXCalendarObject.setFields(200,"title");
OXCalendarObject.setFields(201,"start_date");
OXCalendarObject.setFields(202,"end_date");
OXCalendarObject.setFields(400,"location");
OXCalendarObject.setFields(401,"full_time");
OXCalendarObject.setFields(402,"shown_as");
OXCalendarObject.setFields(102,"color_label");

function OXContactObject() {
	this.type="OXContactObject";
	this.module="contacts";
}
OXContactObject.prototype = new OXGroupwareObject;
OXContactObject.prototype.constructor = OXContactObject;
OXContactObject.idmapping = clone(OXGroupwareObject.idmapping);
OXContactObject.stringmapping = clone(OXGroupwareObject.stringmapping);
OXContactObject.unique = clone(OXGroupwareObject.unique);
OXContactObject.setFields = function (id,stringname) {
	if(id) OXContactObject.idmapping[id]=stringname;
	if(stringname) OXContactObject.stringmapping[stringname]=id;
}
OXContactObject.setFields(500,"display_name");
OXContactObject.setFields(501,"first_name");
OXContactObject.setFields(502,"last_name");
OXContactObject.setFields(503,"second_name");
OXContactObject.setFields(504,"suffix");
OXContactObject.setFields(505,"title");
OXContactObject.setFields(506,"street_home");
OXContactObject.setFields(507,"postal_code_home");
OXContactObject.setFields(508,"city_home");
OXContactObject.setFields(509,"state_home");
OXContactObject.setFields(510,"country_home");
OXContactObject.setFields(511,"birthday");
OXContactObject.setFields(512,"marital_status");
OXContactObject.setFields(513,"number_of_children");
OXContactObject.setFields(514,"profession");
OXContactObject.setFields(515,"nickname");
OXContactObject.setFields(516,"spouse_name");		
OXContactObject.setFields(517,"anniversary");		
OXContactObject.setFields(518,"note");		
OXContactObject.setFields(519,"department");		
OXContactObject.setFields(520,"position");		
OXContactObject.setFields(521,"employee_type");		
OXContactObject.setFields(522,"room_number");		
OXContactObject.setFields(523,"street_business");		
OXContactObject.setFields(525,"postal_code_business");		
OXContactObject.setFields(526,"city_business");		
OXContactObject.setFields(527,"state_business");		
OXContactObject.setFields(528,"country_business");		
OXContactObject.setFields(529,"number_of_employees");		
OXContactObject.setFields(530,"sales_volume");		
OXContactObject.setFields(531,"tax_id");		
OXContactObject.setFields(532,"commercial_register");		
OXContactObject.setFields(533,"branches");		
OXContactObject.setFields(534,"business_category");		
OXContactObject.setFields(535,"info");		
OXContactObject.setFields(536,"manager_name");		
OXContactObject.setFields(537,"assistant_name");		
OXContactObject.setFields(538,"street_other");		
OXContactObject.setFields(539,"city_other");		
OXContactObject.setFields(540,"postal_code_other");		
OXContactObject.setFields(541,"country_other");		
OXContactObject.setFields(542,"telephone_business1");		
OXContactObject.setFields(543,"telephone_business2");		
OXContactObject.setFields(544,"fax_business");		
OXContactObject.setFields(545,"telephone_callback");		
OXContactObject.setFields(546,"telephone_car");		
OXContactObject.setFields(547,"telephone_company");		
OXContactObject.setFields(548,"telephone_home1");		
OXContactObject.setFields(549,"telephone_home2");		
OXContactObject.setFields(550,"fax_home");		
OXContactObject.setFields(551,"cellular_telephone1");		
OXContactObject.setFields(552,"cellular_telephone2");		
OXContactObject.setFields(553,"telephone_other");		
OXContactObject.setFields(554,"fax_other");		
OXContactObject.setFields(555,"email1");		
OXContactObject.setFields(556,"email2");		
OXContactObject.setFields(557,"email3");		
OXContactObject.setFields(558,"url");		
OXContactObject.setFields(559,"telephone_isdn");		
OXContactObject.setFields(560,"telephone_pager");		
OXContactObject.setFields(561,"telephone_primary");		
OXContactObject.setFields(562,"telephone_radio");		
OXContactObject.setFields(563,"telephone_telex");		
OXContactObject.setFields(564,"telephone_ttytdd");		
OXContactObject.setFields(565,"instant_messenger1");
OXContactObject.setFields(566,"instant_messenger2");
OXContactObject.setFields(567,"telephone_ip");			
OXContactObject.setFields(568,"telephone_assistant");		
OXContactObject.setFields(569,"company");		
OXContactObject.setFields(570,"image1");		
OXContactObject.setFields(571,"userfield01");		
OXContactObject.setFields(572,"userfield02");		
OXContactObject.setFields(573,"userfield03");		
OXContactObject.setFields(574,"userfield04");		
OXContactObject.setFields(575,"userfield05");		
OXContactObject.setFields(576,"userfield06");		
OXContactObject.setFields(577,"userfield07");		
OXContactObject.setFields(578,"userfield08");		
OXContactObject.setFields(579,"userfield09");		
OXContactObject.setFields(580,"userfield10");		
OXContactObject.setFields(581,"userfield11");		
OXContactObject.setFields(582,"userfield12");		
OXContactObject.setFields(583,"userfield13");		
OXContactObject.setFields(584,"userfield14");		
OXContactObject.setFields(585,"userfield15");		
OXContactObject.setFields(586,"userfield16");		
OXContactObject.setFields(587,"userfield17");		
OXContactObject.setFields(588,"userfield18");		
OXContactObject.setFields(589,"userfield19");		
OXContactObject.setFields(590,"userfield20");		
OXContactObject.setFields(591,"links");		
OXContactObject.setFields(592,"distribution_list");		
OXContactObject.setFields(593,"context_id");
OXContactObject.setFields(594,"number_of_distribution_list");
OXContactObject.setFields(595,"number_of_links");
OXContactObject.setFields(596,"contains_image1");
OXContactObject.setFields(597,"image_last_modified");
OXContactObject.setFields(598,"state_other");
OXContactObject.setFields(599,"file_as");
OXContactObject.setFields(600,"attachment");
OXContactObject.setFields(601,"image1_content_type");
OXContactObject.setFields(602,"mark_as_distributionlist");
OXContactObject.setFields(605,"default_address");
OXContactObject.setFields(102,"color_label");
OXContactObject.setFields(524,"internal_userid");

function OXMailObject() {
	this.type="OXMailObject";
	this.module="mail";
}
OXMailObject.prototype = new OXObject;
OXMailObject.prototype.constructor = OXMailObject;
OXMailObject.idmapping = clone(OXObject.idmapping);
OXMailObject.stringmapping = clone(OXObject.stringmapping);
OXMailObject.unique = clone(OXObject.unique);
OXMailObject.setFields = function (id,stringname) {
	if(id) OXMailObject.idmapping[id]=stringname;
	if(stringname) OXMailObject.stringmapping[stringname]=id;
}
OXMailObject.setFields(600,"id");
OXMailObject.setFields(601,"folder_id");
OXMailObject.setFields(602,"attachment");
OXMailObject.setFields(603,"from");
OXMailObject.setFields(604,"to");
OXMailObject.setFields(605,"cc");
OXMailObject.setFields(606,"bcc");
OXMailObject.setFields(607,"subject");
OXMailObject.setFields(608,"size");
OXMailObject.setFields(609,"sent_date");
OXMailObject.setFields(610,"received_date");
OXMailObject.setFields(611,"flags");
OXMailObject.setFields(612,"level");
OXMailObject.setFields(613,"disp_notification_to");
OXMailObject.setFields(614,"priority");
OXMailObject.setFields(null,"user");
OXMailObject.setFields(null,"attachments");
OXMailObject.setFields(null,"nested_msgs");

function OXInfoStoreObject() {
	this.type="OXInfoStoreObject";
	this.module="infostore";
}
OXInfoStoreObject.prototype = new OXGroupwareObject;
OXInfoStoreObject.prototype.constructor = OXInfoStoreObject;
OXInfoStoreObject.idmapping = clone(OXGroupwareObject.idmapping);
OXInfoStoreObject.stringmapping = clone(OXGroupwareObject.stringmapping);
OXInfoStoreObject.unique = clone(OXGroupwareObject.unique);
OXInfoStoreObject.setFields = function (id,stringname) {
	if(id) OXInfoStoreObject.idmapping[id]=stringname;
	if(stringname) OXInfoStoreObject.stringmapping[stringname]=id;
}

OXInfoStoreObject.setFields(700,"title");
OXInfoStoreObject.setFields(701,"url");
OXInfoStoreObject.setFields(702,"filename");
OXInfoStoreObject.setFields(703,"file_mimetype");
OXInfoStoreObject.setFields(704,"file_size");
OXInfoStoreObject.setFields(705,"version");
OXInfoStoreObject.setFields(706,"description");
OXInfoStoreObject.setFields(707,"locked_until");
OXInfoStoreObject.setFields(708,"file_md5sum");
OXInfoStoreObject.setFields(709,"version_comment");
OXInfoStoreObject.setFields(710,"current_version");
OXInfoStoreObject.setFields(711,"number_of_versions");
OXInfoStoreObject.setFields(102,"color_label");

function OCDefaultGet(cache,objects,fields,cb,modified) {
	var createKey;
	function createDefaultKey(object,module) {
		if(object.constructor == Array) {
			return object[0];
		} else {
			return object.id;
		}
	}
	function createKeyCalendar(object,module) {
		if(object.constructor == Array) {
			return object[0]+":"+object[2];
		} else {
			return object.id+":"+object.recurrence_position;
		}
	}
	var updatedFolders=new Object();
 	var mymodule;
	if(objects.length>0) {
 		mymodule=objects[0].module;
 		if(mymodule=="calendar") { createKey=createKeyCalendar; }
 		else { createKey =createDefaultKey; }

 	}
 	var currenttimestamp=new Date().getTime();
 	function updateResponse(multiple) {
	 	var returnobjects=new Object;
 		var idcolumns=new Array();
 		var stringcolumns=new Array();
 		var modifiedobjects=new Object();
 		var deletedobjects=new Object();
 		var getobjects=new Array();
 		function updateObjectResponse(response) {
 			if(response && response.data) {
 				var newtimestamp=response.timestamp;
 				for(var i=0;i<response.data.length;i++) {
 					var newobject=response.data[i];
 					var cachedobject=cache.mrulist.get(mymodule+":"+createKey(newobject,mymodule));
 					if(!cachedobject) {
	 					var mycons = cache.getModuleObject(mymodule);
	 					cachedobject=new mycons();	 					
						cache.mrulist.set(mymodule+":"+createKey(newobject,mymodule),cachedobject);
						cachedobject.timestamp=newtimestamp;
						cachedobject.lastupdate=currenttimestamp;
 					} 
 					for(var param=0;param<newobject.length;param++) {
 						cachedobject.setValue(stringcolumns[param],newobject[param]);
 					}
 					if(cachedobject.lastupdate!=currenttimestamp) {
						if(cachedobject.timestamp!=newtimestamp) {
							modifiedobjects[newobject[0]]=true;
							//TMP FIX FOR UPDATE MUST BE REMOVED LATER -- START
							cachedobject.timestamp=newtimestamp;
							cachedobject.lastupdate=currenttimestamp;
							//TMP FIX -- END
						} else {
							cachedobject.lastupdate=currenttimestamp;
						}
 					}
 					
 					returnobjects[createKey(newobject,mymodule)]=cachedobject;	
 				}
 			}
 			for(var i=0;i<objects.length;i++) {
				if(modifiedobjects[objects[i].id] || deletedobjects[objects[i].id] || !returnobjects[createKey(objects[i],mymodule)]) {
				 	if(modified) { modified(returnobjects); cache.activerequests=false; cache.checkMoreRequests(); return; }
				} 
 			}
 			if(cb) { cb(returnobjects); cache.checkMoreRequests(); return; } 
 			cache.checkMoreRequests();
 		}
 		for(var i=0;i<multiple.length;i++) {
 			var single=multiple[i];
 			if(single.data) {
				for(var i2=0;i2<single.data.length;i2++) {
					var newobject=single.data[i2];
					if(newobject.length) {
						modifiedobjects[newobject[0]]=true;
					} else {
						deletedobjects[newobject]=true;
					}
				}
 			} else {
 				//ERRORHANDLING
 			}
 		}
 		var getfields=new Object();
 		for(var i=0;i<fields.length;i++) {
 			getfields[fields[i]]=true;
 		}
		for(var i=0;i<objects.length;i++) {
			var id=objects[i].id;
			var folder_id=objects[i].folder_id;
			var recurrence_position=objects[i].recurrence_position;
			var cachedobject;
			if(recurrence_position != undefined) {
			 	cachedobject= cache.mrulist.get(mymodule+":"+id+":"+recurrence_position);
			} else {
				cachedobject= cache.mrulist.get(mymodule+":"+id);
			}
		 	if(!cachedobject) {
		 		if(recurrence_position != undefined) { getobjects.push( { "id" : id, "folder" : folder_id, "recurrence_position" : recurrence_position });  } 
		 		else { getobjects.push( { "id" : id, "folder" : folder_id }); }
	 		} 
		 	else if(!cachedobject.hasValues(getfields)) {		
				var myfields=cachedobject.getFilledFields();
			 	for(var field in myfields) {
			 		if(!getfields[field]) {
				 		getfields[fields[i]]=true;	
			 		}
			 	}
		 		if(recurrence_position != undefined) { getobjects.push( { "id" : id, "folder" : folder_id, "recurrence_position" : recurrence_position });  } 
		 		else { getobjects.push( { "id" : id, "folder" : folder_id }); }
			} 
			else if(modifiedobjects[id]) {
				if(modifiedobjects[id]) {
			 		if(recurrence_position != undefined) { getobjects.push( { "id" : id, "folder" : folder_id, "recurrence_position" : recurrence_position });  } 
			 		else { getobjects.push( { "id" : id, "folder" : folder_id }); }
				}
			}
			else if(deletedobjects[id]) {
				cache.remove(mymodule+":"+createKey(objects[i],mymodule));
			} else {
				returnobjects[createKey(objects[i],mymodule)]=cachedobject;
				if(updatedFolders[cachedobject.folder_id]) {
					cachedobject.lastupdate=currenttimestamp;
				}
			} 
 		}
 		var localcons=cache.getModuleObject(mymodule);
 		for(var i=0;i<localcons.unique.length;i++) {
	 		idcolumns.push(localcons.stringmapping[localcons.unique[i]]);
			stringcolumns.push(localcons.unique[i]);
 		}
 		for(var i in getfields) {
 			idcolumns.push(cache.getModuleObject(mymodule).stringmapping[i]);
 			stringcolumns.push(i);
 		}
 		
 		if(getobjects.length) {
 			var json=new JSON();
 			json.put(AjaxRoot + "/"+mymodule+"?action=list&session=" + session +"&columns="+idcolumns.join(","),getobjects, null, updateObjectResponse);
 		} else {
 			updateObjectResponse(new Array());
 		}
 	}	
// REAL FUNCTION
	var myfolders=new Object();
 	for(var i=0;i<objects.length;i++) {
		if(!myfolders[objects[i].folder_id]) {
 			myfolders[objects[i].folder_id]=new Object();
 		}
 		var myid=mymodule+":"+objects[i].id;
 		if(objects[i].recurrence_position != undefined) {
 			myid = myid +":"+ objects[i].recurrence_position;
 		}
 		var cachedobject=cache.mrulist.get(myid);
		var timestamp=0;
		var lastupdate=0;
		if(cachedobject) {
			timestamp=cachedobject.getTimestamp();
			lastupdate=cachedobject.getLastUpdate();
		}
		if(!myfolders[objects[i].folder_id]["timestamp"] || myfolders[objects[i].folder_id]["timestamp"]> timestamp) {
			myfolders[objects[i].folder_id]["timestamp"] = timestamp;
		}
		if(!myfolders[objects[i].folder_id]["lastupdate"] || myfolders[objects[i].folder_id]["lastupdate"]> lastupdate) {
			myfolders[objects[i].folder_id]["lastupdate"] = lastupdate;
		}
 	}
 	//CHECK FOR UPDATES
	var requests=new Array();
 	for(var i in myfolders) {
 		if(myfolders[i]["lastupdate"]<(currenttimestamp-cache.updatemilliseconds)) {
 			
 			var requestObject=new Object();
			requestObject["module"] = mymodule;
			requestObject["action"] = 'updates';
			requestObject["columns"] = '1';
			requestObject["folder"] = i;
			requestObject["timestamp"] = myfolders[i]["timestamp"]+1; //Millisecond add
			requests.push(requestObject);
			updatedFolders[i]=true;
 		}
 	}
	if(requests.length>0) {
		var json2=new JSON();
		json2.put(AjaxRoot + "/multiple?session=" + session,requests,null,updateResponse);
	} else {
		updateResponse(new Array());
	}
}
objectcache.setModuleObject(OXInfoStoreObject,"infostore");
objectcache.setModuleObject(OXTaskObject,"tasks");
objectcache.setModuleObject(OXContactObject,"contacts");
objectcache.setModuleObject(OXCalendarObject,"calendar");

objectcache.setRule("infostore","get",OCDefaultGet);
objectcache.setRule("tasks","get",OCDefaultGet);
objectcache.setRule("contacts","get",OCDefaultGet);
objectcache.setRule("calendar","get",OCDefaultGet);
fileloaded();