/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.TzOffsetFrom;
import net.fortuna.ical4j.model.property.TzOffsetTo;
import net.fortuna.ical4j.util.Dates;
import net.fortuna.ical4j.util.PropertyValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Observance
extends Component
implements Comparable {
    public static final String STANDARD = "STANDARD";
    public static final String DAYLIGHT = "DAYLIGHT";
    private transient Log log = LogFactory.getLog((Class)Observance.class);
    private Map onsets = new TreeMap();
    private Date onsetLimit;
    private boolean rdatesCached = false;

    protected Observance(String name) {
        super(name);
    }

    protected Observance(String name, PropertyList properties) {
        super(name, properties);
    }

    public final void validate(boolean recurse) throws ValidationException {
        PropertyValidator.getInstance().assertOne("TZOFFSETFROM", this.getProperties());
        PropertyValidator.getInstance().assertOne("TZOFFSETTO", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTSTART", this.getProperties());
        if (recurse) {
            this.validateProperties();
        }
    }

    public final Date getLatestOnset(Date date) {
        Date initialOnset = ((DtStart)this.getProperty("DTSTART")).getDate();
        if (date.before(initialOnset)) {
            return null;
        }
        long start = System.currentTimeMillis();
        if (this.onsetLimit != null && date.after(this.onsetLimit)) {
            this.onsets.clear();
            this.rdatesCached = false;
        }
        Date onset = this.getCachedOnset(date);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cache " + (onset != null ? "hit" : "miss") + " - retrieval time: " + (System.currentTimeMillis() - start) + "ms"));
        }
        if (onset == null) {
            onset = initialOnset;
            DateList cacheableOnsets = new DateList();
            if (!this.rdatesCached) {
                PropertyList rdates = this.getProperties("RDATE");
                Iterator i = rdates.iterator();
                while (i.hasNext()) {
                    RDate rdate = (RDate)i.next();
                    Iterator j = rdate.getDates().iterator();
                    while (j.hasNext()) {
                        Date rdateOnset = (Date)j.next();
                        if (!rdateOnset.after(date) && rdateOnset.after(onset)) {
                            onset = rdateOnset;
                        }
                        cacheableOnsets.add(rdateOnset);
                    }
                }
                this.rdatesCached = true;
            }
            PropertyList rrules = this.getProperties("RRULE");
            Value dateType = date instanceof DateTime ? Value.DATE_TIME : Value.DATE;
            Iterator i = rrules.iterator();
            while (i.hasNext()) {
                RRule rrule = (RRule)i.next();
                Calendar cal = Dates.getCalendarInstance(date);
                cal.setTime(date);
                cal.add(1, 10);
                this.onsetLimit = Dates.getInstance(cal.getTime(), dateType);
                DateList recurrenceDates = rrule.getRecur().getDates(onset, this.onsetLimit, dateType);
                Iterator j = recurrenceDates.iterator();
                while (j.hasNext()) {
                    Date rruleOnset = (Date)j.next();
                    if (!rruleOnset.after(date) && rruleOnset.after(onset)) {
                        onset = rruleOnset;
                    }
                    cacheableOnsets.add(rruleOnset);
                }
            }
            Collections.sort(cacheableOnsets);
            Date cacheableOnset = null;
            Date nextOnset = null;
            Iterator i2 = cacheableOnsets.iterator();
            while (i2.hasNext()) {
                cacheableOnset = nextOnset;
                nextOnset = (Date)i2.next();
                if (cacheableOnset == null) continue;
                this.onsets.put(new Period(new DateTime(cacheableOnset), new DateTime(nextOnset)), cacheableOnset);
            }
            if (nextOnset != null) {
                Calendar finalOnsetPeriodEnd = Calendar.getInstance();
                finalOnsetPeriodEnd.setTime(nextOnset);
                finalOnsetPeriodEnd.add(1, 100);
                this.onsets.put(new Period(new DateTime(nextOnset), new DateTime(finalOnsetPeriodEnd.getTime())), nextOnset);
            }
        }
        return onset;
    }

    private Date getCachedOnset(Date date) {
        Iterator i = this.onsets.keySet().iterator();
        while (i.hasNext()) {
            Period onsetPeriod = (Period)i.next();
            if (!onsetPeriod.includes((java.util.Date)date, 1)) continue;
            return (Date)this.onsets.get(onsetPeriod);
        }
        return null;
    }

    public final DtStart getStartDate() {
        return (DtStart)this.getProperty("DTSTART");
    }

    public final TzOffsetFrom getOffsetFrom() {
        return (TzOffsetFrom)this.getProperty("TZOFFSETFROM");
    }

    public final TzOffsetTo getOffsetTo() {
        return (TzOffsetTo)this.getProperty("TZOFFSETTO");
    }

    public final int compareTo(Object arg0) {
        return this.compareTo((Observance)arg0);
    }

    public final int compareTo(Observance arg0) {
        DtStart dtStart = (DtStart)this.getProperty("DTSTART");
        DtStart dtStart0 = (DtStart)arg0.getProperty("DTSTART");
        return dtStart.getDate().compareTo(dtStart0.getDate());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.log = LogFactory.getLog((Class)Observance.class);
    }
}

