/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.update;

import com.openexchange.groupware.Init;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.server.impl.DBPool;
import com.openexchange.tools.update.ForeignKeyOld;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import junit.framework.TestCase;

public class ForeignKeyTest
extends TestCase {
    private Context ctx;
    private Connection con;

    public void setUp() throws Exception {
        Init.startServer();
        ContextStorage ctxstor = ContextStorage.getInstance();
        int contextId = ctxstor.getContextId("defaultcontext");
        this.ctx = ctxstor.getContext(contextId);
        this.con = DBPool.pickupWriteable((Context)this.ctx);
        this._sql_update("CREATE TABLE test_parent (id int, PRIMARY KEY (id)) ENGINE=InnoDB");
        this._sql_update("CREATE TABLE test_child (parent_id int, FOREIGN KEY (parent_id) REFERENCES test_parent(id)) ENGINE=InnoDB");
    }

    public void tearDown() throws Exception {
        this._sql_update("DROP TABLE test_child");
        this._sql_update("DROP TABLE test_parent");
        DBPool.closeWriterSilent((Context)this.ctx, (Connection)this.con);
        Init.stopServer();
    }

    public void testDiscoverForeignKeys() throws SQLException {
        List foreignKeys = ForeignKeyOld.getForeignKeys((Connection)this.con, (String)"test_child");
        ForeignKeyTest.assertNotNull((Object)foreignKeys);
        ForeignKeyTest.assertEquals((int)1, (int)foreignKeys.size());
        ForeignKeyOld key = (ForeignKeyOld)foreignKeys.get(0);
        ForeignKeyTest.assertEquals((String)"test_child", (String)key.getSourceTable());
        ForeignKeyTest.assertEquals((String)"test_parent", (String)key.getTargetTable());
        ForeignKeyTest.assertEquals((String)"parent_id", (String)key.getSourceColumn());
        ForeignKeyTest.assertEquals((String)"id", (String)key.getTargetColumn());
        ForeignKeyTest.assertNotNull((Object)key.getName());
    }

    public void testDropForeignKey() throws SQLException {
        new ForeignKeyOld("test_child", "parent_id", "test_parent", "id").drop(this.con);
        List foreignKeys = ForeignKeyOld.getForeignKeys((Connection)this.con, (String)"test_child");
        ForeignKeyTest.assertTrue((boolean)foreignKeys.isEmpty());
    }

    public void testCreateForeignKey() throws SQLException {
        ForeignKeyOld key = new ForeignKeyOld("test_child", "parent_id", "test_parent", "id");
        key.drop(this.con);
        List foreignKeys = ForeignKeyOld.getForeignKeys((Connection)this.con, (String)"test_child");
        ForeignKeyTest.assertTrue((boolean)foreignKeys.isEmpty());
        key.create(this.con);
        foreignKeys = ForeignKeyOld.getForeignKeys((Connection)this.con, (String)"test_child");
        ForeignKeyTest.assertEquals((int)1, (int)foreignKeys.size());
        ForeignKeyTest.assertEquals((Object)key, foreignKeys.get(0));
    }

    public void testCreateIfNotExists() throws SQLException {
        ForeignKeyOld key = new ForeignKeyOld("test_child", "parent_id", "test_parent", "id");
        key.createIfNotExists(this.con);
        key.drop(this.con);
        key.createIfNotExists(this.con);
        List foreignKeys = ForeignKeyOld.getForeignKeys((Connection)this.con, (String)"test_child");
        ForeignKeyTest.assertEquals((int)1, (int)foreignKeys.size());
        ForeignKeyTest.assertEquals((Object)key, foreignKeys.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _sql_update(String sql) throws Exception {
        try (Statement stmt = null;){
            stmt = this.con.createStatement();
            stmt.executeUpdate(sql);
        }
    }
}

