/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.calendar.CalendarSql;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.importexport.AbstractICalImportTest;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.importexport.formats.Format;
import com.openexchange.session.Session;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class Bug7732Test
extends AbstractICalImportTest {
    public static Test suite() {
        return new JUnit4TestAdapter(Bug7732Test.class);
    }

    @org.junit.Test
    public void test7732() throws OXException, SQLException, UnsupportedEncodingException, OXException, NumberFormatException, OXException, OXException {
        int count = 10;
        String ical = "BEGIN:VCALENDAR\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nVERSION:2.0\nMETHOD:PUBLISH\nBEGIN:VEVENT\nCLASS:PUBLIC\nCREATED:20070531T130514Z\nDESCRIPTION:\\n\nDTEND:20070912T083000Z\nDTSTAMP:20070531T130514Z\nDTSTART:20070912T080000Z\nLAST-MODIFIED:20070531T130514Z\nLOCATION:loc\nPRIORITY:5\nRRULE:FREQ=DAILY;COUNT=10\nSEQUENCE:0\nSUMMARY;LANGUAGE=de:Daily iCal\nTRANSP:OPAQUE\nUID:040000008200E00074C5B7101A82E008000000005059CADA94A3C701000000000000000010000000A1B56CAC71BB0948833B0C11C333ADB0\nEND:VEVENT\nEND:VCALENDAR";
        ImportResult res = this.performOneEntryCheck("BEGIN:VCALENDAR\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nVERSION:2.0\nMETHOD:PUBLISH\nBEGIN:VEVENT\nCLASS:PUBLIC\nCREATED:20070531T130514Z\nDESCRIPTION:\\n\nDTEND:20070912T083000Z\nDTSTAMP:20070531T130514Z\nDTSTART:20070912T080000Z\nLAST-MODIFIED:20070531T130514Z\nLOCATION:loc\nPRIORITY:5\nRRULE:FREQ=DAILY;COUNT=10\nSEQUENCE:0\nSUMMARY;LANGUAGE=de:Daily iCal\nTRANSP:OPAQUE\nUID:040000008200E00074C5B7101A82E008000000005059CADA94A3C701000000000000000010000000A1B56CAC71BB0948833B0C11C333ADB0\nEND:VEVENT\nEND:VCALENDAR", Format.ICAL, 2, "7732", ctx, false);
        CalendarSql appointmentSql = new CalendarSql((Session)sessObj);
        CalendarDataObject appointmentObj = appointmentSql.getObjectById(Integer.parseInt(res.getObjectId()), folderId);
        Assert.assertEquals((String)"10 occurences found?", (long)10L, (long)appointmentObj.getOccurrence());
    }

    @org.junit.Test
    public void testMeaningfulParserMessage() throws Exception {
        String ical = "BEGIN:VCALENDAR\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nVERSION:2.0\nMETHOD:PUBLISH\nBEGIN:VEVENT\nDESCRIPTION:Daily for 10 occurrences:\nDTSTAMP:20070102T053656Z\nRRULE:FREQ=DAILY;COUNT=10\nSUMMARY:RExample01\nUID:RExample01\nEND:VEVENT\nEND:VCALENDAR";
        ImportResult res = this.performOneEntryCheck("BEGIN:VCALENDAR\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nVERSION:2.0\nMETHOD:PUBLISH\nBEGIN:VEVENT\nDESCRIPTION:Daily for 10 occurrences:\nDTSTAMP:20070102T053656Z\nRRULE:FREQ=DAILY;COUNT=10\nSUMMARY:RExample01\nUID:RExample01\nEND:VEVENT\nEND:VCALENDAR", Format.ICAL, 2, "7732-b", ctx, true);
        Assert.assertTrue((boolean)res.hasError());
        OXException x = res.getException();
        x.printStackTrace();
        Assert.assertTrue((String)x.getMessage(), (boolean)x.getMessage().contains("Missing DTSTART"));
    }
}

