/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.actions;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.actions.AbstractAttachmentEventActionTest;
import com.openexchange.groupware.attach.impl.FireDetachedEventAction;
import com.openexchange.tx.UndoableAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class FireDetachedEventActionTest
extends AbstractAttachmentEventActionTest {
    private final AbstractAttachmentEventActionTest.MockAttachmentListener listener = new AbstractAttachmentEventActionTest.MockAttachmentListener();
    private AbstractAttachmentEventActionTest.MockDBProvider provider = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.provider = new AbstractAttachmentEventActionTest.MockDBProvider((DBProvider)new DBPoolProvider());
    }

    @Override
    protected UndoableAction getAction() throws Exception {
        FireDetachedEventAction fireDetached = new FireDetachedEventAction();
        fireDetached.setAttachments(this.getAttachments());
        fireDetached.setContext(this.getContext());
        fireDetached.setUser(this.getUser());
        fireDetached.setUserConfiguration(null);
        fireDetached.setProvider((DBProvider)this.provider);
        ArrayList<AbstractAttachmentEventActionTest.MockAttachmentListener> listeners = new ArrayList<AbstractAttachmentEventActionTest.MockAttachmentListener>();
        listeners.add(this.listener);
        fireDetached.setAttachmentListeners(listeners);
        fireDetached.setSource(this.getAttachmentBase());
        return fireDetached;
    }

    @Override
    protected void verifyPerformed() throws Exception {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (AttachmentMetadata m : this.getAttachments()) {
            ids.add(m.getId());
        }
        Iterator<Object> i$ = this.listener.getDetached().iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            FireDetachedEventActionTest.assertTrue((boolean)ids.remove(id));
        }
        FireDetachedEventActionTest.assertTrue((boolean)ids.isEmpty());
        this.listener.clear();
        FireDetachedEventActionTest.assertTrue((String)this.provider.getStatus(), (boolean)this.provider.allOK());
        FireDetachedEventActionTest.assertTrue((String)this.provider.getStatus(), (boolean)this.provider.called());
    }

    @Override
    protected void verifyUndone() throws Exception {
        List<AttachmentMetadata> m = this.listener.getAttached();
        HashMap<Integer, AttachmentMetadata> attachmentMap = new HashMap<Integer, AttachmentMetadata>();
        HashSet<AttachmentMetadata> attachmentSet = new HashSet<AttachmentMetadata>();
        for (AttachmentMetadata att : this.getAttachments()) {
            attachmentMap.put(att.getId(), att);
            attachmentSet.add(att);
        }
        for (AttachmentMetadata attached : m) {
            AttachmentMetadata orig = (AttachmentMetadata)attachmentMap.get(attached.getId());
            FireDetachedEventActionTest.assertEquals(orig, attached);
            FireDetachedEventActionTest.assertTrue((boolean)attachmentSet.remove(attached));
        }
        FireDetachedEventActionTest.assertTrue((boolean)attachmentSet.isEmpty());
        this.listener.clear();
        FireDetachedEventActionTest.assertTrue((boolean)this.provider.allOK());
        FireDetachedEventActionTest.assertTrue((boolean)this.provider.called());
    }
}

