/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.tests;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class AlarmTestLightning
extends CalDAVTest {
    @Override
    protected String getDefaultUserAgent() {
        return "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:38.0) Gecko/20100101 Thunderbird/38.3.0 Lightning/4.0.3.1";
    }

    @Test
    public void testAcknowledgeReminder() throws Exception {
        String uid = AlarmTestLightning.randomUID();
        Date start = TimeTools.D("next sunday at 16:00");
        Date end = TimeTools.D("next sunday at 17:00");
        String iCal = "BEGIN:VCALENDAR\r\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nLAST-MODIFIED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:test\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestLightning.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestLightning.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "CLASS:PUBLIC\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "TRIGGER;VALUE=DURATION:-PT15M\r\n" + "DESCRIPTION:Mozilla Standardbeschreibung\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Date acknowledgedDate = TimeTools.D("next sunday at 15:47:32");
        iCal = "BEGIN:VCALENDAR\r\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nLAST-MODIFIED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:test\r\n" + "X-MOZ-LASTACK:" + AlarmTestLightning.formatAsUTC(acknowledgedDate) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestLightning.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestLightning.format(end, "Europe/Berlin") + "\r\n" + "CLASS:PUBLIC\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "TRANSP:OPAQUE\r\n" + "SEQUENCE:0\r\n" + "X-MOZ-GENERATION:1\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "TRIGGER;VALUE=DURATION:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "X-LIC-ERROR;X-LIC-ERRORTYPE=PROPERTY-PARSE-ERROR:Parse error in property n\r\n" + " ame: ACKNOWLEDGED\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertFalse((String)"reminder still found", (boolean)appointment.containsAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNull((String)"ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
    }

    @Test
    public void testSnoozeReminder() throws Exception {
        String uid = AlarmTestLightning.randomUID();
        Date start = TimeTools.D("next sunday at 16:00");
        Date end = TimeTools.D("next sunday at 17:00");
        String iCal = "BEGIN:VCALENDAR\r\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nLAST-MODIFIED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:test\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestLightning.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestLightning.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "CLASS:PUBLIC\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "TRIGGER;VALUE=DURATION:-PT15M\r\n" + "DESCRIPTION:Mozilla Standardbeschreibung\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Date acknowledgedDate = TimeTools.D("next sunday at 15:47:32");
        Date nextTrigger = TimeTools.D("next sunday at 15:52:32");
        Date nextAcknowledged = TimeTools.D("next sunday at 15:51:32");
        iCal = "BEGIN:VCALENDAR\r\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nLAST-MODIFIED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:test\r\n" + "X-MOZ-LASTACK:" + AlarmTestLightning.formatAsUTC(acknowledgedDate) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestLightning.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestLightning.format(end, "Europe/Berlin") + "\r\n" + "CLASS:PUBLIC\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "TRANSP:OPAQUE\r\n" + "SEQUENCE:0\r\n" + "X-MOZ-SNOOZE-TIME:" + AlarmTestLightning.formatAsUTC(nextTrigger) + "\r\n" + "X-MOZ-GENERATION:1\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "TRIGGER;VALUE=DURATION:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "X-LIC-ERROR;X-LIC-ERRORTYPE=PROPERTY-PARSE-ERROR:Parse error in property n\r\n" + " ame: ACKNOWLEDGED\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestLightning.formatAsUTC(nextAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertEquals((String)"X-MOZ-SNOOZE-TIME wrong", (Object)AlarmTestLightning.formatAsUTC(nextTrigger), (Object)iCalResource.getVEvent().getPropertyValue("X-MOZ-SNOOZE-TIME"));
    }

    @Test
    public void testEditReminder() throws Exception {
        String uid = AlarmTestLightning.randomUID();
        Date start = TimeTools.D("next sunday at 16:00");
        Date end = TimeTools.D("next sunday at 17:00");
        String iCal = "BEGIN:VCALENDAR\r\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nLAST-MODIFIED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:test\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestLightning.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestLightning.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "CLASS:PUBLIC\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "TRIGGER;VALUE=DURATION:-PT15M\r\n" + "DESCRIPTION:Mozilla Standardbeschreibung\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        iCal = "BEGIN:VCALENDAR\r\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nLAST-MODIFIED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:test\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestLightning.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestLightning.format(end, "Europe/Berlin") + "\r\n" + "CLASS:PUBLIC\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "TRANSP:OPAQUE\r\n" + "SEQUENCE:0\r\n" + "X-MOZ-GENERATION:1\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "TRIGGER;VALUE=DURATION:-PT20M\r\n" + "DESCRIPTION:Mozilla Standardbeschreibung\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)20L, (long)appointment.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT20M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
    }

    @Test
    public void testAcknowledgeRecurringReminder() throws Exception {
        String uid = AlarmTestLightning.randomUID();
        Date start = TimeTools.D("next saturday at 15:30");
        Date end = TimeTools.D("next saturday at 17:15");
        Date initialAcknowledged = TimeTools.D("next saturday at 15:14");
        String iCal = "BEGIN:VCALENDAR\r\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:recurring\r\n" + "RRULE:FREQ=DAILY\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestLightning.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestLightning.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "CLASS:PUBLIC\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "TRIGGER;VALUE=DURATION:-PT15M\r\n" + "DESCRIPTION:Mozilla Standardbeschreibung\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(initialAcknowledged);
        calendar.add(5, 1);
        Date nextAcknowledged = calendar.getTime();
        calendar.setTime(initialAcknowledged);
        calendar.add(12, 3);
        calendar.add(13, 17);
        Date acknowledgedDate = calendar.getTime();
        iCal = "BEGIN:VCALENDAR\r\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:recurring\r\n" + "RRULE:FREQ=DAILY\r\n" + "X-MOZ-LASTACK:" + AlarmTestLightning.formatAsUTC(acknowledgedDate) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestLightning.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestLightning.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "X-MOZ-GENERATION:1\r\n" + "CLASS:PUBLIC\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "TRIGGER;VALUE=DURATION:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "X-LIC-ERROR;X-LIC-ERRORTYPE=PROPERTY-PARSE-ERROR:Parse error in property n\r\n" + " ame: ACKNOWLEDGED\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestLightning.formatAsUTC(nextAcknowledged), (Object)iCalResource.getVEvent().getPropertyValue("X-MOZ-LASTACK"));
    }

    @Test
    public void testSnoozeRecurringReminder() throws Exception {
        String uid = AlarmTestLightning.randomUID();
        Date start = TimeTools.D("next friday at 10:00");
        Date end = TimeTools.D("next friday at 10:15");
        String iCal = "BEGIN:VCALENDAR\r\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:recurring\r\n" + "RRULE:FREQ=DAILY\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestLightning.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestLightning.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "CLASS:PUBLIC\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "TRIGGER;VALUE=DURATION:-PT15M\r\n" + "DESCRIPTION:Mozilla Standardbeschreibung\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Date acknowledgedDate = TimeTools.D("next friday at 09:46:24");
        Date nextTrigger = TimeTools.D("next friday at 09:51:24");
        Date nextAcknowledged = TimeTools.D("next friday at 09:50:24");
        iCal = "BEGIN:VCALENDAR\r\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:recurring\r\n" + "RRULE:FREQ=DAILY\r\n" + "X-MOZ-LASTACK:" + AlarmTestLightning.formatAsUTC(acknowledgedDate) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestLightning.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestLightning.format(end, "Europe/Berlin") + "\r\n" + "CLASS:PUBLIC\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "TRANSP:OPAQUE\r\n" + "SEQUENCE:0\r\n" + "X-MOZ-SNOOZE-TIME-" + start.getTime() + "000:" + AlarmTestLightning.formatAsUTC(nextTrigger) + "\r\n" + "X-MOZ-GENERATION:1\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "TRIGGER;VALUE=DURATION:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "X-LIC-ERROR;X-LIC-ERRORTYPE=PROPERTY-PARSE-ERROR:Parse error in property n\r\n" + " ame: ACKNOWLEDGED\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestLightning.formatAsUTC(nextAcknowledged), (Object)iCalResource.getVEvent().getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertEquals((String)"X-MOZ-SNOOZE-TIME wrong", (Object)AlarmTestLightning.formatAsUTC(nextTrigger), (Object)iCalResource.getVEvent().getPropertyValue("X-MOZ-SNOOZE-TIME-" + start.getTime() + "000"));
    }

    @Test
    public void testAcknowledgeExceptionReminder() throws Exception {
        String uid = AlarmTestLightning.randomUID();
        Date start = TimeTools.D("next friday at 10:00");
        Date end = TimeTools.D("next friday at 11:00");
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(start);
        calendar.add(5, 2);
        Date exceptionStart = calendar.getTime();
        calendar.add(10, 1);
        Date exceptionEnd = calendar.getTime();
        calendar.setTime(exceptionStart);
        calendar.add(12, -16);
        calendar.add(5, 1);
        Date seriesAcknowledged = calendar.getTime();
        String iCal = "BEGIN:VCALENDAR\r\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:sdfs\r\n" + "RRULE:FREQ=DAILY\r\n" + "X-MOZ-LASTACK:" + AlarmTestLightning.formatAsUTC(seriesAcknowledged) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestLightning.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestLightning.format(end, "Europe/Berlin") + "\r\n" + "CLASS:PUBLIC\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "TRANSP:OPAQUE\r\n" + "SEQUENCE:0\r\n" + "X-MOZ-GENERATION:1\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "TRIGGER;VALUE=DURATION:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "X-LIC-ERROR;X-LIC-ERRORTYPE=PROPERTY-PARSE-ERROR:Parse error in property n\r\n" + " ame: ACKNOWLEDGED\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "CREATED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:edit\r\n" + "RECURRENCE-ID:" + AlarmTestLightning.formatAsUTC(exceptionStart) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestLightning.format(exceptionStart, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestLightning.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "CLASS:PUBLIC\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "SEQUENCE:0\r\n" + "X-MOZ-GENERATION:1\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "TRIGGER;VALUE=DURATION:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "X-LIC-ERROR;X-LIC-ERRORTYPE=PROPERTY-PARSE-ERROR:Parse error in property n\r\n" + " ame: ACKNOWLEDGED\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertNotNull((String)"No change exceptions found on server", (Object)appointment.getChangeException());
        Assert.assertEquals((String)"Unexpected number of change excpetions", (long)1L, (long)appointment.getChangeException().length);
        Appointment changeExcpetion = this.getChangeExcpetions(appointment).get(0);
        this.rememberForCleanUp(changeExcpetion);
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)changeExcpetion.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestLightning.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestLightning.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertEquals((String)"Not all VEVENTs in iCal found", (long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvents().get(1).getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)"edit", (Object)iCalResource.getVEvents().get(1).getSummary());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvents().get(1).getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvents().get(1).getVAlarm().getPropertyValue("TRIGGER"));
        calendar.setTime(exceptionStart);
        calendar.add(12, -14);
        calendar.add(13, 52);
        Date exceptionAcknowledged = calendar.getTime();
        iCal = "BEGIN:VCALENDAR\r\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:sdfs\r\n" + "RRULE:FREQ=DAILY\r\n" + "X-MOZ-LASTACK:" + AlarmTestLightning.formatAsUTC(exceptionAcknowledged) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestLightning.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestLightning.format(end, "Europe/Berlin") + "\r\n" + "CLASS:PUBLIC\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "TRANSP:OPAQUE\r\n" + "SEQUENCE:0\r\n" + "X-MOZ-GENERATION:1\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "TRIGGER;VALUE=DURATION:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "X-LIC-ERROR;X-LIC-ERRORTYPE=PROPERTY-PARSE-ERROR:Parse error in property n\r\n" + " ame: ACKNOWLEDGED\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "CREATED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:edit\r\n" + "RECURRENCE-ID:" + AlarmTestLightning.formatAsUTC(exceptionStart) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestLightning.format(exceptionStart, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestLightning.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "CLASS:PUBLIC\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "SEQUENCE:0\r\n" + "X-MOZ-GENERATION:1\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "TRIGGER;VALUE=DURATION:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "X-LIC-ERROR;X-LIC-ERRORTYPE=PROPERTY-PARSE-ERROR:Parse error in property n\r\n" + " ame: ACKNOWLEDGED\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertNotNull((String)"No change exceptions found on server", (Object)appointment.getChangeException());
        Assert.assertEquals((String)"Unexpected number of change excpetions", (long)1L, (long)appointment.getChangeException().length);
        changeExcpetion = this.getChangeExcpetions(appointment).get(0);
        this.rememberForCleanUp(changeExcpetion);
        Assert.assertFalse((String)"reminder still found", (boolean)changeExcpetion.containsAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestLightning.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestLightning.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertEquals((String)"Not all VEVENTs in iCal found", (long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvents().get(1).getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)"edit", (Object)iCalResource.getVEvents().get(1).getSummary());
        Assert.assertNull((String)"ALARM in iCal exception found", (Object)iCalResource.getVEvents().get(1).getVAlarm());
    }

    @Test
    public void testSnoozeExceptionReminder() throws Exception {
        String uid = AlarmTestLightning.randomUID();
        Date start = TimeTools.D("next friday at 10:00");
        Date end = TimeTools.D("next friday at 11:00");
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(start);
        calendar.add(5, 2);
        Date exceptionStart = calendar.getTime();
        calendar.add(10, 1);
        Date exceptionEnd = calendar.getTime();
        calendar.setTime(exceptionStart);
        calendar.add(12, -16);
        calendar.add(5, 1);
        Date seriesAcknowledged = calendar.getTime();
        String iCal = "BEGIN:VCALENDAR\r\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:sdfs\r\n" + "RRULE:FREQ=DAILY\r\n" + "X-MOZ-LASTACK:" + AlarmTestLightning.formatAsUTC(seriesAcknowledged) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestLightning.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestLightning.format(end, "Europe/Berlin") + "\r\n" + "CLASS:PUBLIC\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "TRANSP:OPAQUE\r\n" + "SEQUENCE:0\r\n" + "X-MOZ-GENERATION:1\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "TRIGGER;VALUE=DURATION:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "X-LIC-ERROR;X-LIC-ERRORTYPE=PROPERTY-PARSE-ERROR:Parse error in property n\r\n" + " ame: ACKNOWLEDGED\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "CREATED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:edit\r\n" + "RECURRENCE-ID:" + AlarmTestLightning.formatAsUTC(exceptionStart) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestLightning.format(exceptionStart, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestLightning.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "CLASS:PUBLIC\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "SEQUENCE:0\r\n" + "X-MOZ-GENERATION:1\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "TRIGGER;VALUE=DURATION:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "X-LIC-ERROR;X-LIC-ERRORTYPE=PROPERTY-PARSE-ERROR:Parse error in property n\r\n" + " ame: ACKNOWLEDGED\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertNotNull((String)"No change exceptions found on server", (Object)appointment.getChangeException());
        Assert.assertEquals((String)"Unexpected number of change excpetions", (long)1L, (long)appointment.getChangeException().length);
        Appointment changeExcpetion = this.getChangeExcpetions(appointment).get(0);
        this.rememberForCleanUp(changeExcpetion);
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)changeExcpetion.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestLightning.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestLightning.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertEquals((String)"Not all VEVENTs in iCal found", (long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvents().get(1).getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)"edit", (Object)iCalResource.getVEvents().get(1).getSummary());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvents().get(1).getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvents().get(1).getVAlarm().getPropertyValue("TRIGGER"));
        calendar.setTime(exceptionStart);
        calendar.add(12, -14);
        calendar.add(13, 52);
        Date exceptionAcknowledged = calendar.getTime();
        calendar.add(12, 5);
        Date nextTrigger = calendar.getTime();
        iCal = "BEGIN:VCALENDAR\r\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:sdfs\r\n" + "RRULE:FREQ=DAILY\r\n" + "X-MOZ-LASTACK:" + AlarmTestLightning.formatAsUTC(exceptionAcknowledged) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestLightning.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestLightning.format(end, "Europe/Berlin") + "\r\n" + "CLASS:PUBLIC\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "TRANSP:OPAQUE\r\n" + "SEQUENCE:0\r\n" + "X-MOZ-SNOOZE-TIME-" + exceptionStart.getTime() + "000:" + AlarmTestLightning.formatAsUTC(nextTrigger) + "\r\n" + "X-MOZ-GENERATION:1\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "TRIGGER;VALUE=DURATION:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "X-LIC-ERROR;X-LIC-ERRORTYPE=PROPERTY-PARSE-ERROR:Parse error in property n\r\n" + " ame: ACKNOWLEDGED\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "CREATED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestLightning.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:edit\r\n" + "RECURRENCE-ID:" + AlarmTestLightning.formatAsUTC(exceptionStart) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestLightning.format(exceptionStart, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestLightning.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "CLASS:PUBLIC\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "SEQUENCE:0\r\n" + "X-MOZ-GENERATION:1\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "TRIGGER;VALUE=DURATION:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "X-LIC-ERROR;X-LIC-ERRORTYPE=PROPERTY-PARSE-ERROR:Parse error in property n\r\n" + " ame: ACKNOWLEDGED\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
    }
}

