/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.folder.actions.VisibleFoldersRequest;
import com.openexchange.ajax.folder.actions.VisibleFoldersResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.oauth.provider.AbstractOAuthTest;
import com.openexchange.ajax.oauth.provider.OAuthSession;
import com.openexchange.ajax.oauth.provider.protocol.Grant;
import com.openexchange.ajax.oauth.provider.protocol.OAuthParams;
import com.openexchange.ajax.oauth.provider.protocol.Protocol;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.dav.Config;
import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.SyncToken;
import com.openexchange.dav.WebDAVClient;
import com.openexchange.dav.reports.SyncCollectionReportInfo;
import com.openexchange.dav.reports.SyncCollectionResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.util.UUIDs;
import com.openexchange.oauth.provider.rmi.client.ClientDto;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.json.JSONException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runners.Parameterized;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class WebDAVTest {
    protected static final int TIMEOUT = 10000;
    private List<FolderObject> foldersToCleanUp;
    private Map<Long, WebDAVClient> webDAVClients;
    protected AJAXClient client;
    protected static final String AUTH_METHOD_BASIC = "Basic Auth";
    protected static final String AUTH_METHOD_OAUTH = "OAuth";
    protected static ClientDto oAuthClientApp;
    protected static Grant oAuthGrant;
    @Parameterized.Parameter(value=0)
    public String authMethod;

    @BeforeClass
    public static void prepareFramework() throws OXException {
        AJAXConfig.init();
    }

    protected static Iterable<Object[]> availableAuthMethods() {
        ArrayList<Object[]> authMethods = new ArrayList<Object[]>(2);
        authMethods.add(new Object[]{AUTH_METHOD_BASIC});
        authMethods.add(new Object[]{AUTH_METHOD_OAUTH});
        return authMethods;
    }

    @Before
    public void prepareOAuthClient() throws Exception {
        if (this.testOAuth() && oAuthClientApp == null && oAuthGrant == null) {
            oAuthClientApp = AbstractOAuthTest.registerTestClient();
            DefaultHttpClient client = OAuthSession.newOAuthHttpClient();
            String state = UUIDs.getUnformattedStringFromRandom();
            OAuthParams params = new OAuthParams().setHostname(Config.getHostname()).setClientId(oAuthClientApp.getId()).setClientSecret(oAuthClientApp.getSecret()).setRedirectURI((String)oAuthClientApp.getRedirectURIs().get(0)).setScope("carddav caldav").setState(state);
            oAuthGrant = Protocol.obtainAccess((HttpClient)client, params, Config.getLogin(), Config.getPassword());
        }
    }

    protected boolean testOAuth() {
        return AUTH_METHOD_OAUTH.equals(this.authMethod);
    }

    @AfterClass
    public static void unregisterOAuthClient() throws Exception {
        if (oAuthClientApp != null) {
            try {
                AbstractOAuthTest.unregisterTestClient(oAuthClientApp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            oAuthClientApp = null;
            oAuthGrant = null;
        }
    }

    @Before
    public void before() throws Exception {
        this.client = new AJAXClient(AJAXClient.User.User1);
        this.webDAVClients = new HashMap<Long, WebDAVClient>();
        this.getAJAXClient().setHostname(WebDAVTest.getHostname());
        this.getAJAXClient().setProtocol(WebDAVTest.getProtocol());
        this.foldersToCleanUp = new ArrayList<FolderObject>();
    }

    @After
    public void after() throws Exception {
        if (null != this.client) {
            this.cleanupFolders();
            this.client.logout();
            this.client = null;
        }
    }

    public AJAXSession getSession() {
        return this.client.getSession();
    }

    protected AJAXClient getClient() {
        return this.client;
    }

    protected abstract String getDefaultUserAgent();

    protected WebDAVClient getWebDAVClient() throws Exception {
        Long threadID = Thread.currentThread().getId();
        if (!this.webDAVClients.containsKey(threadID)) {
            WebDAVClient webDAVClient = new WebDAVClient(this.getDefaultUserAgent(), oAuthGrant);
            this.webDAVClients.put(threadID, webDAVClient);
            return webDAVClient;
        }
        return this.webDAVClients.get(threadID);
    }

    private void cleanupFolders() {
        if (null != this.foldersToCleanUp) {
            for (FolderObject folder : this.foldersToCleanUp) {
                try {
                    this.getClient().execute(new DeleteRequest((API)EnumAPI.OX_NEW, folder.getObjectID(), new Date()));
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
    }

    protected void rememberForCleanUp(FolderObject folder) {
        this.foldersToCleanUp.add(folder);
    }

    protected FolderObject getFolder(String folderName) throws OXException, IOException, JSONException {
        VisibleFoldersResponse response = this.client.execute(new VisibleFoldersRequest(EnumAPI.OX_NEW, "contacts", new int[]{1, 300}));
        FolderObject folder = WebDAVTest.findByName(response.getPrivateFolders(), folderName);
        if (null == folder && null == (folder = WebDAVTest.findByName(response.getPublicFolders(), folderName))) {
            folder = WebDAVTest.findByName(response.getSharedFolders(), folderName);
        }
        if (null != folder) {
            folder = this.client.execute(new GetRequest((API)EnumAPI.OX_NEW, folder.getObjectID())).getFolder();
        }
        return folder;
    }

    protected FolderObject getCalendarFolder(String folderName) throws OXException, IOException, JSONException {
        VisibleFoldersResponse response = this.client.execute(new VisibleFoldersRequest(EnumAPI.OX_NEW, "calendar", new int[]{1, 300}));
        FolderObject folder = WebDAVTest.findByName(response.getPrivateFolders(), folderName);
        if (null == folder && null == (folder = WebDAVTest.findByName(response.getPublicFolders(), folderName))) {
            folder = WebDAVTest.findByName(response.getSharedFolders(), folderName);
        }
        if (null != folder) {
            folder = this.client.execute(new GetRequest((API)EnumAPI.OX_NEW, folder.getObjectID())).getFolder();
        }
        return folder;
    }

    private static FolderObject findByName(Iterator<FolderObject> iter, String folderName) {
        while (iter.hasNext()) {
            FolderObject folder = iter.next();
            if (!folderName.equals(folder.getFolderName())) continue;
            return folder;
        }
        return null;
    }

    protected boolean removeFromETags(Map<String, String> eTags, String uid) {
        String href = this.getHrefFromETags(eTags, uid);
        if (null != href) {
            eTags.remove(href);
            return true;
        }
        return false;
    }

    protected String getHrefFromETags(Map<String, String> eTags, String uid) {
        for (String href : eTags.keySet()) {
            if (!href.contains(uid)) continue;
            return href;
        }
        return null;
    }

    protected List<String> getChangedHrefs(Map<String, String> previousETags, Map<String, String> newETags) {
        ArrayList<String> hrefs = new ArrayList<String>();
        for (String href : newETags.keySet()) {
            if (previousETags.containsKey(href) && newETags.get(href).equals(newETags.get(href))) continue;
            hrefs.add(href);
        }
        return hrefs;
    }

    protected FolderObject createFolder(FolderObject folder) throws OXException, IOException, JSONException {
        InsertResponse response = this.getClient().execute(new InsertRequest((API)EnumAPI.OX_NEW, folder));
        folder.setObjectID(response.getId());
        folder.setLastModified(response.getTimestamp());
        this.rememberForCleanUp(folder);
        return folder;
    }

    protected FolderObject updateFolder(FolderObject folder) throws OXException, IOException, JSONException {
        InsertResponse response = this.getClient().execute(new UpdateRequest((API)EnumAPI.OX_NEW, folder));
        folder.setLastModified(response.getTimestamp());
        return folder;
    }

    protected FolderObject getFolder(int folderID) throws OXException, IOException, JSONException {
        return this.getClient().execute(new GetRequest((API)EnumAPI.OX_NEW, folderID)).getFolder();
    }

    protected void deleteFolder(FolderObject folder) throws OXException, IOException, JSONException {
        this.getClient().execute(new DeleteRequest((API)EnumAPI.OX_NEW, true, folder));
    }

    protected FolderObject createFolder(FolderObject parent, String folderName) throws OXException, IOException, JSONException {
        FolderObject folder = new FolderObject();
        folder.setFolderName(folderName);
        folder.setParentFolderID(parent.getObjectID());
        folder.setModule(parent.getModule());
        folder.setType(parent.getType());
        folder.setPermissions(parent.getPermissions());
        return this.createFolder(folder);
    }

    protected static String getBaseUri() throws OXException {
        return WebDAVTest.getProtocol() + "://" + WebDAVTest.getHostname();
    }

    protected static AJAXClient.User getUser() {
        return AJAXClient.User.User1;
    }

    protected static String getLogin() throws OXException {
        return WebDAVTest.getLogin(WebDAVTest.getUser());
    }

    protected static String getUsername() throws OXException {
        return WebDAVTest.getUsername(WebDAVTest.getUser());
    }

    protected static String getPassword() throws OXException {
        return WebDAVTest.getPassword(WebDAVTest.getUser());
    }

    protected static String getHostname() throws OXException {
        String hostname = AJAXConfig.getProperty(AJAXConfig.Property.HOSTNAME);
        if (null == hostname) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{AJAXConfig.Property.HOSTNAME.getPropertyName()});
        }
        return hostname;
    }

    protected static String getProtocol() throws OXException {
        String hostname = AJAXConfig.getProperty(AJAXConfig.Property.PROTOCOL);
        if (null == hostname) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{AJAXConfig.Property.PROTOCOL.getPropertyName()});
        }
        return hostname;
    }

    protected static String getLogin(AJAXClient.User user) throws OXException {
        String login = AJAXConfig.getProperty(user.getLogin());
        if (null == login) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{user.getLogin().getPropertyName()});
        }
        if (login.contains("@")) {
            return login;
        }
        String context = AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        if (null == context) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{AJAXConfig.Property.CONTEXTNAME.getPropertyName()});
        }
        return login + "@" + context;
    }

    protected static String getUsername(AJAXClient.User user) throws OXException {
        String username = AJAXConfig.getProperty(user.getLogin());
        if (null == username) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{user.getLogin().getPropertyName()});
        }
        return username.contains("@") ? username.substring(0, username.indexOf("@")) : username;
    }

    protected static String getPassword(AJAXClient.User user) throws OXException {
        String password = AJAXConfig.getProperty(user.getPassword());
        if (null == password) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{user.getPassword().getPropertyName()});
        }
        return password;
    }

    protected static void release(HttpMethodBase method) {
        if (null != method) {
            method.releaseConnection();
        }
    }

    protected static String randomUID() {
        return UUID.randomUUID().toString();
    }

    protected AJAXClient getAJAXClient() {
        return this.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String fetchSyncToken(String relativeUrl) throws Exception {
        String string;
        PropFindMethod propFind = null;
        try {
            DavPropertyNameSet props = new DavPropertyNameSet();
            props.add(PropertyNames.SYNC_TOKEN);
            propFind = new PropFindMethod(WebDAVTest.getBaseUri() + relativeUrl, 0, props, 0);
            MultiStatusResponse response = WebDAVTest.assertSingleResponse(this.getWebDAVClient().doPropFind(propFind, 207));
            string = this.extractTextContent(PropertyNames.SYNC_TOKEN, response);
        }
        catch (Throwable throwable) {
            WebDAVTest.release(propFind);
            throw throwable;
        }
        WebDAVTest.release((HttpMethodBase)propFind);
        return string;
    }

    protected Map<String, String> syncCollection(String syncToken, String relativeUrl) throws Exception {
        MultiStatusResponse[] responses;
        HashMap<String, String> eTags = new HashMap<String, String>();
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.GETETAG);
        SyncCollectionReportInfo reportInfo = new SyncCollectionReportInfo(syncToken, props);
        for (MultiStatusResponse response : responses = this.getWebDAVClient().doReport((ReportInfo)reportInfo, WebDAVTest.getBaseUri() + relativeUrl)) {
            if (!response.getProperties(200).contains(PropertyNames.GETETAG)) continue;
            String href = response.getHref();
            Assert.assertNotNull((String)"got no href from response", (Object)href);
            String eTag = this.extractTextContent(PropertyNames.GETETAG, response);
            Assert.assertNotNull((String)"got no ETag from response", (Object)eTag);
            eTags.put(href, eTag);
        }
        return eTags;
    }

    protected SyncCollectionResponse syncCollection(SyncToken syncToken, String relativeUrl) throws Exception {
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.GETETAG);
        SyncCollectionReportInfo reportInfo = new SyncCollectionReportInfo(syncToken.getToken(), props);
        SyncCollectionResponse syncCollectionResponse = this.getWebDAVClient().doReport(reportInfo, WebDAVTest.getBaseUri() + relativeUrl);
        syncToken.setToken(syncCollectionResponse.getSyncToken());
        return syncCollectionResponse;
    }

    protected String extractHref(DavPropertyName propertyName, MultiStatusResponse response) {
        Node node = this.extractNodeValue(propertyName, response);
        WebDAVTest.assertMatches(PropertyNames.HREF, node);
        String content = node.getTextContent();
        Assert.assertNotNull((String)("no text content in " + PropertyNames.HREF + " child for " + propertyName), (Object)content);
        return content;
    }

    protected Node extractNodeValue(DavPropertyName propertyName, MultiStatusResponse response) {
        WebDAVTest.assertNotEmpty(propertyName, response);
        Object value = response.getProperties(200).get(propertyName).getValue();
        Assert.assertTrue((String)("value is not a node in " + propertyName), (boolean)(value instanceof Node));
        return (Node)value;
    }

    protected List<Node> extractNodeListValue(DavPropertyName propertyName, MultiStatusResponse response) {
        WebDAVTest.assertNotEmpty(propertyName, response);
        Object value = response.getProperties(200).get(propertyName).getValue();
        Assert.assertTrue((String)("value is not a node list in " + propertyName), (boolean)(value instanceof List));
        return (List)value;
    }

    protected DavProperty<?> extractProperty(DavPropertyName propertyName, MultiStatusResponse response) {
        WebDAVTest.assertNotEmpty(propertyName, response);
        DavProperty property = response.getProperties(200).get(propertyName);
        Assert.assertNotNull((String)("property " + propertyName + " not found"), (Object)property);
        return property;
    }

    protected String extractTextContent(DavPropertyName propertyName, MultiStatusResponse response) {
        WebDAVTest.assertNotEmpty(propertyName, response);
        Object value = response.getProperties(200).get(propertyName).getValue();
        Assert.assertTrue((String)("value is not a string in " + propertyName), (boolean)(value instanceof String));
        return (String)value;
    }

    protected static String extractChildTextContent(DavPropertyName propertyName, Element element) {
        NodeList nodes = element.getElementsByTagNameNS(propertyName.getNamespace().getURI(), propertyName.getName());
        Assert.assertNotNull((String)"no child elements found by property name", (Object)nodes);
        Assert.assertEquals((String)"0 or more than one child nodes found for property", (long)1L, (long)nodes.getLength());
        Node node = nodes.item(0);
        Assert.assertNotNull((String)"no child element found by property name", (Object)node);
        return node.getTextContent();
    }

    protected static String formatAsUTC(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    protected static String formatAsDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    public static void assertMatches(DavPropertyName propertyName, Node node) {
        Assert.assertEquals((String)"wrong element name", (Object)propertyName.getName(), (Object)node.getLocalName());
        Assert.assertEquals((String)"wrong element namespace", (Object)propertyName.getNamespace().getURI(), (Object)node.getNamespaceURI());
    }

    public static void assertContains(DavPropertyName propertyName, List<Node> nodeList) {
        for (Node node : nodeList) {
            if (!propertyName.getName().equals(node.getLocalName()) || !propertyName.getNamespace().getURI().equals(node.getNamespaceURI())) continue;
            return;
        }
        Assert.fail((String)("property " + propertyName + " not found in list"));
    }

    public static void assertIsPresent(DavPropertyName propertyName, MultiStatusResponse response) {
        DavProperty property = response.getProperties(200).get(propertyName);
        Assert.assertNotNull((String)("property " + propertyName + " not found"), (Object)property);
    }

    public static void assertNotEmpty(DavPropertyName propertyName, MultiStatusResponse response) {
        WebDAVTest.assertIsPresent(propertyName, response);
        Object value = response.getProperties(200).get(propertyName).getValue();
        Assert.assertNotNull((String)("no value for " + propertyName), (Object)value);
    }

    public static MultiStatusResponse assertSingleResponse(MultiStatusResponse[] responses) {
        Assert.assertNotNull((String)"got no multistatus responses", (Object)responses);
        Assert.assertTrue((String)"got zero multistatus responses", (0 < responses.length ? 1 : 0) != 0);
        Assert.assertTrue((String)"got more than one multistatus responses", (1 == responses.length ? 1 : 0) != 0);
        MultiStatusResponse response = responses[0];
        Assert.assertNotNull((String)"no multistatus response", (Object)response);
        return response;
    }

    public static void assertResponseHeaders(String[] expected, String headerName, HttpMethod method) {
        for (String expectedHeader : expected) {
            boolean found = false;
            Header[] actualHeaders = method.getResponseHeaders(headerName);
            Assert.assertTrue((String)("header '" + headerName + "' not found"), (null != actualHeaders && 0 < actualHeaders.length ? 1 : 0) != 0);
            for (Header actualHeader : actualHeaders) {
                HeaderElement[] actualHeaderElements = actualHeader.getElements();
                Assert.assertTrue((String)("no elements found in header '" + headerName + "'"), (null != actualHeaderElements && 0 < actualHeaderElements.length ? 1 : 0) != 0);
                for (HeaderElement actualHeaderElement : actualHeaderElements) {
                    if (!expectedHeader.equals(actualHeaderElement.getName())) continue;
                    found = true;
                    break;
                }
                if (found) break;
            }
            Assert.assertTrue((String)("header element '" + expectedHeader + "'not found in header '" + headerName + "'"), (boolean)found);
        }
    }
}

