/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.user.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.user.actions.AbstractUserRequest;
import com.openexchange.ajax.user.actions.UpdateParser;
import com.openexchange.ajax.user.actions.UpdateResponse;
import com.openexchange.ajax.writer.ContactWriter;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.ldap.User;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class UpdateRequest
extends AbstractUserRequest<UpdateResponse> {
    private Contact contactData;
    private User userData;
    private String stringifiedJSON;
    private boolean hasImage = false;
    private boolean failOnError = false;

    public UpdateRequest(Contact contactData, User userData) {
        this(contactData, userData, true);
    }

    public UpdateRequest(Contact contactData, User userData, boolean failOnError) {
        this.contactData = contactData;
        this.userData = userData;
        this.failOnError = failOnError;
        boolean bl = this.hasImage = contactData.containsImage1() && null != contactData.getImage1();
        if (this.hasImage) {
            try {
                this.stringifiedJSON = this.convert(contactData, userData).toString();
            }
            catch (JSONException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    @Override
    public AJAXRequest.Method getMethod() {
        if (this.hasImage) {
            return AJAXRequest.Method.POST;
        }
        return AJAXRequest.Method.PUT;
    }

    @Override
    public Header[] getHeaders() {
        if (this.hasImage) {
            return new Header[]{new Header.SimpleHeader("Content-Type", "multipart/form-data")};
        }
        return NO_HEADER;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        if (this.hasImage) {
            String ct = "image/jpg";
            String ext = "jpg";
            if (this.contactData.getImageContentType() != null && (ct = this.contactData.getImageContentType()).startsWith("image/png")) {
                ext = "png";
            }
            return new AJAXRequest.Parameter[]{new AJAXRequest.URLParameter("action", "update"), new AJAXRequest.URLParameter("id", Integer.toString(this.contactData.getInternalUserId())), new AJAXRequest.URLParameter("timestamp", Long.toString(this.contactData.getLastModified().getTime())), new AJAXRequest.FieldParameter("json", this.stringifiedJSON), new AJAXRequest.FileParameter("file", "open-xchange_image." + ext, new ByteArrayInputStream(this.contactData.getImage1()), ct)};
        }
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "update"), new AJAXRequest.Parameter("id", Integer.toString(this.contactData.getInternalUserId())), new AJAXRequest.Parameter("timestamp", Long.toString(this.contactData.getLastModified().getTime()))};
    }

    @Override
    public AbstractAJAXParser<? extends UpdateResponse> getParser() {
        return new UpdateParser(this.failOnError, this.hasImage);
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        return this.convert(this.contactData, this.userData);
    }

    private JSONObject convert(Contact contactData, User userData) throws JSONException {
        JSONObject jsonObj = new JSONObject();
        ContactWriter contactWriter = new ContactWriter(TimeZone.getTimeZone("UTC"));
        contactWriter.writeContact(contactData, jsonObj, null);
        if (userData != null) {
            Locale locale;
            String timezone = userData.getTimeZone();
            if (timezone != null && !timezone.isEmpty()) {
                jsonObj.put("timezone", (Object)timezone);
            }
            if ((locale = userData.getLocale()) != null) {
                jsonObj.put("locale", (Object)locale.toString());
            }
        }
        return jsonObj;
    }
}

