/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.task.Bug21026Test;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.util.TimeZones;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import org.json.JSONException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class Bug30015Test
extends AbstractAJAXSession {
    private AJAXClient client1;
    private TimeZone timeZone;
    private Calendar cal;
    private Task task;
    private Task first;
    private Task second;

    public Bug30015Test(String name) {
        super(name);
    }

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.client1 = this.getClient();
        this.timeZone = this.client1.getValues().getTimeZone();
        this.cal = TimeTools.createCalendar(TimeZones.UTC);
        this.task = new Task();
        this.task.setParentFolderID(this.client1.getValues().getPrivateTaskFolder());
        this.task.setTitle("Test for bug 30015");
        this.cal.set(11, 0);
        this.task.setStartDate(this.cal.getTime());
        this.task.setEndDate(this.cal.getTime());
        this.task.setRecurrenceType(1);
        this.task.setInterval(1);
        this.task.setOccurrence(2);
        this.client1.execute(new InsertRequest(this.task, this.timeZone)).fillTask(this.task);
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.client1.execute(new DeleteRequest(this.first));
        this.client1.execute(new DeleteRequest(this.second));
        super.tearDown();
    }

    @Test
    public void testForTaskCompletedAttributeInNextOccurrence() throws OXException, IOException, JSONException {
        this.first = new Task();
        this.first.setObjectID(this.task.getObjectID());
        this.first.setParentFolderID(this.task.getParentFolderID());
        this.first.setLastModified(this.task.getLastModified());
        this.first.setStatus(3);
        this.first.setPercentComplete(100);
        this.first.setDateCompleted(this.cal.getTime());
        this.first.setLastModified(this.client1.execute(new UpdateRequest(this.first, this.timeZone)).getTimestamp());
        this.second = Bug21026Test.findNextOccurrence(this.client1, this.client1.execute(new GetRequest(this.first)).getTask(this.timeZone));
        this.second = this.client.execute(new GetRequest(this.second)).getTask(this.timeZone);
        Assert.assertFalse((String)"Next occurrence of task must not contain the attribute 'date completed'.", (boolean)this.second.containsDateCompleted());
        Bug30015Test.assertNull((String)"Next occurrence of task must not contain the attribute 'date completed'.", (Object)this.second.getDateCompleted());
    }
}

