/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.bugs;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.share.actions.StartSMTPRequest;
import com.openexchange.ajax.share.actions.StopSMTPRequest;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.ldap.User;
import com.openexchange.java.util.TimeZones;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.notification.ShareNotificationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Bug41622Test
extends ShareTest {
    private Map<AJAXClient, List<Integer>> clientsAndFolders;
    private AJAXClient client2;

    public Bug41622Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.client2.execute(new StartSMTPRequest());
        this.clientsAndFolders = new HashMap<AJAXClient, List<Integer>>();
        this.clientsAndFolders.put(this.client, new ArrayList());
        this.clientsAndFolders.put(this.client2, new ArrayList());
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.clientsAndFolders) {
            for (Map.Entry<AJAXClient, List<Integer>> entry : this.clientsAndFolders.entrySet()) {
                Bug41622Test.deleteFoldersSilently(entry.getKey(), (Collection<Integer>)entry.getValue());
                if (entry.getKey().equals(this.client)) continue;
                entry.getKey().execute(new StopSMTPRequest());
                entry.getKey().logout();
            }
        }
        super.tearDown();
    }

    public void testShowSharingUsers() throws Exception {
        EnumAPI api = Bug41622Test.randomFolderAPI();
        String name = Bug41622Test.randomUID();
        OCLGuestPermission guestPermission = Bug41622Test.createNamedGuestPermission(name + "@example.com", name, "secret");
        int module1 = Bug41622Test.randomModule();
        FolderObject folderA = Create.createPrivateFolder(Bug41622Test.randomUID(), module1, this.client.getValues().getUserId(), guestPermission);
        folderA.setParentFolderID(Bug41622Test.getDefaultFolder(this.client, module1));
        InsertRequest insertRequest1 = new InsertRequest((API)api, folderA);
        insertRequest1.setNotifyPermissionEntities(ShareNotificationService.Transport.MAIL);
        InsertResponse insertResponse1 = this.client.execute(insertRequest1);
        insertResponse1.fillObject((DataObject)folderA);
        this.clientsAndFolders.get(this.client).add(folderA.getObjectID());
        GetResponse getResponse1 = this.client.execute(new GetRequest((API)api, folderA.getObjectID()));
        folderA = getResponse1.getFolder();
        folderA.setLastModified(getResponse1.getTimestamp());
        OCLPermission matchingPermissionA = null;
        for (OCLPermission permission : folderA.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermissionA = permission;
            break;
        }
        Bug41622Test.assertNotNull((String)"No matching permission in created folder found", matchingPermissionA);
        Bug41622Test.checkPermissions(guestPermission, matchingPermissionA);
        ExtendedPermissionEntity guestA = Bug41622Test.discoverGuestEntity(this.client, api, module1, folderA.getObjectID(), matchingPermissionA.getEntity());
        Bug41622Test.checkGuestPermission(guestPermission, guestA);
        String shareURLA = this.discoverShareURL(this.client, guestA);
        int module2 = Bug41622Test.randomModule();
        FolderObject folderB = Create.createPrivateFolder(Bug41622Test.randomUID(), module2, this.client2.getValues().getUserId(), guestPermission);
        folderB.setParentFolderID(Bug41622Test.getDefaultFolder(this.client2, module2));
        InsertRequest insertRequest2 = new InsertRequest((API)api, folderB);
        insertRequest2.setNotifyPermissionEntities(ShareNotificationService.Transport.MAIL);
        InsertResponse insertResponse2 = this.client2.execute(insertRequest2);
        insertResponse2.fillObject((DataObject)folderB);
        this.clientsAndFolders.get(this.client2).add(folderB.getObjectID());
        GetResponse getResponse = this.client2.execute(new GetRequest((API)api, folderB.getObjectID()));
        folderB = getResponse.getFolder();
        folderB.setLastModified(getResponse.getTimestamp());
        OCLPermission matchingPermissionB = null;
        for (OCLPermission permission : folderB.getPermissions()) {
            if (permission.getEntity() == this.client2.getValues().getUserId()) continue;
            matchingPermissionB = permission;
            break;
        }
        Bug41622Test.assertNotNull((String)"No matching permission in created folder found", matchingPermissionB);
        Bug41622Test.checkPermissions(guestPermission, matchingPermissionB);
        ExtendedPermissionEntity guestB = Bug41622Test.discoverGuestEntity(this.client2, api, module2, folderB.getObjectID(), matchingPermissionB.getEntity());
        Bug41622Test.checkGuestPermission(guestPermission, guestB);
        String shareURLB = this.discoverShareURL(this.client2, guestB);
        Bug41622Test.assertEquals((String)"Permission entities differ", (int)matchingPermissionA.getEntity(), (int)matchingPermissionB.getEntity());
        GuestClient guestClientA = this.resolveShare(shareURLA, guestPermission.getRecipient());
        guestClientA.checkModuleAvailable(module1);
        guestClientA.checkModuleAvailable(module2);
        guestClientA.checkFolderAccessible(String.valueOf(folderA.getObjectID()), guestPermission);
        guestClientA.checkFolderAccessible(String.valueOf(folderB.getObjectID()), guestPermission);
        User expectedUser1 = this.client.execute(new com.openexchange.ajax.user.actions.GetRequest(this.client.getValues().getUserId(), TimeZones.UTC, true)).getUser();
        User expectedUser2 = this.client2.execute(new com.openexchange.ajax.user.actions.GetRequest(this.client2.getValues().getUserId(), TimeZones.UTC, true)).getUser();
        User actualUser1 = guestClientA.execute(new com.openexchange.ajax.user.actions.GetRequest(this.client.getValues().getUserId(), TimeZones.UTC, true)).getUser();
        User actualUser2 = guestClientA.execute(new com.openexchange.ajax.user.actions.GetRequest(this.client2.getValues().getUserId(), TimeZones.UTC, true)).getUser();
        Bug41622Test.assertEquals((String)expectedUser1.getDisplayName(), (String)actualUser1.getDisplayName());
        Bug41622Test.assertEquals((String)expectedUser1.getGivenName(), (String)actualUser1.getGivenName());
        Bug41622Test.assertEquals((String)expectedUser1.getSurname(), (String)actualUser1.getSurname());
        Bug41622Test.assertEquals((String)expectedUser2.getDisplayName(), (String)actualUser2.getDisplayName());
        Bug41622Test.assertEquals((String)expectedUser2.getGivenName(), (String)actualUser2.getGivenName());
        Bug41622Test.assertEquals((String)expectedUser2.getSurname(), (String)actualUser2.getSurname());
        GuestClient guestClientB = this.resolveShare(shareURLB, guestPermission.getRecipient());
        guestClientB.checkModuleAvailable(module1);
        guestClientB.checkModuleAvailable(module2);
        guestClientB.checkFolderAccessible(String.valueOf(folderA.getObjectID()), guestPermission);
        guestClientB.checkFolderAccessible(String.valueOf(folderB.getObjectID()), guestPermission);
        actualUser1 = guestClientB.execute(new com.openexchange.ajax.user.actions.GetRequest(this.client.getValues().getUserId(), TimeZones.UTC, true)).getUser();
        actualUser2 = guestClientB.execute(new com.openexchange.ajax.user.actions.GetRequest(this.client2.getValues().getUserId(), TimeZones.UTC, true)).getUser();
        Bug41622Test.assertEquals((String)expectedUser1.getDisplayName(), (String)actualUser1.getDisplayName());
        Bug41622Test.assertEquals((String)expectedUser1.getGivenName(), (String)actualUser1.getGivenName());
        Bug41622Test.assertEquals((String)expectedUser1.getSurname(), (String)actualUser1.getSurname());
        Bug41622Test.assertEquals((String)expectedUser2.getDisplayName(), (String)actualUser2.getDisplayName());
        Bug41622Test.assertEquals((String)expectedUser2.getGivenName(), (String)actualUser2.getGivenName());
        Bug41622Test.assertEquals((String)expectedUser2.getSurname(), (String)actualUser2.getSurname());
    }
}

