/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.bugs;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.infostore.actions.GetInfostoreRequest;
import com.openexchange.ajax.infostore.actions.GetInfostoreResponse;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.share.actions.FileShare;
import com.openexchange.ajax.share.actions.FolderShare;
import com.openexchange.file.storage.DefaultFileStorageObjectPermission;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.ldap.User;
import com.openexchange.server.impl.OCLPermission;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class Bug40627Test
extends ShareTest {
    public Bug40627Test(String name) {
        super(name);
    }

    public void testCheckExtendedFolderPermissions() throws Exception {
        int module = Bug40627Test.randomModule();
        OCLGuestPermission guestPermission = Bug40627Test.randomGuestPermission(module);
        ArrayList<OCLPermission> permissions = new ArrayList<OCLPermission>();
        permissions.add(guestPermission);
        OCLPermission groupPermission = new OCLPermission(0, 0);
        groupPermission.setAllPermission(4, 4, 4, 4);
        groupPermission.setGroupPermission(true);
        permissions.add(groupPermission);
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        int userId2 = client2.getValues().getUserId();
        client2.logout();
        OCLPermission userPermission = new OCLPermission(userId2, 0);
        userPermission.setAllPermission(4, 4, 0, 0);
        permissions.add(userPermission);
        FolderObject folder = this.insertSharedFolder(EnumAPI.OX_NEW, module, this.getDefaultFolder(module), Bug40627Test.randomUID(), permissions.toArray(new OCLPermission[permissions.size()]));
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId() || permission.isGroupPermission() || permission.getEntity() == userId2) continue;
            matchingPermission = permission;
            break;
        }
        Bug40627Test.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        Bug40627Test.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(EnumAPI.OX_NEW, module, folder.getObjectID(), matchingPermission.getEntity());
        Bug40627Test.checkGuestPermission(guestPermission, guest);
        GuestClient guestClient = this.resolveShare(this.discoverShareURL(guest), guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
        GetResponse getResponse = guestClient.execute(new GetRequest((API)EnumAPI.OX_NEW, folder.getObjectID()));
        Bug40627Test.assertFalse((String)getResponse.getErrorMessage(), (boolean)getResponse.hasError());
        FolderShare folderShare = FolderShare.parse((JSONObject)getResponse.getData(), guestClient.getValues().getTimeZone());
        Bug40627Test.checkExtendedPermissions(this.client, folderShare.getExtendedPermissions(), matchingPermission.getEntity(), 0, userId2);
    }

    public void testCheckExtendedObjectPermissions() throws Exception {
        FileStorageGuestObjectPermission guestPermission = Bug40627Test.randomGuestObjectPermission();
        ArrayList<FileStorageObjectPermission> permissions = new ArrayList<FileStorageObjectPermission>();
        permissions.add((FileStorageObjectPermission)guestPermission);
        permissions.add((FileStorageObjectPermission)new DefaultFileStorageObjectPermission(0, true, 1));
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        int userId2 = client2.getValues().getUserId();
        client2.logout();
        permissions.add((FileStorageObjectPermission)new DefaultFileStorageObjectPermission(userId2, false, 2));
        byte[] contents = new byte[64 + random.nextInt(256)];
        random.nextBytes(contents);
        String filename = Bug40627Test.randomUID();
        FolderObject folder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.getDefaultFolder(8));
        File file = this.insertSharedFile(folder.getObjectID(), filename, permissions, contents);
        FileStorageObjectPermission matchingPermission = null;
        for (FileStorageObjectPermission permission : file.getObjectPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId() || permission.isGroup() || permission.getEntity() == userId2) continue;
            matchingPermission = permission;
            break;
        }
        Bug40627Test.assertNotNull((String)"No matching permission in created file found", matchingPermission);
        Bug40627Test.checkPermissions((FileStorageObjectPermission)guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(file.getFolderId(), file.getId(), matchingPermission.getEntity());
        Bug40627Test.checkGuestPermission((FileStorageObjectPermission)guestPermission, guest);
        GuestClient guestClient = this.resolveShare(this.discoverShareURL(guest), guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission, contents);
        GetInfostoreRequest getInfostoreRequest = new GetInfostoreRequest(guestClient.getItem());
        getInfostoreRequest.setFailOnError(true);
        GetInfostoreResponse getInfostoreResponse = guestClient.execute(getInfostoreRequest);
        Bug40627Test.assertFalse((String)getInfostoreResponse.getErrorMessage(), (boolean)getInfostoreResponse.hasError());
        FileShare fileShare = FileShare.parse((JSONObject)getInfostoreResponse.getData(), guestClient.getValues().getTimeZone());
        Bug40627Test.checkExtendedPermissions(this.client, fileShare.getExtendedPermissions(), matchingPermission.getEntity(), 0, userId2);
    }

    private static void checkExtendedPermissions(AJAXClient sharingClient, List<ExtendedPermissionEntity> actual, int expectedGuestID, int expectedGroupID, int expectedUserID) throws Exception {
        Bug40627Test.assertNotNull(actual);
        block4: for (ExtendedPermissionEntity permissionEntity : actual) {
            switch (permissionEntity.getType()) {
                case GROUP: {
                    Bug40627Test.assertEquals((int)permissionEntity.getEntity(), (int)expectedGroupID);
                    Bug40627Test.assertEquals((String)("Group " + permissionEntity.getEntity()), (String)permissionEntity.getDisplayName());
                    continue block4;
                }
                case USER: {
                    if (permissionEntity.getEntity() == sharingClient.getValues().getUserId()) {
                        com.openexchange.ajax.user.actions.GetResponse getResponse = sharingClient.execute(new com.openexchange.ajax.user.actions.GetRequest(sharingClient.getValues().getTimeZone(), true));
                        User expectedUser = getResponse.getUser();
                        Bug40627Test.assertEquals((String)expectedUser.getDisplayName(), (String)permissionEntity.getDisplayName());
                        Bug40627Test.assertNotNull((Object)permissionEntity.getContact());
                        Bug40627Test.assertEquals((String)expectedUser.getSurname(), (String)permissionEntity.getContact().getSurName());
                        Bug40627Test.assertEquals((String)expectedUser.getGivenName(), (String)permissionEntity.getContact().getGivenName());
                        Bug40627Test.assertEquals((String)expectedUser.getMail(), (String)permissionEntity.getContact().getEmail1());
                        continue block4;
                    }
                    Bug40627Test.assertEquals((int)permissionEntity.getEntity(), (int)expectedUserID);
                    Bug40627Test.assertEquals((String)("User " + permissionEntity.getEntity()), (String)permissionEntity.getDisplayName());
                    Bug40627Test.assertNotNull((Object)permissionEntity.getContact());
                    Bug40627Test.assertEquals((String)"User", (String)permissionEntity.getContact().getSurName());
                    Bug40627Test.assertEquals((String)String.valueOf(permissionEntity.getEntity()), (String)permissionEntity.getContact().getGivenName());
                    continue block4;
                }
            }
            Bug40627Test.assertEquals((int)permissionEntity.getEntity(), (int)expectedGuestID);
        }
    }
}

