/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.infostore.actions.AbstractInfostoreRequest;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NotifyFileRequest
extends AbstractInfostoreRequest<AbstractAJAXResponse> {
    private final String id;
    private final int[] entities;
    private final boolean failOnError;

    public NotifyFileRequest(String id, int[] entities, boolean failOnError) {
        this.id = id;
        this.entities = entities;
        this.failOnError = failOnError;
    }

    public NotifyFileRequest(String id, int ... entities) {
        this(id, entities, true);
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        JSONObject jsonBody = new JSONObject();
        JSONArray jsonEntities = new JSONArray();
        for (int entity : this.entities) {
            jsonEntities.put(entity);
        }
        jsonBody.put("entities", (Object)jsonEntities);
        return jsonBody;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        return new AJAXRequest.Parameter[]{new AJAXRequest.URLParameter("id", this.id), new AJAXRequest.URLParameter("action", "notify")};
    }

    @Override
    public AbstractAJAXParser<? extends AbstractAJAXResponse> getParser() {
        return new AbstractAJAXParser<AbstractAJAXResponse>(this.failOnError){

            @Override
            protected AbstractAJAXResponse createResponse(Response response) throws JSONException {
                return new AbstractAJAXResponse(response){};
            }
        };
    }
}

