/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.share.actions.FileShare;
import com.openexchange.exception.OXException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;

public class FileSharesResponse
extends AbstractAJAXResponse {
    private final int[] columns;
    private final JSONArray data;

    public FileSharesResponse(Response response, int[] columns) throws JSONException {
        super(response);
        this.columns = columns;
        this.data = response.hasError() ? null : (JSONArray)response.getData();
    }

    public List<FileShare> getShares(TimeZone timeZone) throws JSONException, OXException {
        if (null != this.data) {
            return FileSharesResponse.parse(this.data, this.columns, timeZone);
        }
        return null;
    }

    private static List<FileShare> parse(JSONArray jsonArray, int[] columns, TimeZone timeZone) throws JSONException, OXException {
        ArrayList<FileShare> shares = new ArrayList<FileShare>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            shares.add(FileShare.parse(jsonArray.getJSONArray(i), columns, timeZone));
        }
        return shares;
    }
}

