/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.session.actions.FormLoginRequest;
import com.openexchange.ajax.session.actions.FormLoginResponse;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.java.Autoboxing;

public class FormLoginTest
extends AbstractAJAXSession {
    private String login;
    private String password;

    public FormLoginTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        AJAXConfig.init();
        this.login = AJAXConfig.getProperty(AJAXConfig.Property.LOGIN) + "@" + AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        this.password = AJAXConfig.getProperty(AJAXConfig.Property.PASSWORD);
    }

    @Override
    protected void tearDown() throws Exception {
        this.login = null;
        this.password = null;
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFormLogin() throws Exception {
        AJAXSession session = new AJAXSession();
        AJAXClient myClient = new AJAXClient(session, false);
        try {
            FormLoginResponse response = myClient.execute(new FormLoginRequest(this.login, this.password));
            FormLoginTest.assertNotNull((String)"Path of redirect response is not found.", (Object)response.getPath());
            FormLoginTest.assertNotNull((String)"Session identifier not found as fragment.", (Object)response.getSessionId());
            FormLoginTest.assertNotNull((String)"Login string was not found as fragment.", (Object)response.getLogin());
            FormLoginTest.assertNotSame((String)"", (Object)Autoboxing.I((int)-1), (Object)Autoboxing.I((int)response.getUserId()));
            FormLoginTest.assertNotNull((String)"Language string was not found as fragment.", (Object)response.getLanguage());
            session.setId(response.getSessionId());
        }
        finally {
            myClient.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dontTestFormLoginWithoutAuthId() throws Exception {
        AJAXSession session = new AJAXSession();
        AJAXClient myClient = new AJAXClient(session, false);
        try {
            FormLoginResponse response = myClient.execute(new FormLoginRequest(this.login, this.password, null));
            FormLoginTest.assertNotNull((String)"Path of redirect response is not found.", (Object)response.getPath());
            FormLoginTest.assertNotNull((String)"Session identifier not found as fragment.", (Object)response.getSessionId());
            FormLoginTest.assertNotNull((String)"Login string was not found as fragment.", (Object)response.getLogin());
            FormLoginTest.assertNotSame((String)"", (Object)Autoboxing.I((int)-1), (Object)Autoboxing.I((int)response.getUserId()));
            FormLoginTest.assertNotNull((String)"Language string was not found as fragment.", (Object)response.getLanguage());
            session.setId(response.getSessionId());
        }
        finally {
            myClient.logout();
        }
    }
}

