/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.reminder;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.AbstractAJAXTest;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.reminder.actions.RangeRequest;
import com.openexchange.ajax.reminder.actions.RangeResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.test.OXTestToolkit;
import com.openexchange.test.TestException;
import com.openexchange.tools.URLParameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public abstract class ReminderTest
extends AbstractAJAXTest {
    private static final String REMINDER_URL = "/ajax/reminder";

    public ReminderTest(String name) {
        super(name);
    }

    @Deprecated
    public static ReminderObject[] listReminder(WebConversation webConversation, Date end, TimeZone timeZone, String host, String sessionId) throws IOException, SAXException, JSONException, OXException, OXException {
        AJAXSession session = new AJAXSession(webConversation, host, sessionId);
        RangeRequest request = new RangeRequest(end);
        RangeResponse response = Executor.execute(session, request, host);
        return response.getReminder(timeZone);
    }

    public static ReminderObject[] listUpdates(WebConversation webConversation, Date lastModified, String host, String sessionId, TimeZone timeZone) throws Exception, OXException {
        host = ReminderTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", sessionId);
        parameter.setParameter("action", "updates");
        parameter.setParameter("timestamp", lastModified);
        GetMethodWebRequest webRequest = new GetMethodWebRequest(host + REMINDER_URL + parameter.getURLParameters());
        WebResponse webResponse = webConversation.getResponse((WebRequest)webRequest);
        ReminderTest.assertEquals((int)200, (int)webResponse.getResponseCode());
        JSONObject jsonObj = new JSONObject(webResponse.getText());
        if (jsonObj.has("error")) {
            throw new TestException("server error: " + jsonObj.get("error"));
        }
        if (!jsonObj.has("data")) {
            throw new TestException("no data in JSON object!");
        }
        JSONArray jsonArray = jsonObj.getJSONArray("data");
        ReminderObject[] reminderObj = new ReminderObject[jsonArray.length()];
        for (int a = 0; a < jsonArray.length(); ++a) {
            JSONObject jsonReminder = jsonArray.getJSONObject(a);
            reminderObj[a] = new ReminderObject();
            reminderObj[a].setObjectId(DataParser.parseInt((JSONObject)jsonReminder, (String)"id"));
            reminderObj[a].setTargetId(DataParser.parseInt((JSONObject)jsonReminder, (String)"target_id"));
            reminderObj[a].setFolder(DataParser.parseInt((JSONObject)jsonReminder, (String)"folder"));
            reminderObj[a].setDate(DataParser.parseTime((JSONObject)jsonReminder, (String)"alarm", (TimeZone)timeZone));
            reminderObj[a].setLastModified(DataParser.parseDate((JSONObject)jsonReminder, (String)"last_modified"));
            reminderObj[a].setUser(DataParser.parseInt((JSONObject)jsonReminder, (String)"user_id"));
            reminderObj[a].setRecurrenceAppointment(DataParser.parseBoolean((JSONObject)jsonReminder, (String)"recurrence_appointment"));
        }
        return reminderObj;
    }

    public static int[] deleteReminder(WebConversation webConversation, int objectId, String host, String sessionId) throws Exception, OXException {
        host = ReminderTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", sessionId);
        parameter.setParameter("action", "delete");
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", objectId);
        ByteArrayInputStream bais = new ByteArrayInputStream(jsonObj.toString().getBytes());
        PutMethodWebRequest webRequest = new PutMethodWebRequest(host + REMINDER_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse webResponse = webConversation.getResponse((WebRequest)webRequest);
        new JSONObject(webResponse.getText());
        ReminderTest.assertEquals((int)200, (int)webResponse.getResponseCode());
        JSONObject jsonResponse = new JSONObject(webResponse.getText());
        if (jsonResponse.has("error")) {
            throw new TestException("server error: " + jsonResponse.get("error"));
        }
        if (jsonResponse.has("data")) {
            JSONArray jsonArray = jsonResponse.getJSONArray("data");
            int[] failedObjects = new int[jsonArray.length()];
            for (int a = 0; a < failedObjects.length; ++a) {
                failedObjects[a] = jsonArray.getInt(a);
            }
            return failedObjects;
        }
        return new int[0];
    }

    public static void compareReminder(ReminderObject reminderObj1, ReminderObject reminderObj2) throws Exception {
        ReminderTest.assertEquals((String)"id", (int)reminderObj1.getObjectId(), (int)reminderObj2.getObjectId());
        OXTestToolkit.assertEqualsAndNotNull("folder", reminderObj1.getFolder(), reminderObj2.getFolder());
        OXTestToolkit.assertEqualsAndNotNull("alarm", reminderObj1.getDate(), reminderObj2.getDate());
    }
}

