/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider;

import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.oauth.provider.AbstractOAuthTest;
import com.openexchange.ajax.oauth.provider.EndpointTest;
import com.openexchange.ajax.oauth.provider.OAuthClient;
import com.openexchange.ajax.oauth.provider.OAuthSession;
import com.openexchange.ajax.oauth.provider.actions.RevokeRequest;
import com.openexchange.ajax.oauth.provider.protocol.GETRequest;
import com.openexchange.ajax.oauth.provider.protocol.GETResponse;
import com.openexchange.ajax.oauth.provider.protocol.HttpTools;
import com.openexchange.ajax.oauth.provider.protocol.OAuthParams;
import com.openexchange.ajax.oauth.provider.protocol.POSTRequest;
import com.openexchange.ajax.oauth.provider.protocol.POSTResponse;
import com.openexchange.ajax.oauth.provider.protocol.Protocol;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.oauth.provider.rmi.client.ClientDto;
import com.openexchange.oauth.provider.rmi.client.RemoteClientManagement;
import java.io.InputStreamReader;
import java.io.Reader;
import java.rmi.Naming;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class ProtocolFlowTest
extends EndpointTest {
    @Test
    public void testFlow() throws Exception {
        GETRequest getLoginForm = (GETRequest)((GETRequest)((GETRequest)((GETRequest)new GETRequest().setHostname(hostname)).setClientId(this.getClientId())).setRedirectURI(this.getRedirectURI())).setState(this.csrfState);
        GETResponse loginFormResponse = getLoginForm.execute((HttpClient)this.client);
        POSTRequest loginRequest = loginFormResponse.preparePOSTRequest().setLogin(login).setPassword(password);
        POSTResponse loginResponse = loginRequest.submit((HttpClient)this.client);
        GETResponse getAuthForm = loginResponse.followRedirect((HttpClient)this.client);
        POSTRequest authRequest = getAuthForm.preparePOSTRequest();
        POSTResponse authResponse = authRequest.submit((HttpClient)this.client);
        Map<String, String> redirectParams = HttpTools.extractQueryParams(authResponse.getRedirectLocation());
        Assert.assertNull((Object)redirectParams.get("error"));
        Assert.assertNotNull((Object)redirectParams.get("code"));
        Assert.assertEquals((Object)this.csrfState, (Object)redirectParams.get("state"));
    }

    @Test
    public void testRedeemRefreshToken() throws Exception {
        OAuthClient oauthClient = new OAuthClient(this.getClientId(), this.getClientSecret(), this.getRedirectURI(), this.getScope());
        oauthClient.assertAccess();
        OAuthSession session = (OAuthSession)oauthClient.getSession();
        String accessToken = session.getAccessToken();
        String refreshToken = session.getRefreshToken();
        LinkedList<BasicNameValuePair> redeemRefreshTokenParams = new LinkedList<BasicNameValuePair>();
        redeemRefreshTokenParams.add(new BasicNameValuePair("client_id", this.getClientId()));
        redeemRefreshTokenParams.add(new BasicNameValuePair("client_secret", this.getClientSecret()));
        redeemRefreshTokenParams.add(new BasicNameValuePair("grant_type", "refresh_token"));
        redeemRefreshTokenParams.add(new BasicNameValuePair("redirect_uri", this.getRedirectURI()));
        redeemRefreshTokenParams.add(new BasicNameValuePair("refresh_token", refreshToken));
        HttpPost redeemRefreshToken = new HttpPost(new URIBuilder().setScheme("https").setHost(hostname).setPath("/ajax/oauth/provider/accessToken").build());
        redeemRefreshToken.setEntity((HttpEntity)new UrlEncodedFormEntity(redeemRefreshTokenParams));
        HttpResponse accessTokenResponse = this.client.execute((HttpUriRequest)redeemRefreshToken);
        Assert.assertEquals((long)200L, (long)accessTokenResponse.getStatusLine().getStatusCode());
        JSONObject jAccessTokenResponse = JSONObject.parse((Reader)new InputStreamReader(accessTokenResponse.getEntity().getContent(), accessTokenResponse.getEntity().getContentEncoding() == null ? "UTF-8" : accessTokenResponse.getEntity().getContentEncoding().getValue())).toObject();
        Assert.assertTrue((boolean)"bearer".equalsIgnoreCase(jAccessTokenResponse.getString("token_type")));
        Assert.assertNotNull((Object)jAccessTokenResponse.get("access_token"));
        Assert.assertNotNull((Object)jAccessTokenResponse.get("refresh_token"));
        Assert.assertNotNull((Object)jAccessTokenResponse.get("scope"));
        Assert.assertNotNull((Object)jAccessTokenResponse.get("expires_in"));
        Assert.assertFalse((boolean)jAccessTokenResponse.getString("access_token").equals(accessToken));
        Assert.assertFalse((boolean)jAccessTokenResponse.getString("refresh_token").equals(refreshToken));
        boolean error = false;
        try {
            oauthClient.assertAccess();
        }
        catch (AssertionError e) {
            error = true;
        }
        Assert.assertTrue((boolean)error);
    }

    @Test
    public void testRedeemIsDeniedWhenRedirectURIChanges() throws Exception {
        OAuthParams params = new OAuthParams().setHostname(hostname).setClientId(this.getClientId()).setClientSecret(this.getClientSecret()).setRedirectURI(this.getRedirectURI()).setScope(this.getScope().toString());
        String sessionId = Protocol.login((HttpClient)this.client, params, login, password);
        String authCode = Protocol.authorize((HttpClient)this.client, params, sessionId);
        LinkedList<BasicNameValuePair> redeemAuthCodeParams = new LinkedList<BasicNameValuePair>();
        redeemAuthCodeParams.add(new BasicNameValuePair("client_id", this.getClientId()));
        redeemAuthCodeParams.add(new BasicNameValuePair("client_secret", this.getClientSecret()));
        redeemAuthCodeParams.add(new BasicNameValuePair("grant_type", "authorization_code"));
        redeemAuthCodeParams.add(new BasicNameValuePair("redirect_uri", this.getSecondRedirectURI()));
        redeemAuthCodeParams.add(new BasicNameValuePair("code", authCode));
        HttpPost redeemAuthCode = new HttpPost(new URIBuilder().setScheme("https").setHost(params.getHostname()).setPath("/ajax/oauth/provider/accessToken").build());
        redeemAuthCode.setEntity((HttpEntity)new UrlEncodedFormEntity(redeemAuthCodeParams));
        HttpResponse accessTokenResponse = this.client.execute((HttpUriRequest)redeemAuthCode);
        Assert.assertEquals((long)400L, (long)accessTokenResponse.getStatusLine().getStatusCode());
        JSONObject jAccessTokenResponse = JSONObject.parse((Reader)new InputStreamReader(accessTokenResponse.getEntity().getContent(), accessTokenResponse.getEntity().getContentEncoding() == null ? "UTF-8" : accessTokenResponse.getEntity().getContentEncoding().getValue())).toObject();
        Assert.assertEquals((Object)"invalid_request", (Object)jAccessTokenResponse.get("error"));
        redeemAuthCodeParams.clear();
        redeemAuthCodeParams.add(new BasicNameValuePair("client_id", this.getClientId()));
        redeemAuthCodeParams.add(new BasicNameValuePair("client_secret", this.getClientSecret()));
        redeemAuthCodeParams.add(new BasicNameValuePair("grant_type", "authorization_code"));
        redeemAuthCodeParams.add(new BasicNameValuePair("redirect_uri", this.getRedirectURI()));
        redeemAuthCodeParams.add(new BasicNameValuePair("code", authCode));
        redeemAuthCode = new HttpPost(new URIBuilder().setScheme("https").setHost(params.getHostname()).setPath("/ajax/oauth/provider/accessToken").build());
        redeemAuthCode.setEntity((HttpEntity)new UrlEncodedFormEntity(redeemAuthCodeParams));
        accessTokenResponse = this.client.execute((HttpUriRequest)redeemAuthCode);
        Assert.assertEquals((long)400L, (long)accessTokenResponse.getStatusLine().getStatusCode());
        jAccessTokenResponse = JSONObject.parse((Reader)new InputStreamReader(accessTokenResponse.getEntity().getContent(), accessTokenResponse.getEntity().getContentEncoding() == null ? "UTF-8" : accessTokenResponse.getEntity().getContentEncoding().getValue())).toObject();
        Assert.assertEquals((Object)"invalid_request", (Object)jAccessTokenResponse.get("error"));
    }

    @Test
    public void testAuthCodeReplay() throws Exception {
        OAuthParams params = new OAuthParams().setHostname(hostname).setClientId(this.getClientId()).setClientSecret(this.getClientSecret()).setRedirectURI(this.getRedirectURI()).setScope(this.getScope().toString());
        String sessionId = Protocol.login((HttpClient)this.client, params, login, password);
        String authCode = Protocol.authorize((HttpClient)this.client, params, sessionId);
        Protocol.redeemAuthCode((HttpClient)this.client, params, authCode);
        LinkedList<BasicNameValuePair> redeemAuthCodeParams = new LinkedList<BasicNameValuePair>();
        redeemAuthCodeParams.add(new BasicNameValuePair("client_id", this.getClientId()));
        redeemAuthCodeParams.add(new BasicNameValuePair("client_secret", this.getClientSecret()));
        redeemAuthCodeParams.add(new BasicNameValuePair("grant_type", "authorization_code"));
        redeemAuthCodeParams.add(new BasicNameValuePair("redirect_uri", this.getRedirectURI()));
        redeemAuthCodeParams.add(new BasicNameValuePair("code", authCode));
        HttpPost redeemAuthCode = new HttpPost(new URIBuilder().setScheme("https").setHost(params.getHostname()).setPath("/ajax/oauth/provider/accessToken").build());
        redeemAuthCode.setEntity((HttpEntity)new UrlEncodedFormEntity(redeemAuthCodeParams));
        HttpResponse replayResponse = this.client.execute((HttpUriRequest)redeemAuthCode);
        Assert.assertEquals((long)400L, (long)replayResponse.getStatusLine().getStatusCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxNumberOfDistinctGrants() throws Exception {
        Credentials masterAdminCredentials = AbstractOAuthTest.getMasterAdminCredentials();
        RemoteClientManagement clientManagement = (RemoteClientManagement)Naming.lookup("rmi://" + AJAXConfig.getProperty(AJAXConfig.Property.RMI_HOST) + ":1099/" + RemoteClientManagement.RMI_NAME);
        ArrayList<ClientDto> clients = new ArrayList<ClientDto>(50);
        for (int i = 0; i < 50; ++i) {
            clients.add(clientManagement.registerClient("default", ProtocolFlowTest.prepareClient("testMaxNumberOfDistinctGrants " + i + " " + System.currentTimeMillis()), masterAdminCredentials));
        }
        try {
            for (ClientDto client : clients) {
                OAuthClient c = new OAuthClient(AJAXClient.User.User1, client.getId(), client.getSecret(), (String)client.getRedirectURIs().get(0), this.getScope());
                c.assertAccess();
            }
            boolean error = false;
            try {
                OAuthClient c = new OAuthClient(AJAXClient.User.User1, this.getClientId(), this.getClientSecret(), this.getRedirectURI(), this.getScope());
                c.assertAccess();
            }
            catch (AssertionError e) {
                error = true;
            }
            Assert.assertTrue((boolean)error);
            Iterator it = clients.iterator();
            ClientDto client2 = (ClientDto)it.next();
            AJAXClient ajaxClient = new AJAXClient(AJAXClient.User.User1);
            ajaxClient.execute(new RevokeRequest(client2.getId()));
            OAuthClient c = new OAuthClient(AJAXClient.User.User1, this.getClientId(), this.getClientSecret(), this.getRedirectURI(), this.getScope());
            c.assertAccess();
        }
        finally {
            for (ClientDto client : clients) {
                try {
                    clientManagement.unregisterClient(client.getId(), masterAdminCredentials);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    @Test
    public void testGrantStorageQuota() throws Exception {
        ArrayList<OAuthClient> clients = new ArrayList<OAuthClient>();
        for (int i = 0; i < 10; ++i) {
            clients.add(new OAuthClient(this.getClientId(), this.getClientSecret(), this.getRedirectURI(), this.getScope()));
            LockSupport.parkNanos(1000000L);
        }
        for (OAuthClient client : clients) {
            client.assertAccess();
        }
        clients.add(new OAuthClient(this.getClientId(), this.getClientSecret(), this.getRedirectURI(), this.getScope()));
        boolean error = false;
        try {
            ((OAuthClient)clients.get(0)).assertAccess();
        }
        catch (AssertionError e) {
            error = true;
        }
        Assert.assertTrue((boolean)error);
        clients.remove(0);
        for (OAuthClient client : clients) {
            client.assertAccess();
        }
    }
}

