/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mailaccount;

import com.openexchange.ajax.mailaccount.AbstractMailAccountTest;
import com.openexchange.ajax.mailaccount.actions.MailAccountAllRequest;
import com.openexchange.ajax.mailaccount.actions.MailAccountAllResponse;
import com.openexchange.exception.OXException;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccountDescription;
import java.io.IOException;
import java.util.List;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class MailAccountAllTest
extends AbstractMailAccountTest {
    public MailAccountAllTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createMailAccount();
    }

    @Override
    public void tearDown() throws Exception {
        if (null != this.mailAccountDescription && 0 != this.mailAccountDescription.getId()) {
            this.deleteMailAccount();
        }
        super.tearDown();
    }

    public void testAllShouldNotIncludePassword() throws OXException, IOException, SAXException, JSONException {
        int[] fields = new int[]{Attribute.ID_LITERAL.getId(), Attribute.PASSWORD_LITERAL.getId()};
        MailAccountAllResponse response = this.getClient().execute(new MailAccountAllRequest(fields));
        List<MailAccountDescription> descriptions = response.getDescriptions();
        MailAccountAllTest.assertFalse((boolean)descriptions.isEmpty());
        boolean found = false;
        for (MailAccountDescription description : descriptions) {
            if (description.getId() != this.mailAccountDescription.getId()) continue;
            MailAccountAllTest.assertTrue((String)"Password was not null", (null == description.getPassword() ? 1 : 0) != 0);
            found = true;
        }
        MailAccountAllTest.assertTrue((String)"Did not find mail account in response", (boolean)found);
    }
}

