/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.MailFlag;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.ForwardRequest;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.MailReferenceResponse;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.ajax.mail.actions.NewMailRequestWithUploads;
import com.openexchange.ajax.mail.actions.NewMailResponse;
import com.openexchange.ajax.mail.actions.ReplyRequest;
import com.openexchange.ajax.mail.actions.ReplyResponse;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import java.io.IOException;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class Bug37247Test
extends AbstractMailTest {
    private static final String EML = "Return-Path: <from@example.tld>\n        Received: from local-out (mwinf8514 [127.0.0.1])\n         by mwinb8903 (Cyrus v2.3.13) with LMTPA;\n         Tue, 01 Jul 2014 17:38:28 +0200\n    X-Sieve: CMU Sieve 2.3\n    Received: from local ([127.0.0.1])\n        by mwinf8514-out with ME\n        id M3dU1o00G3djdXu033dUxU; Tue, 01 Jul 2014 17:37:28 +0200\n    X-ME-User-Auth: from foo <from@example.tld>\n    X-bcc: bcc bar <bcc@example.tld>\n    X-me-spamrating: 36.00\n    X-me-spamlevel: not-spam\n    X-ME-bounce-domain: bar.tld\n    X-ME-Entity: oop\n    Date: Tue, 1 Jul 2014 17:37:28 +0200 (CEST)\n    From: from foo <from@example.tld>\n    Reply-To: rto foo <bar@example.tld>\n    To: to bar <to@example.tld>\n    Cc: cc bar <cc@example.tld>\n    Bcc: bcc bar <bcc@example.tld>\n    Message-ID: <11140339.1095068.1404229048881.JavaMail.www@wwinf8905>\n    Subject: plain text\n    MIME-Version: 1.0\n    Content-Type: text/plain; charset=UTF-8\n    Content-Transfer-Encoding: 7bit\n    X-SAVECOPY: false\n    X-Wum-Nature: EMAIL-NATURE\n    X-WUM-FROM: |~|\n    X-WUM-TO: |~|\n    X-WUM-REPLYTO: |~|\n\n    plain text\n\n    A test signature";
    private UserValues values;

    public Bug37247Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.values = this.getClient().getValues();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug37472Reply() throws OXException, IOException, JSONException {
        String csid = "845.1436870434189";
        NewMailRequest newMailRequest = new NewMailRequest(this.values.getInboxFolder(), EML, 32, true);
        NewMailResponse newMailResponse = this.getClient().execute(newMailRequest);
        Bug37247Test.assertNotNull((String)"Got an empty new mail response", (Object)((Object)newMailResponse));
        String mailId = newMailResponse.getId();
        String folderId = newMailResponse.getFolder();
        try {
            ReplyRequest rReq = new ReplyRequest(folderId, mailId);
            rReq.setCsid(csid);
            ReplyResponse rResp = this.getClient().execute(rReq);
            Bug37247Test.assertNotNull((String)"Got an empty reply response", (Object)((Object)rResp));
            JSONObject jsonObj = (JSONObject)rResp.getData();
            Bug37247Test.assertNotNull((String)"Got an unexpected response", (Object)jsonObj);
            Bug37247Test.assertFalse((String)"Got an empty json object", (boolean)jsonObj.isEmpty());
            csid = jsonObj.getString("csid");
            String subject = "Bug37472Test_testFlagsNotChangingWhenSavingDraft" + System.currentTimeMillis();
            JSONObject composedMail = this.createEMail(this.getSendAddress(), subject, "text/plain", EML);
            JSONObject mail = new JSONObject(composedMail);
            mail.put("flags", 4);
            mail.put("csid", (Object)csid);
            mail.put("initial", true);
            mail.put("sendtype", ComposeType.DRAFT_EDIT.getType());
            NewMailRequestWithUploads sendDraftRequest = new NewMailRequestWithUploads(mail);
            MailReferenceResponse sendDraftResponse = this.client.execute(sendDraftRequest);
            Bug37247Test.assertNotNull((Object)((Object)sendDraftResponse));
            GetRequest gReq = new GetRequest(folderId, mailId);
            GetResponse gResp = this.getClient().execute(gReq);
            Bug37247Test.assertNotNull((String)"Got an empty get mail response", (Object)((Object)gResp));
            Bug37247Test.assertFalse((String)"Got an empty json object", (boolean)jsonObj.isEmpty());
            jsonObj = (JSONObject)gResp.getData();
            int flags = jsonObj.getInt("flags");
            Set<MailFlag> transform = MailFlag.transform(flags);
            Bug37247Test.assertFalse((String)"When saving replyed mail as a draft mail contains answered flag", (boolean)transform.contains((Object)MailFlag.ANSWERED));
        }
        catch (Throwable throwable) {
            if (!(Strings.isEmpty((String)folderId) && Strings.isEmpty((String)mailId))) {
                DeleteRequest dReq = new DeleteRequest(folderId, mailId, true);
                this.getClient().execute(dReq);
            }
            throw throwable;
        }
        if (!(Strings.isEmpty((String)folderId) && Strings.isEmpty((String)mailId))) {
            DeleteRequest dReq = new DeleteRequest(folderId, mailId, true);
            this.getClient().execute(dReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug37472Forward() throws OXException, IOException, JSONException {
        String csid = "845.1436870434189";
        NewMailRequest newMailRequest = new NewMailRequest(this.values.getInboxFolder(), EML, 32, true);
        NewMailResponse newMailResponse = this.getClient().execute(newMailRequest);
        Bug37247Test.assertNotNull((String)"Got an empty new mail response", (Object)((Object)newMailResponse));
        String mailId = newMailResponse.getId();
        String folderId = newMailResponse.getFolder();
        try {
            ForwardRequest rReq = new ForwardRequest(folderId, mailId);
            rReq.setCsid(csid);
            ReplyResponse rResp = this.getClient().execute(rReq);
            Bug37247Test.assertNotNull((String)"Got an empty reply response", (Object)((Object)rResp));
            JSONObject jsonObj = (JSONObject)rResp.getData();
            Bug37247Test.assertNotNull((String)"Got an unexpected response", (Object)jsonObj);
            Bug37247Test.assertFalse((String)"Got an empty json object", (boolean)jsonObj.isEmpty());
            csid = jsonObj.getString("csid");
            String subject = "Bug37472Test_testFlagsNotChangingWhenSavingDraft" + System.currentTimeMillis();
            JSONObject composedMail = this.createEMail(this.getSendAddress(), subject, "text/plain", EML);
            JSONObject mail = new JSONObject(composedMail);
            mail.put("flags", 4);
            mail.put("csid", (Object)csid);
            mail.put("initial", true);
            mail.put("sendtype", ComposeType.DRAFT_EDIT.getType());
            NewMailRequestWithUploads sendDraftRequest = new NewMailRequestWithUploads(mail);
            MailReferenceResponse sendDraftResponse = this.client.execute(sendDraftRequest);
            Bug37247Test.assertNotNull((Object)((Object)sendDraftResponse));
            GetRequest gReq = new GetRequest(folderId, mailId);
            GetResponse gResp = this.getClient().execute(gReq);
            Bug37247Test.assertNotNull((String)"Got an empty get mail response", (Object)((Object)gResp));
            Bug37247Test.assertFalse((String)"Got an empty json object", (boolean)jsonObj.isEmpty());
            jsonObj = (JSONObject)gResp.getData();
            int flags = jsonObj.getInt("flags");
            Set<MailFlag> transform = MailFlag.transform(flags);
            Bug37247Test.assertFalse((String)"When saving replyed mail as a draft mail contains answered flag", (boolean)transform.contains((Object)MailFlag.FORWARDED));
        }
        catch (Throwable throwable) {
            if (!(Strings.isEmpty((String)folderId) && Strings.isEmpty((String)mailId))) {
                DeleteRequest dReq = new DeleteRequest(folderId, mailId, true);
                this.getClient().execute(dReq);
            }
            throw throwable;
        }
        if (!(Strings.isEmpty((String)folderId) && Strings.isEmpty((String)mailId))) {
            DeleteRequest dReq = new DeleteRequest(folderId, mailId, true);
            this.getClient().execute(dReq);
        }
    }
}

