/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.thirdparty;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.infostore.fileaccount.actions.DeleteFileaccountRequest;
import com.openexchange.ajax.infostore.fileaccount.actions.NewFileaccountRequest;
import com.openexchange.ajax.infostore.fileaccount.actions.NewFileaccountResponse;
import com.openexchange.ajax.oauth.actions.DeleteOAuthAccountRequest;
import com.openexchange.ajax.oauth.client.actions.InitOAuthAccountRequest;
import com.openexchange.ajax.oauth.client.actions.InitOAuthAccountResponse;
import com.openexchange.ajax.oauth.client.actions.OAuthService;
import com.openexchange.exception.OXException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractInfostoreThirdpartyEnvironments {
    protected AJAXClient ajaxClient;
    private final List<OAuthService> authProviders;
    private List<Integer> accountIds;
    private String filestoreId;

    protected AbstractInfostoreThirdpartyEnvironments() {
        OAuthService[] auth = OAuthService.values();
        this.authProviders = new ArrayList<OAuthService>(auth.length);
        for (OAuthService authProvider : auth) {
            this.authProviders.add(authProvider);
        }
    }

    protected AbstractInfostoreThirdpartyEnvironments(List<OAuthService> authProvider) {
        if (authProvider == null || authProvider.isEmpty()) {
            throw new IllegalArgumentException("No thirdparty authentication provider found to initialize a filestorage");
        }
        this.authProviders = authProvider;
    }

    public void init() {
        try {
            this.initAJAXClient();
            this.initEnvironments(this.authProviders);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cleanup() throws Exception {
        if (this.authProviders != null && !this.authProviders.isEmpty()) {
            for (OAuthService auth : this.authProviders) {
                this.deleteFilestorageFor(auth);
            }
        }
        if (this.accountIds != null && !this.accountIds.isEmpty()) {
            Iterator<Object> i$ = this.accountIds.iterator();
            while (i$.hasNext()) {
                int accountId = (Integer)i$.next();
                this.deleteOAuthAccount(accountId);
            }
        }
        this.logout();
    }

    private void initAJAXClient() throws OXException, IOException, JSONException {
        this.ajaxClient = new AJAXClient(AJAXClient.User.User1);
    }

    private void initEnvironments(List<OAuthService> authProviders) throws Exception {
        this.accountIds = new ArrayList<Integer>(authProviders.size());
        for (OAuthService authProvider : authProviders) {
            int currentOAuthAccount = this.initOAuthAccountFor(authProvider);
            this.createFilestorageFor(authProvider, currentOAuthAccount);
            this.accountIds.add(currentOAuthAccount);
        }
    }

    private int initOAuthAccountFor(OAuthService auth) throws Exception {
        InitOAuthAccountRequest req = new InitOAuthAccountRequest(auth);
        InitOAuthAccountResponse resp = this.ajaxClient.execute(req);
        JSONObject json = (JSONObject)resp.getData();
        Integer account = (Integer)json.get("accountId");
        return account;
    }

    private void createFilestorageFor(OAuthService authProvider, int account) throws Exception {
        String filestoreId;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("account", (Object)String.valueOf(account));
        NewFileaccountRequest nfReq = new NewFileaccountRequest(authProvider.name(), authProvider.getFilestorageService(), jsonObject);
        NewFileaccountResponse nfResp = this.ajaxClient.execute(nfReq);
        this.filestoreId = filestoreId = (String)nfResp.getData();
    }

    protected void logout() throws OXException, IOException, JSONException {
        if (this.ajaxClient != null) {
            this.ajaxClient.logout();
        }
    }

    private void deleteOAuthAccount(int accountId) throws OXException, IOException, JSONException {
        DeleteOAuthAccountRequest req = new DeleteOAuthAccountRequest(accountId);
        this.ajaxClient.execute(req);
    }

    private void deleteFilestorageFor(OAuthService authProvider) throws Exception {
        DeleteFileaccountRequest delReq = new DeleteFileaccountRequest(authProvider.getFilestorageService(), this.filestoreId);
        this.ajaxClient.execute(delReq);
    }
}

