/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.actions;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.infostore.actions.CopyInfostoreRequest;
import com.openexchange.ajax.infostore.actions.CopyInfostoreResponse;
import com.openexchange.ajax.infostore.actions.DeleteInfostoreRequest;
import com.openexchange.ajax.infostore.actions.DeleteInfostoreResponse;
import com.openexchange.ajax.infostore.actions.GetInfostoreConfigRequest;
import com.openexchange.ajax.infostore.actions.GetInfostoreRequest;
import com.openexchange.ajax.infostore.actions.GetInfostoreResponse;
import com.openexchange.ajax.infostore.actions.NewInfostoreRequest;
import com.openexchange.ajax.infostore.actions.NewInfostoreResponse;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreRequest;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreResponse;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class InfostoreTestManager {
    private final Set<com.openexchange.file.storage.File> createdEntities = new HashSet<com.openexchange.file.storage.File>();
    private AJAXClient client;
    private boolean failOnError;
    private AbstractAJAXResponse lastResponse;

    public InfostoreTestManager() {
    }

    public InfostoreTestManager(AJAXClient client) {
        this();
        this.setClient(client);
    }

    public Set<com.openexchange.file.storage.File> getCreatedEntities() {
        return this.createdEntities;
    }

    public void setClient(AJAXClient client) {
        this.client = client;
    }

    public AJAXClient getClient() {
        return this.client;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    public AbstractAJAXResponse getLastResponse() {
        return this.lastResponse;
    }

    public void cleanUp() throws OXException, IOException, SAXException, JSONException {
        ArrayList<String> objectIDs = new ArrayList<String>(this.createdEntities.size());
        ArrayList<String> folderIDs = new ArrayList<String>(this.createdEntities.size());
        for (com.openexchange.file.storage.File metadata : this.createdEntities) {
            objectIDs.add(metadata.getId());
            folderIDs.add(metadata.getFolderId());
        }
        this.deleteAction(objectIDs, folderIDs, new Date(Long.MAX_VALUE), Boolean.TRUE);
        this.createdEntities.clear();
    }

    public void removeFromCreatedEntities(Collection<String> ids) {
        for (String id : ids) {
            for (com.openexchange.file.storage.File data : new HashSet<com.openexchange.file.storage.File>(this.createdEntities)) {
                if (data.getId() != id) continue;
                this.createdEntities.remove(data);
            }
        }
    }

    public void newAction(com.openexchange.file.storage.File data) throws OXException, IOException, SAXException, JSONException {
        NewInfostoreRequest newRequest = new NewInfostoreRequest(data);
        newRequest.setFailOnError(this.getFailOnError());
        NewInfostoreResponse newResponse = this.getClient().execute(newRequest);
        this.lastResponse = newResponse;
        data.setId(newResponse.getID());
        this.createdEntities.add(data);
    }

    public void newAction(com.openexchange.file.storage.File data, File upload) throws OXException, IOException, SAXException, JSONException {
        NewInfostoreRequest newRequest = new NewInfostoreRequest(data, upload);
        newRequest.setFailOnError(this.getFailOnError());
        NewInfostoreResponse newResponse = this.getClient().execute(newRequest);
        this.lastResponse = newResponse;
        data.setId(newResponse.getID());
        this.createdEntities.add(data);
    }

    public String copyAction(String id, String folderId, com.openexchange.file.storage.File data) throws OXException, IOException, JSONException {
        CopyInfostoreRequest copyRequest = new CopyInfostoreRequest(id, folderId, data);
        copyRequest.setFailOnError(this.getFailOnError());
        CopyInfostoreResponse copyResponse = this.getClient().execute(copyRequest);
        this.lastResponse = copyResponse;
        return copyResponse.getID();
    }

    public Object getConfigAction(String name) throws OXException, IOException, JSONException {
        GetInfostoreConfigRequest req = new GetInfostoreConfigRequest(name);
        req.setFailOnError(this.getFailOnError());
        AbstractAJAXResponse resp = this.getClient().execute(req);
        return resp.getResponse().getData();
    }

    public void updateAction(com.openexchange.file.storage.File data, File.Field[] fields, Date timestamp) throws OXException, IOException, JSONException {
        UpdateInfostoreRequest updateRequest = new UpdateInfostoreRequest(data, fields, timestamp);
        updateRequest.setFailOnError(this.getFailOnError());
        UpdateInfostoreResponse updateResponse = this.getClient().execute(updateRequest);
        this.lastResponse = updateResponse;
    }

    public void updateAction(com.openexchange.file.storage.File data, File file, File.Field[] fields, Date timestamp) throws OXException, IOException, JSONException {
        UpdateInfostoreRequest updateRequest = new UpdateInfostoreRequest(data, fields, file, timestamp);
        updateRequest.setFailOnError(this.getFailOnError());
        UpdateInfostoreResponse updateResponse = this.getClient().execute(updateRequest);
        this.lastResponse = updateResponse;
    }

    public void deleteAction(List<String> ids, List<String> folders, Date timestamp) throws OXException, IOException, SAXException, JSONException {
        this.deleteAction(ids, folders, timestamp, null);
    }

    public void deleteAction(List<String> ids, List<String> folders, Date timestamp, Boolean hardDelete) throws OXException, IOException, SAXException, JSONException {
        DeleteInfostoreRequest deleteRequest = new DeleteInfostoreRequest(ids, folders, timestamp);
        deleteRequest.setHardDelete(hardDelete);
        deleteRequest.setFailOnError(this.getFailOnError());
        DeleteInfostoreResponse deleteResponse = this.getClient().execute(deleteRequest);
        this.lastResponse = deleteResponse;
        this.removeFromCreatedEntities(ids);
    }

    public void deleteAction(String id, String folder, Date timestamp) throws OXException, IOException, SAXException, JSONException {
        this.deleteAction(Arrays.asList(id), Arrays.asList(folder), timestamp);
    }

    public void deleteAction(com.openexchange.file.storage.File data) throws OXException, IOException, SAXException, JSONException {
        this.deleteAction(data.getId(), data.getFolderId(), data.getLastModified());
    }

    public com.openexchange.file.storage.File getAction(String id) throws OXException, JSONException, OXException, IOException, SAXException {
        GetInfostoreRequest getRequest = new GetInfostoreRequest(id);
        getRequest.setFailOnError(this.getFailOnError());
        GetInfostoreResponse getResponse = this.getClient().execute(getRequest);
        this.lastResponse = getResponse;
        return getResponse.getDocumentMetadata();
    }
}

