/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.InfostoreAJAXTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.test.TestInit;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class VersionsTest
extends InfostoreAJAXTest {
    public VersionsTest(String name) {
        super(name);
    }

    public void testVersions() throws Exception {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m("version_comment", "Comment 1"), upload, "text/plain");
        VersionsTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m("version_comment", "Comment 2"), upload, "text/plain");
        VersionsTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m("version_comment", "Comment 3"), upload, "text/plain");
        VersionsTest.assertNoError(res);
        res = this.versions(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), new int[]{705, 710});
        VersionsTest.assertNoError(res);
        VersionsTest.assureVersions(new Integer[]{1, 2, 3}, res, 3);
        res = this.versions(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), new int[]{705, 709});
        VersionsTest.assertNoError(res);
        HashMap<Integer, String> comments = new HashMap<Integer, String>();
        comments.put(1, "Comment 1");
        comments.put(2, "Comment 2");
        comments.put(3, "Comment 3");
        JSONArray arrayOfarrays = (JSONArray)res.getData();
        for (int i = 0; i < arrayOfarrays.length(); ++i) {
            JSONArray payload = arrayOfarrays.getJSONArray(i);
            VersionsTest.assertEquals((String)((String)comments.remove(payload.getInt(0))), (String)payload.getString(1));
        }
    }

    public void testVersionSorting() throws Exception {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m("version_comment", "Comment 1"), upload, "text/plain");
        VersionsTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m("version_comment", "Comment 2"), upload, "text/plain");
        VersionsTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m("version_comment", "Comment 3"), upload, "text/plain");
        VersionsTest.assertNoError(res);
        res = this.versions(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), new int[]{705, 710}, 705, "desc");
        VersionsTest.assertNoError(res);
        VersionsTest.assureVersions(new Integer[]{3, 2, 1}, res, 3);
    }

    public void testUniqueVersions() throws Exception {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m("version_comment", "Comment 1"), upload, "text/plain");
        VersionsTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m("version_comment", "Comment 2"), upload, "text/plain");
        VersionsTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m("version_comment", "Comment 3"), upload, "text/plain");
        VersionsTest.assertNoError(res);
        res = this.versions(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), new int[]{705, 710});
        VersionsTest.assertNoError(res);
        VersionsTest.assureVersions(new Integer[]{1, 2, 3}, res, 3);
        int[] nd = this.detach(this.getWebConversation(), this.getHostName(), this.sessionId, res.getTimestamp().getTime(), (String)this.clean.get(0), new int[]{3});
        VersionsTest.assertEquals((int)0, (int)nd.length);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m("version_comment", "Comment 3"), upload, "text/plain");
        VersionsTest.assertNoError(res);
        res = this.versions(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), new int[]{705, 710});
        VersionsTest.assertNoError(res);
        VersionsTest.assureVersions(new Integer[]{1, 2, 4}, res, 4);
    }

    public void testLastModifiedUTC() throws JSONException, IOException, SAXException {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m("version_comment", "Comment 1"), upload, "text/plain");
        VersionsTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m("version_comment", "Comment 2"), upload, "text/plain");
        VersionsTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m("version_comment", "Comment 3"), upload, "text/plain");
        VersionsTest.assertNoError(res);
        res = this.versions(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), new int[]{6});
        VersionsTest.assertNoError(res);
        JSONArray arr = (JSONArray)res.getData();
        int size = arr.length();
        VersionsTest.assertTrue((size > 0 ? 1 : 0) != 0);
        for (int i = 0; i < size; ++i) {
            JSONArray row = arr.optJSONArray(i);
            VersionsTest.assertTrue((row.length() == 1 ? 1 : 0) != 0);
            VersionsTest.assertNotNull((Object)row.optLong(0));
        }
    }

    public static final void assureVersions(Integer[] ids, Response res, Integer current) throws JSONException {
        HashSet<Integer> versions = new HashSet<Integer>(Arrays.asList(ids));
        JSONArray arrayOfarrays = (JSONArray)res.getData();
        int numberOfVersions = versions.size();
        for (int i = 0; i < arrayOfarrays.length(); ++i) {
            JSONArray comp = arrayOfarrays.getJSONArray(i);
            VersionsTest.assertTrue((String)("Didn't expect " + comp.getInt(0)), (boolean)versions.remove(comp.getInt(0)));
            if (current != null && comp.getInt(0) != current.intValue()) {
                VersionsTest.assertFalse((boolean)comp.getBoolean(1));
                continue;
            }
            if (current == null) continue;
            VersionsTest.assertTrue((boolean)comp.getBoolean(1));
        }
        VersionsTest.assertEquals((int)numberOfVersions, (int)arrayOfarrays.length());
        VersionsTest.assertTrue((boolean)versions.isEmpty());
    }
}

