/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.tree;

import com.openexchange.ajax.folder.tree.FolderNode;
import com.openexchange.ajax.folder.tree.FolderNodeVisitor;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.FolderTestManager;
import java.util.Collection;

public abstract class AbstractFolderNode
implements FolderNode {
    private FolderObject folder;
    private FolderNode parent;
    private final AJAXClient client;
    private final FolderTestManager manager;

    public AbstractFolderNode(FolderObject underlyingObject, AJAXClient client) {
        this.folder = underlyingObject;
        this.client = client;
        this.manager = new FolderTestManager(client);
    }

    public AbstractFolderNode(int folderId, AJAXClient client) {
        this(null, client);
        this.setFolder(this.getManager().getFolderFromServer(folderId));
    }

    @Override
    public FolderObject getFolder() {
        return this.folder;
    }

    @Override
    public FolderNode resolve(String ... path) {
        return this.resolveRecursively(0, path);
    }

    protected FolderNode resolveRecursively(int i, String[] path) {
        if (i == path.length) {
            return this;
        }
        String childName = path[i];
        for (FolderNode node : this.getChildren()) {
            if (!node.getFolder().getFolderName().equals(childName)) continue;
            return ((AbstractFolderNode)node).resolveRecursively(i + 1, path);
        }
        return null;
    }

    @Override
    public FolderNode resolve(Collection<String> path) {
        return this.resolveRecursively(0, path.toArray(new String[path.size()]));
    }

    @Override
    public FolderNode getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        this.parent = this.load(this.getFolder().getParentFolderID());
        return this.parent;
    }

    protected FolderNode load(FolderObject folder) {
        FolderObject folderObject = this.manager.getFolderFromServer(folder, false);
        if (folderObject == null) {
            return this.node(folder, this.client);
        }
        return this.node(folderObject, this.client);
    }

    protected FolderNode load(int folderId) {
        FolderObject folderObject = this.manager.getFolderFromServer(folderId);
        return this.node(folderObject, this.client);
    }

    protected FolderTestManager getManager() {
        return this.manager;
    }

    protected AJAXClient getClient() {
        return this.client;
    }

    protected void setFolder(FolderObject folder) {
        this.folder = folder;
    }

    protected abstract FolderNode node(FolderObject var1, AJAXClient var2);

    @Override
    public void recurse(FolderNodeVisitor visitor) {
        this.recurse(0, visitor);
    }

    protected void recurse(int i, FolderNodeVisitor visitor) {
        visitor.visit(i, this);
        for (FolderNode child : this.getChildren()) {
            ((AbstractFolderNode)child).recurse(i + 1, visitor);
        }
    }
}

