/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.AbstractFolderRequest;
import com.openexchange.ajax.folder.actions.PathResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractColumnsParser;
import java.util.List;

public class PathRequest
extends AbstractFolderRequest<PathResponse> {
    private static final int[] DEFAULT_COLUMNS = new int[]{1, 301, 300, 304, 308, 2, 306};
    private final String folder;
    private final int[] columns;
    private final boolean failOnError;
    private boolean altNames = false;

    public PathRequest(API api, String folderId, int[] columns, boolean failOnError) {
        super(api);
        this.folder = folderId;
        this.columns = columns;
        this.failOnError = failOnError;
    }

    public PathRequest(API api, String folderId, int[] columns) {
        this(api, folderId, columns, true);
    }

    public PathRequest(API api, String folderId) {
        this(api, folderId, DEFAULT_COLUMNS, true);
    }

    public PathRequest(API api, int folderId, int[] columns, boolean failOnError) {
        this(api, Integer.toString(folderId), columns, failOnError);
    }

    public PathRequest(API api, int folderId, int[] columns) {
        this(api, Integer.toString(folderId), columns, true);
    }

    @Override
    public Object getBody() {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    protected void addParameters(List<AJAXRequest.Parameter> params) {
        params.add(new AJAXRequest.Parameter("action", "path"));
        params.add(new AJAXRequest.Parameter("id", this.folder));
        params.add(new AJAXRequest.Parameter("columns", this.columns));
        if (this.altNames) {
            params.add(new AJAXRequest.Parameter("altNames", Boolean.toString(this.altNames)));
        }
    }

    public PathParser getParser() {
        return new PathParser(this.columns, this.failOnError);
    }

    public void setAltNames(boolean altNames) {
        this.altNames = altNames;
    }

    private static class PathParser
    extends AbstractColumnsParser<PathResponse> {
        public PathParser(int[] columns, boolean failOnError) {
            super(failOnError, columns);
        }

        @Override
        protected PathResponse instantiateResponse(Response response) {
            return new PathResponse(response);
        }
    }
}

