/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.drive.test;

import com.openexchange.ajax.drive.action.DeleteLinkRequest;
import com.openexchange.ajax.drive.action.GetLinkRequest;
import com.openexchange.ajax.drive.action.GetLinkResponse;
import com.openexchange.ajax.drive.test.AbstractDriveShareTest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.infostore.actions.GetInfostoreRequest;
import com.openexchange.ajax.infostore.actions.InfostoreTestManager;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.DriveShareTarget;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.modules.Module;
import com.openexchange.test.TestInit;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.json.JSONException;

public class GetLinkTest
extends AbstractDriveShareTest {
    private InfostoreTestManager itm;
    private FolderObject rootFolder;
    private FolderObject folder;
    private DefaultFile file;
    private FolderObject folder2;

    public GetLinkTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.itm = new InfostoreTestManager(this.client);
        UserValues values = this.client.getValues();
        this.rootFolder = this.insertPrivateFolder(EnumAPI.OX_NEW, Module.INFOSTORE.getFolderConstant(), values.getPrivateInfostoreFolder());
        this.folder = this.insertPrivateFolder(EnumAPI.OX_NEW, Module.INFOSTORE.getFolderConstant(), this.rootFolder.getObjectID());
        this.folder2 = this.insertPrivateFolder(EnumAPI.OX_NEW, Module.INFOSTORE.getFolderConstant(), this.rootFolder.getObjectID());
        long now = System.currentTimeMillis();
        this.file = new DefaultFile();
        this.file.setFolderId(String.valueOf(this.folder2.getObjectID()));
        this.file.setTitle("GetLinkTest_" + now);
        this.file.setFileName(this.file.getTitle());
        this.file.setDescription(this.file.getTitle());
        this.file.setFileMD5Sum(this.getChecksum(new File(TestInit.getTestProperty("ajaxPropertiesFile"))));
        this.itm.newAction((com.openexchange.file.storage.File)this.file, new File(TestInit.getTestProperty("ajaxPropertiesFile")));
    }

    public void testGetFileLink() throws Exception {
        DriveShareTarget target = new DriveShareTarget();
        target.setDrivePath("/" + this.folder2.getFolderName());
        target.setName(this.file.getFileName());
        target.setChecksum(this.file.getFileMD5Sum());
        this.performTest(target);
    }

    public void testGetFolderLink() throws Exception {
        DriveShareTarget target = new DriveShareTarget();
        target.setDrivePath("/" + this.folder.getFolderName());
        target.setChecksum("d41d8cd98f00b204e9800998ecf8427e");
        this.performTest(target);
    }

    public void testBadFileChecksum() throws Exception {
        DriveShareTarget target = new DriveShareTarget();
        target.setDrivePath("/" + this.folder2.getFolderName());
        target.setName(this.file.getFileName());
        target.setChecksum("bad");
        GetLinkRequest getLinkRequest = new GetLinkRequest(this.rootFolder.getObjectID(), target, false);
        GetLinkResponse getLinkResponse = this.client.execute(getLinkRequest);
        GetLinkTest.assertTrue((String)"Expected error.", (boolean)getLinkResponse.hasError());
        GetLinkTest.assertTrue((String)"Wrong exception", (boolean)DriveExceptionCodes.FILEVERSION_NOT_FOUND.equals(getLinkResponse.getException()));
    }

    public void testBadDirectoryChecksum() throws Exception {
        DriveShareTarget target = new DriveShareTarget();
        target.setDrivePath("/" + this.folder.getFolderName());
        target.setChecksum("bad");
        GetLinkRequest getLinkRequest = new GetLinkRequest(this.rootFolder.getObjectID(), target, false);
        GetLinkResponse getLinkResponse = this.client.execute(getLinkRequest);
        GetLinkTest.assertTrue((String)"Expected error.", (boolean)getLinkResponse.hasError());
        GetLinkTest.assertTrue((String)"Wrong exception", (boolean)DriveExceptionCodes.DIRECTORYVERSION_NOT_FOUND.equals(getLinkResponse.getException()));
    }

    private void performTest(DriveShareTarget target) throws OXException, IOException, JSONException, Exception {
        GetLinkRequest getLinkRequest = new GetLinkRequest(this.rootFolder.getObjectID(), target);
        GetLinkResponse getLinkResponse = this.client.execute(getLinkRequest);
        String url = getLinkResponse.getUrl();
        GuestClient guestClient = this.resolveShare(url, null, null);
        OCLGuestPermission expectedPermission = GetLinkTest.createAnonymousGuestPermission();
        expectedPermission.setEntity(guestClient.getValues().getUserId());
        guestClient.checkShareAccessible(expectedPermission);
        int guestID = guestClient.getValues().getUserId();
        this.client.execute(new DeleteLinkRequest(this.rootFolder.getObjectID(), target));
        ExtendedPermissionEntity guestEntity = target.isFolder() ? this.discoverGuestEntity(EnumAPI.OX_NEW, 8, this.folder2.getObjectID(), guestID) : this.discoverGuestEntity(this.file.getFolderId(), this.file.getId(), guestID);
        GetLinkTest.assertNull((String)"Share was not deleted", (Object)guestEntity);
        List objectPermissions = this.client.execute(new GetInfostoreRequest(this.file.getId())).getDocumentMetadata().getObjectPermissions();
        GetLinkTest.assertTrue((String)"Permission was not deleted", (boolean)objectPermissions.isEmpty());
    }

    @Override
    public void tearDown() throws Exception {
        this.itm.cleanUp();
        super.tearDown();
    }
}

