/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact.action;

import com.openexchange.ajax.contact.action.AbstractContactRequest;
import com.openexchange.ajax.contact.action.DeleteParser;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.groupware.container.Contact;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeleteRequest
extends AbstractContactRequest<CommonDeleteResponse> {
    private final int folderId;
    private final int objectId;
    private final int[] objectIds;
    private final Date lastModified;
    private final boolean failOnError;

    public DeleteRequest(int folderId, int objectId, Date lastModified, boolean failOnError) {
        this.folderId = folderId;
        this.objectId = objectId;
        this.objectIds = null;
        this.lastModified = lastModified;
        this.failOnError = failOnError;
    }

    public DeleteRequest(int folderId, int[] objectIds, Date lastModified, boolean failOnError) {
        this.folderId = folderId;
        this.objectId = 0;
        this.objectIds = objectIds;
        this.lastModified = lastModified;
        this.failOnError = failOnError;
    }

    public DeleteRequest(Contact contact, boolean failOnError) {
        this(contact.getParentFolderID(), contact.getObjectID(), contact.getLastModified(), failOnError);
    }

    public DeleteRequest(int folderId, int[] objectIds, Date lastModified) {
        this(folderId, objectIds, lastModified, true);
    }

    public DeleteRequest(int folderId, int objectId, Date lastModified) {
        this(folderId, objectId, lastModified, true);
    }

    public DeleteRequest(Contact contact) {
        this(contact.getParentFolderID(), contact.getObjectID(), contact.getLastModified(), true);
    }

    @Override
    public Object getBody() throws JSONException {
        if (this.objectIds == null) {
            JSONObject json = new JSONObject();
            json.put("id", this.objectId);
            json.put("folder", this.folderId);
            return json;
        }
        JSONArray jsonArray = new JSONArray();
        for (int id : this.objectIds) {
            JSONObject json = new JSONObject();
            json.put("id", id);
            json.put("folder", this.folderId);
        }
        return jsonArray;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "delete"), new AJAXRequest.Parameter("timestamp", this.lastModified)};
    }

    public DeleteParser getParser() {
        return new DeleteParser(this.failOnError);
    }
}

