/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.contact.action.CopyRequest;
import com.openexchange.ajax.contact.action.CopyResponse;
import com.openexchange.groupware.container.Contact;
import java.util.UUID;
import org.json.JSONObject;

public class Bug34075Test
extends AbstractManagedContactTest {
    public Bug34075Test(String name) {
        super(name);
    }

    public void testAssignNewUidDuringCopy() throws Exception {
        Contact contact = this.generateContact();
        contact.setUid(UUID.randomUUID().toString());
        contact = this.manager.newAction(contact);
        CopyResponse copyResponse = this.client.execute(new CopyRequest(contact.getObjectID(), contact.getParentFolderID(), contact.getParentFolderID(), true));
        Bug34075Test.assertNotNull((String)"No response", (Object)((Object)copyResponse));
        Bug34075Test.assertFalse((String)"Errors in response", (boolean)copyResponse.hasError());
        JSONObject data = (JSONObject)copyResponse.getData();
        int objectID = data.getInt("id");
        Contact copiedContact = this.manager.getAction(contact.getParentFolderID(), objectID);
        Bug34075Test.assertNotNull((String)"Copied contact not found", (Object)copiedContact);
        Bug34075Test.assertEquals((String)"Last name wrong", (String)contact.getSurName(), (String)copiedContact.getSurName());
        Bug34075Test.assertFalse((String)"Same UID in copied contact", (boolean)contact.getUid().equals(copiedContact.getUid()));
    }
}

