/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.resource.ResourceTools;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.CalendarTestManager;
import java.util.Calendar;
import java.util.Date;

public class Bug35355Test
extends AbstractAJAXSession {
    private CalendarTestManager ctm1;
    private CalendarTestManager ctm3;
    private Appointment appointment;
    private AJAXClient client2;
    private AJAXClient client3;
    private Appointment exception;
    private Appointment blockingApp;
    private UserParticipant up1;
    private UserParticipant up2;
    private UserParticipant up3;
    private ResourceParticipant resourceParticipant;
    private int nextYear;

    public Bug35355Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.client3 = new AJAXClient(AJAXClient.User.User3);
        this.up1 = new UserParticipant(this.client.getValues().getUserId());
        this.up2 = new UserParticipant(this.client2.getValues().getUserId());
        this.up3 = new UserParticipant(this.client3.getValues().getUserId());
        this.resourceParticipant = new ResourceParticipant(ResourceTools.getSomeResource(this.client));
        this.ctm1 = new CalendarTestManager(this.client);
        this.ctm1.setFailOnError(true);
        this.ctm3 = new CalendarTestManager(this.client3);
        this.ctm3.setFailOnError(true);
        this.nextYear = Calendar.getInstance().get(1) + 1;
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug 35355 Test");
        this.appointment.setStartDate(TimeTools.D("06.11." + this.nextYear + " 08:00"));
        this.appointment.setEndDate(TimeTools.D("06.11." + this.nextYear + " 09:00"));
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.appointment.setOccurrence(3);
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setParticipants(new Participant[]{this.up1, this.up2, this.resourceParticipant});
        this.ctm1.insert(this.appointment);
        this.exception = new Appointment();
        this.exception.setTitle("Bug 35355 Exception");
        this.exception.setObjectID(this.appointment.getObjectID());
        this.exception.setStartDate(TimeTools.D("07.11." + this.nextYear + " 08:00"));
        this.exception.setEndDate(TimeTools.D("07.11." + this.nextYear + " 09:00"));
        this.exception.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.exception.setLastModified(new Date(Long.MAX_VALUE));
        this.exception.setRecurrencePosition(2);
        this.exception.setParticipants(new Participant[]{this.up1, this.up2});
        this.exception.setIgnoreConflicts(true);
        this.ctm1.update(this.exception);
        this.blockingApp = new Appointment();
        this.blockingApp.setTitle("Bug 35355 Blocking Appointment");
        this.blockingApp.setStartDate(TimeTools.D("07.11." + this.nextYear + " 07:00"));
        this.blockingApp.setEndDate(TimeTools.D("07.11." + this.nextYear + " 10:00"));
        this.blockingApp.setParticipants(new Participant[]{this.up3, this.resourceParticipant});
        this.blockingApp.setIgnoreConflicts(true);
        this.blockingApp.setParentFolderID(this.client3.getValues().getPrivateAppointmentFolder());
    }

    public void testBug35355() throws Exception {
        this.ctm3.insert(this.blockingApp);
        Bug35355Test.assertFalse((boolean)this.ctm3.getLastResponse().hasConflicts());
        Bug35355Test.assertFalse((boolean)this.ctm3.getLastResponse().hasError());
        Appointment updateSeries = new Appointment();
        updateSeries.setObjectID(this.appointment.getObjectID());
        updateSeries.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        updateSeries.setStartDate(TimeTools.D("06.11." + this.nextYear + " 08:00"));
        updateSeries.setEndDate(TimeTools.D("06.11." + this.nextYear + " 09:00"));
        updateSeries.setRecurrenceType(1);
        updateSeries.setInterval(1);
        updateSeries.setOccurrence(3);
        updateSeries.setLastModified(new Date(Long.MAX_VALUE));
        updateSeries.setParticipants(new Participant[]{this.up1, this.resourceParticipant});
        this.ctm1.update(updateSeries);
        Bug35355Test.assertFalse((String)"No conflict expected.", (boolean)this.ctm1.getLastResponse().hasConflicts());
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm1.cleanUp();
        this.ctm3.cleanUp();
        super.tearDown();
    }
}

