/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.test.CalendarTestManager;
import java.util.List;
import org.junit.Test;

public class Bug32278Test
extends AbstractAJAXSession {
    private Appointment appointment;
    private CalendarTestManager ctm;

    public Bug32278Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ctm = new CalendarTestManager(this.getClient());
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug 32278 Test");
        this.appointment.setStartDate(TimeTools.D("01.05.2014 08:00"));
        this.appointment.setEndDate(TimeTools.D("01.05.2014 09:00"));
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.appointment.setOccurrence(3);
        this.appointment.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
    }

    @Test
    public void testBug() throws Exception {
        this.ctm.insert(this.appointment);
        this.appointment.setRecurrenceType(0);
        this.appointment.removeInterval();
        this.appointment.removeOccurrence();
        this.ctm.update(this.appointment);
        List<Appointment> list = this.ctm.list(new ListIDs(this.appointment.getParentFolderID(), this.appointment.getObjectID()), new int[]{206, 207});
        for (Appointment app : list) {
            Bug32278Test.assertFalse((String)"No recurrence ID expected.", (boolean)app.containsRecurrenceID());
            Bug32278Test.assertFalse((String)"No recurrence position expected.", (boolean)app.containsRecurrencePosition());
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        super.tearDown();
    }
}

