/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.ResyncData;
import com.sun.mail.imap.protocol.MessageSet;
import com.sun.mail.imap.protocol.UIDSet;
import java.util.ArrayList;
import java.util.Vector;
import javax.mail.Message;

public final class Utility {
    private Utility() {
    }

    public static MessageSet[] toMessageSet(Message[] msgs, Condition cond) {
        ArrayList<MessageSet> v = new ArrayList<MessageSet>(1);
        for (int i = 0; i < msgs.length; ++i) {
            IMAPMessage msg = (IMAPMessage)msgs[i];
            if (msg.isExpunged()) continue;
            int current = msg.getSequenceNumber();
            if (cond != null && !cond.test(msg)) continue;
            MessageSet set = new MessageSet();
            set.start = current;
            ++i;
            while (i < msgs.length) {
                msg = (IMAPMessage)msgs[i];
                if (!msg.isExpunged()) {
                    int next = msg.getSequenceNumber();
                    if (cond == null || cond.test(msg)) {
                        if (next == current + 1) {
                            current = next;
                        } else {
                            --i;
                            break;
                        }
                    }
                }
                ++i;
            }
            set.end = current;
            v.add(set);
        }
        if (v.isEmpty()) {
            return null;
        }
        return v.toArray(new MessageSet[v.size()]);
    }

    public static UIDSet[] toUIDSet(Message[] msgs) {
        Vector<UIDSet> v = new Vector<UIDSet>(1);
        for (int i = 0; i < msgs.length; ++i) {
            IMAPMessage msg = (IMAPMessage)msgs[i];
            if (msg.isExpunged()) continue;
            long current = msg.getUID();
            UIDSet set = new UIDSet();
            set.start = current;
            ++i;
            while (i < msgs.length) {
                msg = (IMAPMessage)msgs[i];
                if (!msg.isExpunged()) {
                    long next = msg.getUID();
                    if (next == current + 1L) {
                        current = next;
                    } else {
                        --i;
                        break;
                    }
                }
                ++i;
            }
            set.end = current;
            v.addElement(set);
        }
        if (v.isEmpty()) {
            return null;
        }
        Object[] sets = new UIDSet[v.size()];
        v.copyInto(sets);
        return sets;
    }

    public static UIDSet[] getResyncUIDSet(ResyncData rd) {
        return rd.getUIDSet();
    }

    public static interface Condition {
        public boolean test(IMAPMessage var1);
    }
}

